/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.TextBuffer;
import java.util.List;

public class TextFile
extends AbstractFile {
    private int recordLength;
    private List<TextBuffer> buffers;
    private int eof;

    public TextFile(String name, byte[] buffer) {
        super(name, buffer);
    }

    public TextFile(String name, byte[] buffer, int recordLength, int eof) {
        this(name, buffer);
        this.eof = eof;
        this.recordLength = recordLength;
    }

    public TextFile(String name, List<TextBuffer> buffers, int recordLength, int eof) {
        super(name, null);
        this.buffers = buffers;
        this.eof = eof;
        this.recordLength = recordLength;
    }

    @Override
    public String getHexDump() {
        if (this.buffers == null) {
            return super.getHexDump();
        }
        StringBuilder text = new StringBuilder();
        for (TextBuffer tb : this.buffers) {
            int i = 0;
            int rec = 0;
            while (i < tb.buffer.length) {
                text.append("\nRecord #" + (tb.firstRecNo + rec) + "\n");
                text.append(String.valueOf(HexFormatter.format(tb.buffer, i, tb.reclen)) + "\n");
                i += tb.reclen;
                ++rec;
            }
        }
        return text.toString();
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Name          : " + this.name + "\n");
        if (this.recordLength > 0) {
            text.append(String.format("Record length : %,8d%n", this.recordLength));
            text.append(String.format("End of file   : %,8d%n", this.eof));
        } else {
            text.append(String.format("End of file   : %,8d%n", this.buffer.length));
        }
        text.append("\n");
        if (this.buffers != null) {
            return this.treeFileText(text);
        }
        if (this.recordLength == 0) {
            return this.unknownLength(text);
        }
        return this.knownLength(text, 0).toString();
    }

    private StringBuilder knownLength(StringBuilder text, int recNo) {
        int ptr = 0;
        while (ptr < this.buffer.length) {
            if (this.buffer[ptr] == 0) {
                ++recNo;
            } else {
                int len = this.buffer.length - ptr;
                int bytes = len < this.recordLength ? len : this.recordLength;
                while (this.buffer[ptr + bytes - 1] == 0) {
                    --bytes;
                }
                text.append("Record #" + recNo++ + "\n");
                text.append(HexFormatter.getString(this.buffer, ptr, bytes));
            }
            ptr += this.recordLength;
        }
        return text;
    }

    private String unknownLength(StringBuilder text) {
        int nulls = 0;
        int ptr = 0;
        int size = this.buffer.length;
        while (ptr < size) {
            int val;
            if ((val = HexFormatter.intValue(this.buffer[ptr++])) >= 128) {
                val -= 128;
            }
            if (val == 0) {
                ++nulls;
                continue;
            }
            if (val == 13) {
                text.append("\n");
                continue;
            }
            if (nulls > 0) {
                text.append("\nNew record at : " + (ptr - 1) + "\n");
                nulls = 0;
            }
            text.append((char)val);
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    private String treeFileText(StringBuilder text) {
        for (TextBuffer tb : this.buffers) {
            this.buffer = tb.buffer;
            this.knownLength(text, tb.firstRecNo);
        }
        return text.toString();
    }
}

