/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import java.util.ArrayList;
import java.util.List;

public class SimpleText2
extends AbstractFile {
    List<Integer> lineStarts = new ArrayList<Integer>();
    int loadAddress;
    boolean showByte = false;

    public SimpleText2(String name, byte[] buffer, int loadAddress) {
        super(name, buffer);
        this.loadAddress = loadAddress;
        int ptr = 0;
        while (buffer[ptr] != -1) {
            int length = buffer[ptr] & 0xFF;
            this.lineStarts.add(ptr);
            ptr += length + 1;
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Name    : " + this.name + "\n");
        text.append(String.format("Length  : $%04X (%d)%n", this.buffer.length, this.buffer.length));
        text.append(String.format("Load at : $%04X%n%n", this.loadAddress));
        for (Integer i : this.lineStarts) {
            text.append(String.format("%05X  %s%n", i, this.getLine(i)));
        }
        return text.toString();
    }

    @Override
    public String getHexDump() {
        StringBuilder text = new StringBuilder();
        for (Integer i : this.lineStarts) {
            text.append(String.valueOf(HexFormatter.formatNoHeader(this.buffer, i, (this.buffer[i] & 0xFF) + 1)) + "\n");
        }
        text.append(String.valueOf(HexFormatter.formatNoHeader(this.buffer, this.buffer.length - 2, 2)) + "\n");
        return text.toString();
    }

    private String getLine(int ptr) {
        StringBuilder line = new StringBuilder();
        int length = this.buffer[ptr] & 0xFF;
        while (--length > 0) {
            int val;
            if ((val = this.buffer[++ptr] & 0xFF) == 187) {
                while (line.length() < 35) {
                    line.append(' ');
                }
                line.append(';');
                continue;
            }
            if (val >= 128) {
                while (line.length() < 10) {
                    line.append(' ');
                }
                if (val == 220) {
                    line.append(String.format("EQU", val));
                } else if (val == 208) {
                    line.append(String.format("STA", val));
                } else if (val == 210) {
                    line.append(String.format("STY", val));
                } else if (val == 212) {
                    line.append(String.format("LSR", val));
                } else if (val == 213) {
                    line.append(String.format("ROR", val));
                } else if (val == 215) {
                    line.append(String.format("ASL", val));
                } else if (val == 217) {
                    line.append(String.format("EQ ", val));
                } else if (val == 219) {
                    line.append(String.format("TGT", val));
                } else if (val == 218) {
                    line.append(String.format("ORG", val));
                } else if (val == 177) {
                    line.append(String.format("TYA", val));
                } else if (val == 193) {
                    line.append(String.format("AND", val));
                } else if (val == 196) {
                    line.append(String.format("CMP", val));
                } else if (val == 200) {
                    line.append(String.format("EOR", val));
                } else if (val == 202) {
                    line.append(String.format("JMP", val));
                } else if (val == 203) {
                    line.append(String.format("JSR", val));
                } else if (val == 205) {
                    line.append(String.format("LDA", val));
                } else if (val == 206) {
                    line.append(String.format("LDX", val));
                } else if (val == 207) {
                    line.append(String.format("LDY", val));
                } else if (val == 161) {
                    line.append(String.format("PHA", val));
                } else if (val == 162) {
                    line.append(String.format("PLA", val));
                } else if (val == 165) {
                    line.append(String.format("RTS", val));
                } else if (val == 169) {
                    line.append(String.format("SEC", val));
                } else if (val == 173) {
                    line.append(String.format("TAY", val));
                } else if (val == 130) {
                    line.append(String.format("BMI", val));
                } else if (val == 132) {
                    line.append(String.format("BCS", val));
                } else if (val == 133) {
                    line.append(String.format("BPL", val));
                } else if (val == 134) {
                    line.append(String.format("BNE", val));
                } else if (val == 135) {
                    line.append(String.format("BEQ", val));
                } else if (val == 153) {
                    line.append(String.format("CLC", val));
                } else if (val == 156) {
                    line.append(String.format("DEX", val));
                } else if (val == 159) {
                    line.append(String.format("INY", val));
                } else {
                    line.append(String.format(".%02X.", val));
                }
                line.append(' ');
                if (this.buffer[++ptr] >= 32 || !this.showByte) continue;
                val = this.buffer[ptr] & 0xFF;
                line.append(String.format(".%02X. ", val));
                continue;
            }
            line.append((char)val);
        }
        return line.toString();
    }
}

