/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;

public class SimpleText
extends AbstractFile {
    public SimpleText(String name, byte[] buffer) {
        super(name, buffer);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Name : " + this.name + "\n");
        text.append(String.format("End of file   : %,8d%n%n", this.buffer.length));
        int ptr = 0;
        while (ptr < this.buffer.length) {
            String line = this.getLine(ptr);
            text.append(String.valueOf(line) + "\n");
            if ((ptr += line.length() + 1) >= this.buffer.length || this.buffer[ptr] != 10) continue;
            ++ptr;
        }
        return text.toString();
    }

    private String getLine(int ptr) {
        StringBuilder line = new StringBuilder();
        while (ptr < this.buffer.length && this.buffer[ptr] != 13) {
            line.append((char)this.buffer[ptr++]);
        }
        return line.toString();
    }

    public static boolean isHTML(byte[] buffer) {
        String text = new String(buffer, 0, buffer.length);
        return text.indexOf("HTML") > 0 || text.indexOf("html") > 0;
    }
}

