/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.PascalCodeStatement;
import com.bytezone.diskbrowser.applefile.PascalConstants;
import com.bytezone.diskbrowser.applefile.PascalProcedure;
import java.util.ArrayList;
import java.util.List;

public class PascalSegment
extends AbstractFile
implements PascalConstants {
    int segmentNoHeader;
    int segmentNoBody;
    public final int blockNo;
    public final int size;
    List<PascalProcedure> procedures;
    int segKind;
    int textAddress;
    int machineType;
    int version;
    int intrinsSegs1;
    int intrinsSegs2;
    int slot;
    int totalProcedures;

    public PascalSegment(String name, byte[] fullBuffer, int seq) {
        super(name, fullBuffer);
        this.slot = seq;
        this.blockNo = HexFormatter.intValue(fullBuffer[seq * 4], fullBuffer[seq * 4 + 1]);
        this.size = HexFormatter.intValue(fullBuffer[seq * 4 + 2], fullBuffer[seq * 4 + 3]);
        this.segmentNoHeader = fullBuffer[256 + seq * 2];
        this.segKind = HexFormatter.intValue(fullBuffer[192 + seq * 2], fullBuffer[192 + seq * 2 + 1]);
        this.textAddress = HexFormatter.intValue(fullBuffer[224 + seq * 2], fullBuffer[224 + seq * 2 + 1]);
        int flags = fullBuffer[257 + seq * 2] & 0xFF;
        this.machineType = flags & 0xF;
        this.version = (flags & 0xD0) >> 5;
        this.intrinsSegs1 = HexFormatter.intValue(fullBuffer[288 + seq * 4], fullBuffer[288 + seq * 4 + 1]);
        this.intrinsSegs2 = HexFormatter.intValue(fullBuffer[288 + seq * 4 + 2], fullBuffer[288 + seq * 4 + 3]);
        this.buffer = new byte[this.size];
        System.arraycopy(fullBuffer, this.blockNo * 512, this.buffer, 0, this.size);
        this.totalProcedures = this.buffer[this.size - 1] & 0xFF;
        this.segmentNoBody = this.buffer[this.size - 2] & 0xFF;
        if (this.segmentNoBody != this.segmentNoHeader) {
            System.out.println("Segment number mismatch : " + this.segmentNoBody + " / " + this.segmentNoHeader);
        }
    }

    private void buildProcedureList() {
        this.procedures = new ArrayList<PascalProcedure>(this.totalProcedures);
        int i = 1;
        while (i <= this.totalProcedures) {
            this.procedures.add(new PascalProcedure(this.buffer, i));
            ++i;
        }
    }

    public String toText() {
        return String.format(" %2d    %02X    %04X %,6d  %-8s  %-15s  %3d   %3d    %d     %d    %d    %d", this.slot, this.blockNo, this.size, this.size, this.name, SegmentKind[this.segKind], this.textAddress, this.segmentNoHeader, this.machineType, this.version, this.intrinsSegs1, this.intrinsSegs2);
    }

    @Override
    public String getText() {
        if (this.procedures == null) {
            this.buildProcedureList();
        }
        StringBuilder text = new StringBuilder();
        String title = "Segment - " + this.name;
        text.append(String.valueOf(title) + "\n" + "===============================".substring(0, title.length()) + "\n\n");
        String warning = this.segmentNoBody == this.segmentNoHeader ? "" : " (" + this.segmentNoHeader + " in header)";
        text.append(String.format("Address........ %02X%n", this.blockNo));
        text.append(String.format("Length......... %04X%n", this.buffer.length));
        text.append(String.format("Machine type... %d%n", this.machineType));
        text.append(String.format("Version........ %d%n", this.version));
        text.append(String.format("Segment........ %d%s%n", this.segmentNoBody, warning));
        text.append(String.format("Total procs.... %d%n", this.procedures.size()));
        text.append("\nProcedure Dictionary\n====================\n\n");
        int len = this.procedures.size() * 2 + 2;
        text.append("Proc  Offset  Lvl  Entry   Exit   Parm   Data   Proc header\n");
        text.append("----  ------  ---  -----   ----   ----   ----   --------------------\n");
        for (PascalProcedure procedure : this.procedures) {
            if (procedure.valid) {
                int address = this.size - procedure.slot * 2 - 2;
                text.append(String.format(" %2d    %04X  %3d    %04X   %04X   %04X   %04X   (%04X - %04X = %04X)%n", procedure.procedureNo, procedure.offset, procedure.procLevel, procedure.codeStart, procedure.codeEnd, procedure.parmSize, procedure.dataSize, address, procedure.offset, procedure.procOffset));
                continue;
            }
            text.append(String.format(" %2d    %04X%n", procedure.slot, procedure.offset));
        }
        text.append("\nStrings\n=======\n");
        for (PascalProcedure pp : this.procedures) {
            List<PascalCodeStatement> strings = pp.extractStrings();
            for (PascalCodeStatement cs : strings) {
                text.append(String.format(" %2d   %04X   %s%n", pp.procedureNo, cs.ptr, cs.text));
            }
        }
        for (PascalProcedure procedure : this.procedures) {
            if (!procedure.valid) continue;
            text.append(procedure);
        }
        return text.toString();
    }
}

