/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.PascalConstants;
import com.bytezone.diskbrowser.applefile.PascalSegment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PascalCode
extends AbstractFile
implements PascalConstants,
Iterable<PascalSegment> {
    List<PascalSegment> segments = new ArrayList<PascalSegment>(16);
    String codeName;
    String comment;

    public static void print() {
        int i = 0;
        while (i < 216) {
            System.out.printf("%3d  %d  %3s  %s%n", i + 128, PascalConstants.mnemonicSize[i], PascalConstants.mnemonics[i], PascalConstants.descriptions[i]);
            ++i;
        }
    }

    public PascalCode(String name, byte[] buffer) {
        super(name, buffer);
        int nonameCounter = 0;
        int i = 0;
        while (i < 16) {
            this.codeName = HexFormatter.getString(buffer, 64 + i * 8, 8).trim();
            int size = HexFormatter.intValue(buffer[i * 4 + 2], buffer[i * 4 + 3]);
            if (size > 0) {
                if (this.codeName.length() == 0) {
                    this.codeName = "<NULL" + nonameCounter++ + ">";
                }
                this.segments.add(new PascalSegment(this.codeName, buffer, i));
            }
            ++i;
        }
        this.comment = HexFormatter.getPascalString(buffer, 432);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder(this.getHeader());
        text.append("Segment Dictionary\n==================\n\n");
        text.append("Slot  Addr    Len    Len    Name    Kind            Text  Seg#  Mtyp  Vers  I/S\n");
        text.append("----  ----  -----  -----  --------  --------------- ----  ----  ----  ----  ---\n");
        for (PascalSegment segment : this.segments) {
            text.append(String.valueOf(segment.toText()) + "\n");
        }
        text.append("\nComment : " + this.comment + "\n\n");
        return text.toString();
    }

    private String getHeader() {
        return "Name : " + this.name + "\n\n";
    }

    @Override
    public Iterator<PascalSegment> iterator() {
        return this.segments.iterator();
    }
}

