/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class HiResImage
extends AbstractFile {
    public HiResImage(String name, byte[] buffer) {
        super(name, buffer);
        if (HiResImage.isGif(buffer)) {
            this.makeGif();
        } else {
            this.makeScreen();
        }
    }

    private void makeScreen() {
        int rows = this.buffer.length <= 8192 ? 192 : 384;
        this.image = new BufferedImage(280, rows, 10);
        DataBuffer db = this.image.getRaster().getDataBuffer();
        int element = 0;
        byte[] mask = new byte[]{64, 32, 16, 8, 4, 2, 1};
        int z = 0;
        while (z < rows / 192) {
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 8) {
                    int k = 0;
                    while (k < 8) {
                        int base = i * 40 + j * 128 + k * 1024 + z * 8192;
                        int max = base + 40;
                        if (max > this.buffer.length) {
                            max = this.buffer.length;
                        }
                        int ptr = base;
                        while (ptr < max) {
                            byte val = this.buffer[ptr];
                            if (val == 0) {
                                element += 7;
                            } else {
                                int bit = 6;
                                while (bit >= 0) {
                                    if ((val & mask[bit]) > 0) {
                                        db.setElem(element, 255);
                                    }
                                    ++element;
                                    --bit;
                                }
                            }
                            ++ptr;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++z;
        }
    }

    private void makeGif() {
        try {
            this.image = ImageIO.read(new ByteArrayInputStream(this.buffer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getText() {
        return "Image File : " + this.name;
    }

    public static boolean isGif(byte[] buffer) {
        if (buffer.length < 6) {
            return false;
        }
        String text = new String(buffer, 0, 6);
        return text.equals("GIF89a") || text.equals("GIF87a");
    }
}

