/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.ApplesoftConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ApplesoftBasicProgram
extends AbstractFile {
    private static final byte ASCII_QUOTE = 34;
    private static final byte ASCII_COLON = 58;
    private static final byte ASCII_SEMI_COLON = 59;
    private static final byte TOKEN_FOR = -127;
    private static final byte TOKEN_NEXT = -126;
    private static final byte TOKEN_GOTO = -85;
    private static final byte TOKEN_IF = -83;
    private static final byte TOKEN_REM = -78;
    private static final byte TOKEN_PRINT = -70;
    private static final byte TOKEN_THEN = -60;
    private static final byte TOKEN_EQUALS = -48;
    private List<SourceLine> sourceLines = new ArrayList<SourceLine>();
    private int lastPtr;

    public ApplesoftBasicProgram(String name, byte[] buffer) {
        super(name, buffer);
        int ptr = 0;
        int lastOffset = 0;
        while (ptr < buffer.length) {
            int offset = HexFormatter.intValue(buffer[ptr], buffer[ptr + 1]);
            if (offset <= lastOffset) break;
            SourceLine line = new SourceLine(ptr);
            this.sourceLines.add(line);
            ptr += line.length;
            lastOffset = offset;
        }
        this.lastPtr = ptr;
    }

    @Override
    public String getText() {
        StringBuilder pgm = new StringBuilder();
        this.addHeader(pgm);
        int indent = 0;
        Stack<String> loopVariables = new Stack<String>();
        ArrayList<String> source = new ArrayList<String>();
        for (SourceLine line : this.sourceLines) {
            source.addAll(line.getSource());
            pgm.append(String.format("%5d ", line.lineNumber));
            int indentIf = 0;
            for (SubLine subline : line.sublines) {
                if (subline.isNext()) {
                    indent = this.newIndentAfterNext(subline, loopVariables, indent);
                    this.appendSubLine(pgm, subline, indent + indentIf);
                } else if (subline.isFor()) {
                    this.appendSubLine(pgm, subline, indent + indentIf);
                    ++indent;
                    loopVariables.push(subline.variable);
                } else if (subline.isIf()) {
                    this.appendSubLine(pgm, subline, indent + indentIf);
                    ++indentIf;
                    if (subline.isIfThenNext()) {
                        indent = this.newIndentAfterNext(subline.subline, loopVariables, indent);
                    }
                } else if (subline.isSplitPrint()) {
                    int count = 0;
                    for (String s : subline.printLines) {
                        pgm.append(s);
                        if (++count >= subline.printLines.size()) continue;
                        pgm.append("\n                       ".substring(0, indent + 7));
                    }
                } else {
                    this.appendSubLine(pgm, subline, indent + indentIf);
                }
                if (subline.isLastSubLine()) {
                    pgm.append("\n");
                    continue;
                }
                if (subline.length == 1) {
                    pgm.append(":");
                    continue;
                }
                pgm.append(":\n      ");
            }
        }
        return pgm.toString().trim();
    }

    private StringBuilder appendSubLine(StringBuilder text, SubLine subline, int indent) {
        int in = indent;
        while (in-- > 0) {
            text.append("  ");
        }
        text.append(subline);
        return text;
    }

    private int newIndentAfterNext(SubLine subline, Stack<String> loopVariables, int indent) {
        if (subline.variables.length == 0) {
            if (loopVariables.size() > 0) {
                loopVariables.pop();
                --indent;
            }
        } else {
            String[] stringArray = subline.variables;
            int n = subline.variables.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                while (loopVariables.size() > 0) {
                    --indent;
                    if (this.sameVariable(loopVariables.pop(), var)) break;
                }
                ++n2;
            }
        }
        return indent < 0 ? 0 : indent;
    }

    private boolean sameVariable(String v1, String v2) {
        if (v1.equals(v2)) {
            return true;
        }
        return v1.length() >= 2 && v2.length() >= 2 && v1.charAt(0) == v2.charAt(0) && v1.charAt(1) == v2.charAt(1);
    }

    private int getLineLength(int ptr) {
        int offset = HexFormatter.intValue(this.buffer[ptr], this.buffer[ptr + 1]);
        if (offset == 0) {
            return 0;
        }
        ptr += 4;
        int length = 5;
        while (ptr < this.buffer.length && this.buffer[ptr++] != 0) {
            ++length;
        }
        return length;
    }

    private void addHeader(StringBuilder pgm) {
        pgm.append("Name    : " + this.name + "\n");
        pgm.append("Length  : $" + HexFormatter.format4(this.buffer.length));
        pgm.append(" (" + this.buffer.length + ")\n");
        int programLoadAddress = 0;
        if (this.buffer.length > 1) {
            int offset = HexFormatter.intValue(this.buffer[0], this.buffer[1]);
            programLoadAddress = offset - this.getLineLength(0);
        }
        pgm.append("Load at : $" + HexFormatter.format4(programLoadAddress));
        pgm.append(" (" + programLoadAddress + ")\n\n");
    }

    @Override
    public String getHexDump() {
        int length;
        if (this.buffer.length < 2) {
            return super.getHexDump();
        }
        StringBuilder pgm = new StringBuilder();
        this.addHeader(pgm);
        int ptr = 0;
        int offset = HexFormatter.intValue(this.buffer[0], this.buffer[1]);
        int programLoadAddress = offset - this.getLineLength(0);
        while (ptr <= this.lastPtr) {
            length = this.getLineLength(ptr);
            if (length == 0) {
                pgm.append(HexFormatter.formatNoHeader(this.buffer, ptr, 2, programLoadAddress));
                ptr += 2;
                break;
            }
            if (ptr + length < this.buffer.length) {
                pgm.append(String.valueOf(HexFormatter.formatNoHeader(this.buffer, ptr, length, programLoadAddress)) + "\n\n");
            }
            ptr += length;
        }
        if (ptr < this.buffer.length) {
            length = this.buffer.length - ptr;
            pgm.append("\n\n");
            pgm.append(HexFormatter.formatNoHeader(this.buffer, ptr, length, programLoadAddress));
        }
        return pgm.toString();
    }

    private class SourceLine {
        List<SubLine> sublines = new ArrayList<SubLine>();
        int lineNumber;
        int linePtr;
        int length;

        public SourceLine(int ptr) {
            byte b;
            this.linePtr = ptr;
            this.lineNumber = HexFormatter.intValue(ApplesoftBasicProgram.this.buffer[ptr + 2], ApplesoftBasicProgram.this.buffer[ptr + 3]);
            int startPtr = ptr += 4;
            boolean inString = false;
            boolean inRemark = false;
            block5: while ((b = ApplesoftBasicProgram.this.buffer[ptr++]) != 0) {
                switch (b) {
                    case -78: {
                        inRemark = true;
                        break;
                    }
                    case 34: {
                        if (inRemark) break;
                        inString = !inString;
                        break;
                    }
                    case 58: {
                        if (inString || inRemark) continue block5;
                        this.sublines.add(new SubLine(startPtr, ptr - startPtr, this));
                        startPtr = ptr;
                        inString = false;
                    }
                }
            }
            this.sublines.add(new SubLine(startPtr, ptr - startPtr, this));
            this.length = ptr - this.linePtr;
        }

        public List<String> getSource() {
            ArrayList<String> source = new ArrayList<String>();
            source.add(String.valueOf(this.lineNumber));
            for (SubLine subline : this.sublines) {
                source.add(subline.toSubString());
                while (subline.subline != null) {
                    subline = subline.subline;
                    source.add(subline.toSubString());
                }
            }
            return source;
        }
    }

    private class SubLine {
        SourceLine parent;
        int ptr;
        int length;
        String variable = "";
        String[] variables;
        SubLine subline;
        List<String> printLines;

        public SubLine(int startPtr, int length, SourceLine parent) {
            this.ptr = startPtr;
            this.length = length;
            this.parent = parent;
            switch (ApplesoftBasicProgram.this.buffer[startPtr]) {
                case -127: {
                    int ptr = startPtr + 1;
                    while (ApplesoftBasicProgram.this.buffer[ptr] != -48) {
                        this.variable = String.valueOf(this.variable) + (char)ApplesoftBasicProgram.this.buffer[ptr++];
                    }
                    break;
                }
                case -126: {
                    if (length > 2) {
                        String varList = new String(ApplesoftBasicProgram.this.buffer, startPtr + 1, length - 2);
                        this.variables = varList.split(",");
                        break;
                    }
                    this.variables = new String[0];
                    break;
                }
                case -83: {
                    int ptr = startPtr + 1;
                    while (ApplesoftBasicProgram.this.buffer[ptr] != -60 && ApplesoftBasicProgram.this.buffer[ptr] != -85) {
                        ++ptr;
                    }
                    this.subline = new SubLine(ptr, length - (ptr - startPtr), parent);
                    break;
                }
                case -60: {
                    if (ApplesoftBasicProgram.this.buffer[startPtr + 1] == -83) {
                        int ptr = startPtr + 2;
                        while (ApplesoftBasicProgram.this.buffer[ptr] != -60 && ApplesoftBasicProgram.this.buffer[ptr] != -85) {
                            ++ptr;
                        }
                        this.subline = new SubLine(ptr, length - (ptr - startPtr), parent);
                    }
                }
                case -70: {
                    if (ApplesoftBasicProgram.this.buffer[startPtr + 1] != 34) break;
                    if (ApplesoftBasicProgram.this.buffer[startPtr + length - 2] == 34) {
                        this.doPrintSplit(startPtr + 2, startPtr + length - 3, "\"");
                        break;
                    }
                    if (ApplesoftBasicProgram.this.buffer[startPtr + length - 3] != 34 || ApplesoftBasicProgram.this.buffer[startPtr + length - 2] != 59) break;
                    this.doPrintSplit(startPtr + 2, startPtr + length - 4, "\";");
                }
            }
        }

        private void doPrintSplit(int start, int end, String endText) {
            StringBuilder text = new StringBuilder();
            while (start <= end) {
                if (ApplesoftBasicProgram.this.buffer[start] == 34) {
                    return;
                }
                text.append((char)ApplesoftBasicProgram.this.buffer[start++]);
            }
            if (text.length() <= 40) {
                return;
            }
            this.printLines = new ArrayList<String>();
            while (text.length() > 40) {
                if (this.printLines.size() == 0) {
                    this.printLines.add("PRINT \"" + text.substring(0, 40));
                } else {
                    this.printLines.add("       " + text.substring(0, 40));
                }
                text.delete(0, 40);
            }
            this.printLines.add("       " + text.toString() + endText);
        }

        public boolean isLastSubLine() {
            return ApplesoftBasicProgram.this.buffer[this.ptr + this.length - 1] == 0;
        }

        public boolean isFor() {
            return this.variable.length() > 0;
        }

        public boolean isNext() {
            return this.variables != null;
        }

        public boolean isIf() {
            return ApplesoftBasicProgram.this.buffer[this.ptr] == -83;
        }

        public boolean isIfThenNext() {
            return this.subline != null && this.subline.isNext();
        }

        public boolean isSplitPrint() {
            return this.printLines != null;
        }

        public int type() {
            return HexFormatter.intValue(ApplesoftBasicProgram.this.buffer[this.ptr]);
        }

        public String toSubString() {
            String fullLine = this.toString();
            if (this.subline == null) {
                return fullLine;
            }
            String nextLine = this.subline.toString();
            return fullLine.substring(0, fullLine.length() - nextLine.length());
        }

        public String toString() {
            StringBuilder line = new StringBuilder();
            int i = this.ptr;
            int max = this.ptr + this.length - 1;
            while (i < max) {
                int b = HexFormatter.intValue(ApplesoftBasicProgram.this.buffer[i]);
                if (b > 127) {
                    if (line.length() > 0 && line.charAt(line.length() - 1) != ' ') {
                        line.append(' ');
                    }
                    if (b - 128 >= ApplesoftConstants.tokens.length) {
                        System.out.println("Invalid token : " + b);
                        break;
                    }
                    line.append(ApplesoftConstants.tokens[b - 128]);
                } else if (b < 32) {
                    if (b == 8 && line.length() > 0) {
                        line.deleteCharAt(line.length() - 1);
                    } else {
                        line.append("^" + (char)(b + 64));
                    }
                } else {
                    line.append((char)b);
                }
                ++i;
            }
            return line.toString();
        }
    }
}

