/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.gui.DataSource;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFile
implements DataSource {
    public String name;
    public byte[] buffer;
    AssemblerProgram assembler;
    protected BufferedImage image;
    protected List<HexBlock> hexBlocks = new ArrayList<HexBlock>();

    public AbstractFile(String name, byte[] buffer) {
        this.name = name;
        this.buffer = buffer;
    }

    @Override
    public String getText() {
        return "Name : " + this.name + "\n\nNo text description";
    }

    @Override
    public String getAssembler() {
        if (this.buffer == null) {
            return "No buffer";
        }
        if (this.assembler == null) {
            this.assembler = new AssemblerProgram(this.name, this.buffer, 0);
        }
        return this.assembler.getText();
    }

    @Override
    public String getHexDump() {
        if (this.hexBlocks.size() > 0) {
            StringBuilder text = new StringBuilder();
            for (HexBlock hb : this.hexBlocks) {
                if (hb.title != null) {
                    text.append(String.valueOf(hb.title) + "\n\n");
                }
                text.append(String.valueOf(HexFormatter.format(this.buffer, hb.ptr, hb.size)) + "\n\n");
            }
            text.deleteCharAt(text.length() - 1);
            text.deleteCharAt(text.length() - 1);
            return text.toString();
        }
        if (this.buffer == null || this.buffer.length == 0) {
            return "No buffer";
        }
        if (this.buffer.length <= 99999) {
            return HexFormatter.format(this.buffer, 0, this.buffer.length);
        }
        return HexFormatter.format(this.buffer, 0, 99999);
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    protected class HexBlock {
        public int ptr;
        public int size;
        public String title;

        public HexBlock(int ptr, int size, String title) {
            this.ptr = ptr;
            this.size = size;
            this.title = title;
        }
    }
}

