/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.common;

import java.awt.Dimension;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public class State {
    private static final String PREF_WINDOW_WIDTH = "WindowWidth";
    private static final String PREF_WINDOW_HEIGHT = "WindowHeight";
    private static final String PREF_WINDOW_STATE = "WindowExtendedState";
    public Preferences preferences;

    public State(Preferences preferences) {
        this.preferences = preferences;
    }

    public void clear() {
        try {
            this.preferences.clear();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public Dimension getWindowSize(int defaultWidth, int defaultHeight) {
        int width = this.preferences.getInt(PREF_WINDOW_WIDTH, defaultWidth);
        int height = this.preferences.getInt(PREF_WINDOW_HEIGHT, defaultHeight);
        return new Dimension(width, height);
    }

    public int getExtendedState(int defaultState) {
        return this.preferences.getInt(PREF_WINDOW_STATE, defaultState);
    }

    public void save(JFrame window) {
        this.preferences.putInt(PREF_WINDOW_WIDTH, window.getWidth());
        this.preferences.putInt(PREF_WINDOW_HEIGHT, window.getHeight());
        this.preferences.putInt(PREF_WINDOW_STATE, window.getExtendedState());
    }
}

