/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.common;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import javax.swing.UIManager;

public class Platform {
    public static final String OS = System.getProperty("os.name").toLowerCase();
    public static final String separator = System.getProperty("file.separator");
    public static final String userHome = System.getProperty("user.home");
    public static final boolean MAC = OS.startsWith("mac os");
    public static final boolean MAC_OS_X = OS.startsWith("mac os x");
    public static final boolean LINUX = OS.equals("linux");
    public static final boolean WINDOWS = OS.startsWith("windows");
    public static Toolkit toolkit = Toolkit.getDefaultToolkit();
    public static final int MENU_MASK = toolkit.getMenuShortcutKeyMask();
    private static String fontName = MAC_OS_X ? "Monaco" : (WINDOWS ? "Lucida Sans Typewriter" : "Lucida Sans Typewriter");
    private static GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    public static String[] fontNames = ge.getAvailableFontFamilyNames();

    public static void setLookAndFeel() {
        try {
            if (MAC) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            } else {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isFontAvailable(String name) {
        String[] stringArray = fontNames;
        int n = fontNames.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Font getFont(FontType fontType, FontSize fontSize) {
        switch (fontSize) {
            case BASE: {
                return Platform.getFont(fontType, 12);
            }
            case BASE_PLUS_1: {
                return Platform.getFont(fontType, 14);
            }
            case BASE_PLUS_2: {
                return Platform.getFont(fontType, 16);
            }
            case BASE_MINUS_1: {
                return Platform.getFont(fontType, 10);
            }
            case BASE_MINUS_2: {
                return Platform.getFont(fontType, 8);
            }
        }
        return Platform.getFont(fontType, 12);
    }

    public static Font getFont(FontType fontType, int type, int fontSize) {
        assert (Platform.isFontAvailable(fontName));
        switch (fontType) {
            case PLAIN: {
                return new Font(fontName, type, fontSize);
            }
            case SANS_SERIF: {
                return new Font("SansSerif", type, fontSize);
            }
            case SERIF: {
                return new Font("Serif", type, fontSize);
            }
            case MONOSPACED: {
                return new Font("Monospaced", type, fontSize);
            }
        }
        return new Font(fontName, type, fontSize);
    }

    public static Font getFont(FontType fontType, int fontSize) {
        return Platform.getFont(fontType, 0, fontSize);
    }

    public static enum FontSize {
        BASE_MINUS_2,
        BASE_MINUS_1,
        BASE,
        BASE_PLUS_1,
        BASE_PLUS_2;

    }

    public static enum FontType {
        PLAIN,
        SANS_SERIF,
        SERIF,
        MONOSPACED;

    }
}

