/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.exportfile;

import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportFileDestinationPane;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExportGraphicsTypePane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private Composite parent;
    private Object layoutData;
    private Composite control;
    private ExportWizard wizard;

    public ExportGraphicsTypePane(Composite composite, ExportWizard exportWizard, Object object) {
        this.parent = composite;
        this.wizard = exportWizard;
        this.layoutData = object;
    }

    public WizardPane getNextPane() {
        return new ExportFileDestinationPane(this.parent, this.wizard, this.layoutData);
    }

    public void open() {
        this.wizard.enableFinishButton(false);
        this.wizard.enableNextButton(true);
        this.control = new Composite(this.parent, 0);
        this.control.setLayoutData(this.layoutData);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.justify = true;
        rowLayout.marginBottom = 5;
        rowLayout.marginLeft = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginTop = 5;
        rowLayout.spacing = 3;
        this.control.setLayout((Layout)rowLayout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("ExportGraphicsTypePrompt"));
        RowLayout rowLayout2 = new RowLayout(512);
        rowLayout2.justify = true;
        rowLayout2.spacing = 3;
        Composite composite = new Composite(this.control, 0);
        composite.setLayout((Layout)rowLayout2);
        Button button = new Button(composite, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeHiresBlackAndWhite"));
        button.setSelection(this.getGraphicsFilter().isHiresBlackAndWhiteMode());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(1);
            }
        });
        button = new Button(composite, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeHiresColor"));
        button.setSelection(this.getGraphicsFilter().isHiresColorMode());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(2);
            }
        });
        button = new Button(composite, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeDoubleHiresBlackAndWhite"));
        button.setSelection(this.getGraphicsFilter().isDoubleHiresBlackAndWhiteMode());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(3);
            }
        });
        button = new Button(composite, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeDoubleHiresColor"));
        button.setSelection(this.getGraphicsFilter().isDoubleHiresColorMode());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(4);
            }
        });
        button = new Button(composite, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeSuperHiresColor"));
        button.setSelection(this.getGraphicsFilter().isSuperHires16Mode());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(5);
            }
        });
        button = new Button(composite, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeSuperHires3200Color"));
        button.setSelection(this.getGraphicsFilter().isSuperHires3200Mode());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(6);
            }
        });
        button = new Button(composite, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeQuickDraw2Icon"));
        button.setSelection(this.getGraphicsFilter().isQuickDraw2Icon());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(7);
            }
        });
        label = new Label(this.control, 64);
        label.setText(this.textBundle.get("ExportGraphicsFileFormatPrompt"));
        Composite composite2 = new Composite(this.control, 0);
        composite2.setLayout((Layout)rowLayout2);
        String[] stringArray = GraphicsFileFilter.getFileExtensions();
        for (int i = 0; i < stringArray.length; ++i) {
            button = new Button(composite2, 16);
            button.setText(stringArray[i]);
            button.setSelection(stringArray[i].equals(this.getGraphicsFilter().getExtension()));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Button button = (Button)selectionEvent.getSource();
                    ExportGraphicsTypePane.this.getGraphicsFilter().setExtension(button.getText());
                }
            });
        }
    }

    public void dispose() {
        this.control.dispose();
        this.control = null;
    }

    protected GraphicsFileFilter getGraphicsFilter() {
        return (GraphicsFileFilter)this.wizard.getFileFilter();
    }
}

