/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DiskMapTab {
    private FormattedDisk disk;
    private TextBundle textBundle = UiBundle.getInstance();
    private Color freeFill;
    private Color usedFill;
    private Color black;
    private Color gray;

    public DiskMapTab(CTabFolder cTabFolder, FormattedDisk formattedDisk) {
        this.disk = formattedDisk;
        this.freeFill = new Color((Device)cTabFolder.getDisplay(), 100, 200, 100);
        this.usedFill = new Color((Device)cTabFolder.getDisplay(), 200, 100, 100);
        this.black = new Color((Device)cTabFolder.getDisplay(), 0, 0, 0);
        this.gray = new Color((Device)cTabFolder.getDisplay(), 50, 50, 50);
        this.createDiskMapTab(cTabFolder);
    }

    protected void createDiskMapTab(CTabFolder cTabFolder) {
        CTabItem cTabItem = new CTabItem(cTabFolder, 0);
        if (this.disk.getLogicalDiskNumber() > 0) {
            cTabItem.setText(this.textBundle.get("DiskMapTab.MultipleTabsTitle") + this.disk.getLogicalDiskNumber());
        } else {
            cTabItem.setText(this.textBundle.get("DiskMapTab.SingleTabTitle"));
        }
        Canvas canvas = new Canvas((Composite)cTabFolder, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        canvas.setLayout((Layout)gridLayout);
        cTabItem.setControl((Control)canvas);
        String[] stringArray = this.disk.getBitmapLabels();
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 20;
        Label label = new Label((Composite)canvas, 16384);
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length == 1) {
            stringBuffer.append(this.textBundle.format("DiskMapTab.BlockDecriptiveLabel", stringArray[0].toLowerCase()));
        } else {
            stringBuffer.append(this.textBundle.format("DiskMapTab.TrackAndSectorDecriptiveLabel", new Object[]{stringArray[0].toLowerCase(), stringArray[1].toLowerCase()}));
        }
        label.setText(stringBuffer.toString());
        label.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.heightHint = 20;
        gridData.widthHint = 20;
        Composite composite = new Composite((Composite)canvas, 0);
        composite.setLayoutData((Object)gridData);
        gridData = new GridData(256);
        gridData.heightHint = 20;
        Canvas canvas2 = new Canvas((Composite)canvas, 0);
        canvas2.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                DiskMapTab.this.paintHorizontalRuler(paintEvent);
            }
        });
        canvas2.setLayoutData((Object)gridData);
        gridData = new GridData(16);
        gridData.widthHint = 20;
        canvas2 = new Canvas((Composite)canvas, 0);
        canvas2.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                DiskMapTab.this.paintVerticalRuler(paintEvent);
            }
        });
        canvas2.setLayoutData((Object)gridData);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        Canvas canvas3 = new Canvas((Composite)canvas, 2048);
        canvas3.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                DiskMapTab.this.paintMap(paintEvent);
            }
        });
        canvas3.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.heightHint = 20;
        gridData.horizontalSpan = 2;
        Canvas canvas4 = new Canvas((Composite)canvas, 0);
        canvas4.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                DiskMapTab.this.paintLegend(paintEvent);
            }
        });
        canvas4.setLayoutData((Object)gridData);
    }

    public void dispose() {
        this.freeFill.dispose();
        this.usedFill.dispose();
        this.black.dispose();
        this.gray.dispose();
    }

    protected void paintHorizontalRuler(PaintEvent paintEvent) {
        String string = (this.disk.getBitmapLabels()[0] + "s").toUpperCase();
        Canvas canvas = (Canvas)paintEvent.widget;
        Rectangle rectangle = canvas.getClientArea();
        paintEvent.gc.drawLine(rectangle.x, rectangle.y + rectangle.height / 2, rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
        Point point = paintEvent.gc.textExtent(string);
        paintEvent.gc.drawString(string, rectangle.x + rectangle.width / 2 - point.x, rectangle.y + rectangle.height / 2 - point.y / 2);
    }

    protected void paintVerticalRuler(PaintEvent paintEvent) {
        String string = (this.disk.getBitmapLabels()[0] + "s").toUpperCase();
        if (this.disk.getBitmapLabels().length == 2) {
            string = (this.disk.getBitmapLabels()[1] + "s").toUpperCase();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(string.charAt(i));
        }
        string = stringBuffer.toString();
        Canvas canvas = (Canvas)paintEvent.widget;
        Rectangle rectangle = canvas.getClientArea();
        paintEvent.gc.drawLine(rectangle.x + rectangle.width / 2, rectangle.y, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
        Point point = paintEvent.gc.textExtent(string);
        paintEvent.gc.drawText(string, rectangle.x + rectangle.width / 2 - point.x / 2, rectangle.y + rectangle.height / 2 - point.y / 2);
    }

    protected void paintMap(PaintEvent paintEvent) {
        if (this.disk.getDiskUsage() == null) {
            this.paintNoMap(paintEvent);
        } else if (this.disk.getBitmapDimensions() == null) {
            this.paintBlockMap(paintEvent);
        } else {
            this.paintSectorMap(paintEvent);
        }
    }

    protected void paintLegend(PaintEvent paintEvent) {
        Color color = paintEvent.gc.getBackground();
        Canvas canvas = (Canvas)paintEvent.widget;
        int n = paintEvent.gc.getFontMetrics().getHeight();
        String string = this.textBundle.get("DiskMapTab.FreeLegend");
        String string2 = this.textBundle.get("DiskMapTab.UsedLegend");
        int n2 = 50;
        int n3 = (n + 5) * 2 + paintEvent.gc.textExtent((String)string).x + paintEvent.gc.textExtent((String)string2).x;
        int n4 = canvas.getClientArea().width / 2 - n3;
        Rectangle rectangle = new Rectangle(n4, 0, n, n);
        this.drawBox(rectangle, paintEvent.gc, this.freeFill, this.black, this.gray);
        paintEvent.gc.setBackground(color);
        paintEvent.gc.drawText(string, n4 += n, 0);
        n4 += paintEvent.gc.textExtent((String)string).x;
        rectangle = new Rectangle(n4 += n2, 0, n, n);
        this.drawBox(rectangle, paintEvent.gc, this.usedFill, this.black, this.gray);
        paintEvent.gc.setBackground(color);
        paintEvent.gc.drawText(string2, n4 += n, 0);
    }

    private void paintNoMap(PaintEvent paintEvent) {
        paintEvent.gc.drawString(this.textBundle.get("DiskMapTab.DiskMapUnavailableMessage"), 0, 0);
    }

    private void paintSectorMap(PaintEvent paintEvent) {
        int[] nArray = this.disk.getBitmapDimensions();
        int n = nArray[1];
        int n2 = nArray[0];
        this.paintDiskMap(n2, n, paintEvent);
    }

    private void paintBlockMap(PaintEvent paintEvent) {
        int n;
        double d;
        Canvas canvas = (Canvas)paintEvent.widget;
        Rectangle rectangle = canvas.getClientArea();
        double d2 = rectangle.width;
        double d3 = this.disk.getBitmapLength();
        double d4 = Math.sqrt(d3 / (d2 * (d = (double)rectangle.height)));
        int n2 = (int)(d2 * d4 + 0.5);
        if ((double)(n2 * (n = (int)(d * d4 + 0.5))) < d3) {
            ++n2;
        }
        if ((double)(n2 * n) < d3) {
            ++n;
        }
        this.paintDiskMap(n2, n, paintEvent);
    }

    private void paintDiskMap(int n, int n2, PaintEvent paintEvent) {
        Canvas canvas = (Canvas)paintEvent.widget;
        Rectangle rectangle = canvas.getClientArea();
        rectangle.width -= 2;
        rectangle.height -= 2;
        int[] nArray = new int[n2 + 1];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i * rectangle.height / n2 + 1;
        }
        nArray[n2] = rectangle.height;
        int[] nArray2 = new int[n + 1];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = i * rectangle.width / n + 1;
        }
        nArray2[n] = rectangle.width;
        Image image = new Image((Device)canvas.getDisplay(), rectangle);
        GC gC = new GC((Drawable)image);
        int n3 = 0;
        int n4 = 0;
        FormattedDisk.DiskUsage diskUsage = this.disk.getDiskUsage();
        for (n3 = 0; n3 < n && diskUsage.hasNext(); ++n3) {
            for (n4 = 0; n4 < n2 && diskUsage.hasNext(); ++n4) {
                diskUsage.next();
                boolean bl = diskUsage.isFree();
                Rectangle rectangle2 = new Rectangle(nArray2[n3], nArray[n4], nArray2[n3 + 1] - nArray2[n3], nArray[n4 + 1] - nArray[n4]);
                this.drawBox(rectangle2, gC, bl ? this.freeFill : this.usedFill, this.black, this.gray);
            }
        }
        paintEvent.gc.drawImage(image, 0, 0);
        gC.dispose();
        image.dispose();
    }

    protected void drawBox(Rectangle rectangle, GC gC, Color color, Color color2, Color color3) {
        if (rectangle.width >= 10 && rectangle.height >= 10) {
            int n = Math.min(rectangle.height, rectangle.width);
            rectangle.height = n + (rectangle.height - n) / 2;
            rectangle.width = n + (rectangle.width - n) / 2;
            rectangle.x += 2;
            rectangle.y += 2;
            rectangle.width -= 5;
            rectangle.height -= 5;
            gC.setBackground(color3);
            gC.fillRectangle(rectangle);
            rectangle.x -= 2;
            rectangle.y -= 2;
            gC.setBackground(color);
            gC.fillRectangle(rectangle);
            gC.setForeground(color2);
            gC.drawRectangle(rectangle);
        } else {
            gC.setBackground(color);
            gC.fillRectangle(rectangle);
        }
    }
}

