/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.cpm.CpmFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.OzDosFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.UniDosFormatDisk;
import com.webcodepro.applecommander.storage.os.pascal.PascalFormatDisk;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.os.rdos.RdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.storage.physical.NibbleOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.storage.physical.UniversalDiskImageLayout;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.StreamUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Disk {
    public static final int BLOCK_SIZE = 512;
    public static final int SECTOR_SIZE = 256;
    public static final int PRODOS_BLOCKS_ON_140KB_DISK = 280;
    public static final int DOS33_SECTORS_ON_140KB_DISK = 560;
    public static final int APPLE_140KB_DISK = 143360;
    public static final int APPLE_140KB_NIBBLE_DISK = 232960;
    public static final int APPLE_800KB_DISK = 819200;
    public static final int APPLE_800KB_2IMG_DISK = 819264;
    public static final int APPLE_5MB_HARDDISK = 0x500000;
    public static final int APPLE_10MB_HARDDISK = 0xA00000;
    public static final int APPLE_20MB_HARDDISK = 0x1400000;
    public static final int APPLE_32MB_HARDDISK = 33553920;
    private static FilenameFilter[] filenameFilters;
    private TextBundle textBundle = StorageBundle.getInstance();
    private String filename;
    private boolean newImage = false;
    private ByteArrayImageLayout diskImageManager;
    private ImageOrder imageOrder;

    public static FilenameFilter[] getFilenameFilters() {
        if (filenameFilters == null) {
            new Disk();
        }
        return filenameFilters;
    }

    private Disk() {
        filenameFilters = new FilenameFilter[]{new FilenameFilter(this.textBundle.get("Disk.AllImages"), "*.do; *.dsk; *.po; *.nib; *.2mg; *.2img; *.hdv; *.do.gz; *.dsk.gz; *.po.gz; *.nib.gz; *.2mg.gz; *.2img.gz"), new FilenameFilter(this.textBundle.get("Disk.140kDosImages"), "*.do; *.dsk; *.do.gz; *.dsk.gz"), new FilenameFilter(this.textBundle.get("Disk.140kNibbleImages"), "*.nib; *.nib.gz"), new FilenameFilter(this.textBundle.get("Disk.140kProdosImages"), "*.po; *.po.gz"), new FilenameFilter(this.textBundle.get("Disk.800kProdosImages"), "*.2mg; *.2img; *.2mg.gz, *.2img.gz"), new FilenameFilter(this.textBundle.get("Disk.ApplePcImages"), "*.hdv"), new FilenameFilter(this.textBundle.get("Disk.CompressedImages"), "*.do.gz; *.dsk.gz; *.po.gz; *.2mg.gz; *.2img.gz"), new FilenameFilter(this.textBundle.get("Disk.AllFiles"), "*.*")};
    }

    protected Disk(String string, ImageOrder imageOrder) {
        this.imageOrder = imageOrder;
        this.filename = string;
        this.newImage = true;
    }

    public Disk(String string) throws IOException {
        this.filename = string;
        File file = new File(string);
        InputStream inputStream = new FileInputStream(file);
        if (this.isCompressed()) {
            inputStream = new GZIPInputStream(inputStream);
        }
        int n = (int)file.length();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        StreamUtil.copy(inputStream, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n2 = 64;
        this.diskImageManager = byArray.length == 819200 + n2 || byArray.length == 0x500000 + n2 || byArray.length == 0xA00000 + n2 || byArray.length == 0x1400000 + n2 || byArray.length == 33553920 + n2 ? new UniversalDiskImageLayout(byArray) : new ByteArrayImageLayout(byArray);
        if (this.isProdosOrder()) {
            this.imageOrder = new ProdosOrder(this.diskImageManager);
        } else if (this.isDosOrder()) {
            this.imageOrder = new DosOrder(this.diskImageManager);
        } else if (this.isNibbleOrder()) {
            this.imageOrder = new NibbleOrder(this.diskImageManager);
        }
    }

    public void save() throws IOException {
        File file = new File(this.getFilename());
        if (!file.exists()) {
            file.createNewFile();
        }
        OutputStream outputStream = new FileOutputStream(file);
        if (this.isCompressed()) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        outputStream.write(this.getDiskImageManager().getDiskImage());
        outputStream.close();
        this.getDiskImageManager().setChanged(false);
        this.newImage = false;
    }

    public void saveAs(String string) throws IOException {
        this.filename = string;
        this.save();
    }

    public FormattedDisk[] getFormattedDisks() {
        if (this.isProdosFormat()) {
            return new FormattedDisk[]{new ProdosFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isUniDosFormat()) {
            return new FormattedDisk[]{new UniDosFormatDisk(this.filename, this.imageOrder, 0), new UniDosFormatDisk(this.filename, this.imageOrder, 50)};
        }
        if (this.isOzDosFormat()) {
            return new FormattedDisk[]{new OzDosFormatDisk(this.filename, this.imageOrder, 0), new OzDosFormatDisk(this.filename, this.imageOrder, 256)};
        }
        if (this.isDosFormat()) {
            return new FormattedDisk[]{new DosFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isPascalFormat()) {
            return new FormattedDisk[]{new PascalFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isRdosFormat()) {
            return new FormattedDisk[]{new RdosFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isCpmFormat()) {
            return new FormattedDisk[]{new CpmFormatDisk(this.filename, this.imageOrder)};
        }
        return null;
    }

    public ByteArrayImageLayout getDiskImageManager() {
        if (this.imageOrder != null) {
            return this.imageOrder.getDiskImageManager();
        }
        return this.diskImageManager;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public boolean isCompressed() {
        return this.filename.toLowerCase().endsWith(".gz");
    }

    public boolean isProdosOrder() {
        return this.filename.toLowerCase().endsWith(".po") || this.filename.toLowerCase().endsWith(".po.gz") || this.is2ImgOrder() || this.filename.toLowerCase().endsWith(".hdv") || this.getPhysicalSize() >= 819264;
    }

    public boolean isDosOrder() {
        return this.filename.toLowerCase().endsWith(".do") || this.filename.toLowerCase().endsWith(".do.gz") || this.filename.toLowerCase().endsWith(".dsk") || this.filename.toLowerCase().endsWith(".dsk.gz");
    }

    public boolean is2ImgOrder() {
        return this.filename.toLowerCase().endsWith(".2img") || this.filename.toLowerCase().endsWith(".2img.gz") || this.filename.toLowerCase().endsWith(".2mg") || this.filename.toLowerCase().endsWith(".2mg.gz");
    }

    public boolean isNibbleOrder() {
        return this.filename.toLowerCase().endsWith(".nib") || this.filename.toLowerCase().endsWith(".nib.gz");
    }

    public int getPhysicalSize() {
        if (this.getDiskImageManager() != null) {
            return this.getDiskImageManager().getPhysicalSize();
        }
        return this.getImageOrder().getPhysicalSize();
    }

    protected void resizeDiskImage(int n) {
        if (n < this.getPhysicalSize()) {
            throw new IllegalArgumentException(this.textBundle.get("Disk.ResizeDiskError"));
        }
        byte[] byArray = new byte[n];
        byte[] byArray2 = this.imageOrder.getDiskImageManager().getDiskImage();
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        this.imageOrder.getDiskImageManager().setDiskImage(byArray);
    }

    public byte[] readBlock(int n) {
        return this.imageOrder.readBlock(n);
    }

    public void writeBlock(int n, byte[] byArray) {
        this.imageOrder.writeBlock(n, byArray);
    }

    public byte[] readSector(int n, int n2) throws IllegalArgumentException {
        return this.imageOrder.readSector(n, n2);
    }

    public void writeSector(int n, int n2, byte[] byArray) throws IllegalArgumentException {
        this.imageOrder.writeSector(n, n2, byArray);
    }

    public boolean isProdosFormat() {
        byte[] byArray = this.readBlock(2);
        return byArray[0] == 0 && byArray[1] == 0 && (byArray[4] & 0xF0) == 240;
    }

    public boolean isDosFormat() {
        if (!this.is140KbDisk()) {
            return false;
        }
        byte[] byArray = this.readSector(17, 0);
        return (this.imageOrder.isSizeApprox(143360) || this.imageOrder.isSizeApprox(232960)) && byArray[1] == 17 && byArray[39] == 122 && byArray[52] == 35 && byArray[53] == 16;
    }

    public boolean isUniDosFormat() {
        if (!this.is800KbDisk()) {
            return false;
        }
        byte[] byArray = this.readSector(17, 0);
        byte[] byArray2 = this.readSector(67, 0);
        return byArray[1] == 17 && byArray[2] == 31 && byArray[39] == 122 && byArray[52] == 50 && byArray[53] == 32 && byArray[54] == 0 && byArray[55] == 1 && byArray2[1] == 17 && byArray2[2] == 31 && byArray2[39] == 122 && byArray2[52] == 50 && byArray2[53] == 32 && byArray2[54] == 0 && byArray2[55] == 1;
    }

    public boolean isOzDosFormat() {
        if (!this.is800KbDisk()) {
            return false;
        }
        byte[] byArray = this.readBlock(544);
        return byArray[1] == 17 && byArray[2] == 31 && byArray[39] == 122 && byArray[52] == 50 && byArray[53] == 32 && byArray[54] == 0 && byArray[55] == 1 && byArray[311] == 1 && byArray[257] == 17 && byArray[258] == 31 && byArray[295] == 122 && byArray[308] == 50 && byArray[309] == 32 && byArray[310] == 0 && byArray[311] == 1;
    }

    public boolean isPascalFormat() {
        if (!this.is140KbDisk() && !this.is800KbDisk()) {
            return false;
        }
        byte[] byArray = this.readBlock(2);
        return byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 6 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0;
    }

    public boolean isCpmFormat() {
        int n;
        if (!this.is140KbDisk()) {
            return false;
        }
        byte[] byArray = this.readSector(3, 0);
        int[] nArray = new int[256];
        for (n = 0; n < byArray.length; ++n) {
            nArray[n] = AppleUtil.getUnsignedByte(byArray[n]);
        }
        for (n = 0; n < byArray.length; n += 32) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < 32; ++n2) {
                n3 += nArray[n + n2] == 229 ? 1 : 0;
            }
            if (n3 == 32) continue;
            if (nArray[n] > 15 && nArray[n] != 229) {
                return false;
            }
            for (n2 = 0; n2 < 8; ++n2) {
                if (nArray[n + 1 + n2] <= 127) continue;
                return false;
            }
            if (nArray[n + 12] > 31 || nArray[n + 14] > 0) {
                return false;
            }
            if (nArray[n + 15] <= 128) continue;
            return false;
        }
        return true;
    }

    protected boolean is140KbDisk() {
        return this.getPhysicalSize() >= 143360 && this.getPhysicalSize() <= 232960;
    }

    protected boolean is800KbDisk() {
        return this.getPhysicalSize() >= 819200 && this.getPhysicalSize() <= 819264;
    }

    public boolean isRdosFormat() {
        if (!this.is140KbDisk()) {
            return false;
        }
        byte[] byArray = this.readSector(0, 13);
        String string = AppleUtil.getString(byArray, 224, 4);
        return "RDOS".equals(string);
    }

    public boolean hasChanged() {
        return this.getDiskImageManager().hasChanged();
    }

    public boolean isNewImage() {
        return this.newImage;
    }

    public ImageOrder getImageOrder() {
        return this.imageOrder;
    }

    protected void setImageOrder(ImageOrder imageOrder) {
        this.imageOrder = imageOrder;
    }

    public class FilenameFilter {
        private String names;
        private String extensions;

        public FilenameFilter(String string, String string2) {
            this.names = string;
            this.extensions = string2;
        }

        public String getExtensions() {
            return this.extensions;
        }

        public String getNames() {
            return this.names;
        }
    }
}

