/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.comparedisks;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.comparedisks.CompareDisksWizard;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CompareDisksResultsPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private Composite parent;
    private Object layoutData;
    private Composite control;
    private CompareDisksWizard wizard;

    public CompareDisksResultsPane(Composite composite, CompareDisksWizard compareDisksWizard, Object object) {
        this.parent = composite;
        this.wizard = compareDisksWizard;
        this.layoutData = object;
    }

    public void open() {
        this.control = new Composite(this.parent, 0);
        this.control.setLayoutData(this.layoutData);
        this.wizard.enableNextButton(false);
        this.wizard.enableFinishButton(true);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.justify = true;
        rowLayout.marginBottom = 5;
        rowLayout.marginLeft = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginTop = 5;
        rowLayout.spacing = 3;
        this.control.setLayout((Layout)rowLayout);
        String string = this.compareDisks();
        Label label = new Label(this.control, 64);
        label.setText(string);
        label = new Label(this.control, 64);
        label.setText(this.textBundle.get("CompareDisksResultsPane.RestartText"));
    }

    public WizardPane getNextPane() {
        return null;
    }

    public void dispose() {
        this.control.dispose();
        this.control = null;
    }

    protected String compareDisks() {
        StringBuffer stringBuffer = new StringBuffer();
        FormattedDisk[] formattedDiskArray = null;
        try {
            formattedDiskArray = new Disk(this.wizard.getDiskname1()).getFormattedDisks();
        }
        catch (Throwable throwable) {
            stringBuffer.append(this.textBundle.format("CompareDisksResultsPane.UnableToLoadDiskN", new Object[]{new Integer(1), throwable.getLocalizedMessage()}));
        }
        FormattedDisk[] formattedDiskArray2 = null;
        try {
            formattedDiskArray2 = new Disk(this.wizard.getDiskname2()).getFormattedDisks();
        }
        catch (Throwable throwable) {
            stringBuffer.append(this.textBundle.format("CompareDisksResultsPane.UnableToLoadDiskN", new Object[]{new Integer(2), throwable.getLocalizedMessage()}));
        }
        if (formattedDiskArray != null && formattedDiskArray2 != null) {
            if (formattedDiskArray.length != formattedDiskArray2.length) {
                stringBuffer.append(this.textBundle.get("CompareDisksResultsPane.DifferentSizeError"));
            } else {
                boolean bl;
                boolean bl2 = formattedDiskArray[0].isCpmFormat() || formattedDiskArray[0].isDosFormat() || formattedDiskArray[0].isRdosFormat();
                boolean bl3 = bl = formattedDiskArray2[0].isCpmFormat() || formattedDiskArray2[0].isDosFormat() || formattedDiskArray2[0].isRdosFormat();
                if (bl2 && bl) {
                    if (!AppleUtil.disksEqualByTrackAndSector(formattedDiskArray[0], formattedDiskArray2[0])) {
                        stringBuffer.append(this.textBundle.get("CompareDisksResultsPane.DataDiffersMessage"));
                    }
                } else if (!bl2 && !bl) {
                    if (!AppleUtil.disksEqualByBlock(formattedDiskArray[0], formattedDiskArray2[0])) {
                        stringBuffer.append(this.textBundle.get("CompareDisksResultsPane.DataDiffersMessage"));
                    }
                } else {
                    stringBuffer.append(this.textBundle.get("CompareDisksResultsPane.DifferentDataFormatError"));
                }
            }
        }
        if (stringBuffer.length() == 0) {
            return this.textBundle.get("CompareDisksResultsPane.DisksMatch");
        }
        return stringBuffer.toString();
    }
}

