/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.util.contentadapter;

import com.webcodepro.applecommander.ui.swt.util.SwtUtil;
import com.webcodepro.applecommander.ui.swt.util.contentadapter.ContentTypeAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Control;

public class StyledTextAdapter
implements ContentTypeAdapter {
    private StyledText styledText;
    private String printJobName;

    public StyledTextAdapter(StyledText styledText, String string) {
        this.styledText = styledText;
        this.printJobName = string;
    }

    public void print() {
        final Printer printer = SwtUtil.showPrintDialog((Control)this.styledText);
        if (printer == null) {
            return;
        }
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.jobName = this.printJobName;
        styledTextPrintOptions.printLineBackground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.footer = "\t<page>";
        styledTextPrintOptions.header = "\t" + this.printJobName;
        final Runnable runnable = this.styledText.print(printer, styledTextPrintOptions);
        new Thread(new Runnable(){

            public void run() {
                runnable.run();
                printer.dispose();
            }
        }).start();
    }

    public void selectAll() {
        this.styledText.selectAll();
    }

    public void copy() {
        if (this.styledText.getSelectionCount() == 0) {
            Point point = this.styledText.getSelection();
            this.styledText.selectAll();
            this.styledText.copy();
            this.styledText.setSelection(point);
        } else {
            this.styledText.copy();
        }
    }
}

