/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.util;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class SwtUtil {
    private static TextBundle textBundle = UiBundle.getInstance();

    public static void center(Shell shell, Shell shell2) {
        int n = shell.getLocation().x + (shell.getSize().x - shell2.getSize().x) / 2;
        int n2 = shell.getLocation().y + (shell.getSize().y - shell2.getSize().y) / 2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        shell2.setLocation(n, n2);
    }

    public static void setupPagingInformation(ScrolledComposite scrolledComposite) {
        GC gC = new GC((Drawable)scrolledComposite);
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getAverageCharWidth();
        Rectangle rectangle = scrolledComposite.getClientArea();
        int n3 = rectangle.height / n;
        int n4 = n3 * n;
        int n5 = rectangle.width - n2;
        scrolledComposite.getVerticalBar().setIncrement(n);
        scrolledComposite.getVerticalBar().setPageIncrement(n4);
        scrolledComposite.getHorizontalBar().setIncrement(n2);
        scrolledComposite.getHorizontalBar().setPageIncrement(n5);
    }

    public static Printer showPrintDialog(Control control) {
        PrintDialog printDialog = new PrintDialog(control.getShell());
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            return null;
        }
        return new Printer(printerData);
    }

    public static int showYesNoDialog(Shell shell, String string, String string2) {
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText(string);
        messageBox.setMessage(string2);
        return messageBox.open();
    }

    public static int showOkCancelErrorDialog(Shell shell, String string, String string2) {
        MessageBox messageBox = new MessageBox(shell, 289);
        messageBox.setText(string);
        messageBox.setMessage(string2);
        return messageBox.open();
    }

    public static void showErrorDialog(Shell shell, String string, String string2) {
        MessageBox messageBox = new MessageBox(shell, 33);
        messageBox.setText(string);
        messageBox.setMessage(string2);
        messageBox.open();
    }

    public static void showSystemErrorDialog(Shell shell, Throwable throwable) {
        SwtUtil.showErrorDialog(shell, textBundle.get("SystemErrorTitle"), textBundle.format("SystemErrorMessage", throwable.getMessage()));
    }
}

