/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.util.AppleUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AppleWorksWordProcessorFileFilter
implements FileFilter {
    private static final int RENDER_AS_TEXT = 0;
    private static final int RENDER_AS_HTML = 1;
    private static final int RENDER_AS_RTF = 2;
    private int rendering = 0;
    private boolean inHeaderOrFooter = false;
    private static final int TWIPS_PER_INCH = 1440;
    private static final int CODE_BOLD_ON = 1;
    private static final int CODE_BOLD_OFF = 2;
    private static final int CODE_SUPERSCRIPT_ON = 3;
    private static final int CODE_SUPERSCRIPT_OFF = 4;
    private static final int CODE_SUBSCRIPT_ON = 5;
    private static final int CODE_SUBSCRIPT_OFF = 6;
    private static final int CODE_UNDERLINE_ON = 7;
    private static final int CODE_UNDERLINE_OFF = 8;
    private static final int CODE_PAGE_NUMBER = 9;
    private static final int CODE_STICKY_SPACE = 11;
    private static final int CODE_DATE = 14;
    private static final int CODE_TIME = 15;
    private static final int COMMAND_PAGEHEADER_END = 213;
    private static final int COMMAND_PAGEFOOTER_END = 214;
    private static final int COMMAND_RIGHT = 215;
    private static final int COMMAND_PLATEN_WIDTH = 216;
    private static final int COMMAND_MARGIN_LEFT = 217;
    private static final int COMMAND_MARGIN_RIGHT = 218;
    private static final int COMMAND_JUSTIFY = 223;
    private static final int COMMAND_LEFT = 224;
    private static final int COMMAND_CENTER = 225;
    private static final int COMMAND_PAPER_LENGTH = 226;
    private static final int COMMAND_MARGIN_TOP = 227;
    private static final int COMMAND_MARGIN_BOTTOM = 228;
    private static final int COMMAND_NEW_PAGE = 233;
    private static final int COMMAND_PAGEHEADER = 237;
    private static final int COMMAND_PAGEFOOTER = 236;
    private static final int COMMAND_SKIP_LINES = 238;
    private static final int COMMAND_PAGE_BREAK = 244;
    private static final int COMMAND_PAGE_BREAK_256 = 245;
    private static final int COMMAND_EOF = 255;

    public byte[] filter(FileEntry fileEntry) {
        byte[] byArray = fileEntry.getFileData();
        if (byArray[4] != 79) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        if (this.isHtmlRendering()) {
            printWriter.println("<html><style>BODY { font-family: monospace; }</style><body>");
        } else if (this.isRtfRendering()) {
            printWriter.print("{\\rtf1");
            printWriter.print("{\\fonttbl{\\f0\\fmodern\\fprq1\\fcharset0 Courier New;}}");
            printWriter.print("{\\*\\generator AppleCommander ");
            printWriter.print("1.3.5.9");
            printWriter.println(";}");
            printWriter.print("\\f0 ");
        }
        boolean bl = byArray[183] != 0;
        int n = 300 + (bl ? 2 : 0);
        while (n < byArray.length) {
            int n2 = AppleUtil.getUnsignedByte(byArray[n++]);
            int n3 = AppleUtil.getUnsignedByte(byArray[n++]);
            if (n2 == 255 && n3 == 255) break;
            if (n3 == 208) {
                this.handleReturn(printWriter);
                continue;
            }
            if (n3 > 208) {
                if (this.isHtmlRendering()) {
                    n = this.handleCommandRecordAsHtml(n2, n3, printWriter, n);
                    continue;
                }
                if (this.isRtfRendering()) {
                    n = this.handleCommandRecordAsRtf(n2, n3, printWriter, n);
                    continue;
                }
                n = this.handleCommandRecordAsText(n2, n3, printWriter, n);
                continue;
            }
            n = this.handleTextRecord(byArray, printWriter, n);
        }
        if (this.isHtmlRendering()) {
            printWriter.println("</body></html>");
        } else if (this.isRtfRendering()) {
            printWriter.println("}");
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected int handleTextRecord(byte[] byArray, PrintWriter printWriter, int n) {
        AppleUtil.getUnsignedByte(byArray[n++]);
        int n2 = AppleUtil.getUnsignedByte(byArray[n++]);
        boolean bl = n2 >= 128;
        int n3 = n2 & 0x7F;
        while (n3 > 0) {
            byte by = byArray[n++];
            --n3;
            if (by < 32) {
                if (this.isHtmlRendering()) {
                    this.handleSpecialCodesAsHtml(printWriter, by);
                    continue;
                }
                if (this.isRtfRendering()) {
                    this.handleSpecialCodesAsRtf(printWriter, by);
                    continue;
                }
                this.handleSpecialCodesAsText(printWriter, by);
                continue;
            }
            if (this.isHtmlRendering() && by == 32) {
                int n4 = 0;
                while (byArray[n + n4] == 32) {
                    ++n4;
                }
                if (n4 > 0) {
                    printWriter.print("&nbsp;");
                    while (byArray[n] == 32) {
                        ++n;
                        --n3;
                        printWriter.print("&nbsp;");
                    }
                    continue;
                }
                printWriter.print((char)by);
                continue;
            }
            printWriter.print((char)by);
        }
        if (bl) {
            this.handleReturn(printWriter);
        }
        return n;
    }

    protected void handleReturn(PrintWriter printWriter) {
        if (this.isHtmlRendering()) {
            printWriter.println("<br>");
        } else if (this.isRtfRendering()) {
            printWriter.println("\\par");
        } else {
            printWriter.println();
        }
    }

    protected void handleSpecialCodesAsHtml(PrintWriter printWriter, byte by) {
        switch (by) {
            case 1: {
                printWriter.print("<b>");
                break;
            }
            case 2: {
                printWriter.print("</b>");
                break;
            }
            case 3: {
                printWriter.print("<sup>");
                break;
            }
            case 4: {
                printWriter.print("</sup>");
                break;
            }
            case 5: {
                printWriter.print("<sub>");
                break;
            }
            case 6: {
                printWriter.print("</sub>");
                break;
            }
            case 7: {
                printWriter.print("<u>");
                break;
            }
            case 8: {
                printWriter.print("</u>");
                break;
            }
            case 11: {
                printWriter.print("&nbsp;");
                break;
            }
            default: {
                this.handleSpecialCodesAsText(printWriter, by);
            }
        }
    }

    protected void handleSpecialCodesAsRtf(PrintWriter printWriter, byte by) {
        switch (by) {
            case 9: {
                printWriter.print("{\\chpgn}");
                break;
            }
            case 1: {
                printWriter.print("\\b ");
                break;
            }
            case 2: {
                printWriter.print("\\b0 ");
                break;
            }
            case 7: {
                printWriter.print("\\ul ");
                break;
            }
            case 8: {
                printWriter.print("\\ulnone");
                break;
            }
            case 3: {
                printWriter.print("\\super ");
                break;
            }
            case 5: {
                printWriter.print("\\sub ");
                break;
            }
            case 4: 
            case 6: {
                printWriter.print("\\nosupersub ");
                break;
            }
            case 11: {
                printWriter.print(" ");
                break;
            }
            default: {
                this.handleSpecialCodesAsText(printWriter, by);
            }
        }
    }

    protected void handleSpecialCodesAsText(PrintWriter printWriter, byte by) {
        switch (by) {
            case 9: {
                printWriter.print("[Page#]");
                break;
            }
            case 14: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy");
                printWriter.print(simpleDateFormat.format(new Date()));
                break;
            }
            case 15: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                printWriter.print(simpleDateFormat.format(new Date()));
            }
        }
    }

    protected int handleCommandRecordAsHtml(int n, int n2, PrintWriter printWriter, int n3) {
        switch (n2) {
            case 215: {
                printWriter.println("<style>BODY: text-align: right;</style>");
                break;
            }
            case 223: {
                printWriter.println("<style>BODY: text-align: justify;</style>");
                break;
            }
            case 224: {
                printWriter.println("<style>BODY: text-align: left;</style>");
                break;
            }
            case 225: {
                printWriter.println("<style>BODY: text-align: center;</style>");
                break;
            }
            default: {
                n3 = this.handleCommandRecordAsText(n, n2, printWriter, n3);
            }
        }
        return n3;
    }

    protected int handleCommandRecordAsRtf(int n, int n2, PrintWriter printWriter, int n3) {
        if (this.inHeaderOrFooter) {
            printWriter.print("}\\f0 ");
            this.inHeaderOrFooter = false;
        }
        int n4 = n * 1440 / 10;
        switch (n2) {
            case 237: {
                printWriter.print("{\\header ");
                this.inHeaderOrFooter = true;
                break;
            }
            case 236: {
                printWriter.print("{\\footer ");
                this.inHeaderOrFooter = true;
                break;
            }
            case 213: 
            case 214: {
                printWriter.print("}");
                break;
            }
            case 215: {
                printWriter.println("\\pard\\qr ");
                break;
            }
            case 224: {
                printWriter.println("\\pard ");
                break;
            }
            case 225: {
                printWriter.println("\\pard\\qc ");
                break;
            }
            case 223: {
                printWriter.print("\\qj ");
                break;
            }
            case 233: 
            case 244: 
            case 245: {
                printWriter.print("\\page ");
                break;
            }
            case 216: {
                printWriter.print("\\paperw");
                printWriter.print(n4);
                printWriter.print(" ");
                break;
            }
            case 226: {
                printWriter.print("\\paperl");
                printWriter.print(n4);
                printWriter.print(" ");
                break;
            }
            case 217: {
                printWriter.print("\\margl");
                printWriter.print(n4);
                printWriter.print(" ");
                break;
            }
            case 218: {
                printWriter.print("\\margr");
                printWriter.print(n4);
                printWriter.print(" ");
                break;
            }
            case 227: {
                printWriter.print("\\margt");
                printWriter.print(n4);
                printWriter.print(" ");
                break;
            }
            case 228: {
                printWriter.print("\\margb");
                printWriter.print(n4);
                printWriter.print(" ");
                break;
            }
            default: {
                n3 = this.handleCommandRecordAsText(n, n2, printWriter, n3);
            }
        }
        return n3;
    }

    protected int handleCommandRecordAsText(int n, int n2, PrintWriter printWriter, int n3) {
        switch (n2) {
            case 238: {
                for (int i = 0; i < n; ++i) {
                    this.handleReturn(printWriter);
                }
                break;
            }
        }
        return n3;
    }

    public String getSuggestedFileName(FileEntry fileEntry) {
        String string = fileEntry.getFilename().trim();
        String string2 = ".txt";
        if (this.isHtmlRendering()) {
            string2 = ".html";
        } else if (this.isRtfRendering()) {
            string2 = ".rtf";
        }
        if (!string.toLowerCase().endsWith(string2)) {
            string = string + string2;
        }
        return string;
    }

    protected void setRendering(int n) {
        this.rendering = n;
    }

    public boolean isTextRendering() {
        return this.rendering == 0;
    }

    public boolean isHtmlRendering() {
        return this.rendering == 1;
    }

    public boolean isRtfRendering() {
        return this.rendering == 2;
    }

    public void selectTextRendering() {
        this.rendering = 0;
    }

    public void selectHtmlRendering() {
        this.rendering = 1;
    }

    public void selectRtfRendering() {
        this.rendering = 2;
    }
}

