/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.TextBundle;

public class DosOrder
extends ImageOrder {
    private TextBundle textBundle = StorageBundle.getInstance();

    public DosOrder(ByteArrayImageLayout byteArrayImageLayout) {
        super(byteArrayImageLayout);
    }

    public boolean isBlockDevice() {
        return false;
    }

    public boolean isTrackAndSectorDevice() {
        return true;
    }

    public byte[] readSector(int n, int n2) throws IllegalArgumentException {
        return this.readBytes(this.getOffset(n, n2), 256);
    }

    public void writeSector(int n, int n2, byte[] byArray) throws IllegalArgumentException {
        this.writeBytes(this.getOffset(n, n2), byArray);
    }

    protected int getOffset(int n, int n2) throws IllegalArgumentException {
        if (!(this.isSizeApprox(143360) || this.isSizeApprox(819200) || this.isSizeApprox(819264) || n == 0 || n2 == 0)) {
            throw new IllegalArgumentException(this.textBundle.get("DosOrder.UnrecognizedFormatError"));
        }
        int n3 = (n * this.getSectorsPerTrack() + n2) * 256;
        if (n3 > this.getPhysicalSize()) {
            throw new IllegalArgumentException(this.textBundle.format("DosOrder.InvalidSizeError", n, n2));
        }
        return n3;
    }

    public byte[] readBlock(int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        int[] nArray = new int[]{0, 13, 11, 9, 7, 5, 3, 1};
        int[] nArray2 = new int[]{14, 12, 10, 8, 6, 4, 2, 15};
        int n4 = nArray[n3];
        int n5 = nArray2[n3];
        byte[] byArray = new byte[512];
        System.arraycopy(this.readSector(n2, n4), 0, byArray, 0, 256);
        System.arraycopy(this.readSector(n2, n5), 0, byArray, 256, 256);
        return byArray;
    }

    public void writeBlock(int n, byte[] byArray) {
        int n2 = n / 8;
        int n3 = n % 8;
        int[] nArray = new int[]{0, 13, 11, 9, 7, 5, 3, 1};
        int[] nArray2 = new int[]{14, 12, 10, 8, 6, 4, 2, 15};
        int n4 = nArray[n3];
        int n5 = nArray2[n3];
        byte[] byArray2 = new byte[256];
        System.arraycopy(byArray, 0, byArray2, 0, 256);
        this.writeSector(n2, n4, byArray2);
        System.arraycopy(byArray, 256, byArray2, 0, 256);
        this.writeSector(n2, n5, byArray2);
    }
}

