/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class FormattedDisk
extends Disk
implements DirectoryEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int FILE_DISPLAY_STANDARD = 1;
    public static final int FILE_DISPLAY_NATIVE = 2;
    public static final int FILE_DISPLAY_DETAIL = 3;

    public FormattedDisk(String string, ImageOrder imageOrder) {
        super(string, imageOrder);
    }

    public abstract String getDiskName();

    public void setDiskName(String string) {
    }

    public abstract String getFormat();

    public abstract int getFreeSpace();

    public abstract int getUsedSpace();

    public abstract int[] getBitmapDimensions();

    public abstract int getBitmapLength();

    public abstract DiskUsage getDiskUsage();

    public abstract String[] getBitmapLabels();

    public List getDiskInformation() {
        ArrayList<DiskInformation> arrayList = new ArrayList<DiskInformation>();
        arrayList.add(new DiskInformation(this.textBundle.get("FormattedDisk.FileName"), this.getFilename()));
        arrayList.add(new DiskInformation(this.textBundle.get("FormattedDisk.DiskName"), this.getDiskName()));
        arrayList.add(new DiskInformation(this.textBundle.get("FormattedDisk.PhysicalSizeInBytes"), this.getPhysicalSize()));
        arrayList.add(new DiskInformation(this.textBundle.get("FormattedDisk.FreeSpaceInBytes"), this.getFreeSpace()));
        arrayList.add(new DiskInformation(this.textBundle.get("FormattedDisk.UsedSpaceInBytes"), this.getUsedSpace()));
        arrayList.add(new DiskInformation(this.textBundle.get("FormattedDisk.PhysicalSizeInKb"), this.getPhysicalSize() / 1024));
        arrayList.add(new DiskInformation(this.textBundle.get("FormattedDisk.FreeSpaceInKb"), this.getFreeSpace() / 1024));
        arrayList.add(new DiskInformation(this.textBundle.get("FormattedDisk.UsedSpaceInKb"), this.getUsedSpace() / 1024));
        arrayList.add(new DiskInformation(this.textBundle.get("FormattedDisk.ArchiveOrder"), this.is2ImgOrder() ? this.textBundle.get("FormattedDisk.2Img") : (this.isDosOrder() ? this.textBundle.get("Dos33") : (this.isProdosOrder() ? this.textBundle.get("Prodos") : this.textBundle.get("FormattedDisk.Unknown")))));
        arrayList.add(new DiskInformation(this.textBundle.get("FormattedDisk.DiskFormat"), this.getFormat()));
        return arrayList;
    }

    public List getFileColumnHeaders(int n) {
        ArrayList<FileColumnHeader> arrayList = new ArrayList<FileColumnHeader>();
        arrayList.add(new FileColumnHeader(this.textBundle.get("Name"), 30, 1));
        arrayList.add(new FileColumnHeader(this.textBundle.get("Type"), 8, 2));
        arrayList.add(new FileColumnHeader(this.textBundle.get("SizeInBytes"), 6, 3));
        arrayList.add(new FileColumnHeader(this.textBundle.get("LockedQ"), 6, 2));
        return arrayList;
    }

    public abstract boolean supportsDeletedFiles();

    public abstract boolean canReadFileData();

    public abstract boolean canWriteFileData();

    public abstract boolean canHaveDirectories();

    public abstract boolean canDeleteFile();

    public abstract byte[] getFileData(FileEntry var1);

    public FileEntry getFile(String string) {
        List list = this.getFiles();
        return this.getFile(list, string.trim());
    }

    protected FileEntry getFile(List list, String string) {
        FileEntry fileEntry = null;
        if (list != null) {
            FileEntry fileEntry2;
            for (int i = 0; !(i >= list.size() || (fileEntry2 = (FileEntry)list.get(i)).isDirectory() && (fileEntry = this.getFile(((DirectoryEntry)((Object)fileEntry2)).getFiles(), string)) != null); ++i) {
                String string2 = fileEntry2.getFilename();
                if (string2 != null) {
                    string2 = string2.trim();
                }
                if (!string.equalsIgnoreCase(string2)) continue;
                fileEntry = fileEntry2;
                break;
            }
        }
        return fileEntry;
    }

    public abstract void format();

    protected void writeBootCode() {
        InputStream inputStream = this.getClass().getResourceAsStream("/com/webcodepro/applecommander/storage/AppleCommander-boot.dump");
        if (inputStream != null) {
            byte[] byArray = new byte[256];
            try {
                inputStream.read(byArray, 0, byArray.length);
                this.writeSector(0, 0, byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public abstract int getLogicalDiskNumber();

    public abstract String getSuggestedFilename(String var1);

    public abstract String getSuggestedFiletype(String var1);

    public abstract String[] getFiletypes();

    public abstract boolean needsAddress(String var1);

    public FormattedDisk getFormattedDisk() {
        return this;
    }

    public void resizeDiskImage() {
        this.resizeDiskImage(this.getFreeSpace() + this.getUsedSpace());
    }

    public boolean supportsDiskMap() {
        return false;
    }

    public abstract void changeImageOrder(ImageOrder var1);

    public abstract void setFileData(FileEntry var1, byte[] var2) throws DiskFullException;

    public class FileColumnHeader {
        public static final int ALIGN_LEFT = 1;
        public static final int ALIGN_CENTER = 2;
        public static final int ALIGN_RIGHT = 3;
        private String title;
        private int maximumWidth;
        private int alignment;

        public FileColumnHeader(String string, int n, int n2) {
            this.title = string;
            this.maximumWidth = n;
            this.alignment = n2;
        }

        public String getTitle() {
            return this.title;
        }

        public int getMaximumWidth() {
            return this.maximumWidth;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isLeftAlign() {
            return this.alignment == 1;
        }

        public boolean isCenterAlign() {
            return this.alignment == 2;
        }

        public boolean isRightAlign() {
            return this.alignment == 3;
        }
    }

    public static interface DiskUsage {
        public boolean hasNext();

        public void next();

        public boolean isFree();

        public boolean isUsed();
    }

    public class DiskInformation {
        private String label;
        private String value;

        public DiskInformation(String string, String string2) {
            this.label = string;
            this.value = string2;
        }

        public DiskInformation(String string, int n) {
            this.label = string;
            this.value = Integer.toString(n);
        }

        public DiskInformation(String string, Date date) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(StorageBundle.getInstance().get("DateFormat"));
            this.label = string;
            this.value = date != null ? simpleDateFormat.format(date) : StorageBundle.getInstance().get("FormattedDisk.NullDate");
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }
    }
}

