/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.diskimage;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DiskImageOrderPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private DiskImageWizard wizard;
    private Composite control;
    private Composite parent;

    public DiskImageOrderPane(Composite composite, DiskImageWizard diskImageWizard) {
        this.parent = composite;
        this.wizard = diskImageWizard;
    }

    public WizardPane getNextPane() {
        return null;
    }

    public void open() {
        this.control = new Composite(this.parent, 0);
        this.wizard.enableNextButton(false);
        this.wizard.enableFinishButton(true);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.justify = true;
        rowLayout.marginBottom = 5;
        rowLayout.marginLeft = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginTop = 5;
        rowLayout.spacing = 3;
        this.control.setLayout((Layout)rowLayout);
        Label label = new Label(this.control, 64);
        if (this.wizard.isHardDisk()) {
            label.setText(this.textBundle.get("DiskImageOrderProdosOnly"));
        } else {
            label.setText(this.textBundle.get("DiskImageOrderPrompt"));
        }
        RowLayout rowLayout2 = new RowLayout(512);
        rowLayout2.justify = true;
        rowLayout2.spacing = 3;
        Composite composite = new Composite(this.control, 0);
        composite.setLayout((Layout)rowLayout2);
        this.createRadioButton(composite, this.textBundle.get("DiskImageOrderDosLabel"), 1, this.textBundle.get("DiskImageOrderDosText"));
        this.createRadioButton(composite, this.textBundle.get("DiskImageOrderProdosLabel"), 2, this.textBundle.get("DiskImageOrderProdosText"));
        if (this.wizard.getSize() == 143360) {
            this.createRadioButton(composite, this.textBundle.get("DiskImageOrderNibbleLabel"), 3, this.textBundle.get("DiskImageOrderNibbleText"));
        }
        label = new Label(this.control, 64);
        if (this.wizard.isHardDisk()) {
            label.setText(this.textBundle.get("DiskImageOrderNoCompression"));
        } else {
            label.setText(this.textBundle.get("DiskImageOrderCompressionPrompt"));
        }
        Button button = new Button(this.control, 32);
        button.setText(this.textBundle.get("DiskImageOrderGzipCheckbox"));
        button.setToolTipText(this.textBundle.get("DiskImageOrderGzipTooltip"));
        button.setSelection(this.wizard.isCompressed());
        button.setEnabled(!this.wizard.isHardDisk());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskImageOrderPane.this.getWizard().setCompressed(!DiskImageOrderPane.this.getWizard().isCompressed());
            }
        });
    }

    protected void createRadioButton(Composite composite, String string, final int n, String string2) {
        Button button = new Button(composite, 16);
        button.setText(string);
        button.setToolTipText(string2);
        button.setSelection(this.wizard.getOrder() == n);
        button.setEnabled(!this.wizard.isHardDisk());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskImageOrderPane.this.getWizard().setOrder(n);
            }
        });
    }

    public void dispose() {
        this.control.dispose();
    }

    protected DiskImageWizard getWizard() {
        return this.wizard;
    }
}

