/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt;

import com.webcodepro.applecommander.compiler.ApplesoftCompiler;
import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileEntryComparator;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.filters.AppleWorksDataBaseFileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksSpreadSheetFileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksWordProcessorFileFilter;
import com.webcodepro.applecommander.storage.filters.ApplesoftFileFilter;
import com.webcodepro.applecommander.storage.filters.AssemblySourceFileFilter;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.BusinessBASICFileFilter;
import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.storage.filters.GutenbergFileFilter;
import com.webcodepro.applecommander.storage.filters.IntegerBasicFileFilter;
import com.webcodepro.applecommander.storage.filters.PascalTextFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.storage.os.prodos.ProdosDiskSizeDoesNotMatchException;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.storage.physical.NibbleOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.ui.ImportSpecification;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.UserPreferences;
import com.webcodepro.applecommander.ui.swt.DiskWindow;
import com.webcodepro.applecommander.ui.swt.FileViewerWindow;
import com.webcodepro.applecommander.ui.swt.util.DropDownSelectionListener;
import com.webcodepro.applecommander.ui.swt.util.ImageManager;
import com.webcodepro.applecommander.ui.swt.util.SwtUtil;
import com.webcodepro.applecommander.ui.swt.wizard.compilefile.CompileWizard;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportWizard;
import com.webcodepro.applecommander.ui.swt.wizard.importfile.ImportWizard;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.Host;
import com.webcodepro.applecommander.util.StreamUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DiskExplorerTab {
    private static final char CTRL_C = '\u0003';
    private static final char CTRL_D = '\u0004';
    private static final char CTRL_E = '\u0005';
    private static final char CTRL_I = '\t';
    private static final char CTRL_P = '\u0010';
    private static final char CTRL_S = '\u0013';
    private static final char CTRL_V = '\u0016';
    private Shell shell;
    private ImageManager imageManager;
    private DiskWindow diskWindow;
    private FormattedDisk[] disks;
    private SashForm sashForm;
    private Tree directoryTree;
    private Table fileTable;
    private ToolBar toolBar;
    private ToolItem standardFormatToolItem;
    private ToolItem nativeFormatToolItem;
    private ToolItem detailFormatToolItem;
    private ToolItem showDeletedFilesToolItem;
    private ToolItem exportToolItem;
    private ToolItem importToolItem;
    private ToolItem compileToolItem;
    private ToolItem viewFileItem;
    private ToolItem printToolItem;
    private ToolItem deleteToolItem;
    private ToolItem saveToolItem;
    private ToolItem saveAsToolItem;
    private ToolItem changeOrderToolItem;
    private Menu changeImageOrderMenu;
    private UserPreferences userPreferences = UserPreferences.getInstance();
    private TextBundle textBundle = UiBundle.getInstance();
    private FileFilter fileFilter;
    private GraphicsFileFilter graphicsFilter = new GraphicsFileFilter();
    private AppleWorksWordProcessorFileFilter awpFilter = new AppleWorksWordProcessorFileFilter();
    private GutenbergFileFilter gutenbergFilter = new GutenbergFileFilter();
    private int currentFormat = 1;
    private boolean formatChanged;
    private List currentFileList;
    private Map columnWidths = new HashMap();
    private boolean showDeletedFiles;
    static /* synthetic */ Class class$com$webcodepro$applecommander$storage$filters$TextFileFilter;
    static /* synthetic */ Class class$com$webcodepro$applecommander$storage$filters$GraphicsFileFilter;

    public DiskExplorerTab(CTabFolder cTabFolder, FormattedDisk[] formattedDiskArray, ImageManager imageManager, DiskWindow diskWindow) {
        this.disks = formattedDiskArray;
        this.shell = cTabFolder.getShell();
        this.imageManager = imageManager;
        this.diskWindow = diskWindow;
        this.createFilesTab(cTabFolder);
    }

    public void dispose() {
        this.sashForm.dispose();
        this.directoryTree.dispose();
        this.fileTable.dispose();
        this.standardFormatToolItem.dispose();
        this.nativeFormatToolItem.dispose();
        this.detailFormatToolItem.dispose();
        this.showDeletedFilesToolItem.dispose();
        this.exportToolItem.dispose();
        this.importToolItem.dispose();
        this.deleteToolItem.dispose();
        this.compileToolItem.dispose();
        this.viewFileItem.dispose();
        this.toolBar.dispose();
        this.changeOrderToolItem.dispose();
        this.directoryTree = null;
        this.fileTable = null;
        this.currentFileList = null;
    }

    protected void createFilesTab(CTabFolder cTabFolder) {
        CTabItem cTabItem = new CTabItem(cTabFolder, 0);
        cTabItem.setText(this.textBundle.get("FilesTab"));
        Composite composite = new Composite((Composite)cTabFolder, 0);
        cTabItem.setControl((Control)composite);
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        this.createFileToolBar(composite, gridData);
        this.sashForm = new SashForm(composite, 0);
        this.sashForm.setOrientation(256);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.sashForm.setLayoutData((Object)gridData);
        this.directoryTree = new Tree((Composite)this.sashForm, 2052);
        this.directoryTree.setMenu(this.createDirectoryPopupMenu());
        this.directoryTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.changeCurrentFormat(DiskExplorerTab.this.getCurrentFormat());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                Tree tree = (Tree)selectionEvent.getSource();
                TreeItem[] treeItemArray = tree.getSelection();
                treeItemArray[0].setExpanded(!treeItemArray[0].getExpanded());
            }
        });
        this.directoryTree.addListener(2, this.createDirectoryKeyboardHandler());
        this.directoryTree.addListener(2, this.createToolbarCommandHandler());
        this.fileTable = new Table((Composite)this.sashForm, 67586);
        this.fileTable.setHeaderVisible(true);
        this.sashForm.setWeights(new int[]{1, 2});
        for (int i = 0; i < this.disks.length; ++i) {
            TreeItem treeItem = new TreeItem(this.directoryTree, 2048);
            treeItem.setText(this.disks[i].getDiskName());
            treeItem.setData((Object)this.disks[i]);
            this.directoryTree.setSelection(new TreeItem[]{treeItem});
            if (!this.disks[i].canHaveDirectories()) continue;
            Iterator iterator = this.disks[i].getFiles().iterator();
            while (iterator.hasNext()) {
                FileEntry fileEntry = (FileEntry)iterator.next();
                if (!fileEntry.isDirectory()) continue;
                TreeItem treeItem2 = new TreeItem(treeItem, 2048);
                treeItem2.setText(fileEntry.getFilename());
                treeItem2.setData((Object)fileEntry);
                this.addDirectoriesToTree(treeItem2, (DirectoryEntry)((Object)fileEntry));
            }
        }
        this.computeColumnWidths(1);
        this.computeColumnWidths(2);
        this.computeColumnWidths(3);
        this.formatChanged = true;
        this.fillFileTable(this.disks[0].getFiles());
        this.directoryTree.setSelection(new TreeItem[]{this.directoryTree.getItems()[0]});
    }

    protected Menu createDirectoryPopupMenu() {
        Menu menu = new Menu((Decorations)this.shell, 8);
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("ExpandMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeItem[] treeItemArray = DiskExplorerTab.this.getDirectoryTree().getSelection();
                treeItemArray[0].setExpanded(true);
            }
        });
        menuItem.setEnabled(this.disks[0].canHaveDirectories());
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("CollapseMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeItem[] treeItemArray = DiskExplorerTab.this.getDirectoryTree().getSelection();
                treeItemArray[0].setExpanded(false);
            }
        });
        menuItem.setEnabled(this.disks[0].canHaveDirectories());
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("ExpandAllMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeItem[] treeItemArray = DiskExplorerTab.this.getDirectoryTree().getSelection();
                DiskExplorerTab.this.setDirectoryExpandedStates(treeItemArray[0], true);
            }
        });
        menuItem.setEnabled(this.disks[0].canHaveDirectories());
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("CollapseAllMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeItem[] treeItemArray = DiskExplorerTab.this.getDirectoryTree().getSelection();
                DiskExplorerTab.this.setDirectoryExpandedStates(treeItemArray[0], false);
            }
        });
        menuItem.setEnabled(this.disks[0].canHaveDirectories());
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("CreateDirectoryMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        menuItem.setEnabled(this.disks[0].canCreateDirectories());
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("ImportMenuItem"));
        menuItem.setImage(this.imageManager.get("importfile.gif"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.importFiles();
            }
        });
        menuItem.setEnabled(this.disks[0].canCreateFile() && this.disks[0].canWriteFileData());
        return menu;
    }

    protected Menu createFilePopupMenu() {
        Menu menu = new Menu((Decorations)this.shell, 8);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                Menu menu = (Menu)menuEvent.getSource();
                MenuItem[] menuItemArray = menu.getItems();
                FileEntry fileEntry = DiskExplorerTab.this.getSelectedFileEntry();
                menuItemArray[0].setEnabled(DiskExplorerTab.this.getDisk(0).canReadFileData() && fileEntry != null && !fileEntry.isDeleted() && !fileEntry.isDirectory());
                menuItemArray[1].setEnabled(DiskExplorerTab.this.getDisk(0).canReadFileData() && fileEntry != null && !fileEntry.isDeleted() && !fileEntry.isDirectory());
                menuItemArray[3].setEnabled(DiskExplorerTab.this.getDisk(0).canReadFileData() && fileEntry != null && fileEntry.canCompile() && !fileEntry.isDeleted());
                menuItemArray[5].setEnabled(DiskExplorerTab.this.getDisk(0).canReadFileData() && fileEntry != null && !fileEntry.isDeleted() && !fileEntry.isDirectory());
                menuItemArray[6].setEnabled(DiskExplorerTab.this.getDisk(0).canReadFileData() && fileEntry != null && !fileEntry.isDeleted() && !fileEntry.isDirectory());
                menuItemArray[8].setEnabled(DiskExplorerTab.this.getDisk(0).canDeleteFile() && fileEntry != null && !fileEntry.isDeleted());
            }
        });
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("ViewWizardMenuItem"));
        menuItem.setAccelerator(262230);
        menuItem.setImage(this.imageManager.get("viewfile.gif"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.viewFile(null);
            }
        });
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("ViewAsMenuItem"));
        menuItem.setMenu(this.createFileViewMenu(4));
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("CompileMenuItem"));
        menuItem.setAccelerator(262211);
        menuItem.setImage(this.imageManager.get("compile.gif"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.compileFileWizard();
            }
        });
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("ExportWizardMenuItem"));
        menuItem.setAccelerator(262213);
        menuItem.setImage(this.imageManager.get("exportfile.gif"));
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("ExportAsMenuItem"));
        menuItem.setMenu(this.createFileExportMenu(4));
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("DeleteMenuItem"));
        menuItem.setAccelerator(262212);
        menuItem.setImage(this.imageManager.get("deletefile.gif"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.deleteFile();
            }
        });
        return menu;
    }

    protected Menu createFileViewMenu(int n) {
        Menu menu = new Menu((Decorations)this.shell, n);
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ViewAsTextMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.viewFile(class$com$webcodepro$applecommander$storage$filters$TextFileFilter == null ? (class$com$webcodepro$applecommander$storage$filters$TextFileFilter = DiskExplorerTab.class$("com.webcodepro.applecommander.storage.filters.TextFileFilter")) : class$com$webcodepro$applecommander$storage$filters$TextFileFilter);
            }
        });
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("VeiwAsGraphicsMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.viewFile(class$com$webcodepro$applecommander$storage$filters$GraphicsFileFilter == null ? (class$com$webcodepro$applecommander$storage$filters$GraphicsFileFilter = DiskExplorerTab.class$("com.webcodepro.applecommander.storage.filters.GraphicsFileFilter")) : class$com$webcodepro$applecommander$storage$filters$GraphicsFileFilter);
            }
        });
        return menu;
    }

    protected Menu createFileExportMenu(int n) {
        Menu menu = new Menu((Decorations)this.shell, n);
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ExportAsRawDiskDataMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.setFileFilter(null);
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ExportAsBinaryMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.setFileFilter(new BinaryFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ExportAsApplesoftBasicMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.setFileFilter(new ApplesoftFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ExportAsIntegerBasicMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.setFileFilter(new IntegerBasicFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ExportAsBusinessBASICMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.setFileFilter(new BusinessBASICFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ExportAsAsciiTextMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.setFileFilter(new TextFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ExportAsFormattedAssemblyMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.setFileFilter(new AssemblySourceFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ExportAsPascalTextMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.setFileFilter(new PascalTextFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("GutenbergRenderingMenuItem"));
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        menuItem.setMenu(menu2);
        menuItem = new MenuItem(menu2, 0);
        menuItem.setText(this.textBundle.get("WordProcessorRenderAsTextMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getGutenbergFilter().selectTextRendering();
                DiskExplorerTab.this.setFileFilter(DiskExplorerTab.this.getGutenbergFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu2, 0);
        menuItem.setText(this.textBundle.get("WordProcessorRenderAsHtmlMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getGutenbergFilter().selectHtmlRendering();
                DiskExplorerTab.this.setFileFilter(DiskExplorerTab.this.getGutenbergFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu2, 0);
        menuItem.setText(this.textBundle.get("WordProcessorRenderAsRtfMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getGutenbergFilter().selectRtfRendering();
                DiskExplorerTab.this.setFileFilter(DiskExplorerTab.this.getGutenbergFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ExportAsAppleWorksSpreadsheetFileMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.setFileFilter(new AppleWorksSpreadSheetFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ExportAsAppleWorksDatabaseFileMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.setFileFilter(new AppleWorksDataBaseFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ExportAsAppleWorksWordProcessorFileMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.setFileFilter(DiskExplorerTab.this.getAwpFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("WordProcessorRenderingMenuItem"));
        Menu menu3 = new Menu((Decorations)this.shell, 4);
        menuItem.setMenu(menu3);
        menu3.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                Menu menu = (Menu)menuEvent.getSource();
                MenuItem[] menuItemArray = menu.getItems();
                menuItemArray[0].setSelection(DiskExplorerTab.this.getAwpFilter().isTextRendering());
                menuItemArray[1].setSelection(DiskExplorerTab.this.getAwpFilter().isHtmlRendering());
                menuItemArray[2].setSelection(DiskExplorerTab.this.getAwpFilter().isRtfRendering());
            }
        });
        menuItem = new MenuItem(menu3, 16);
        menuItem.setText(this.textBundle.get("WordProcessorRenderAsTextMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getAwpFilter().selectTextRendering();
            }
        });
        menuItem = new MenuItem(menu3, 16);
        menuItem.setText(this.textBundle.get("WordProcessorRenderAsHtmlMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getAwpFilter().selectHtmlRendering();
            }
        });
        menuItem = new MenuItem(menu3, 16);
        menuItem.setText(this.textBundle.get("WordProcessorRenderAsRtfMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getAwpFilter().selectRtfRendering();
            }
        });
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 0);
        menuItem.setText(this.textBundle.get("ExportAsGraphicsMenuItem"));
        menuItem.setEnabled(GraphicsFileFilter.isCodecAvailable());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.setFileFilter(DiskExplorerTab.this.getGraphicsFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.textBundle.get("ExportGraphicsModeMenuItem"));
        menuItem.setEnabled(GraphicsFileFilter.isCodecAvailable());
        menu3 = new Menu((Decorations)this.shell, 4);
        menuItem.setMenu(menu3);
        menu3.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                Menu menu = (Menu)menuEvent.getSource();
                MenuItem[] menuItemArray = menu.getItems();
                menuItemArray[0].setSelection(DiskExplorerTab.this.getGraphicsFilter().isHiresBlackAndWhiteMode());
                menuItemArray[1].setSelection(DiskExplorerTab.this.getGraphicsFilter().isHiresColorMode());
                menuItemArray[2].setSelection(DiskExplorerTab.this.getGraphicsFilter().isDoubleHiresBlackAndWhiteMode());
                menuItemArray[3].setSelection(DiskExplorerTab.this.getGraphicsFilter().isDoubleHiresColorMode());
                menuItemArray[4].setSelection(DiskExplorerTab.this.getGraphicsFilter().isSuperHires16Mode());
                menuItemArray[5].setSelection(DiskExplorerTab.this.getGraphicsFilter().isSuperHires3200Mode());
                menuItemArray[6].setSelection(DiskExplorerTab.this.getGraphicsFilter().isQuickDraw2Icon());
            }
        });
        menuItem = new MenuItem(menu3, 16);
        menuItem.setText(this.textBundle.get("ExportGraphicsAsHiresBlackAndWhiteMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(1);
            }
        });
        menuItem = new MenuItem(menu3, 16);
        menuItem.setText(this.textBundle.get("ExportGraphicsAsHiresColorMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(2);
            }
        });
        menuItem = new MenuItem(menu3, 16);
        menuItem.setText(this.textBundle.get("ExportGraphicsAsDoubleHiresBlackAndWhiteMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(3);
            }
        });
        menuItem = new MenuItem(menu3, 16);
        menuItem.setText(this.textBundle.get("ExportGraphicsAsDoubleHiresColorMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(4);
            }
        });
        menuItem = new MenuItem(menu3, 16);
        menuItem.setText(this.textBundle.get("ExportGraphicsAsSuperHiresMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(5);
            }
        });
        menuItem = new MenuItem(menu3, 16);
        menuItem.setText(this.textBundle.get("ExportGraphicsAsSuperHires3200ColorMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(6);
            }
        });
        menuItem = new MenuItem(menu3, 16);
        menuItem.setText(this.textBundle.get("ExportGraphicsAsQuickDraw2IconMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(7);
            }
        });
        String[] stringArray = GraphicsFileFilter.getFileExtensions();
        if (stringArray != null && stringArray.length > 0) {
            menuItem = new MenuItem(menu, 64);
            menuItem.setText(this.textBundle.get("ExportGraphicsFormatMenuItem"));
            menuItem.setEnabled(GraphicsFileFilter.isCodecAvailable());
            menu3 = new Menu((Decorations)this.shell, 4);
            menuItem.setMenu(menu3);
            menu3.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent menuEvent) {
                    Menu menu = (Menu)menuEvent.getSource();
                    MenuItem[] menuItemArray = menu.getItems();
                    for (int i = 0; i < menuItemArray.length; ++i) {
                        menuItemArray[i].setSelection(menuItemArray[i].getText().equals(DiskExplorerTab.this.getGraphicsFilter().getExtension()));
                    }
                }
            });
            for (int i = 0; i < stringArray.length; ++i) {
                menuItem = new MenuItem(menu3, 16);
                menuItem.setText(stringArray[i]);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        MenuItem menuItem = (MenuItem)selectionEvent.getSource();
                        DiskExplorerTab.this.getGraphicsFilter().setExtension(menuItem.getText());
                    }
                });
            }
        }
        return menu;
    }

    protected void setDirectoryExpandedStates(TreeItem treeItem, boolean bl) {
        treeItem.setExpanded(bl);
        TreeItem[] treeItemArray = treeItem.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            this.setDirectoryExpandedStates(treeItemArray[i], bl);
        }
    }

    protected void computeColumnWidths(int n) {
        List list = this.disks[0].getFileColumnHeaders(n);
        int[] nArray = new int[list.size()];
        GC gC = new GC((Drawable)this.shell);
        for (int i = 0; i < list.size(); ++i) {
            FormattedDisk.FileColumnHeader fileColumnHeader = (FormattedDisk.FileColumnHeader)list.get(i);
            nArray[i] = fileColumnHeader.getTitle().length() >= fileColumnHeader.getMaximumWidth() ? gC.stringExtent((String)fileColumnHeader.getTitle()).x + 2 * gC.stringExtent((String)this.textBundle.get((String)"WidestCharacter")).x : gC.stringExtent((String)this.textBundle.get((String)"WidestCharacter")).x * fileColumnHeader.getMaximumWidth();
        }
        gC.dispose();
        gC = null;
        this.columnWidths.put(new Integer(n), nArray);
    }

    protected void preserveColumnWidths() {
        TableColumn[] tableColumnArray = this.fileTable.getColumns();
        int[] nArray = new int[tableColumnArray.length];
        for (int i = 0; i < tableColumnArray.length; ++i) {
            nArray[i] = tableColumnArray[i].getWidth();
        }
        this.columnWidths.put(new Integer(this.currentFormat), nArray);
    }

    protected void fillFileTable(List list) {
        Object object;
        Object object2;
        TableColumn tableColumn;
        int[] nArray = this.sashForm.getWeights();
        if (this.formatChanged) {
            this.fileTable.dispose();
            this.fileTable = new Table((Composite)this.sashForm, 67586);
            this.fileTable.addListener(2, this.createFileKeyboardHandler());
            this.fileTable.addListener(2, this.createToolbarCommandHandler());
            this.fileTable.setHeaderVisible(true);
            this.fileTable.setMenu(this.createFilePopupMenu());
            this.fileTable.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DiskExplorerTab.this.getImportToolItem().setEnabled(DiskExplorerTab.this.getDisk(0).canCreateFile() && DiskExplorerTab.this.getDisk(0).canWriteFileData());
                    if (DiskExplorerTab.this.getFileTable().getSelectionCount() > 0) {
                        FileEntry fileEntry = DiskExplorerTab.this.getSelectedFileEntry();
                        DiskExplorerTab.this.getExportToolItem().setEnabled(DiskExplorerTab.this.getDisk(0).canReadFileData());
                        DiskExplorerTab.this.getDeleteToolItem().setEnabled(DiskExplorerTab.this.getDisk(0).canDeleteFile());
                        DiskExplorerTab.this.getCompileToolItem().setEnabled(fileEntry != null && fileEntry.canCompile());
                        DiskExplorerTab.this.getViewFileToolItem().setEnabled(true);
                    } else {
                        DiskExplorerTab.this.getExportToolItem().setEnabled(false);
                        DiskExplorerTab.this.getDeleteToolItem().setEnabled(false);
                        DiskExplorerTab.this.getCompileToolItem().setEnabled(false);
                        DiskExplorerTab.this.getViewFileToolItem().setEnabled(false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    DiskExplorerTab.this.viewFile(null);
                }
            });
            tableColumn = null;
            object2 = this.disks[0].getFileColumnHeaders(this.currentFormat);
            object = (int[])this.columnWidths.get(new Integer(this.currentFormat));
            int n = 0;
            while (n < object2.size()) {
                FormattedDisk.FileColumnHeader fileColumnHeader = (FormattedDisk.FileColumnHeader)object2.get(n);
                int n2 = fileColumnHeader.isCenterAlign() ? 0x1000000 : (fileColumnHeader.isLeftAlign() ? 16384 : 131072);
                tableColumn = new TableColumn(this.fileTable, n2);
                tableColumn.setText(fileColumnHeader.getTitle());
                tableColumn.setWidth((int)object[n]);
                final int n3 = n++;
                tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        DiskExplorerTab.this.sortFileTable(n3);
                    }
                });
            }
        } else {
            this.fileTable.removeAll();
        }
        tableColumn = list.iterator();
        while (tableColumn.hasNext()) {
            object2 = (FileEntry)tableColumn.next();
            if (!this.showDeletedFiles && object2.isDeleted()) continue;
            object = new TableItem(this.fileTable, 0);
            List list2 = object2.getFileColumnData(this.currentFormat);
            for (int i = 0; i < list2.size(); ++i) {
                object.setText(i, (String)list2.get(i));
            }
            object.setData(object2);
        }
        this.sashForm.setWeights(nArray);
        this.formatChanged = false;
        this.currentFileList = list;
        this.exportToolItem.setEnabled(false);
        this.deleteToolItem.setEnabled(false);
        this.compileToolItem.setEnabled(false);
        this.viewFileItem.setEnabled(false);
    }

    protected void exportFileWizard() {
        FileEntry fileEntry = this.getSelectedFileEntry();
        if (fileEntry != null) {
            this.fileFilter = fileEntry.getSuggestedFilter();
        }
        ExportWizard exportWizard = new ExportWizard(this.shell, this.imageManager, fileEntry.getFormattedDisk());
        exportWizard.setFileFilter(this.fileFilter);
        exportWizard.setDirectory(this.userPreferences.getExportDirectory());
        exportWizard.open();
        if (exportWizard.isWizardCompleted()) {
            this.fileFilter = exportWizard.getFileFilter();
            String string = exportWizard.getDirectory();
            this.exportFile(string);
        }
    }

    protected void exportFile(String string) {
        boolean bl = string == null;
        TableItem[] tableItemArray = this.fileTable.getSelection();
        for (int i = 0; i < tableItemArray.length; ++i) {
            Object object;
            Object object2;
            TableItem tableItem = tableItemArray[i];
            FileEntry fileEntry = (FileEntry)tableItem.getData();
            String string2 = null;
            if (bl) {
                object2 = new FileDialog(this.shell, 8192);
                object2.setFilterPath(this.userPreferences.getExportDirectory());
                if (this.fileFilter != null) {
                    object2.setFileName(this.fileFilter.getSuggestedFileName(fileEntry));
                } else {
                    object2.setFileName(fileEntry.getFilename());
                }
                string2 = object2.open();
                string = object2.getFilterPath();
            } else {
                string2 = this.fileFilter != null ? string + File.separator + AppleUtil.getNiceFilename(this.fileFilter.getSuggestedFileName(fileEntry)) : string + File.separator + AppleUtil.getNiceFilename(fileEntry.getFilename());
            }
            if (string2 == null) continue;
            this.userPreferences.setExportDirectory(string);
            try {
                int n;
                object2 = new File(string2);
                if (((File)object2).exists() && (n = SwtUtil.showYesNoDialog(this.shell, this.textBundle.get("FileExistsTitle"), this.textBundle.format("FileExistsMessage", string2))) == 128) {
                    return;
                }
                object = null;
                object = this.fileFilter != null ? (Object)this.fileFilter.filter(fileEntry) : (Object)fileEntry.getFormattedDisk().getFileData(fileEntry);
                FileOutputStream fileOutputStream = new FileOutputStream((File)object2);
                ((OutputStream)fileOutputStream).write((byte[])object);
                ((OutputStream)fileOutputStream).close();
                continue;
            }
            catch (Exception exception) {
                int n;
                exception.printStackTrace();
                object = exception.getMessage();
                if (object == null) {
                    object = exception.getClass().getName();
                }
                if ((n = SwtUtil.showOkCancelErrorDialog(this.shell, this.textBundle.get("ExportErrorTitle"), this.textBundle.format("ExportErrorMessage", new Object[]{string2, object}))) == 256) break;
            }
        }
    }

    protected void compileFileWizard() {
        FileEntry fileEntry = this.getSelectedFileEntry();
        CompileWizard compileWizard = new CompileWizard(this.shell, this.imageManager, fileEntry.getFormattedDisk());
        compileWizard.setDirectory(this.userPreferences.getCompileDirectory());
        compileWizard.open();
        if (compileWizard.isWizardCompleted()) {
            String string = compileWizard.getDirectory();
            this.compileFile(string);
        }
    }

    private void compileFile(String string) {
        boolean bl = string == null;
        TableItem[] tableItemArray = this.fileTable.getSelection();
        for (int i = 0; i < tableItemArray.length; ++i) {
            Object object;
            Object object2;
            TableItem tableItem = tableItemArray[i];
            FileEntry fileEntry = (FileEntry)tableItem.getData();
            String string2 = null;
            if (bl) {
                object2 = new FileDialog(this.shell, 8192);
                object2.setFilterPath(this.userPreferences.getCompileDirectory());
                object2.setFileName(fileEntry.getFilename() + ".S");
                string2 = object2.open();
                string = object2.getFilterPath();
            } else {
                string2 = string + File.separator + AppleUtil.getNiceFilename(fileEntry.getFilename() + ".S");
            }
            if (string2 == null) continue;
            this.userPreferences.setCompileDirectory(string);
            try {
                int n;
                object2 = new File(string2);
                if (((File)object2).exists() && (n = SwtUtil.showYesNoDialog(this.shell, this.textBundle.get("FileExistsTitle"), this.textBundle.format("FileExistsMessage", string2))) == 128) {
                    return;
                }
                object = new ApplesoftCompiler(fileEntry);
                byte[] byArray = ((ApplesoftCompiler)object).compile();
                FileOutputStream fileOutputStream = new FileOutputStream((File)object2);
                ((OutputStream)fileOutputStream).write(byArray);
                ((OutputStream)fileOutputStream).close();
                continue;
            }
            catch (Exception exception) {
                int n;
                object = exception.getMessage();
                if (object == null) {
                    object = exception.getClass().getName();
                }
                if ((n = SwtUtil.showOkCancelErrorDialog(this.shell, this.textBundle.get("UnableToCompileTitle"), this.textBundle.format("UnableToCompileMessage", new Object[]{string2, object}))) == 256) break;
            }
        }
    }

    protected void deleteFile() {
        TableItem[] tableItemArray = this.fileTable.getSelection();
        String string = tableItemArray.length > 1 ? this.textBundle.get("DeletePromptMultipleFiles") : this.textBundle.get("DeletePromptSingleFile") + this.textBundle.get("DeletePromptTrailer");
        int n = SwtUtil.showYesNoDialog(this.shell, this.textBundle.get("DeletePromptTitle"), string);
        if (n == 64) {
            for (int i = 0; i < tableItemArray.length; ++i) {
                TableItem tableItem = tableItemArray[i];
                FileEntry fileEntry = (FileEntry)tableItem.getData();
                fileEntry.delete();
            }
            this.fillFileTable(this.currentFileList);
            this.saveToolItem.setEnabled(true);
        }
    }

    protected void importFiles() {
        TreeItem treeItem = this.directoryTree.getSelection()[0];
        DirectoryEntry directoryEntry = (DirectoryEntry)treeItem.getData();
        ImportWizard importWizard = new ImportWizard(this.shell, this.imageManager, directoryEntry.getFormattedDisk());
        importWizard.open();
        if (importWizard.isWizardCompleted()) {
            Shell shell = null;
            try {
                List list = importWizard.getImportSpecifications();
                shell = new Shell(this.shell, 67680);
                shell.setText(this.textBundle.get("ImportingFilesTitle"));
                GridLayout gridLayout = new GridLayout();
                gridLayout.horizontalSpacing = 5;
                gridLayout.makeColumnsEqualWidth = false;
                gridLayout.marginHeight = 5;
                gridLayout.marginWidth = 5;
                gridLayout.numColumns = 2;
                gridLayout.verticalSpacing = 5;
                shell.setLayout((Layout)gridLayout);
                Label label = new Label((Composite)shell, 0);
                label.setText(this.textBundle.get("ImportingFilesProcessingLabel"));
                Label label2 = new Label((Composite)shell, 0);
                GridData gridData = new GridData();
                gridData.widthHint = 300;
                label2.setLayoutData((Object)gridData);
                label = new Label((Composite)shell, 0);
                label.setText(this.textBundle.get("ImportingFilesFilenameLabel"));
                Label label3 = new Label((Composite)shell, 0);
                gridData = new GridData();
                gridData.widthHint = 300;
                label3.setLayoutData((Object)gridData);
                gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                gridData.grabExcessHorizontalSpace = true;
                ProgressBar progressBar = new ProgressBar((Composite)shell, 0);
                progressBar.setLayoutData((Object)gridData);
                progressBar.setMinimum(0);
                progressBar.setMaximum(list.size());
                shell.pack();
                SwtUtil.center(this.shell, shell);
                shell.open();
                for (int i = 0; i < list.size(); ++i) {
                    ImportSpecification importSpecification = (ImportSpecification)list.get(i);
                    label2.setText(this.textBundle.format("FileNofM", new Object[]{new Integer(i + 1), new Integer(list.size())}));
                    label3.setText(importSpecification.getSourceFilename());
                    progressBar.setSelection(i);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    FileInputStream fileInputStream = new FileInputStream(importSpecification.getSourceFilename());
                    StreamUtil.copy(fileInputStream, byteArrayOutputStream);
                    FileEntry fileEntry = directoryEntry.createFile();
                    fileEntry.setFilename(importSpecification.getTargetFilename());
                    fileEntry.setFiletype(importSpecification.getFiletype());
                    if (importSpecification.isRawFileImport()) {
                        this.disks[0].setFileData(fileEntry, byteArrayOutputStream.toByteArray());
                        continue;
                    }
                    if (fileEntry.needsAddress()) {
                        fileEntry.setAddress(importSpecification.getAddress());
                    }
                    try {
                        fileEntry.setFileData(byteArrayOutputStream.toByteArray());
                        continue;
                    }
                    catch (ProdosDiskSizeDoesNotMatchException prodosDiskSizeDoesNotMatchException) {
                        int n = SwtUtil.showYesNoDialog(this.shell, this.textBundle.get("ResizeDiskTitle"), this.textBundle.get("ResizeDiskMessage"));
                        if (n != 64) continue;
                        ProdosFormatDisk prodosFormatDisk = (ProdosFormatDisk)fileEntry.getFormattedDisk();
                        prodosFormatDisk.resizeDiskImage();
                        fileEntry.setFileData(byteArrayOutputStream.toByteArray());
                    }
                }
            }
            catch (Exception exception) {
                SwtUtil.showErrorDialog(this.shell, this.textBundle.get("ImportErrorTitle"), this.textBundle.format("ImportErrorMessage", exception.getMessage()));
            }
            shell.close();
            shell.dispose();
            this.changeCurrentFormat(this.currentFormat);
            this.saveToolItem.setEnabled(true);
        }
    }

    protected void sortFileTable(int n) {
        Collections.sort(this.currentFileList, new FileEntryComparator(n, this.currentFormat));
        this.fillFileTable(this.currentFileList);
    }

    protected void addDirectoriesToTree(TreeItem treeItem, DirectoryEntry directoryEntry) {
        Iterator iterator = directoryEntry.getFiles().iterator();
        while (iterator.hasNext()) {
            FileEntry fileEntry = (FileEntry)iterator.next();
            if (!fileEntry.isDirectory()) continue;
            TreeItem treeItem2 = new TreeItem(treeItem, 2048);
            treeItem2.setText(fileEntry.getFilename());
            treeItem2.setData((Object)fileEntry);
            this.addDirectoriesToTree(treeItem2, (DirectoryEntry)((Object)fileEntry));
        }
    }

    private void createFileToolBar(Composite composite, Object object) {
        this.toolBar = new ToolBar(composite, 0x800000);
        this.toolBar.addListener(2, this.createToolbarCommandHandler());
        if (object != null) {
            this.toolBar.setLayoutData(object);
        }
        this.standardFormatToolItem = new ToolItem(this.toolBar, 16);
        this.standardFormatToolItem.setImage(this.imageManager.get("standardfileview.gif"));
        this.standardFormatToolItem.setText(this.textBundle.get("StandardViewToolItem"));
        this.standardFormatToolItem.setToolTipText(this.textBundle.get("StandardViewHoverText"));
        this.standardFormatToolItem.setSelection(true);
        this.standardFormatToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.changeCurrentFormat(1);
            }
        });
        this.nativeFormatToolItem = new ToolItem(this.toolBar, 16);
        this.nativeFormatToolItem.setImage(this.imageManager.get("nativefileview.gif"));
        this.nativeFormatToolItem.setText(this.textBundle.get("NativeViewToolItem"));
        this.nativeFormatToolItem.setToolTipText(this.textBundle.get("NativeViewHoverText"));
        this.nativeFormatToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.changeCurrentFormat(2);
            }
        });
        this.detailFormatToolItem = new ToolItem(this.toolBar, 16);
        this.detailFormatToolItem.setImage(this.imageManager.get("detailfileview.gif"));
        this.detailFormatToolItem.setText(this.textBundle.get("DetailViewToolItem"));
        this.detailFormatToolItem.setToolTipText(this.textBundle.get("DetailViewHoverText"));
        this.detailFormatToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.changeCurrentFormat(3);
            }
        });
        new ToolItem(this.toolBar, 2);
        this.showDeletedFilesToolItem = new ToolItem(this.toolBar, 32);
        this.showDeletedFilesToolItem.setImage(this.imageManager.get("deletedfiles.gif"));
        this.showDeletedFilesToolItem.setText(this.textBundle.get("ShowDeletedFilesToolItem"));
        this.showDeletedFilesToolItem.setToolTipText(this.textBundle.get("ShowDeletedFilesHoverText"));
        this.showDeletedFilesToolItem.setEnabled(this.disks[0].supportsDeletedFiles());
        this.showDeletedFilesToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolItem toolItem = (ToolItem)selectionEvent.getSource();
                DiskExplorerTab.this.setShowDeletedFiles(toolItem.getSelection());
                DiskExplorerTab.this.fillFileTable(DiskExplorerTab.this.getCurrentFileList());
            }
        });
        new ToolItem(this.toolBar, 2);
        this.importToolItem = new ToolItem(this.toolBar, 8);
        this.importToolItem.setImage(this.imageManager.get("importfile.gif"));
        this.importToolItem.setText(this.textBundle.get("ImportWizardToolItem"));
        this.importToolItem.setToolTipText(this.textBundle.get("ImportWizardHoverText"));
        this.importToolItem.setEnabled(this.disks[0].canCreateFile() && this.disks[0].canWriteFileData());
        this.importToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.importFiles();
            }
        });
        this.exportToolItem = new ToolItem(this.toolBar, 4);
        this.exportToolItem.setImage(this.imageManager.get("exportfile.gif"));
        this.exportToolItem.setText(this.textBundle.get("ExportWizardToolItem"));
        this.exportToolItem.setToolTipText(this.textBundle.get("ExportWizardHoverText"));
        this.exportToolItem.setEnabled(false);
        this.exportToolItem.addSelectionListener((SelectionListener)new DropDownSelectionListener(this.createFileExportMenu(0)));
        this.exportToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail != 4) {
                    DiskExplorerTab.this.exportFileWizard();
                }
            }
        });
        new ToolItem(this.toolBar, 2);
        this.compileToolItem = new ToolItem(this.toolBar, 8);
        this.compileToolItem.setImage(this.imageManager.get("compile.gif"));
        this.compileToolItem.setText(this.textBundle.get("CompileWizardToolItem"));
        this.compileToolItem.setToolTipText(this.textBundle.get("CompileWizardHoverText"));
        this.compileToolItem.setEnabled(false);
        this.compileToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail != 4) {
                    DiskExplorerTab.this.compileFileWizard();
                }
            }
        });
        this.viewFileItem = new ToolItem(this.toolBar, 8);
        this.viewFileItem.setImage(this.imageManager.get("viewfile.gif"));
        this.viewFileItem.setText(this.textBundle.get("ViewFileToolItem"));
        this.viewFileItem.setToolTipText(this.textBundle.get("ViewFileHoverText"));
        this.viewFileItem.setEnabled(false);
        this.viewFileItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail != 4) {
                    DiskExplorerTab.this.viewFile(null);
                }
            }
        });
        this.printToolItem = new ToolItem(this.toolBar, 8);
        this.printToolItem.setImage(this.imageManager.get("print.gif"));
        this.printToolItem.setText(this.textBundle.get("PrintButton"));
        this.printToolItem.setToolTipText(this.textBundle.get("PrintDirectoryHoverText"));
        this.printToolItem.setEnabled(true);
        this.printToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail != 4) {
                    DiskExplorerTab.this.print();
                }
            }
        });
        new ToolItem(this.toolBar, 2);
        this.deleteToolItem = new ToolItem(this.toolBar, 8);
        this.deleteToolItem.setImage(this.imageManager.get("deletefile.gif"));
        this.deleteToolItem.setText(this.textBundle.get("DeleteFileToolItem"));
        this.deleteToolItem.setToolTipText(this.textBundle.get("DeleteFileHoverText"));
        this.deleteToolItem.setEnabled(false);
        this.deleteToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.deleteFile();
            }
        });
        new ToolItem(this.toolBar, 2);
        this.changeOrderToolItem = new ToolItem(this.toolBar, 4);
        this.changeOrderToolItem.setImage(this.imageManager.get("changeorder.gif"));
        this.changeOrderToolItem.setText(this.textBundle.get("ChangeDiskOrderToolItem"));
        this.changeOrderToolItem.setToolTipText(this.textBundle.get("ChangeDiskOrderHoverText"));
        ImageOrder imageOrder = this.disks[0].getImageOrder();
        this.changeOrderToolItem.setEnabled(imageOrder.isBlockDevice() && imageOrder.getBlocksOnDevice() == 280 || imageOrder.isTrackAndSectorDevice() && imageOrder.getSectorsPerDisk() == 560);
        this.changeOrderToolItem.addSelectionListener((SelectionListener)new DropDownSelectionListener(this.getChangeImageOrderMenu()));
        this.changeOrderToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolItem toolItem = (ToolItem)selectionEvent.getSource();
                Rectangle rectangle = toolItem.getBounds();
                Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                point = DiskExplorerTab.this.getToolBar().toDisplay(point);
                DiskExplorerTab.this.getChangeImageOrderMenu().setLocation(point.x, point.y);
                DiskExplorerTab.this.getChangeImageOrderMenu().setVisible(true);
            }
        });
        new ToolItem(this.toolBar, 2);
        this.saveToolItem = new ToolItem(this.toolBar, 8);
        this.saveToolItem.setImage(this.imageManager.get("saveimage.gif"));
        this.saveToolItem.setText(this.textBundle.get("SaveDiskImageToolItem"));
        this.saveToolItem.setToolTipText(this.textBundle.get("SaveDiskImageHoverText"));
        this.saveToolItem.setEnabled(this.disks[0].hasChanged());
        this.saveToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.save();
            }
        });
        this.saveAsToolItem = new ToolItem(this.toolBar, 8);
        this.saveAsToolItem.setImage(this.imageManager.get("saveas.gif"));
        this.saveAsToolItem.setText(this.textBundle.get("SaveDiskImageAsToolItem"));
        this.saveAsToolItem.setToolTipText(this.textBundle.get("SaveDiskImageAsHoverText"));
        this.saveAsToolItem.setEnabled(true);
        this.saveAsToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskExplorerTab.this.saveAs();
            }
        });
        this.toolBar.pack();
    }

    protected void changeCurrentFormat(int n) {
        TreeItem treeItem = this.directoryTree.getSelection()[0];
        Object object = treeItem.getData();
        DirectoryEntry directoryEntry = (DirectoryEntry)object;
        List list = directoryEntry.getFiles();
        boolean bl = this.formatChanged = this.currentFormat != n;
        if (this.formatChanged || !((Object)list).equals(this.currentFileList)) {
            this.preserveColumnWidths();
            this.currentFormat = n;
            this.fillFileTable(list);
            this.standardFormatToolItem.setSelection(this.currentFormat == 1);
            this.nativeFormatToolItem.setSelection(this.currentFormat == 2);
            this.detailFormatToolItem.setSelection(this.currentFormat == 3);
        }
    }

    protected void saveAs() {
        FileDialog fileDialog = new FileDialog(this.shell, 8192);
        fileDialog.setFilterPath(this.userPreferences.getSaveDirectory());
        fileDialog.setFileName(Host.getFileName(this.disks[0].getFilename()));
        fileDialog.setText(this.textBundle.get("SaveDiskImageAsPrompt"));
        String string = fileDialog.open();
        this.userPreferences.setSaveDirectory(fileDialog.getFilterPath());
        if (string == null) {
            return;
        }
        try {
            this.disks[0].saveAs(string);
            this.diskWindow.setStandardWindowTitle();
            this.saveToolItem.setEnabled(this.disks[0].hasChanged());
        }
        catch (IOException iOException) {
            this.showSaveError(iOException);
        }
    }

    protected void save() {
        try {
            if (this.disks[0].isNewImage()) {
                this.saveAs();
                return;
            }
            this.disks[0].save();
            this.saveToolItem.setEnabled(this.disks[0].hasChanged());
        }
        catch (IOException iOException) {
            this.showSaveError(iOException);
        }
    }

    protected void showSaveError(IOException iOException) {
        Shell shell = this.shell;
        String string = iOException.getMessage();
        if (string == null) {
            string = iOException.getClass().getName();
        }
        MessageBox messageBox = new MessageBox(shell, 65);
        messageBox.setText(this.textBundle.get("SaveDiskImageErrorTitle"));
        messageBox.setMessage(this.textBundle.format("SaveDiskImageErrorMessage", new Object[]{this.getDisk(0).getFilename(), string}));
        messageBox.open();
    }

    private Listener createDirectoryKeyboardHandler() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 2) {
                    TreeItem[] treeItemArray = null;
                    if ((event.stateMask & 0x40000) != 0) {
                        switch (event.character) {
                            case '-': {
                                treeItemArray = DiskExplorerTab.this.getDirectoryTree().getSelection();
                                DiskExplorerTab.this.setDirectoryExpandedStates(treeItemArray[0], false);
                                break;
                            }
                            case '+': {
                                treeItemArray = DiskExplorerTab.this.getDirectoryTree().getSelection();
                                DiskExplorerTab.this.setDirectoryExpandedStates(treeItemArray[0], true);
                            }
                        }
                    } else {
                        switch (event.character) {
                            case '-': {
                                treeItemArray = DiskExplorerTab.this.getDirectoryTree().getSelection();
                                treeItemArray[0].setExpanded(false);
                                break;
                            }
                            case '+': {
                                treeItemArray = DiskExplorerTab.this.getDirectoryTree().getSelection();
                                treeItemArray[0].setExpanded(true);
                            }
                        }
                    }
                }
            }
        };
    }

    protected void viewFile(Class clazz) {
        FileEntry fileEntry = this.getSelectedFileEntry();
        if (fileEntry.isDeleted()) {
            SwtUtil.showErrorDialog(this.shell, this.textBundle.get("DeleteFileErrorTitle"), this.textBundle.get("DeleteFileErrorMessage"));
        } else if (fileEntry.isDirectory()) {
            TreeItem treeItem = this.findDirectoryItem(this.directoryTree.getSelection()[0].getItems(), fileEntry.getFilename(), 1, 0);
            if (treeItem != null) {
                this.directoryTree.showItem(treeItem);
                this.directoryTree.setSelection(new TreeItem[]{treeItem});
                this.changeCurrentFormat(this.currentFormat);
            }
        } else {
            FileViewerWindow fileViewerWindow = null;
            FileFilter fileFilter = null;
            try {
                fileFilter = (FileFilter)clazz.newInstance();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (InstantiationException instantiationException) {
                SwtUtil.showSystemErrorDialog(this.shell, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                SwtUtil.showSystemErrorDialog(this.shell, illegalAccessException);
            }
            fileViewerWindow = fileFilter != null ? new FileViewerWindow(this.shell, fileEntry, this.imageManager, fileFilter) : new FileViewerWindow(this.shell, fileEntry, this.imageManager);
            fileViewerWindow.open();
        }
    }

    protected TreeItem findDirectoryItem(TreeItem[] treeItemArray, String string, int n, int n2) {
        if (n == n2) {
            return null;
        }
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItem treeItem;
            if (string.equals(treeItemArray[i].getText())) {
                return treeItemArray[i];
            }
            if (treeItemArray[i].getItems() == null || (treeItem = this.findDirectoryItem(treeItemArray[i].getItems(), string, n, n2 + 1)) == null) continue;
            return treeItem;
        }
        return null;
    }

    private Listener createFileKeyboardHandler() {
        return new Listener(){

            public void handleEvent(Event event) {
                FileEntry fileEntry = DiskExplorerTab.this.getSelectedFileEntry();
                if (fileEntry != null && event.type == 2 && (event.stateMask & 0x40000) != 0) {
                    switch (event.character) {
                        case '\u0003': {
                            if (!DiskExplorerTab.this.getCompileToolItem().isEnabled()) break;
                            DiskExplorerTab.this.compileFileWizard();
                            break;
                        }
                        case '\u0004': {
                            if (!DiskExplorerTab.this.getDeleteToolItem().isEnabled()) break;
                            DiskExplorerTab.this.deleteFile();
                            break;
                        }
                        case '\u0005': {
                            DiskExplorerTab.this.exportFileWizard();
                            break;
                        }
                        case '\u0016': {
                            DiskExplorerTab.this.viewFile(null);
                        }
                    }
                }
            }
        };
    }

    private Listener createToolbarCommandHandler() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 2) {
                    if ((event.stateMask & 0x40000) != 0) {
                        if ((event.stateMask & 0x20000) != 0) {
                            switch (event.character) {
                                case '\u0013': {
                                    DiskExplorerTab.this.saveAs();
                                }
                            }
                        } else {
                            switch (event.character) {
                                case '\t': {
                                    DiskExplorerTab.this.importFiles();
                                    break;
                                }
                                case '\u0010': {
                                    DiskExplorerTab.this.print();
                                    break;
                                }
                                case '\u0013': {
                                    if (!DiskExplorerTab.this.getSaveToolItem().isEnabled()) break;
                                    DiskExplorerTab.this.save();
                                }
                            }
                        }
                    } else if ((event.stateMask & 0x10000) != 65536) {
                        switch (event.keyCode) {
                            case 0x100000B: {
                                DiskExplorerTab.this.changeCurrentFormat(1);
                                break;
                            }
                            case 0x100000C: {
                                DiskExplorerTab.this.changeCurrentFormat(2);
                                break;
                            }
                            case 0x100000D: {
                                DiskExplorerTab.this.changeCurrentFormat(3);
                                break;
                            }
                            case 0x100000E: {
                                DiskExplorerTab.this.setShowDeletedFiles(!DiskExplorerTab.this.getShowDeletedFilesToolItem().getSelection());
                                DiskExplorerTab.this.getShowDeletedFilesToolItem().setSelection(DiskExplorerTab.this.isShowDeletedFiles());
                                DiskExplorerTab.this.fillFileTable(DiskExplorerTab.this.getCurrentFileList());
                            }
                        }
                    }
                }
            }
        };
    }

    protected FileEntry getSelectedFileEntry() {
        FileEntry fileEntry = null;
        if (this.fileTable.getSelectionIndex() >= 0) {
            fileEntry = (FileEntry)this.fileTable.getItem(this.fileTable.getSelectionIndex()).getData();
        }
        return fileEntry;
    }

    protected void print() {
        PrintDialog printDialog = new PrintDialog(this.shell);
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            return;
        }
        final Printer printer = new Printer(printerData);
        new Thread(){

            public void run() {
                new Printing(printer).run();
                printer.dispose();
            }
        }.start();
    }

    protected void changeImageOrder(String string, ImageOrder imageOrder) {
        try {
            this.disks[0].changeImageOrder(imageOrder);
            String string2 = this.disks[0].getFilename();
            if (this.disks[0].isCompressed()) {
                int n = string2.lastIndexOf(".", string2.length() - 4);
                string2 = string2.substring(0, n + 1) + string + ".gz";
            } else {
                int n = string2.lastIndexOf(".");
                string2 = string2.substring(0, n + 1) + string;
            }
            this.disks[0].setFilename(string2);
            this.diskWindow.setStandardWindowTitle();
        }
        catch (Throwable throwable) {
            Shell shell = this.shell;
            String string3 = throwable.getMessage();
            if (string3 == null) {
                string3 = throwable.getClass().getName();
            }
            MessageBox messageBox = new MessageBox(shell, 33);
            messageBox.setText(this.textBundle.get("ChangeImageOrderErrorTitle"));
            messageBox.setMessage(this.textBundle.format("ChangeImageOrderErrorMessage", string3));
            messageBox.open();
        }
    }

    protected Menu createChangeImageOrderMenu() {
        Menu menu = new Menu((Decorations)this.shell, 0);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                Menu menu = (Menu)menuEvent.getSource();
                MenuItem[] menuItemArray = menu.getItems();
                menuItemArray[0].setSelection(DiskExplorerTab.this.getDisk(0).isNibbleOrder());
                menuItemArray[1].setSelection(DiskExplorerTab.this.getDisk(0).isDosOrder());
                menuItemArray[2].setSelection(DiskExplorerTab.this.getDisk(0).isProdosOrder());
            }
        });
        MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setText(this.textBundle.get("ChangeToNibbleOrderMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!DiskExplorerTab.this.getDisk(0).isNibbleOrder()) {
                    NibbleOrder nibbleOrder = new NibbleOrder(new ByteArrayImageLayout(232960));
                    nibbleOrder.format();
                    DiskExplorerTab.this.changeImageOrder("nib", nibbleOrder);
                }
            }
        });
        menuItem = new MenuItem(menu, 16);
        menuItem.setText(this.textBundle.get("ChangeToDosOrderMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!DiskExplorerTab.this.getDisk(0).isDosOrder()) {
                    DiskExplorerTab.this.changeImageOrder("dsk", new DosOrder(new ByteArrayImageLayout(143360)));
                }
            }
        });
        menuItem = new MenuItem(menu, 16);
        menuItem.setText(this.textBundle.get("ChangeToProdosOrderMenuItem"));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!DiskExplorerTab.this.getDisk(0).isProdosOrder()) {
                    DiskExplorerTab.this.changeImageOrder("po", new ProdosOrder(new ByteArrayImageLayout(143360)));
                }
            }
        });
        return menu;
    }

    protected void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    protected void setShowDeletedFiles(boolean bl) {
        this.showDeletedFiles = bl;
    }

    protected boolean isShowDeletedFiles() {
        return this.showDeletedFiles;
    }

    protected Menu getChangeImageOrderMenu() {
        if (this.changeImageOrderMenu == null) {
            this.changeImageOrderMenu = this.createChangeImageOrderMenu();
        }
        return this.changeImageOrderMenu;
    }

    protected ToolBar getToolBar() {
        return this.toolBar;
    }

    protected FormattedDisk[] getDisks() {
        return this.disks;
    }

    protected FormattedDisk getDisk(int n) {
        return this.disks[n];
    }

    protected int getCurrentFormat() {
        return this.currentFormat;
    }

    protected Tree getDirectoryTree() {
        return this.directoryTree;
    }

    protected AppleWorksWordProcessorFileFilter getAwpFilter() {
        return this.awpFilter;
    }

    protected GutenbergFileFilter getGutenbergFilter() {
        return this.gutenbergFilter;
    }

    protected GraphicsFileFilter getGraphicsFilter() {
        return this.graphicsFilter;
    }

    protected ToolItem getImportToolItem() {
        return this.importToolItem;
    }

    protected ToolItem getExportToolItem() {
        return this.exportToolItem;
    }

    protected ToolItem getCompileToolItem() {
        return this.compileToolItem;
    }

    protected Table getFileTable() {
        return this.fileTable;
    }

    protected ToolItem getDeleteToolItem() {
        return this.deleteToolItem;
    }

    protected ToolItem getViewFileToolItem() {
        return this.viewFileItem;
    }

    protected List getCurrentFileList() {
        return this.currentFileList;
    }

    protected ToolItem getSaveToolItem() {
        return this.saveToolItem;
    }

    protected ToolItem getShowDeletedFilesToolItem() {
        return this.showDeletedFilesToolItem;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Printing
    implements Runnable {
        private Printer printer;
        private int y;
        private int x;
        private Rectangle clientArea;
        private GC gc;
        private List fileHeaders;
        private int[] printColumnWidths;
        private int[] printColumnPosition;
        private Font normalFont;
        private Font headerFont;
        private String filename;
        private int page = 1;
        private int dpiY;
        private int dpiX;

        public Printing(Printer printer) {
            this.printer = printer;
        }

        public void run() {
            if (this.printer.startJob(DiskExplorerTab.this.getDisk(0).getFilename())) {
                this.clientArea = this.printer.getClientArea();
                this.dpiY = this.printer.getDPI().y;
                this.dpiX = this.printer.getDPI().x;
                Rectangle rectangle = this.printer.computeTrim(0, 0, 0, 0);
                this.clientArea.x = this.dpiX + rectangle.x;
                this.clientArea.y = this.dpiY + rectangle.y;
                this.clientArea.width -= this.clientArea.x + rectangle.width;
                this.clientArea.height -= this.clientArea.y + rectangle.height;
                this.y = this.clientArea.y;
                this.x = this.clientArea.x;
                this.gc = new GC((Drawable)this.printer);
                int n = 12;
                if (DiskExplorerTab.this.getCurrentFormat() == 2) {
                    n = 10;
                } else if (DiskExplorerTab.this.getCurrentFormat() == 3) {
                    n = 8;
                }
                this.normalFont = new Font((Device)this.printer, new String(), n, 0);
                this.headerFont = new Font((Device)this.printer, new String(), n, 1);
                for (int i = 0; i < DiskExplorerTab.this.getDisks().length; ++i) {
                    FormattedDisk formattedDisk = DiskExplorerTab.this.getDisk(i);
                    this.filename = formattedDisk.getFilename();
                    this.fileHeaders = formattedDisk.getFileColumnHeaders(DiskExplorerTab.this.getCurrentFormat());
                    this.gc.setFont(this.headerFont);
                    this.computeHeaderWidths();
                    this.printFileHeaders();
                    this.gc.setFont(this.normalFont);
                    this.println(formattedDisk.getDiskName());
                    this.printFiles(formattedDisk, 1);
                }
                if (this.y != this.clientArea.y) {
                    this.printFooter();
                    this.printer.endPage();
                }
                this.printer.endJob();
            }
        }

        protected void computeHeaderWidths() {
            int n;
            int n2 = 0;
            int[] nArray = new int[this.fileHeaders.size()];
            for (n = 0; n < this.fileHeaders.size(); ++n) {
                FormattedDisk.FileColumnHeader fileColumnHeader = (FormattedDisk.FileColumnHeader)this.fileHeaders.get(n);
                nArray[n] = fileColumnHeader.getMaximumWidth() >= fileColumnHeader.getTitle().length() ? fileColumnHeader.getMaximumWidth() : fileColumnHeader.getTitle().length();
                n2 += nArray[n];
            }
            this.printColumnWidths = new int[this.fileHeaders.size()];
            this.printColumnPosition = new int[this.fileHeaders.size()];
            n = this.clientArea.x;
            for (int i = 0; i < this.fileHeaders.size(); ++i) {
                this.printColumnWidths[i] = nArray[i] * this.clientArea.width / n2;
                this.printColumnPosition[i] = n;
                n += this.printColumnWidths[i];
            }
        }

        protected void printFileHeaders() {
            for (int i = 0; i < this.fileHeaders.size(); ++i) {
                FormattedDisk.FileColumnHeader fileColumnHeader = (FormattedDisk.FileColumnHeader)this.fileHeaders.get(i);
                this.print(i, fileColumnHeader.getTitle(), fileColumnHeader.getAlignment());
            }
            this.println(new String());
        }

        protected void print(int n, String string, int n2) {
            int n3 = this.printColumnPosition[n];
            int n4 = n + 1 < this.printColumnPosition.length ? this.printColumnPosition[n + 1] : this.clientArea.width;
            int n5 = this.printColumnWidths[n];
            switch (n2) {
                case 1: {
                    this.x = n3;
                    break;
                }
                case 2: {
                    this.x = n3 + (n5 - this.gc.stringExtent((String)string).x) / 2;
                    break;
                }
                case 3: {
                    this.x = n4 - this.gc.stringExtent((String)string).x;
                }
            }
            this.gc.drawString(string, this.x, this.y);
        }

        protected void println(String string) {
            if (this.y == this.clientArea.y) {
                this.printer.startPage();
                this.printHeader();
                ++this.y;
                this.printFileHeaders();
            }
            this.gc.drawString(string, this.x, this.y);
            this.x = this.clientArea.x;
            this.y += this.gc.stringExtent((String)string).y;
            if (this.y > this.clientArea.y + this.clientArea.height) {
                this.printFooter();
                this.printer.endPage();
                this.y = this.clientArea.y;
            }
        }

        protected void printHeader() {
            Point point = this.gc.stringExtent(this.filename);
            this.gc.drawString(this.filename, this.clientArea.x + (this.clientArea.width - point.x) / 2, this.y - this.dpiY + point.y);
        }

        protected void printFooter() {
            TextBundle textBundle = UiBundle.getInstance();
            String string = textBundle.format("PageNumberText", Integer.toString(this.page));
            Point point = this.gc.stringExtent(string);
            this.gc.drawString(string, this.clientArea.x + (this.clientArea.width - point.x) / 2, this.clientArea.y + this.clientArea.height + this.dpiY - point.y);
            ++this.page;
        }

        protected void printFiles(DirectoryEntry directoryEntry, int n) {
            Iterator iterator = directoryEntry.getFiles().iterator();
            while (iterator.hasNext()) {
                FileEntry fileEntry = (FileEntry)iterator.next();
                if (fileEntry.isDeleted() && !DiskExplorerTab.this.isShowDeletedFiles()) continue;
                List list = fileEntry.getFileColumnData(DiskExplorerTab.this.getCurrentFormat());
                for (int i = 0; i < list.size(); ++i) {
                    FormattedDisk.FileColumnHeader fileColumnHeader = (FormattedDisk.FileColumnHeader)this.fileHeaders.get(i);
                    String string = (String)list.get(i);
                    if ("name".equalsIgnoreCase(fileColumnHeader.getTitle())) {
                        for (int j = 0; j < n; ++j) {
                            string = "  " + string;
                        }
                    }
                    this.print(i, string, fileColumnHeader.getAlignment());
                }
                this.println(new String());
                if (!fileEntry.isDirectory()) continue;
                this.printFiles((DirectoryEntry)((Object)fileEntry), n + 1);
            }
        }
    }
}

