/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.filteradapter;

import com.webcodepro.applecommander.ui.swt.FileViewerWindow;
import com.webcodepro.applecommander.ui.swt.filteradapter.FilterAdapter;
import com.webcodepro.applecommander.ui.swt.util.contentadapter.StyledTextAdapter;
import com.webcodepro.applecommander.util.BusinessBASICToken;
import com.webcodepro.applecommander.util.BusinessBASICTokenizer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BusinessBASICFilterAdapter
extends FilterAdapter {
    private StyledText styledText;

    public BusinessBASICFilterAdapter(FileViewerWindow fileViewerWindow, String string, String string2, Image image) {
        super(fileViewerWindow, string, string2, image);
    }

    public void display() {
        if (this.styledText == null) {
            this.createStyledText();
        }
        Point point = this.styledText.computeSize(-1, -1, true);
        this.getComposite().setContent((Control)this.styledText);
        this.getComposite().setExpandHorizontal(true);
        this.getComposite().setExpandVertical(true);
        this.getComposite().setMinWidth(point.x);
        this.getComposite().setMinHeight(point.y);
        this.getComposite().getContent().addListener(2, this.getToolbarCommandHandler());
        this.setContentTypeAdapter(new StyledTextAdapter(this.styledText, this.getFileEntry().getFilename()));
    }

    public void dispose() {
        this.styledText.dispose();
    }

    protected void createStyledText() {
        this.styledText = new StyledText((Composite)this.getComposite(), 0);
        this.styledText.setForeground(this.getBlackColor());
        this.styledText.setFont(this.getCourierFont());
        this.styledText.setEditable(false);
        BusinessBASICTokenizer businessBASICTokenizer = new BusinessBASICTokenizer(this.getFileEntry());
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        while (businessBASICTokenizer.hasMoreTokens()) {
            StyleRange styleRange;
            int n2;
            BusinessBASICToken businessBASICToken = businessBASICTokenizer.getNextToken();
            if (businessBASICToken == null) continue;
            if (businessBASICToken.isLineNumber()) {
                if (bl) {
                    bl = false;
                } else {
                    this.styledText.append("\n");
                }
                bl2 = true;
                this.styledText.append(Integer.toString(businessBASICToken.getLineNumber()));
                this.styledText.append("   ");
                if (n <= 0) continue;
                for (n2 = 0; n2 < n; ++n2) {
                    this.styledText.append("  ");
                }
                continue;
            }
            if (businessBASICToken.isCommandSeparator() || businessBASICToken.isExpressionSeparator()) {
                this.styledText.append(businessBASICToken.getStringValue());
                bl2 = true;
                continue;
            }
            if (businessBASICToken.isEndOfCommand()) {
                this.styledText.append("\n");
                bl2 = false;
                continue;
            }
            if (businessBASICToken.isString()) {
                if (!bl2) {
                    this.styledText.append(" ");
                }
                n2 = this.styledText.getCharCount();
                this.styledText.append(businessBASICToken.getStringValue().trim());
                styleRange = new StyleRange();
                styleRange.start = n2;
                styleRange.length = businessBASICToken.getStringValue().trim().length();
                styleRange.foreground = this.getGreenColor();
                this.styledText.setStyleRange(styleRange);
                bl2 = false;
                continue;
            }
            if (!businessBASICToken.isToken()) continue;
            if (!bl2) {
                this.styledText.append(" ");
            }
            n2 = this.styledText.getCharCount();
            this.styledText.append(businessBASICToken.getTokenString());
            styleRange = new StyleRange();
            styleRange.start = n2;
            styleRange.length = businessBASICToken.getTokenString().length();
            styleRange.foreground = this.getBlueColor();
            this.styledText.setStyleRange(styleRange);
            bl2 = false;
            if (businessBASICToken.isIndenter()) {
                ++n;
                continue;
            }
            if (!businessBASICToken.isOutdenter()) continue;
            --n;
        }
    }
}

