/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.BusinessBASICToken;

public class BusinessBASICTokenizer {
    private static String[] tokens = new String[]{"END", "FOR", "NEXT", "INPUT", "OUTPUT", "DIM", "READ", "WRITE", "OPEN", "CLOSE", "*error*", "TEXT", "*error*", "BYE", "*error*", "*error*", "*error*", "*error*", "*error*", "WINDOW", "INVOKE", "PERFORM", "*error*", "*error*", "FRE", "HPOS", "VPOS", "ERRLIN", "ERR", "KBD", "EOF", "TIME$", "DATE$", "PREFIX$", "EXFN.", "EXFN%.", "OUTREC", "INDENT", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "POP", "HOME", "*error*", "SUB$(", "OFF", "TRACE", "NOTRACE", "NORMAL", "INVERSE", "SCALE(", "RESUME", "*error*", "LET", "GOTO", "IF", "RESTORE", "SWAP", "GOSUB", "RETURN", "REM", "STOP", "ON", "*error*", "LOAD", "SAVE", "DELETE", "RUN", "RENAME", "LOCK", "UNLOCK", "CREATE", "EXEC", "CHAIN", "*error*", "*error*", "*error*", "CATALOG", "*error*", "*error*", "DATA", "IMAGE", "CAT", "DEF", "*error*", "PRINT", "DEL", "ELSE", "CONT", "LIST", "CLEAR", "GET", "NEW", "TAB", "TO", "SPC(", "USING", "THEN", "*error*", "MOD", "STEP", "AND", "OR", "EXTENSION", " DIV", "*error*", "FN", "NOT", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "tf7", "TAB(", "TO", "SPC(", "USING", "THEN", "*error*", "MOD", "STEP", "AND", "OR", "EXTENSION", " DIV", "*error*", "FN", "NOT", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "AS", "SGN(", "INT(", "ABS(", "*error*", "TYP(", "REC(", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "PDL(", "BUTTON(", "SQR(", "RND(", "LOG(", "EXP(", "COS(", "SIN(", "TAN(", "ATN(", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "STR$(", "HEX$(", "CHR$(", "LEN(", "VAL(", "ASC(", "TEN(", "*error*", "*error*", "CONV(", "CONV&(", "CONV$(", "CONV%(", "LEFT$(", "RIGHT$(", "MID$(", "INSTR$(", "*error*", "*error*", "*error*", "*error*"};
    private byte[] fileData;
    private int offset = 2;
    private int nextAddress = -1;

    public BusinessBASICTokenizer(FileEntry fileEntry) {
        this(fileEntry.getFileData());
    }

    public BusinessBASICTokenizer(byte[] byArray) {
        this.fileData = byArray;
    }

    public boolean hasMoreTokens() {
        return this.offset < this.fileData.length;
    }

    public BusinessBASICToken getNextToken() {
        if (this.hasMoreTokens()) {
            byte by;
            if (this.nextAddress == -1) {
                this.nextAddress = AppleUtil.getUnsignedByte(this.fileData, this.offset);
                ++this.offset;
                if (this.nextAddress == 0) {
                    this.offset = this.fileData.length;
                    return null;
                }
                int n = AppleUtil.getWordValue(this.fileData, this.offset);
                this.offset += 2;
                return new BusinessBASICToken(n);
            }
            if ((by = this.fileData[this.offset++]) == 0) {
                this.nextAddress = -1;
                return this.getNextToken();
            }
            if ((by & 0x80) != 0) {
                int n = AppleUtil.getUnsignedByte(by) - 128;
                if (n == 127) {
                    by = this.fileData[this.offset++];
                    n = AppleUtil.getUnsignedByte(by);
                }
                if (n >= tokens.length) {
                    return new BusinessBASICToken(by, "<UNKNOWN TOKEN>");
                }
                return new BusinessBASICToken(by, tokens[n]);
            }
            if (by == 58 || by == 59 || by == 44 || by == 94 || by == 43 || by == 45 || by == 42 || by == 47) {
                return new BusinessBASICToken(new String(new byte[]{by}));
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                char c;
                if ((c = (char)by) < ' ') {
                    stringBuffer.append("<CTRL-");
                    stringBuffer.append((char)(64 + c));
                    stringBuffer.append('>');
                } else {
                    stringBuffer.append(c);
                }
                by = this.fileData[this.offset];
                if ((by & 0x80) != 0 || by == 0 || by == 58 || by == 44 || by == 59) break;
                ++this.offset;
            }
            return new BusinessBASICToken(stringBuffer.toString());
        }
        return null;
    }
}

