/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.ac;
import com.webcodepro.applecommander.util.TextBundle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AppleCommander {
    public static final String VERSION = "1.3.5.10";
    private static TextBundle textBundle = UiBundle.getInstance();

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            if (AppleCommander.isSwtAvailable()) {
                AppleCommander.launchSwtAppleCommander(stringArray);
            } else if (AppleCommander.isSwingAvailable()) {
                AppleCommander.launchSwingAppleCommander(stringArray);
            } else {
                AppleCommander.showHelp();
            }
        } else {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            if ("-swt".equalsIgnoreCase(stringArray[0])) {
                AppleCommander.launchSwtAppleCommander(stringArray);
            } else if ("-swing".equalsIgnoreCase(stringArray[0])) {
                System.err.println(textBundle.get("SwingVersionNotAvailable"));
                AppleCommander.launchSwingAppleCommander(stringArray);
            } else if ("-command".equalsIgnoreCase(stringArray[0])) {
                System.err.println(textBundle.get("CommandLineNotAvailable"));
            } else if ("-help".equalsIgnoreCase(stringArray[0]) || "-?".equalsIgnoreCase(stringArray[0])) {
                AppleCommander.showHelp();
            } else {
                ac.main(stringArray);
            }
        }
    }

    protected static void launchSwtAppleCommander(String[] stringArray) {
        try {
            Class<?> clazz = Class.forName("com.webcodepro.applecommander.ui.swt.SwtAppleCommander");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("launch", null);
            method.invoke(obj, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
    }

    protected static boolean isSwtAvailable() {
        try {
            Class.forName("org.eclipse.swt.SWT");
            Class.forName("com.webcodepro.applecommander.ui.swt.SwtAppleCommander");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    protected static boolean isSwingAvailable() {
        try {
            Class.forName("com.webcodepro.applecommander.ui.swing.SwingAppleCommander");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    protected static void launchSwingAppleCommander(String[] stringArray) {
        try {
            Class<?> clazz = Class.forName("com.webcodepro.applecommander.ui.swing.SwingAppleCommander");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("launch", null);
            method.invoke(obj, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
    }

    protected static void showHelp() {
        System.err.println(textBundle.get("AppleCommanderHelp"));
        System.err.println();
        ac.help();
    }
}

