/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.compiler;

import com.webcodepro.applecommander.compiler.CompileException;
import com.webcodepro.applecommander.compiler.CompilerBundle;
import com.webcodepro.applecommander.compiler.Variable;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.util.ApplesoftToken;
import com.webcodepro.applecommander.util.ApplesoftTokenizer;
import com.webcodepro.applecommander.util.ApplesoftTokens;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class ApplesoftCompiler
implements ApplesoftTokens {
    private TextBundle textBundle = CompilerBundle.getInstance();
    private ApplesoftTokenizer tokenizer;
    private ApplesoftToken tokenAlreadySeen;
    private StringBuffer sourceAssembly = new StringBuffer();
    private StringBuffer sourceLine = new StringBuffer();
    private Map knownAddresses = new HashMap();
    private List usedAddresses = new ArrayList();
    private List variables = new ArrayList();
    private Map commandMethods = new HashMap();
    private Stack loopVariables = new Stack();
    private boolean integerOnlyMath;

    public ApplesoftCompiler(FileEntry fileEntry) {
        this.tokenizer = new ApplesoftTokenizer(fileEntry);
        this.initializeKnownAddresses();
    }

    protected void initializeKnownAddresses() {
        InputStream inputStream = this.getClass().getResourceAsStream("AppleMemoryAddresses.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.knownAddresses.put(string, properties.getProperty(string));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected boolean hasMoreTokens() {
        return this.peekToken() != null;
    }

    protected ApplesoftToken nextToken() {
        ApplesoftToken applesoftToken = this.tokenAlreadySeen;
        if (this.tokenAlreadySeen != null) {
            this.tokenAlreadySeen = null;
        } else {
            applesoftToken = this.tokenizer.getNextToken();
        }
        if (applesoftToken != null) {
            if (applesoftToken.isLineNumber()) {
                this.sourceLine.append("* ");
                this.sourceLine.append(applesoftToken.getLineNumber());
                this.sourceLine.append(" ");
            } else if (applesoftToken.isToken()) {
                this.sourceLine.append(applesoftToken.getTokenString());
            } else if (applesoftToken.isString()) {
                this.sourceLine.append(applesoftToken.getStringValue());
            }
        }
        return applesoftToken;
    }

    protected ApplesoftToken peekToken() {
        if (this.tokenAlreadySeen == null) {
            this.tokenAlreadySeen = this.tokenizer.getNextToken();
        }
        return this.tokenAlreadySeen;
    }

    public byte[] compile() throws CompileException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.hasMoreTokens()) {
            ApplesoftToken applesoftToken = this.nextToken();
            if (!applesoftToken.isLineNumber()) {
                throw new CompileException(this.textBundle.get("ApplesoftCompiler.ExpectLineNumberError"));
            }
            this.sourceAssembly.append("LINE");
            this.sourceAssembly.append(applesoftToken.getLineNumber());
            this.sourceAssembly.append("\n");
            do {
                this.evaluateCommand();
                applesoftToken = this.peekToken();
                if (applesoftToken == null || !applesoftToken.isCommandSeparator()) continue;
                applesoftToken = this.nextToken();
            } while (applesoftToken != null && applesoftToken.isCommandSeparator());
            stringBuffer.append(this.sourceLine);
            stringBuffer.append("\n");
            stringBuffer.append(this.sourceAssembly);
            stringBuffer.append("\n");
            this.sourceLine.setLength(0);
            this.sourceAssembly.setLength(0);
        }
        stringBuffer.insert(0, this.buildUsedAddresses());
        stringBuffer.append(this.buildVariableSection());
        this.sourceLine.setLength(0);
        this.sourceAssembly.setLength(0);
        return stringBuffer.toString().getBytes();
    }

    protected StringBuffer buildUsedAddresses() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.usedAddresses.size() > 0) {
            stringBuffer.append("* Addresses:\n");
            for (int i = 0; i < this.usedAddresses.size(); ++i) {
                String string = (String)this.usedAddresses.get(i);
                stringBuffer.append(string);
                stringBuffer.append(" = ");
                stringBuffer.append((String)this.knownAddresses.get(string));
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    protected StringBuffer buildVariableSection() {
        this.sourceAssembly.setLength(0);
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable variable;
            if (i == 0) {
                this.sourceAssembly.append("\n");
                this.sourceAssembly.append("* Variables:\n");
            }
            if ((variable = (Variable)this.variables.get(i)).isConstantInteger()) {
                this.addAssembly(variable.getName(), "DW", variable.getValue());
                continue;
            }
            if (variable.isConstantFloat()) continue;
            if (variable.isConstantString()) {
                this.addAssembly(variable.getName(), "ASC", variable.getValue());
                this.addAssembly(null, "HEX", "00");
                continue;
            }
            if (variable.isTypeFloat()) {
                this.addAssembly(variable.getName(), "HEX", "8400000000");
                continue;
            }
            if (variable.isTypeInteger()) {
                this.addAssembly(variable.getName(), "DS", "2");
                continue;
            }
            if (!variable.isTypeString()) continue;
        }
        return this.sourceAssembly;
    }

    protected void evaluateCommand() {
        ApplesoftToken applesoftToken = this.nextToken();
        while (applesoftToken != null && applesoftToken.isCommandSeparator()) {
            applesoftToken = this.nextToken();
        }
        if (applesoftToken == null || !applesoftToken.isToken()) {
            return;
        }
        Method method = this.getMethod(applesoftToken);
        if (method != null) {
            try {
                method.invoke((Object)this, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(this.textBundle.format("ApplesoftCompiler.UnableToLocateError", method.getName()));
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(this.textBundle.format("ApplesoftCompiler.UnableToLocateError", method.getName()));
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println(this.textBundle.format("ApplesoftCompiler.UnableToLocateError", method.getName()));
                invocationTargetException.printStackTrace();
            }
        } else {
            while (this.peekToken() != null && !this.peekToken().isCommandSeparator() && !this.peekToken().isLineNumber()) {
                this.nextToken();
            }
        }
    }

    protected Method getMethod(ApplesoftToken applesoftToken) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("evaluate");
        stringBuffer.append(applesoftToken.getTokenString().trim());
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) != '=') continue;
            stringBuffer.deleteCharAt(i);
        }
        String string = stringBuffer.toString();
        Method method = (Method)this.commandMethods.get(string);
        if (method == null) {
            try {
                method = this.getClass().getMethod(string, new Class[0]);
                this.commandMethods.put(string, method);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return method;
    }

    protected void addAssembly(String string, String string2, String string3) {
        if (string != null) {
            this.sourceAssembly.append(string);
        }
        if (string2 != null) {
            this.sourceAssembly.append(" ");
            this.sourceAssembly.append(string2);
            if (string3 != null) {
                this.sourceAssembly.append(" ");
                this.sourceAssembly.append(string3);
                if (!this.usedAddresses.contains(string3) && this.knownAddresses.containsKey(string3)) {
                    this.usedAddresses.add(string3);
                }
            }
            this.sourceAssembly.append("\n");
        }
    }

    public void evaluateHOME() {
        this.addAssembly(null, "JSR", "HOME");
    }

    public void evaluateTEXT() {
        this.addAssembly(null, "JSR", "TEXT");
    }

    public void evaluateRETURN() {
        this.addAssembly(null, "RTS", null);
    }

    public void evaluateEND() {
        this.evaluateRETURN();
    }

    public void evaluateHGR() {
        this.addAssembly(null, "JSR", "HGR");
    }

    public void evaluateHGR2() {
        this.addAssembly(null, "JSR", "HGR2");
    }

    public void evaluateGR() {
        this.addAssembly(null, "JSR", "GR");
    }

    public void evaluateINVERSE() {
        this.addAssembly(null, "LDA", "#$3F");
        this.addAssembly(null, "STA", "INVFLAG");
    }

    public void evaluateNORMAL() {
        this.addAssembly(null, "LDA", "#$FF");
        this.addAssembly(null, "STA", "INVFLAG");
    }

    public void evaluateFLASH() {
        this.addAssembly(null, "LDA", "#$7F");
        this.addAssembly(null, "STA", "INVFLAG");
    }

    protected Variable evaluateExpression() throws CompileException {
        ApplesoftToken applesoftToken = this.peekToken();
        if (applesoftToken.isEndOfCommand()) {
            return null;
        }
        applesoftToken = this.nextToken();
        if (applesoftToken.isString()) {
            String string = applesoftToken.getStringValue();
            Variable variable = null;
            for (int i = 0; i < this.variables.size() && !string.equals((variable = (Variable)this.variables.get(i)).getValue()); ++i) {
                variable = null;
            }
            if (variable == null) {
                variable = this.isIntegerNumber(string) ? new Variable("INT" + string, 5, string) : (string.startsWith("\"") ? new Variable("STR" + this.variables.size(), 4, string) : (string.endsWith("$") ? new Variable("VAR" + string, 1, string) : (string.endsWith("%") || this.isIntegerOnlyMath() ? new Variable("VAR" + string, 2, string) : new Variable("VAR" + string, 3, string))));
                this.variables.add(variable);
            }
            return variable;
        }
        throw new CompileException(this.textBundle.get("ApplesoftCompiler.UnableToEvaluateError"));
    }

    protected Variable evaluateNumber() throws CompileException {
        Variable variable = this.evaluateExpression();
        if (variable.isNumber()) {
            return variable;
        }
        throw new CompileException(this.textBundle.get("ApplesoftCompiler.NumberRequiredError"));
    }

    protected String getLineNumberLabel() throws CompileException {
        ApplesoftToken applesoftToken = this.nextToken();
        if (applesoftToken.isString() && this.isIntegerNumber(applesoftToken.getStringValue())) {
            return "LINE" + applesoftToken.getStringValue();
        }
        throw new CompileException(this.textBundle.format("ApplesoftCompiler.ExpectingLineNumberError", applesoftToken.toString()));
    }

    protected void addLoadByteValue(Variable variable, char c) throws CompileException {
        if (variable.isConstantInteger()) {
            this.addAssembly(null, "LD" + c, "#" + variable.getValue());
        } else if (variable.isTypeInteger()) {
            this.addAssembly(null, "LD" + c, variable.getName());
        } else if (variable.isConstantFloat() || variable.isTypeFloat()) {
            this.addAssembly(null, "LDY", "#>" + variable.getName());
            this.addAssembly(null, "LDA", "#<" + variable.getName());
            this.addAssembly(null, "JSR", "MOVFM");
            this.addAssembly(null, "JSR", "QINT");
            this.addAssembly(null, "LD" + c, "FACLO");
        } else {
            throw new CompileException(this.textBundle.format("ApplesoftCompiler.InvalidByteFormatError", variable.getName()));
        }
    }

    protected void addLoadWordValue(Variable variable, char c, char c2) throws CompileException {
        if (variable.isConstantInteger()) {
            this.addAssembly(null, "LD" + c, "#>" + variable.getValue());
            this.addAssembly(null, "LD" + c2, "#<" + variable.getValue());
        } else if (variable.isTypeInteger()) {
            this.addAssembly(null, "LD" + c, variable.getName() + "+1");
            this.addAssembly(null, "LD" + c2, variable.getName());
        } else if (variable.isConstantFloat() || variable.isTypeFloat()) {
            this.addLoadFac(variable);
            this.addAssembly(null, "JSR", "QINT");
            this.addAssembly(null, "LD" + c, "FACMO");
            this.addAssembly(null, "LD" + c2, "FACLO");
        } else {
            throw new CompileException(this.textBundle.format("ApplesoftCompiler.InvalidWordFormatError", variable.getName()));
        }
    }

    protected void addLoadAddress(Variable variable, char c, char c2) {
        this.addAssembly(null, "LD" + c, "#>" + variable.getName());
        this.addAssembly(null, "LD" + c2, "#<" + variable.getName());
    }

    protected void addLoadFac(Variable variable) throws CompileException {
        if (variable.isConstantFloat() || variable.isTypeFloat()) {
            this.addLoadAddress(variable, 'Y', 'A');
            this.addAssembly(null, "JSR", "MOVFM");
        } else if (variable.isConstantInteger() || variable.isTypeInteger()) {
            this.addLoadWordValue(variable, 'A', 'Y');
            this.addAssembly(null, "JSR", "GIVAYF");
        } else {
            throw new CompileException(this.textBundle.format("ApplesoftCompiler.InvalidFloatTypeError", variable.getName()));
        }
    }

    protected void addCopyFac(Variable variable) throws CompileException {
        if (!variable.isTypeFloat()) {
            throw new CompileException(this.textBundle.get("ApplesoftCompiler.CannotCopyToFloatError"));
        }
        this.addLoadAddress(variable, 'Y', 'X');
        this.addAssembly(null, "JSR", "MOVMF");
    }

    public void evaluateHTAB() throws CompileException {
        this.addLoadByteValue(this.evaluateExpression(), 'A');
        this.addAssembly(null, "STA", "CH");
    }

    public void evaluateVTAB() throws CompileException {
        this.addLoadByteValue(this.evaluateExpression(), 'X');
        this.addAssembly(null, "DEX", null);
        this.addAssembly(null, "STX", "CV");
        this.addAssembly(null, "JSR", "LF");
    }

    public void evaluateHCOLOR() throws CompileException {
        this.addLoadByteValue(this.evaluateExpression(), 'X');
        this.addAssembly(null, "JSR", "SETHCOL");
    }

    public void evaluatePRINT() throws CompileException {
        ApplesoftToken applesoftToken = null;
        do {
            Variable variable;
            if ((variable = this.evaluateExpression()) == null) {
                this.addAssembly(null, "JSR", "PRCR");
            } else if (variable.isConstantFloat() || variable.isTypeFloat()) {
                this.addLoadFac(variable);
                this.addAssembly(null, "JSR", "PRNTFAC");
            } else if (variable.isConstantInteger() || variable.isTypeInteger()) {
                this.addLoadWordValue(variable, 'X', 'A');
                this.addAssembly(null, "JSR", "LINPRT");
            } else if (variable.isConstantString()) {
                this.addLoadAddress(variable, 'Y', 'A');
                this.addAssembly(null, "JSR", "STROUT");
            } else if (variable.isTypeString()) {
                throw new CompileException(this.textBundle.get("ApplesoftCompiler.StringPrintUnsupported"));
            }
            applesoftToken = this.peekToken();
            if (applesoftToken == null || !applesoftToken.isExpressionSeparator()) continue;
            this.nextToken();
        } while ((applesoftToken = this.peekToken()) != null && !applesoftToken.isEndOfCommand());
    }

    public void evaluateGOTO() throws CompileException {
        this.addAssembly(null, "JMP", this.getLineNumberLabel());
    }

    protected void checkSyntax(byte by, String string) throws CompileException {
        ApplesoftToken applesoftToken = this.nextToken();
        if (applesoftToken.getTokenValue() != by) {
            throw new CompileException(this.textBundle.format("ApplesoftCompiler.SyntaxError", string));
        }
    }

    protected void checkSyntax(String string, String string2) throws CompileException {
        ApplesoftToken applesoftToken = this.nextToken();
        if (!string.equals(applesoftToken.getStringValue())) {
            throw new CompileException(this.textBundle.format("ApplesoftCompiler.SyntaxError", string2));
        }
    }

    public void evaluateFOR() throws CompileException {
        Variable variable = this.evaluateExpression();
        if (!variable.isTypeFloat() && !variable.isTypeInteger()) {
            throw new CompileException(this.textBundle.get("ApplesoftCompiler.ForStatementUnsupportedTypeError"));
        }
        this.checkSyntax((byte)-48, "=");
        Variable variable2 = this.evaluateNumber();
        this.checkSyntax((byte)-63, "TO");
        Variable variable3 = this.evaluateNumber();
        String string = "FOR" + this.loopVariables.size();
        this.loopVariables.add(string);
        this.addLoadFac(variable2);
        this.addCopyFac(variable);
        this.addAssembly(string, null, null);
        this.addLoadFac(variable3);
        this.addLoadAddress(variable, 'Y', 'A');
        this.addAssembly(null, "JSR", "FCOMP");
        this.addAssembly(null, "CMP", "#$FF");
        this.addAssembly(null, "BEQ", "END" + string);
    }

    public void evaluateHPLOT() throws CompileException {
        boolean bl = true;
        while (this.peekToken() != null && !this.peekToken().isEndOfCommand()) {
            if (!bl) {
                this.checkSyntax((byte)-63, "TO");
            }
            Variable variable = this.evaluateNumber();
            this.checkSyntax(",", ", (comma)");
            Variable variable2 = this.evaluateNumber();
            if (bl) {
                this.addLoadWordValue(variable, 'Y', 'X');
                this.addLoadByteValue(variable2, 'A');
                this.addAssembly(null, "JSR", "HPOSN");
                bl = false;
                continue;
            }
            this.addLoadWordValue(variable, 'X', 'A');
            this.addLoadByteValue(variable2, 'Y');
            this.addAssembly(null, "JSR", "HLIN");
        }
    }

    public void evaluateNEXT() throws CompileException {
        Variable variable = null;
        if (!this.peekToken().isCommandSeparator()) {
            variable = this.evaluateExpression();
        }
        if (variable.isTypeFloat()) {
            this.addAssembly(null, "LDY", "#1");
            this.addAssembly(null, "JSR", "SNGFLT");
            this.addLoadAddress(variable, 'Y', 'A');
            this.addAssembly(null, "JSR", "FADD");
            this.addCopyFac(variable);
        } else if (variable.isTypeInteger()) {
            this.addAssembly(null, "INC", variable.getName());
            this.addAssembly(null, "BNE", ":1");
            this.addAssembly(null, "INC", variable.getName() + "+1");
            this.addAssembly(":1", null, null);
        }
        String string = (String)this.loopVariables.pop();
        this.addAssembly(null, "JMP", string);
        this.addAssembly("END" + string, null, null);
    }

    protected boolean isIntegerNumber(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isIntegerOnlyMath() {
        return this.integerOnlyMath;
    }

    public void setIntegerOnlyMath(boolean bl) {
        this.integerOnlyMath = bl;
    }
}

