/*
  tables.c
  Copyright 2000,2001 by William Sheldon Simms III

  This file is a part of open apple -- a free Apple II emulator.
 
  Open apple is free software; you can redistribute it and/or modify it under the terms
  of the GNU General Public License as published by the Free Software Foundation; either
  version 2, or (at your option) any later version.
 
  Open apple is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License along with open apple;
  see the file COPYING. If not, visit the Free Software Foundation website at http://www.fsf.org
 */

#include "instructions.h"
#include "tables.h"

/* instruction decode tables */

ifunc binary_instruction_table [256] =
{
  i00_BRK, i01_ORA,        iEA_NOP,        iEA_NOP, i04_TSB, i05_ORA,        i06_ASL, iEA_NOP,
  i08_PHP, i09_ORA,        i0A_ASL,        iEA_NOP, i0C_TSB, i0D_ORA,        i0E_ASL, iEA_NOP,
  i10_BPL, i11_ORA,        i12_ORA,        iEA_NOP, i14_TRB, i15_ORA,        i16_ASL, iEA_NOP,
  i18_CLC, i19_ORA,        i1A_INC,        iEA_NOP, i1C_TRB, i1D_ORA,        i1E_ASL, iEA_NOP,
  i20_JSR, i21_AND,        iEA_NOP,        iEA_NOP, i24_BIT, i25_AND,        i26_ROL, iEA_NOP,
  i28_PLP, i29_AND,        i2A_ROL,        iEA_NOP, i2C_BIT, i2D_AND,        i2E_ROL, iEA_NOP,
  i30_BMI, i31_AND,        i32_AND,        iEA_NOP, i34_BIT, i35_AND,        i36_ROL, iEA_NOP,
  i38_SEC, i39_AND,        i3A_DEC,        iEA_NOP, i3C_BIT, i3D_AND,        i3E_ROL, iEA_NOP,
  i40_RTI, i41_EOR,        iEA_NOP,        iEA_NOP, iEA_NOP, i45_EOR,        i46_LSR, iEA_NOP,
  i48_PHA, i49_EOR,        i4A_LSR,        iEA_NOP, i4C_JMP, i4D_EOR,        i4E_LSR, iEA_NOP,
  i50_BVC, i51_EOR,        i52_EOR,        iEA_NOP, iEA_NOP, i55_EOR,        i56_LSR, iEA_NOP,
  i58_CLI, i59_EOR,        i5A_PHY,        iEA_NOP, iEA_NOP, i5D_EOR,        i5E_LSR, iEA_NOP,
  i60_RTS, i61_ADC_binary, iEA_NOP,        iEA_NOP, i64_STZ, i65_ADC_binary, i66_ROR, iEA_NOP,
  i68_PLA, i69_ADC_binary, i6A_ROR,        iEA_NOP, i6C_JMP, i6D_ADC_binary, i6E_ROR, iEA_NOP,
  i70_BVS, i71_ADC_binary, i72_ADC_binary, iEA_NOP, i74_STZ, i75_ADC_binary, i76_ROR, iEA_NOP,
  i78_SEI, i79_ADC_binary, i7A_PLY,        iEA_NOP, i7C_JMP, i7D_ADC_binary, i7E_ROR, iEA_NOP,
  i80_BRA, i81_STA,        iEA_NOP,        iEA_NOP, i84_STY, i85_STA,        i86_STX, iEA_NOP,
  i88_DEY, i89_BIT,        i8A_TXA,        iEA_NOP, i8C_STY, i8D_STA,        i8E_STX, iEA_NOP,
  i90_BCC, i91_STA,        i92_STA,        iEA_NOP, i94_STY, i95_STA,        i96_STX, iEA_NOP,
  i98_TYA, i99_STA,        i9A_TXS,        iEA_NOP, i9C_STZ, i9D_STA,        i9E_STZ, iEA_NOP,
  iA0_LDY, iA1_LDA,        iA2_LDX,        iEA_NOP, iA4_LDY, iA5_LDA,        iA6_LDX, iEA_NOP,
  iA8_TAY, iA9_LDA,        iAA_TAX,        iEA_NOP, iAC_LDY, iAD_LDA,        iAE_LDX, iEA_NOP,
  iB0_BCS, iB1_LDA,        iB2_LDA,        iEA_NOP, iB4_LDY, iB5_LDA,        iB6_LDX, iEA_NOP,
  iB8_CLV, iB9_LDA,        iBA_TSX,        iEA_NOP, iBC_LDY, iBD_LDA,        iBE_LDX, iEA_NOP,
  iC0_CPY, iC1_CMP,        iEA_NOP,        iEA_NOP, iC4_CPY, iC5_CMP,        iC6_DEC, iEA_NOP,
  iC8_INY, iC9_CMP,        iCA_DEX,        iEA_NOP, iCC_CPY, iCD_CMP,        iCE_DEC, iEA_NOP,
  iD0_BNE, iD1_CMP,        iD2_CMP,        iEA_NOP, iEA_NOP, iD5_CMP,        iD6_DEC, iEA_NOP,
  iD8_CLD, iD9_CMP,        iDA_PHX,        iEA_NOP, iEA_NOP, iDD_CMP,        iDE_DEC, iEA_NOP,
  iE0_CPX, iE1_SBC_binary, iEA_NOP,        iEA_NOP, iE4_CPX, iE5_SBC_binary, iE6_INC, iEA_NOP,
  iE8_INX, iE9_SBC_binary, iEA_NOP,        iEA_NOP, iEC_CPX, iED_SBC_binary, iEE_INC, iEA_NOP,
  iF0_BEQ, iF1_SBC_binary, iF2_SBC_binary, iEA_NOP, iEA_NOP, iF5_SBC_binary, iF6_INC, iEA_NOP,
  iF8_SED, iF9_SBC_binary, iFA_PLX,        iEA_NOP, iEA_NOP, iFD_SBC_binary, iFE_INC, iEA_NOP
};

ifunc decimal_instruction_table [256] =
{
  i00_BRK, i01_ORA,         iEA_NOP,         iEA_NOP, i04_TSB, i05_ORA,         i06_ASL, iEA_NOP,
  i08_PHP, i09_ORA,         i0A_ASL,         iEA_NOP, i0C_TSB, i0D_ORA,         i0E_ASL, iEA_NOP,
  i10_BPL, i11_ORA,         i12_ORA,         iEA_NOP, i14_TRB, i15_ORA,         i16_ASL, iEA_NOP,
  i18_CLC, i19_ORA,         i1A_INC,         iEA_NOP, i1C_TRB, i1D_ORA,         i1E_ASL, iEA_NOP,
  i20_JSR, i21_AND,         iEA_NOP,         iEA_NOP, i24_BIT, i25_AND,         i26_ROL, iEA_NOP,
  i28_PLP, i29_AND,         i2A_ROL,         iEA_NOP, i2C_BIT, i2D_AND,         i2E_ROL, iEA_NOP,
  i30_BMI, i31_AND,         i32_AND,         iEA_NOP, i34_BIT, i35_AND,         i36_ROL, iEA_NOP,
  i38_SEC, i39_AND,         i3A_DEC,         iEA_NOP, i3C_BIT, i3D_AND,         i3E_ROL, iEA_NOP,
  i40_RTI, i41_EOR,         iEA_NOP,         iEA_NOP, iEA_NOP, i45_EOR,         i46_LSR, iEA_NOP,
  i48_PHA, i49_EOR,         i4A_LSR,         iEA_NOP, i4C_JMP, i4D_EOR,         i4E_LSR, iEA_NOP,
  i50_BVC, i51_EOR,         i52_EOR,         iEA_NOP, iEA_NOP, i55_EOR,         i56_LSR, iEA_NOP,
  i58_CLI, i59_EOR,         i5A_PHY,         iEA_NOP, iEA_NOP, i5D_EOR,         i5E_LSR, iEA_NOP,
  i60_RTS, i61_ADC_decimal, iEA_NOP,         iEA_NOP, i64_STZ, i65_ADC_decimal, i66_ROR, iEA_NOP,
  i68_PLA, i69_ADC_decimal, i6A_ROR,         iEA_NOP, i6C_JMP, i6D_ADC_decimal, i6E_ROR, iEA_NOP,
  i70_BVS, i71_ADC_decimal, i72_ADC_decimal, iEA_NOP, i74_STZ, i75_ADC_decimal, i76_ROR, iEA_NOP,
  i78_SEI, i79_ADC_decimal, i7A_PLY,         iEA_NOP, i7C_JMP, i7D_ADC_decimal, i7E_ROR, iEA_NOP,
  i80_BRA, i81_STA,         iEA_NOP,         iEA_NOP, i84_STY, i85_STA,         i86_STX, iEA_NOP,
  i88_DEY, i89_BIT,         i8A_TXA,         iEA_NOP, i8C_STY, i8D_STA,         i8E_STX, iEA_NOP,
  i90_BCC, i91_STA,         i92_STA,         iEA_NOP, i94_STY, i95_STA,         i96_STX, iEA_NOP,
  i98_TYA, i99_STA,         i9A_TXS,         iEA_NOP, i9C_STZ, i9D_STA,         i9E_STZ, iEA_NOP,
  iA0_LDY, iA1_LDA,         iA2_LDX,         iEA_NOP, iA4_LDY, iA5_LDA,         iA6_LDX, iEA_NOP,
  iA8_TAY, iA9_LDA,         iAA_TAX,         iEA_NOP, iAC_LDY, iAD_LDA,         iAE_LDX, iEA_NOP,
  iB0_BCS, iB1_LDA,         iB2_LDA,         iEA_NOP, iB4_LDY, iB5_LDA,         iB6_LDX, iEA_NOP,
  iB8_CLV, iB9_LDA,         iBA_TSX,         iEA_NOP, iBC_LDY, iBD_LDA,         iBE_LDX, iEA_NOP,
  iC0_CPY, iC1_CMP,         iEA_NOP,         iEA_NOP, iC4_CPY, iC5_CMP,         iC6_DEC, iEA_NOP,
  iC8_INY, iC9_CMP,         iCA_DEX,         iEA_NOP, iCC_CPY, iCD_CMP,         iCE_DEC, iEA_NOP,
  iD0_BNE, iD1_CMP,         iD2_CMP,         iEA_NOP, iEA_NOP, iD5_CMP,         iD6_DEC, iEA_NOP,
  iD8_CLD, iD9_CMP,         iDA_PHX,         iEA_NOP, iEA_NOP, iDD_CMP,         iDE_DEC, iEA_NOP,
  iE0_CPX, iE1_SBC_decimal, iEA_NOP,         iEA_NOP, iE4_CPX, iE5_SBC_decimal, iE6_INC, iEA_NOP,
  iE8_INX, iE9_SBC_decimal, iEA_NOP,         iEA_NOP, iEC_CPX, iED_SBC_decimal, iEE_INC, iEA_NOP,
  iF0_BEQ, iF1_SBC_decimal, iF2_SBC_decimal, iEA_NOP, iEA_NOP, iF5_SBC_decimal, iF6_INC, iEA_NOP,
  iF8_SED, iF9_SBC_decimal, iFA_PLX,         iEA_NOP, iEA_NOP, iFD_SBC_decimal, iFE_INC, iEA_NOP
};

ifunc * instruction_table = binary_instruction_table;

/* instruction cycle times */

char instruction_cycles [256] =
{
  7, 6, 0, 0, 5, 3, 5, 0, 3, 2, 2, 0, 6, 4, 6, 0,
  2, 5, 5, 0, 5, 4, 6, 0, 2, 4, 2, 0, 6, 4, 6, 0,
  6, 6, 0, 0, 3, 3, 5, 0, 4, 2, 2, 0, 4, 4, 6, 0,
  2, 5, 5, 0, 4, 4, 6, 0, 2, 4, 2, 0, 4, 4, 6, 0,

  6, 6, 0, 0, 0, 3, 5, 0, 3, 2, 2, 0, 3, 4, 6, 0,
  2, 5, 5, 0, 0, 4, 6, 0, 2, 4, 3, 0, 0, 4, 6, 0,
  6, 6, 0, 0, 3, 3, 5, 0, 4, 2, 2, 0, 6, 4, 6, 0,
  2, 5, 5, 0, 4, 4, 6, 0, 2, 4, 4, 0, 6, 4, 6, 0,

  2, 6, 0, 0, 3, 3, 3, 0, 2, 2, 2, 0, 4, 4, 4, 0,
  2, 6, 5, 0, 4, 4, 4, 0, 2, 5, 2, 0, 4, 5, 5, 0,
  2, 6, 2, 0, 3, 3, 3, 0, 2, 2, 2, 0, 4, 4, 4, 0,
  2, 5, 5, 0, 4, 4, 4, 0, 2, 4, 2, 0, 4, 4, 4, 0,

  2, 6, 0, 0, 3, 3, 5, 0, 2, 2, 2, 0, 4, 4, 6, 0,
  2, 5, 5, 0, 0, 4, 6, 0, 2, 4, 3, 0, 0, 4, 6, 0,
  2, 6, 0, 0, 3, 3, 5, 0, 2, 2, 2, 0, 4, 4, 6, 0,
  2, 5, 5, 0, 0, 4, 6, 0, 2, 4, 4, 0, 0, 4, 6, 0
};

/* debugger disassembler tables */

char instruction_size [256] =
{
  2, 2, 0, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
  2, 2, 2, 0, 2, 2, 2, 0, 1, 3, 1, 0, 3, 3, 3, 0,
  3, 2, 0, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
  2, 2, 2, 0, 2, 2, 2, 0, 1, 3, 1, 0, 3, 3, 3, 0,

  1, 2, 0, 0, 0, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
  2, 2, 2, 0, 0, 2, 2, 0, 1, 3, 1, 0, 0, 3, 3, 0,
  1, 2, 0, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
  2, 2, 2, 0, 2, 2, 2, 0, 1, 3, 1, 0, 3, 3, 3, 0,

  2, 2, 0, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
  2, 2, 2, 0, 2, 2, 2, 0, 1, 3, 1, 0, 3, 3, 3, 0,
  2, 2, 2, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
  2, 2, 2, 0, 2, 2, 2, 0, 1, 3, 1, 0, 3, 3, 3, 0,

  2, 2, 0, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
  2, 2, 2, 0, 0, 2, 2, 0, 1, 3, 1, 0, 0, 3, 3, 0,
  2, 2, 0, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
  2, 2, 2, 0, 0, 2, 2, 0, 1, 3, 1, 0, 0, 3, 3, 0
};

char instruction_is_branch [256] =
{
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

char instruction_is_immediate [256] =
{
  0, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
  0, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

  0, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
  0, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

  0, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
  1, 0, 1, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

  1, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
  1, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
};

const char * standard_instruction_strings [256] =
{
  /* 0 */
  "brk  #$%2.2x",
  "ora  ($%2.2x,X)",
  "",
  "",
  "tsb  $%2.2x",
  "ora  $%2.2x",
  "asl  $%2.2x",
  "",
  "php",
  "ora  #$%2.2x",
  "asl  A",
  "",
  "tsb  $%4.4x",
  "ora  $%4.4x",
  "asl  $%4.4x",
  "",

  /* 1 */
  "bpl  $%4.4x   (%+d)",
  "ora  ($%2.2x),Y",
  "ora  ($%2.2x)",
  "",
  "trb  $%2.2x",
  "ora  $%2.2x,X",
  "asl  $%2.2x,X",
  "",
  "clc",
  "ora  $%4.4x,Y",
  "inc  A",
  "",
  "trb  $%4.4x",
  "trb  $%4.4x,X",
  "trb  $%4.4x,X",
  "",

  /* 2 */
  "jsr  $%4.4x",
  "and  ($%2.2x,X)",
  "",
  "",
  "bit  $%2.2x",
  "and  $%2.2x",
  "rol  $%2.2x",
  "",
  "plp",
  "and  #$%2.2x",
  "rol  A",
  "",
  "bit  $%4.4x",
  "and  $%4.4x",
  "rol  $%4.4x",
  "",

  /* 3 */
  "bmi  $%4.4x   (%+d)",
  "and  ($%2.2x),Y",
  "and  ($%2.2x)",
  "",
  "bit  $%2.2x,X",
  "and  $%2.2x,X",
  "rol  $%2.2x,X",
  "",
  "sec",
  "and  $%4.4x,Y",
  "dec  A",
  "",
  "bit  $%4.4x,X",
  "and  $%4.4x,X",
  "rol  $%4.4x,X",
  "",

  /* 4 */
  "rti",
  "eor  ($%2.2x,X)",
  "",
  "",
  "",
  "eor  $%2.2x",
  "lsr  $%2.2x",
  "",
  "pha",
  "eor  #$%2.2x",
  "lsr  A",
  "",
  "jmp  $%4.4x",
  "eor  $%4.4x",
  "lsr  $%4.4x",
  "",

  /* 5 */
  "bvc  $%4.4x   (%+d)",
  "eor  ($%2.2x),Y",
  "eor  ($%2.2x)",
  "",
  "",
  "eor  $%2.2x,X",
  "lsr  $%2.2x,X",
  "",
  "cli",
  "eor  $%4.4x,Y",
  "phy",
  "",
  "",
  "eor  $%4.4x,X",
  "lsr  $%4.4x,X",
  "",

  /* 6 */
  "rts",
  "adc  ($%2.2x,X)",
  "",
  "",
  "stz  $%2.2x",
  "adc  $%2.2x",
  "ror  $%2.2x",
  "",
  "pla",
  "adc  #$%2.2x",
  "ror  A",
  "",
  "jmp  ($%4.4x)",
  "adc  $%4.4x",
  "ror  $%4.4x",
  "",

  /* 7 */
  "bvs  $%4.4x   (%+d)",
  "adc  ($%2.2x),Y",
  "adc  ($%2.2x)",
  "",
  "stz  $%2.2x,X",
  "adc  $%2.2x,X",
  "ror  $%2.2x,X",
  "",
  "sei",
  "adc  $%4.4x,Y",
  "ply",
  "",
  "jmp  ($%4.4x,X)",
  "adc  $%4.4x,X",
  "ror  $%4.4x,X",
  "",

  /* 8 */
  "bra  $%4.4x   (%+d)",
  "sta  ($%2.2x,X)",
  "",
  "",
  "sty  $%2.2x",
  "sta  $%2.2x",
  "stx  $%2.2x",
  "",
  "dey",
  "bit  #$%2.2x",
  "txa",
  "",
  "sty  $%4.4x",
  "sta  $%4.4x",
  "stx  $%4.4x",
  "",

  /* 9 */
  "bcc  $%4.4x   (%+d)",
  "sta  ($%2.2x),Y",
  "sta  ($%2.2x)",
  "",
  "sty  $%2.2x,X",
  "sta  $%2.2x,X",
  "stx  $%2.2x,Y",
  "",
  "tya",
  "sta  $%4.4x,Y",
  "txs",
  "",
  "stz  $%4.4x",
  "sta  $%4.4x,X",
  "stz  $%4.4x,X",
  "",

  /* A */
  "ldy  #$%2.2x",
  "lda  ($%2.2x,X)",
  "ldx  #$%2.2x",
  "",
  "ldy  $%2.2x",
  "lda  $%2.2x",
  "ldx  $%2.2x",
  "",
  "tay",
  "lda  #$%2.2x",
  "tax",
  "",
  "ldy  $%4.4x",
  "lda  $%4.4x",
  "ldx  $%4.4x",
  "",

  /* B */
  "bcs  $%4.4x   (%+d)",
  "lda  ($%2.2x),Y",
  "lda  ($%2.2x)",
  "",
  "ldy  $%2.2x,X",
  "lda  $%2.2x,X",
  "ldx  $%2.2x,Y",
  "",
  "clv",
  "lda  $%4.4x,Y",
  "tsx",
  "",
  "ldy  $%4.4x,X",
  "lda  $%4.4x,X",
  "ldx  $%4.4x,Y",
  "",

  /* C */
  "cpy  #$%2.2x",
  "cmp  ($%2.2x,X)",
  "",
  "",
  "cpy  $%2.2x",
  "cmp  $%2.2x",
  "dec  $%2.2x",
  "",
  "iny",
  "cmp  #$%2.2x",
  "dex",
  "",
  "cpy  $%4.4x",
  "cmp  $%4.4x",
  "dec  $%4.4x",
  "",

  /* D */
  "bne  $%4.4x   (%+d)",
  "cmp  ($%2.2x),Y",
  "cmp  ($%2.2x)",
  "",
  "",
  "cmp  $%2.2x,X",
  "dec  $%2.2x,X",
  "",
  "cld",
  "cmp  $%4.4x,Y",
  "phx",
  "",
  "",
  "cmp  $%4.4x,X",
  "dec  $%4.4x,X",
  "",

  /* E */
  "cpx  #$%2.2x",
  "sbc  ($%2.2x,X)",
  "",
  "",
  "cpx  $%2.2x",
  "sbc  $%2.2x",
  "inc  $%2.2x",
  "",
  "inx",
  "sbc  #$%2.2x",
  "nop",
  "",
  "cpx  $%4.4x",
  "sbc  $%4.4x",
  "inc  $%4.4x",
  "",

  /* F */
  "beq  $%4.4x   (%+d)",
  "sbc  ($%2.2x),Y",
  "sbc  ($%2.2x)",
  "",
  "",
  "sbc  $%2.2x,X",
  "inc  $%2.2x,X",
  "",
  "sed",
  "sbc  $%4.4x,Y",
  "plx",
  "",
  "",
  "sbc  $%4.4x,X",
  "inc  $%4.4x,X",
  ""
};

const char * orthogonal_instruction_strings [256] =
{
  /* 0 */
  "brk",
  "or   ($%2.2x+X)",
  "",
  "",
  "tsb  $%2.2x",
  "or   $%2.2x",
  "shl  $%2.2x",
  "",
  "psh  P",
  "or   #$%2.2x",
  "shl  A",
  "",
  "tsb  $%4.4x",
  "or   $%4.4x",
  "shl  $%4.4x",
  "",

  /* 1 */
  "bnc  $%+d",
  "or   ($%2.2x)+Y",
  "or   ($%2.2x)",
  "",
  "trb  $%2.2x",
  "or   $%2.2x+X",
  "shl  $%2.2x+X",
  "",
  "clr  C",
  "or   $%4.4x+Y",
  "inc  A",
  "",
  "trb  $%4.4x",
  "or   $%4.4x+X",
  "shl  $%4.4x+X",
  "",

  /* 2 */
  "jsr  $%4.4x",
  "and  ($%2.2x+X)",
  "",
  "",
  "bit  $%2.2x",
  "and  $%2.2x",
  "rol  $%2.2x",
  "",
  "pul  P",
  "and  #$%2.2x",
  "rol  A",
  "",
  "bit  $%4.4x",
  "and  $%4.4x",
  "rol  $%4.4x",
  "",

  /* 3 */
  "bns  %+d",
  "and  ($%2.2x)+Y",
  "and  ($%2.2x)",
  "",
  "bit  $%2.2x+X",
  "and  $%2.2x+X",
  "rol  $%2.2x+X",
  "",
  "set  C",
  "and  $%4.4x+Y",
  "dec  A",
  "",
  "bit  $%4.4x+X",
  "and  $%4.4x+X",
  "rol  $%4.4x+X",
  "",

  /* 4 */
  "rti",
  "xor  ($%2.2x+X)",
  "",
  "",
  "",
  "xor  $%2.2x",
  "shr  $%2.2x",
  "",
  "psh  A",
  "xor  #$%2.2x",
  "shr  A",
  "",
  "jmp  $%4.4x",
  "xor  $%4.4x",
  "shr  $%4.4x",
  "",

  /* 5 */
  "bvc  %+d",
  "xor  ($%2.2x)+Y",
  "xor  ($%2.2x)",
  "",
  "",
  "xor  $%2.2x+X",
  "shr  $%2.2x+X",
  "",
  "clr  I",
  "xor  $%4.4x+Y",
  "psh  Y",
  "",
  "",
  "xor  $%4.4x+X",
  "shr  $%4.4x+X",
  "",

  /* 6 */
  "rts",
  "adc  ($%2.2x+X)",
  "",
  "",
  "mov  #0,$%2.2x",
  "adc  $%2.2x",
  "ror  $%2.2x",
  "",
  "pul  A",
  "adc  #$%2.2x",
  "ror  A",
  "",
  "jmp  ($%4.4x)",
  "adc  $%4.4x",
  "ror  $%4.4x",
  "",

  /* 7 */
  "bvs  %+d",
  "adc  ($%2.2x)+Y",
  "adc  ($%2.2x)",
  "",
  "mov  #0,$%2.2x+X",
  "adc  $%2.2x+X",
  "ror  $%2.2x+X",
  "",
  "set  I",
  "adc  $%4.4x+Y",
  "pul  Y",
  "",
  "jmp  ($%4.4x+X)",
  "adc  $%4.4x+X",
  "ror  $%4.4x+X",
  "",

  /* 8 */
  "bra  %+d",
  "mov  A,($%2.2x+X)",
  "",
  "",
  "mov  Y,$%2.2x",
  "mov  A,$%2.2x",
  "mov  X,$%2.2x",
  "",
  "dec  Y",
  "bit  #$%2.2x",
  "mov  X,A",
  "",
  "mov  Y,$%4.4x",
  "mov  A,$%4.4x",
  "mov  X,$%4.4x",
  "",

  /* 9 */
  "bcc  %+d",
  "mov  A,($%2.2x)+Y",
  "mov  A,($%2.2x)",
  "",
  "mov  Y,$%2.2x+X",
  "mov  A,$%2.2x+X",
  "mov  X,$%2.2x+Y",
  "",
  "mov  Y,A",
  "mov  A,$%4.4x+X",
  "mov  X,S",
  "",
  "mov  #0,$%4.4x",
  "mov  A,$%4.4x+X",
  "mov  #0,$%4.4x+X",
  "",

  /* A */
  "mov  #$%2.2x,Y",
  "mov  ($%2.2x+X),A",
  "mov  #$%2.2x,X",
  "",
  "mov  $%2.2x,Y",
  "mov  $%2.2x,A",
  "mov  $%2.2x,X",
  "",
  "mov  A,Y",
  "mov  #$%2.2x,A",
  "mov  A,X",
  "",
  "mov  $%4.4x,Y",
  "mov  $%4.4x,A",
  "mov  $%4.4x,X",
  "",

  /* B */
  "bcs  %+d",
  "mov  ($%2.2x)+Y,A",
  "mov  ($%2.2x),A",
  "",
  "mov  $%2.2x+X,Y",
  "mov  $%2.2x+X,A",
  "mov  $%2.2x+Y,X",
  "",
  "clr  V",
  "mov  $%4.4x+Y,A",
  "mov  S,X",
  "",
  "mov  $%4.4x+X,Y",
  "mov  $%4.4x+X,A",
  "mov  $%4.4x+Y,X",
  "",

  /* C */
  "cmp  Y,#$%2.2x",
  "cmp  A,($%2.2x+X)",
  "",
  "",
  "cmp  Y,$%2.2x",
  "cmp  A,$%2.2x",
  "dec  $%2.2x",
  "",
  "inc  Y",
  "cmp  A,#$%2.2x",
  "dec  X",
  "",
  "cmp  Y,$%4.4x",
  "cmp  A,$%4.4x",
  "dec  $%4.4x",
  "",

  /* D */
  "bzc  %+d",
  "cmp  A,($%2.2x)+Y",
  "cmp  A,($%2.2x)",
  "",
  "",
  "cmp  A,$%2.2x+X",
  "dec  $%2.2x+X",
  "",
  "clr  D",
  "cmp  A,$%4.4x+Y",
  "psh  X",
  "",
  "",
  "cmp  A,$%4.4x+X",
  "dec  $%4.4x+X",
  "",

  /* E */
  "cmp  X,#$%2.2x",
  "sbc  ($%2.2x+X)",
  "",
  "",
  "cmp  X,$%2.2x",
  "sbc  $%2.2x",
  "inc  $%2.2x",
  "",
  "inc  X",
  "sbc  #$%2.2x",
  "nop",
  "",
  "cmp  X,$%4.4x",
  "sbc  $%4.4x",
  "inc  $%4.4x",
  "",

  /* F */
  "beq  %+d",
  "sbc  ($%2.2x)+Y",
  "sbc  ($%2.2x)",
  "",
  "",
  "sbc  $%2.2x+X",
  "inc  $%2.2x+X",
  "",
  "set  D",
  "sbc  $%4.4x+Y",
  "pul  X",
  "",
  "",
  "sbc  $%4.4x+X",
  "inc  $%4.4x+X",
  ""
};

const char ** instruction_strings = standard_instruction_strings;

