/* bhead.c (C) Copyright 2008 Bill Buckels */

/* Written in Aztec C */

/* CP/M 80 program to remove the first 4 bytes
   of a DOS 3.3 Binary File transferred to
   Apple CP/M using the APDOS utility */

/* You have a royalty free right to use
   this program for any purpose whatsoever
   provided you agree that Bill Buckels
   has no liability whatsoever from its use. */

#include <fcntl.h>

#define BUFLEN 256

char infile[80], outfile[80], buf[BUFLEN];
int fi, fo, len, olen, cmdline;


main(argc, argv)
int argc;
char **argv;
{

	printf("BHEAD (C) Bill Buckels 2008\n");
	printf("Usage is: \"BHEAD infile outfile\"\n");
	printf("---------------------------\n");

    if (argc > 2) {
	  	cmdline = 1;
	  	strcpy(infile,argv[1]);
	  	strcpy(outfile,argv[2]);
	}
	else {
     	cmdline = 0;
     	printf("Infile  ? ");

    	/* let them bail if they enter a blank line */
		gets(infile);
		if (infile[0] == 0)exit(0);
		printf("Outfile ? ");
		gets(outfile);
		if (outfile[0] == 0)exit(0);
	}

    /* force them to bail if any problems
       opening the input or the output file */
	fi = open(infile,  O_RDONLY, 0);
	if (fi == -1) {
	   printf("Can't open %s...",infile);
	   onexit(1);
	}
	fo = open(outfile, O_WRONLY|O_TRUNC|O_CREAT, 0);
	if (fo == -1) {
	   printf("Can't open %s...",outfile);
	   close(fi);
	   onexit(2);
	}

	/* not bothering to see if the input file
	   is shorter than 4 bytes... what does it
	   matter anyway? */
	read(fi,buf,4);

	/* read the file in chunks to speed-up
	   disk access */
	for (;;) {
		len = read(fi,buf,BUFLEN);
		if (len < 1)break;
		/* put a dot on the screen
		   every write */
		putchar('.');
		olen = write(fo,buf,len);
		if (olen != len) {
		   /* not bothering to clean-up */
		   printf("\nDisk Full!");
		   break;
		}
		if (len < BUFLEN) break;
	}
	close(fi);
	close(fo);
	printf("\nDone!");
	onexit(0);
}

onexit(xcode)
int xcode;
{
	if (cmdline == 0)getchar();
	putchar('\n');
	exit(xcode);
}
