
(*    Get Apple disk image up serial cable in                      *)
(*    7-Track increments, store in .DSK image file when done.      *)

(*  It's sloppy, poorly commented, and probably ambiguous          *)
(*  but a few hours and a lot of beer later it's done and          *)
(*  it works!    Look for a cleaner and better program later       *)
(*  FYI: I borrowed parts of the serial driver off a public-domain *)
(*  upload in the Pascal section of wuarchive                      *)

(*   good luck   - glitch@eskimo.com                               *)

program GetDisk;
uses
   dos,crt;

const
     RBR = $3F8;                {Port address - RX Buffer Register}
     THR = $3F8;                {Transmit Hold Register}
     DLL = $3F8;                {Low byte of divisor}
     DLM = $3F9;                {High Byte of Divisor}
     IER = $3F9;                {Overlays INT Enable Register}
     LCR = $3FB;                {Line Control Register}
     MCR = $3FC;                {Modem Control Register}
     LSR = $3FD;                {Line Status Register}

     BAUD300   = 384;            {300 Baud Divisor}
     BAUD1200  =  96;           {1200 Baud Divisor}
     BAUD2400  =  48;           {2400 Baud Divisor}
     BAUD4800  =  24;           {4800 Baud Divisor}
     BAUD9600  =  12;           {9600 Baud Divisor}
     BAUD19200 =   6;          {19200 Baud Divisor}
     RTS       = $02;           {Mask for ReadyToSend}
     ERBFI     = $01;           {Mask to enable Receive INT's}
     THRE      = $20;           {Mask for THRE}
     TWOSTOP   = $04;           {Mask for 2 stop bits (110 baud only)}
     ONESTOP   = $00;           {Mask for 1 stop bit}
     DTR       = $01;           {Mask for DTR}
     DLAB      = $80;           {Mask for DLAB}
     NOPARITY  = $00;           {Mask for no parity}
     EIGHTBITS = $03;           {Mask for 8 bits/char}

     OCW1      = $21;           {Mask for enable bits for 8259}
     OCW2      = $20;           {Port for 8259 Commands}
     NSEOI     = $20;           {Non-specific End-Of-Interrupt Command}
     OUT2      = $08;           {Mask for OUT2}
     IRQ4      = $10;           {Mask to dis/enable hardware int level 4}
     PORT1INT  = 12;            {Int vector number for IRQ4}

     QUEUEMAX  = 255;           {Max queue subscript, 2^n-1}

var
   hour,minute,second,sec100 : word;
   time : string[40];
   ho,mi,se : string[10];
   timeout : real;
   inf : string[1];
   header : byte;
   baud : array[1..2,1..6] of integer;
   buffer : array[1..28672] of byte;
   bfd, queueIn, queueOut, bytesread, byteswritten : integer;
   chunk,px : longint;
   outfilename : string[15];
   outfile : file;
   x,y,z,baudrate,temp,loop : integer;
   chunkstr : string[5];
   queue : array [0..QUEUEMAX] of byte;  {Circular buffer}
   oldVector : pointer;                  {Storage for old INT vector}
   ch : char;                            {Keyboard Char}

function UpCaseStr(S : String) : String;
var P : Integer;
begin
for P := 1 to length(s) do
S[P] := Upcase(S[P]);
UpCaseStr := S;
end;

procedure initoutfile;  {make a 143360 empty outfile to write our disk to}
begin
for x := 1 to 28672 do
buffer[x] := 0;
assign(outfile,outfilename);
rewrite(outfile,1);
for x := 1 to 5 do
blockwrite(outfile,buffer,28672,byteswritten);
close(outfile);
end;

procedure stamp;  {grab system time to benchmark our transfer}
begin
gettime(hour,minute,second,sec100);
str(hour,ho);
str(minute,mi);
str(second,se);
time :=ho+':'+mi+':'+se;
end;

procedure InterruptsOn; inline($FB); {Turn on interrupts}

{$IFOPT R+}              {Don't forget to turn Range Checking on...}
{$DEFINE RANGE}
{$ENDIF}

{$R-}

procedure Port1ISR; Interrupt; {INT Service Routine for port 1}
begin
     InterruptsOn;
     queueIn := Succ(queueIn) and QUEUEMAX;
     if queueIn = queueOut then                {Queue full, put pointer back}
	queueIn := Pred(queueIn) and QUEUEMAX;
     queue[queueIn] := Port[RBR];
     Port[OCW2] := NSEOI
end;

{$IFDEF RANGE}
{$R+}
{$ENDIF}

{$F+}

Procedure RestoreIntVec;  {Exit proc to restore int vector}
begin                     {shutoff ints and drop dtr}
     Port[IER] := 0;                    {INTs off at UART}
     Port[OCW1] := Port[OCW1] or IRQ4;  {INTs off at 8259}
     Port[MCR] := 0;                    {DTR, RTS, OUT2 off}
     SetIntVec(PORT1INT,oldVector)
end;

{$F-}


procedure writeit;     {write the 7-track chunk to our blank outfile}
 begin
 gotoxy(9,10);
 writeln('Writing 7 tracks                                     ');
 assign(outfile,outfilename);
 px := (5-chunk)* 28672;
 reset(outfile,1);
 seek(outfile,px);
 gotoxy(20,20);
 blockwrite(outfile,buffer,28672,byteswritten);
    if byteswritten <> 28672 then
       begin
       gotoxy(9,10);
       writeln('Disk write error! ',byteswritten,'/28672 bytes written');
       {$i-} close(outfile);
       erase(outfile); {$i+}
       halt(1)
       end;
close(outfile);
end;


(* main *)

begin
     Baud[1,1] := 300;    (* Valid Baud Rates *)
     Baud[1,2] := 1200;
     Baud[1,3] := 2400;
     Baud[1,4] := 4800;
     Baud[1,5] := 9600;
     Baud[1,6] := 19200;
     Baud[2,1] := 384;   {300 Baud Divisor}
     Baud[2,2] := 96;   {1200 Baud Divisor}
     Baud[2,3] := 48;   {2400 Baud Divisor}
     Baud[2,4] := 24;   {4800 Baud Divisor}
     Baud[2,5] := 12;   {9600 Baud Divisor}
     Baud[2,6] := 6;   {19200 Baud Divisor}
     x := 1;
     clrscr;
     writeln('Apple serial disk image downloader         By The Glitch');
     writeln;
     write('Output file name: ');
     readln(outfilename);
     outfilename := upcasestr(outfilename);
     writeln;
     initoutfile;
     repeat
      Bfd := 0;
      gotoxy(1,5);
      write('Baud Rate (300,1200,4800,9600,19200):');
      gotoxy(39,5);
      readln(BaudRate);
      for x:= 1 to 6 do
        if BaudRate = Baud[1,x] then bfd := x;
     until (bfd <> 0);


     clrscr;
     gotoxy(1,10);
     writeln('STATUS:');
     gotoxy(1,8);
     writeln('Downloading file: ',outfilename);
     CheckBreak := TRUE;
     DirectVideo := TRUE;
     queueIn := 0;
     queueOut := 0;
     Port[IER] := 0;                    {Disable UART INT's}

{Here's where we take over the comm interrupt}

     GetIntVec(PORT1INT,oldVector);
     exitProc := Addr(RestoreIntVec);
     SetIntVec(PORT1INT,Addr(Port1ISR));

{Initialize the UART}

     Port[LCR] := Port[LCR] or DLAB;    {Allow access to Divisor}
     Port[DLL] := Lo(Baud[2,bfd]);         {Baud Rate to whatever input}
     Port[DLM] := Hi(Baud[2,bfd]);         {Ditto...}
     Port[LCR] := EIGHTBITS or ONESTOP or NOPARITY; {8N1, of course!}
     Port[MCR] := DTR or RTS or OUT2;

{Turn on INTs at 8259}

     Port[OCW1] := Port[OCW1] and not (IRQ4);
     if Port[LSR] <> 0 then;          {Clear any errors}
     if Port[RBR] <> 0 then;          {Clear trash from RX buffer}
     Port[IER] := ERBFI;              {Enable UART RX INTs}

   stamp;    {get starting time}
   gotoxy(1,12);
   writeln('Start time: ',time);

   for chunk := 1 to 5 do {loop for 5 chunks of 7 tracks each}
   begin
     gotoxy(9,10);
     writeln('Waiting for header - chunk ',chunk,'/5       ');
     header := 0;
     queue[temp] := $0;
	   repeat
	    while queueIN <> queueOUT do
	       begin
	       temp :=Succ(queueOut) and QUEUEMAX;
	       header := queue[temp];
	       queueOut := temp;
	       end;
	   until (header = $69);
     gotoxy(9,10);
     writeln('Receiving chunk ',chunk,'/5                ');
     gotoxy(40,10);
     writeln('           ');
     loop := 1;
     repeat
      while queueIN <> queueOut do  {wait on com port for incoming byte}
	   begin
		timeout := 0;
		TEMP := Succ(queueOut) and QUEUEMAX;
		buffer[loop] := queue[temp]; {store byte in buffer}
		loop := loop + 1;
		gotoxy(40,10);
		writeln(loop);
		queueOut := TEMP;
	   end;
       timeout := timeout + 1;
       (* Wait for idle period to time out or all bytes made it *)
      until ((timeout > 2147400000) or (loop=28673));

     if timeout > 500000 then
      begin
      gotoxy(9,10);
      writeln('Error!          ');
      gotoxy(1,15);
      writeln;
      writeln('Timeout error in chunk ',chunk,' of 5 - read ',loop,' of 28672 bytes');
      halt;
      end;

     writeit;  {write 7 tracks to output file}
   end; {for..chunk}

   gotoxy(9,10);
   writeln('Done!                ');

   stamp;         {get finishing time}
   gotoxy(1,13);
   writeln('  End Time: ',time);

   sound(1000);   {beep to indicate successful transfer}
   delay(20);
   nosound;

   gotoxy(1,18);  {toss the cursor down & exit }
 end.

