         lst   off

* UNIX coff utility
* data structure routines
*
* 1990-1992, tao Developer Project

         rel
         xc
         xc
         mx    %00

         put   coff.h     ;global defines
         put   x.data     ;external data definitions
         put   x.general  ;external general definitions
         put   x.gsos     ;external GS/OS i/o definitions
         put   x.output   ;external output definitions

         put   gsos.h     ;GS/OS defines
         put   memory.h   ;memory manager defines
         put   resource.h ;resouce manager defines
         put   texttool.h ;text tool defines

         use   coff.mac   ;macro definitions
         use   datatype.mac ;HLL data types


**************************************************
* add label name and expression evaluation to    *
* label stack.                                   *
* ---------------------------------------------- *
* (input)                                        *
*  long - handle to replacement label name.      *
*  long - handle to label expression.            *
*  word - label type.                            *
**************************************************
add_label ent
]type    =     $e0        ;type of label
]name_handle = $e2        ;handle to label name
]expr_handle = $e6        ;expression label evaluates to
]node_handle = $ea        ;label node
]node_ptr =    $ee
]label_last_handle = $f2  ;handle to first element in linked list
]label_last_ptr = $f6

         pla              ;return address
         plx
         stx   ]type
         plx
         ply
         stx   ]expr_handle
         sty   ]expr_handle+2
         plx
         ply
         stx   ]name_handle
         sty   ]name_handle+2
         pha              ;push return address back on stack

         pha              ;long - result
         pha
         pea   #0         ;long - block size
         pea   #18
         lda   userID     ;word - user ID of block
         pha
         pea   #attrNoSpec ;word - block attributes
         pha              ;long - start of block
         pha
         _NewHandle
         plx
         ply
         stx   ]node_handle
         sty   ]node_handle+2
         lda   []node_handle]
         sta   ]node_ptr
         ldy   #2
         lda   []node_handle],y
         sta   ]node_ptr+2

         lda   @label+`last
         ora   @label+`last+2
         bne   :0
         ldx   ]node_handle
         ldy   ]node_handle+2
         stx   @label+`next
         sty   @label+`next+2
         ldy   #`prev     ;make first previous node NULL
         lda   #NULL
         sta   []node_ptr],y
         ldy   #`prev+2
         sta   []node_ptr],y
         bra   :1

:0       ldx   @label+`last
         ldy   @label+`last+2
         stx   ]label_last_handle
         sty   ]label_last_handle+2
         lda   []label_last_handle]
         sta   ]label_last_ptr
         ldy   #2
         lda   []label_last_handle],y
         sta   ]label_last_ptr+2
         ldy   #`next     ;make next label after last current node
         lda   ]node_handle
         sta   []label_last_ptr],y
         ldy   #`next+2
         lda   ]node_handle+2
         sta   []label_last_ptr],y
         ldy   #`prev     ;make previous node last node
         lda   ]label_last_handle
         sta   []node_ptr],y
         ldy   #`prev+2
         lda   ]label_last_handle+2
         sta   []node_ptr],y

:1       ldy   #`label_name ;store label name
         lda   ]name_handle
         sta   []node_ptr],y
         ldy   #`label_name+2
         lda   ]name_handle+2
         sta   []node_ptr],y
         ldy   #`expr_name ;store expression evaluation string
         lda   ]expr_handle
         sta   []node_ptr],y
         ldy   #`expr_name+2
         lda   ]expr_handle+2
         sta   []node_ptr],y
         ldy   #`type     ;store label type
         lda   ]type
         sta   []node_ptr],y
         ldy   #`next     ;make next node NULL
         lda   #NULL
         sta   []node_ptr],y
         ldy   #`next+2
         sta   []node_ptr],y

         ldx   ]node_handle ;make new last node
         ldy   ]node_handle+2
         stx   @label+`last
         sty   @label+`last+2
         rts


**************************************************
* delete labels from label array.                *
* ---------------------------------------------- *
* (input)                                        *
*  a - delete LOCAL or GLOBAL labels.            *
**************************************************
delete_labels ent
]label_type =  $e0        ;type of label to delete
]label_handle = $e2       ;handle to current label
]label_ptr =   $e6
]prev_label_handle = $ea  ;handle to previous label
]prev_label_ptr = $ee

         sta   ]label_type

         ldx   #^@label   ;make first label previous label. first
         ldy   #@label    ;label structure is header node.
         stx   ]prev_label_ptr+2
         sty   ]prev_label_ptr

         stz   @label+`last ;re-initialize last node
         stz   @label+`last+2
         ldx   @label+`next
         ldy   @label+`next+2
         stx   ]label_handle
         sty   ]label_handle+2
         lda   []label_handle]
         sta   ]label_ptr
         ldy   #2
         lda   []label_handle],y
         sta   ]label_ptr+2
         lda   ]label_handle
         ora   ]label_handle+2
         bne   :delete_label
         rts

:delete_label ldy #`type
         lda   []label_ptr],y
         cmp   ]label_type
         bne   :0
         ldy   #`next
         lda   []label_ptr],y
         sta   []prev_label_ptr],y
         ldy   #`next+2
         lda   []label_ptr],y
         sta   []prev_label_ptr],y
         pei   ]label_handle+2
         pei   ]label_handle
         _DisposeHandle
         bra   :next_label

:0       ldx   ]label_handle
         ldy   ]label_handle+2
         stx   @label+`last
         sty   @label+`last+2
         stx   ]prev_label_handle
         sty   ]prev_label_handle+2
         lda   []prev_label_handle]
         sta   ]prev_label_ptr
         ldy   #2
         lda   []prev_label_handle],y
         sta   ]prev_label_ptr+2

:next_label ldy #`next    ;prepare to examine next label in
         lda   []label_ptr],y ;linked list
         sta   ]label_handle
         ldy   #`next+2
         lda   []label_ptr],y
         sta   ]label_handle+2
         lda   []label_handle]
         sta   ]label_ptr
         ldy   #2
         lda   []label_handle],y
         sta   ]label_ptr+2
         lda   ]label_handle ;end if at end of linked list
         ora   ]label_handle+2
         bne   :delete_label
         rts


**************************************************
* delete @expr_list stack.                       *
**************************************************
delete_expr_list ent
]list_lo_handle = $f0
]list_hi_handle = $f4
]list_lo_ptr = $f8
]list_hi_ptr = $fc

         ldx   @expr_list+`lo
         ldy   @expr_list+`lo+2
         stx   ]list_lo_handle
         sty   ]list_lo_handle+2
         ldx   @expr_list+`hi
         ldy   @expr_list+`hi+2
         stx   ]list_hi_handle
         sty   ]list_hi_handle+2
         lda   []list_lo_handle]
         sta   ]list_lo_ptr
         ldy   #2
         lda   []list_lo_handle],y
         sta   ]list_lo_ptr+2
         lda   []list_hi_handle],y
         sta   ]list_hi_ptr
         ldy   #2
         lda   []list_hi_handle],y
         sta   ]list_hi_ptr+2

         ldy   @expr_list+`size
:delete_list phy
         lda   []list_hi_ptr],y
         pha
         lda   []list_lo_ptr],y
         pha
         _DisposeHandle
         ply
         dey
         bne   :delete_list

         pei   ]list_lo_handle+2
         pei   ]list_lo_handle
         _DisposeHandle
         pei   ]list_hi_handle+2
         pei   ]list_hi_handle
         _DisposeHandle
         rts


**************************************************
* match operator value with its string           *
* representation.                                *
* ---------------------------------------------- *
* (input)                                        *
*  a - operator value.                           *
* (output)                                       *
*  x - HOW of string representing operator.      *
*  y - LOW of string representing operator.      *
**************************************************
find_operator ent

         ldx   #0         ;default is NULL string
         ldy   #0

         cmp   #ADD
         bne   :sub
         ldx   #^:add_str
         ldy   #:add_str
         rts
:sub     cmp   #SUB
         bne   :mul
         ldx   #^:sub_str
         ldy   #:sub_str
         rts
:mul     cmp   #MUL
         bne   :div
         ldx   #^:mul_str
         ldy   #:mul_str
         rts
:div     cmp   #DIV
         bne   :mod
         ldx   #^:div_str
         ldy   #:div_str
         rts
:mod     cmp   #MOD
         bne   :negation
         ldx   #^:mod_str
         ldy   #:mod_str
         rts
:negation cmp  #NEGATION
         bne   :bit_shift
         ldx   #^:negation_str
         ldy   #:negation_str
         rts
:bit_shift cmp #BIT_SHIFT
         bne   :and
         ldx   #^:bit_shift_str
         ldy   #:bit_shift_str
         rts
:and     cmp   #AND
         bne   :or
         ldx   #^:and_str
         ldy   #:and_str
         rts
:or      cmp   #OR
         bne   :eor
         ldx   #^:or_str
         ldy   #:or_str
         rts
:eor     cmp   #EOR
         bne   :not
         ldx   #^:eor_str
         ldy   #:eor_str
         rts
:not     cmp   #NOT
         bne   :less_equal
         ldx   #^:not_str
         ldy   #:not_str
         rts
:less_equal cmp #LESS_EQUAL
         bne   :greater_equal
         ldx   #^:less_equal_str
         ldy   #:less_equal_str
         rts
:greater_equal cmp #GREATER_EQUAL
         bne   :not_equal
         ldx   #^:greater_equal_str
         ldy   #:greater_equal_str
         rts
:not_equal cmp #NOT_EQUAL
         bne   :less
         ldx   #^:not_equal_str
         ldy   #:not_equal_str
         rts
:less    cmp   #LESS
         bne   :greater
         ldx   #^:less_str
         ldy   #:less_str
         rts
:greater cmp   #GREATER
         bne   :equal
         ldx   #^:greater_str
         ldy   #:greater_str
         rts
:equal   cmp   #EQUAL
         bne   :logical_and
         ldx   #^:equal_str
         ldy   #:equal_str
         rts
:logical_and cmp #LOGICAL_AND
         bne   :inclusive_or
         ldx   #^:logical_and_str
         ldy   #:logical_and_str
         rts
:inclusive_or cmp #INCLUSIVE_OR
         bne   :exclusive_or
         ldx   #^:inclusive_or_str
         ldy   #:inclusive_or_str
         rts
:exclusive_or cmp #EXCLUSIVE_OR
         bne   :complement
         ldx   #^:exclusive_or_str
         ldy   #:exclusive_or_str
         rts
:complement cmp #COMPLEMENT
         bne   :label_length
         ldx   #^:complement_str
         ldy   #:complement_str
         rts
:label_length cmp #LABEL_LENGTH
         bne   :end
         ldx   #^:label_length_str
         ldy   #:label_length_str
:end     rts

:add_str strl  '+'
:sub_str strl  '-'
:mul_str strl  '*'
:div_str strl  '/'
:mod_str strl  '%%'
:negation_str strl '~'
:bit_shift_str strl '|'
:and_str strl  '&&'
:or_str  strl  '||'
:eor_str strl  '.eor.'
:not_str strl  '!'
:less_equal_str strl '<='
:greater_equal_str strl '>='
:not_equal_str strl '<>'
:less_str strl '<'
:greater_str strl '>'
:equal_str strl '='
:logical_and_str strl '&'
:inclusive_or_str strl '.ior.'
:exclusive_or_str strl '.beor.'
:complement_str strl '.bnot.'
:label_length_str strl 'length ('


**************************************************
* match label name with expression name.         *
* ---------------------------------------------- *
* (input)                                        *
*  x - LOW of expression name.                   *
*  y - HOW of expression name.                   *
* (output)                                       *
*  x - HOW of label name (NULL if not found).    *
*  y - LOW of label name (NULL if not found).    *
**************************************************
match_label ent
]expr_ptr =    $f0        ;expression name string
]label_handle = $f4       ;linked list of labels
]label_ptr =   $f8
]expr_name_handle = $fc   ;expression evaluation
]expr_name_ptr = $fc
]label_name_handle = $fc  ;label name

         stx   ]expr_ptr
         sty   ]expr_ptr+2

         lda   @label+`next ;fail if no labels in list
         ora   @label+`next+2
         beq   :fail
         ldx   @label+`next
         ldy   @label+`next+2
         stx   ]label_handle
         sty   ]label_handle+2
:loop    lda   []expr_ptr]
         sta   :expr_len
         lda   []label_handle]
         sta   ]label_ptr
         ldy   #2
         lda   []label_handle],y
         sta   ]label_ptr+2
         ldy   #`expr_name
         lda   []label_ptr],y
         sta   ]expr_name_handle
         ldy   #`expr_name+2
         lda   []label_ptr],y
         sta   ]expr_name_handle+2
         ldy   #2
         lda   []expr_name_handle],y
         tay
         lda   []expr_name_handle]
         sta   ]expr_name_ptr
         sty   ]expr_name_ptr+2

         lda   []expr_name_ptr] ;no comparison if lengths different
         cmp   :expr_len
         bne   :end_loop

         ldy   #2         ;compare strings
         shorta
:0       lda   []expr_name_ptr],y
         cmp   []expr_ptr],y
         bne   :end_loop
         iny
         dec   :expr_len
         bne   :0
         longa

         ldy   #`label_name
         lda   []label_ptr],y
         sta   ]label_name_handle
         ldy   #`label_name+2
         lda   []label_ptr],y
         sta   ]label_name_handle+2
         lda   []label_name_handle]
         tax
         ldy   #2
         lda   []label_name_handle],y
         tay
         rts

:end_loop longa
         ldy   #`next
         lda   []label_ptr],y
         sta   ]label_handle
         ldy   #`next+2
         lda   []label_ptr],y
         sta   ]label_handle+2
         ora   ]label_handle
         bne   :loop

:fail    ldx   #NULL
         ldy   #NULL
         rts

:expr_len dw   0          ;length of expression string


**************************************************
* push value onto @expr_list stack.              *
* ---------------------------------------------- *
* (input)                                        *
*  a - expression value.                         *
*  x - LOW of expression label.                  *
*  y - HOW of expression label.                  *
**************************************************
push_expr_list ent
]list_lo_handle = $e0
]list_hi_handle = $e4
]list_lo_ptr = $e8
]list_hi_ptr = $ec
]expr_value =  $f0        ;expression value
]expr_handle = $f2        ;handle to expression name
]expr_ptr =    $f6

         sta   ]expr_value
         stx   ]expr_handle
         sty   ]expr_handle+2

         txa              ;alloc handle if operator is being
         ora   ]expr_handle+2 ;pushed on stack
         bne   :0

         pha              ;long - result
         pha
         pea   #0         ;long - block size
         pea   #2
         lda   userID     ;word - user ID of block
         pha
         pea   #attrNoCross ;word - block attributes
         pha              ;long - start of block
         pha
         _NewHandle
         plx
         ply
         stx   ]expr_handle
         sty   ]expr_handle+2

:0       lda   []expr_handle]
         sta   ]expr_ptr
         ldy   #2
         lda   []expr_handle],y
         sta   ]expr_ptr+2
         lda   ]expr_value
         sta   []expr_ptr]

         lda   @expr_list+`size
         inc
         asl
         pea   #0
         pha
         pea   #0
         pha
         ldx   @expr_list+`lo
         ldy   @expr_list+`lo+2
         phy
         phx
         _SetHandleSize
         ldx   @expr_list+`hi
         ldy   @expr_list+`hi+2
         phy
         phx
         _SetHandleSize

         ldx   @expr_list+`lo
         ldy   @expr_list+`lo+2
         stx   ]list_lo_handle
         sty   ]list_lo_handle+2
         ldx   @expr_list+`hi
         ldy   @expr_list+`hi+2
         stx   ]list_hi_handle
         sty   ]list_hi_handle+2
         lda   []list_lo_handle]
         sta   ]list_lo_ptr
         ldy   #2
         lda   []list_lo_handle],y
         sta   ]list_lo_ptr+2
         lda   []list_hi_handle]
         sta   ]list_hi_ptr
         ldy   #2
         lda   []list_hi_handle],y
         sta   ]list_hi_ptr+2

         lda   @expr_list+`size
         asl
         tay
         lda   ]expr_handle
         sta   []list_lo_ptr],y
         lda   ]expr_handle+2
         sta   []list_hi_ptr],y
         inc   @expr_list+`size
         rts


**************************************************
         sav   link/structure.l
