/*
		MazezaM

	Apple II Text verion.

	Copyright (C) 2002-2008

	Compile with:

>	cl65 -O2 MazezaM.c -o MAZE -t apple2


	Compress after removing the header first four bytes with:
>	c64pack MAZE MAZE.COMP /r
>	dasm AppleDepack.s -oMAZEZAMTEXT -f3 -v0


	This code may be used
	and distributed under
	the terms of the GNU
	General Public Licence.

*/


#include <stdio.h> // We use printf(); putchar();

#include <string.h> // strlen for the Level name centering.

#include <conio.h> // Console functions.

#define LEVELS 13 // Number of Levels
#define SCREENHEIGHT 21
#define SCREENWIDTH 40 // size of screen horizontal. At least 28!
#define TRUE 1
#define FALSE 0


unsigned int uLives,uWidth,uHeight, i, j, l, t, r, rx, lx, bCloseFlag=FALSE, Column;
		/* Global miscellaneous variables - i,j for loops and Player coordinates,
		t,r,rx,lx - for the Level build. */

char *MazeLine[12], // Text pointer to the Level (Max 12 lines)
	Mazezam[200], // Storage of the level.
	PressedKey;   // Which key is pressed.
static char *ARGH[]={	"ARGH!",
			"OUCH!",
			"GRRR!",
			"NOOU!",
			"NAAH!",
			"UUUF!",
			"AAAH!",
			"OUUF!",
			"PUFF!"
		};

void ClearScreen()
{
	clrscr();
}

void InverseOn()
{
	revers(TRUE);
}

void InverseOff()
{
	revers(FALSE);
}

void PrintEqual()
{
	InverseOn();
	cputc('=');
	InverseOff();
}

void PrintEnter()
{
	printf("\n");
}

void PrintSpace()
{
	cputc(' ');
}

void FillRow()
{
	for (Column=0;Column<SCREENWIDTH;Column++)
		PrintEqual();
	PrintEnter();
}

void FillWall()
{
	for (l=0;l<((SCREENWIDTH-28)/2);l++) PrintEqual();
}

void FillSpace()
{
	for (l=0;l<28;l++) PrintSpace();
}

void gotogxy(int x,int y)
{
	gotoxy(x,y);

}

void	Level(int MazeNumber)
{
	int k;
	char *LevelName; // Pointer to the Level name string.

	ClearScreen();
	switch (MazeNumber)
		{
		case 1:
			LevelName="Humble Origins";uWidth=7;uHeight=2;lx=rx=1;
			MazeLine[1]=" #  #  ";
			MazeLine[2]=" #  ## ";
			break;

		case 2:
			LevelName="Easy Does It";uWidth=8;uHeight=lx=3;rx=2;
			MazeLine[1]="  #  ###";
			MazeLine[2]="  # # # ";
			MazeLine[3]=" # # #  ";
			break;

		case 3:
			LevelName="Up,  Up and Away";uWidth=5;uHeight=lx=11;rx=1;
			MazeLine[1]= "  #  ";
			MazeLine[2]= " # ##";
			MazeLine[3]= " ##  ";
			MazeLine[4]= "# #  ";
			MazeLine[5]= " # # ";
			MazeLine[6]= " ### ";
			MazeLine[7]= "# #  ";
			MazeLine[8]= " # # ";
			MazeLine[9]= " # # ";
			MazeLine[10]="# ## ";
			MazeLine[11]=" #   ";
			break;

		case 4:
			LevelName="To and Fro";uWidth=13;uHeight=6;lx=rx=1;
			MazeLine[1]="   #####     ";
			MazeLine[2]="# #####  ### ";
			MazeLine[3]=" # ### ####  ";
			MazeLine[4]="# #  ####### ";
			MazeLine[5]=" ### #   ##  ";
			MazeLine[6]="# # # ##  #  ";
			break;


		case 5:
			LevelName="Loop-de-Loop";uWidth=14;uHeight=4;lx=2;rx=4;
			MazeLine[1]=" ##### ## ##  ";
			MazeLine[2]="   ##  ##  ## ";
			MazeLine[3]="##  # ## ###  ";
			MazeLine[4]="   ########  #";
			break;


		case 6:
			LevelName="Little  Harder";uWidth=5;uHeight=4;lx=2;rx=1;
			MazeLine[1]=" # # ";
			MazeLine[2]="  # #";
			MazeLine[3]=" #   ";
			MazeLine[4]=" ## #";
			break;
		case 7:
			LevelName="Somehow Easy";uWidth=5;uHeight=rx=3;lx=1;
			MazeLine[1]="  ## ";
			MazeLine[2]=" #   ";
			MazeLine[3]=" # ##";
			break;

		case 8:
			LevelName="Be  Prepared";uWidth=7;uHeight=6;lx=5;rx=3;
			MazeLine[1]="   #   ";
			MazeLine[2]=" ####  ";
			MazeLine[3]=" ### ##";
			MazeLine[4]=" # # # ";
			MazeLine[5]=" # ##  ";
			MazeLine[6]="# ##   ";
			break;

		case 9:
			LevelName="Two  Front Doors";uWidth=16;uHeight=rx=7;lx=1;
			MazeLine[1]="       #######  ";
			MazeLine[2]="  #### #### # # ";
			MazeLine[3]="## ## ###### # #";
			MazeLine[4]="##     # #      ";
			MazeLine[5]="  ############# ";
			MazeLine[6]=" # ##    # ###  ";
			MazeLine[7]="  #   ###     ##";
			break;

		case 10:
			LevelName="Through, through";uWidth=15;uHeight=4;lx=3;rx=1;
			MazeLine[1]=" ####  ####  ##";
			MazeLine[2]=" # ## ## # ##  ";
			MazeLine[3]=" # ## #### ##  ";
			MazeLine[4]=" # ##  ####  # ";
			break;

		case 11:
			LevelName="Double Cross";uWidth=9;uHeight=lx=7;rx=3;
			MazeLine[1]=" #  #### ";
			MazeLine[2]=" #  # ## ";
			MazeLine[3]=" # #### #";
			MazeLine[4]="# ##  #  ";
			MazeLine[5]="  #   ###";
			MazeLine[6]=" ######  ";
			MazeLine[7]="  #      ";
			break;

		case 12:
			LevelName="Inside Out";uWidth=14;uHeight=10;lx=8;rx=1;
			MazeLine[1]= "            # ";
			MazeLine[2]= " ##########  #";
			MazeLine[3]= " ###       ## ";
			MazeLine[4]= " # ######## # ";
			MazeLine[5]= " ### ###  ### ";
			MazeLine[6]= " ###   #  ### ";
			MazeLine[7]= " # ####### ## ";
			MazeLine[8]= " # # #    ### ";
			MazeLine[9]= " ############ ";
			MazeLine[10]="              ";
			break;

		case 13:
			LevelName="Hidden corridor ";uWidth=12;uHeight=10;lx=4;rx=1;
			MazeLine[1]= " ## # # ### ";
			MazeLine[2]= " #   ##   # ";
			MazeLine[3]= "  ##  #  ## ";
			MazeLine[4]= " ########   ";
			MazeLine[5]= " #    # ##  ";
			MazeLine[6]= "# ## # # #  ";
			MazeLine[7]= " ####### # #";
			MazeLine[8]= "  ###### #  ";
			MazeLine[9]= " # # # # ## ";
			MazeLine[10]="# # # # #   ";
			break;

		default:
			ClearScreen();
			gotogxy(9,7);
			printf("Congratulations!");
			gotogxy(2,8);
			printf("You've completed the MazezaM");
			gotogxy(12,10);
			InverseOn();
			printf("Well Done!");
			InverseOff();
			bCloseFlag=TRUE;
			cgetc();
			break;
		}

	if (bCloseFlag) return;

	for (i=1;i<uHeight+1;i++) strcpy(&Mazezam[i*uWidth],MazeLine[i]); // Copy the Level Data.

	l=((SCREENWIDTH-uWidth)/2);
	t=((22-uHeight)/2);
	r=SCREENWIDTH-l-uWidth;
	PrintEqual();
	PrintEqual();
	printf("  Level ");
	if (MazeNumber<10)
			{
			cputc('0');
			cputc((MazeNumber+48));
			}
	else
			{
			cputc(((MazeNumber/10)+48));
			cputc(((MazeNumber%10)+48));
			}
	printf("  ");
	for (i=0;i<(SCREENWIDTH-28);i++) PrintEqual();
	printf("  Lives ");
	if (uLives<10) 	{
				cputc('0');
				cputc((uLives+48));
			}
	else		{
				cputc(((uLives/10)+48));
				cputc(((uLives%10)+48));
			}
	printf("  ");
	PrintEqual();
	PrintEqual();
	PrintEnter();


	for (i=1;i!=t+1;i++) FillRow();

	for (i=1;i!=uHeight+1;i++)
	{
		gotogxy(0,t+i);
		if (i==lx) for (k=0;k!=l;k++) cputc(' ');
		if (i!=lx) for (k=0;k!=l;k++) PrintEqual();
		printf(MazeLine[i]); // Print the Level line.
		if (i==rx) for (k=0;k!=r;k++) cputc(' ');
		if (i!=rx) for (k=0;k!=r;k++) PrintEqual();
	}
	gotogxy(0,t+i);
	for (i=t+uHeight+1;i!=SCREENHEIGHT;i++) FillRow();
	j=strlen(LevelName);
	for (k=0;k!=((SCREENWIDTH-2-j)/2);k++) PrintEqual();
	PrintSpace();
	printf(LevelName);
	PrintSpace();
	for (k=0;k!=((SCREENWIDTH-2-j)/2);k++) PrintEqual();
	PrintEnter();

	for (i=0;i!=l;i++)
	{
		gotogxy(i+1,t+lx);
		cputc('P'); //Start animation
		gotogxy(i,t+lx);
		cputc(' '); // Fill after
	}

	gotogxy(l-1,t+lx);
	printf("OP");
	i=lx;
	j=1;
}

void Title()
{
	ClearScreen();
        FillWall();
	printf("        ");
	for (i=1;i<13;i++) PrintEqual();
	printf("        ");
	FillWall();
	PrintEnter();
        for (l=0;l<SCREENWIDTH;l++) PrintEqual();
	PrintEnter();
	for (l=0;l<((SCREENWIDTH-22)/2);l++) PrintEqual();
	InverseOn();
	printf("http://drhirudo.hit.bg");
	InverseOff();
	for (l=0;l<((SCREENWIDTH-22)/2);l++) PrintEqual();
	PrintEnter();
	FillRow();
	FillWall();
        FillSpace();
	FillWall();
	PrintEnter();
	FillWall();
	printf("        M A Z E Z A M       ");
	FillWall();
	PrintEnter();
	FillWall();
	FillSpace();
	FillWall();
	PrintEnter();
	FillWall();
	printf(" A][ version (C) 2004-08 by ");
	FillWall();
	PrintEnter();
	FillWall();
	printf("     Ventzislav Tzvetkov    ");
	FillWall();
	PrintEnter();
	FillWall();
	FillSpace();
	FillWall();
	PrintEnter();
	FillRow();
	PrintEnter();
	PrintEnter();	
	printf("               Keys:\n\n           MOVE - I,J,K,L\n\n");
	printf("          RETRY LEVEL - r\n          QUIT  GAME  - q\n\n");
	printf("       Press SPACE to start\n");
	uLives=3;
	Column=SCREENWIDTH/2;
	for (;;)
	{

		gotogxy(Column,9);
		cputc('P');
		PressedKey=cgetc();

		if (PressedKey==' ') break;
		if (PressedKey=='Q' || PressedKey=='q')
			{
			bCloseFlag=TRUE;
			break;
			}
		if (PressedKey=='L' || PressedKey=='l')
			{
			gotogxy(Column,9);
			Column+=(Column<(SCREENWIDTH-((SCREENWIDTH-26)/2)));
			PrintSpace();
			}
		if (PressedKey=='J' || PressedKey=='j')
			{
			gotogxy(Column,9);
			Column-=(Column>((SCREENWIDTH-28)/2));
			PrintSpace();
			}
 	}
}


void main()
{
	int Mazeno,Loop,rand;

//	printf("\0335"); // Hide Cursor escape sequence

	for (;;)
	{
		bCloseFlag=FALSE;
		Title();
		Mazeno=1;
		if (bCloseFlag) break;
		Level(Mazeno); 

		for(;;)
		{

			PressedKey=cgetc();
			if (PressedKey=='R' || PressedKey=='r')
			{
				uLives--;
			if (uLives<1) PressedKey='q';
		 		else
				{
				gotogxy(l+j-3,t+i-1);
				InverseOn();
				printf(ARGH[rand%9]);
				InverseOff();
				cgetc();
				Level(Mazeno);
				}
			}



			if (PressedKey=='Q' || PressedKey=='q')
			{
				gotogxy(l+j-3,t+i-1);
				InverseOn();
				printf(ARGH[rand%9]);
				InverseOff();
				cgetc();
				gotogxy(((SCREENWIDTH-10)/2),10);
				InverseOn();
				printf("GAME OVER!");
				InverseOff();
				cgetc();
				bCloseFlag=TRUE;
				break;
   			}

			if ((PressedKey=='L' || PressedKey=='l') && (i==rx && j==uWidth))
			{
				gotogxy(l+j-1,t+i);
				PrintSpace();
				for (i=l+uWidth;i!=SCREENWIDTH;i++)
				{
					gotogxy(i,t+rx);
					cputc('P');
					gotogxy(i,t+rx);
					cputc(' ');
				}
				InverseOn();
				i=t+rx;
				switch (rand%6)
				{
				case 0:
					gotogxy(13,i);
					printf("Hurray!");
					break;

				case 1:
					gotogxy(13,i);
					printf("Hurrah!");
					break;

				case 2:
					gotogxy(16,i);
					printf("Yes!");
					break;

				case 3:
					gotogxy(14,i);
					printf("Great!");
					break;

				case 4:
					gotogxy(12,i);
					printf("Yee-hah!");
					break;

				default:
					gotogxy(16,i);
					printf("Yay!");
				}
				InverseOff();
				cgetc();
				uLives++;
				Level(++Mazeno);
				PressedKey=0;
			}
			if ((PressedKey=='L' || PressedKey=='l') && j<uWidth)
				if ((Mazezam[i*uWidth+j])==' ')
				{
					gotogxy(l+j-1,t+i);
					PrintSpace();
					j++;
					gotogxy(l+j-1,t+i);
					cputc('P');
				} 

				else

					if (Mazezam[(i*uWidth)+uWidth-1]==' ')
					{
					j++;
					for (Loop=uWidth-1;Loop>0;Loop--)
					Mazezam[(i*uWidth)+Loop]=Mazezam[(i*uWidth)+Loop-1];
					Mazezam[i*uWidth]=' ';
					gotogxy(l,t+i);
					for (Loop=0;Loop<uWidth;Loop++) putchar(Mazezam[i*uWidth+Loop]);
					gotogxy(l+j-1,t+i);
					cputc('P');
					}

			if ((PressedKey=='J' || PressedKey=='j') && j>1)
				if (Mazezam[(i*uWidth)+j-2]==' ')
				{
				gotogxy(l+j-1,t+i);
				PrintSpace();
				j--;
				gotogxy(l+j-1,t+i);
				cputc('P');
				}
				else

					if (Mazezam[i*uWidth]==' ')
					{
					j--;
					for (Loop=1;Loop!=uWidth;Loop++)
					Mazezam[(i*uWidth)+Loop-1]=Mazezam[(i*uWidth)+Loop];
					Mazezam[(i*uWidth)+uWidth-1]=' ';
					gotogxy(l,t+i);
					for (Loop=0;Loop<uWidth;Loop++) putchar(Mazezam[i*uWidth+Loop]);
					gotogxy(l+j-1,t+i);
					cputc('P');
					}

					if ((PressedKey=='K' || PressedKey=='k') && i<uHeight)
						if (Mazezam[((i+1)*uWidth)+j-1]==' ')
						{
						gotogxy(l+j-1,t+i);
						PrintSpace();
						i++;
						gotogxy(l+j-1,t+i);cputc('P');
						}

			if ((PressedKey=='I' || PressedKey=='i') && i>1)
				if (Mazezam[((i-1)*uWidth)+j-1]==' ')
				{
				gotogxy(l+j-1,t+i);
				PrintSpace();
				i--;
				gotogxy(l+j-1,t+i);
				cputc('P');
				}

			PressedKey=0;
			if (bCloseFlag) {
					bCloseFlag=FALSE;
					break;
					}
			rand++;
		}
	}
	ClearScreen();

//	printf("\0335"); // Show Cursor escape sequence
	return;
}
