;-----------------------------------------------------------------------------
; rodata.inc
; Part of penetrator, the zx spectrum game, made for Apple II
;
; Stefan Wessels, 2019
; This is free and unencumbered software released into the public domain.

;-----------------------------------------------------------------------------
.segment "RODATA"

;-----------------------------------------------------------------------------
; the lo byte for the memory at the start of every screen row
rowL:
    .repeat $C0, Row
        .byte   XINSET + Row & $08 << 4 | Row & $C0 >> 1 | Row & $C0 >> 3
    .endrep

;-----------------------------------------------------------------------------
; the hi byte for the memory at the start of every screen row
rowH:
    .repeat $C0, Row
        .byte   >$0000 | Row & $07 << 2 | Row & $30 >> 4
    .endrep

;-----------------------------------------------------------------------------
; pixels in format for drawPlotXY
plotPix: .byte %00001111, %01111000

;-----------------------------------------------------------------------------
; Offsets for printing the high score table on the title screen
scoreTextOffset:
.byte textHighScore1-textHS
.byte textHighScore2-textHS
.byte textHighScore3-textHS
.byte textHighScore4-textHS
.byte textHighScore5-textHS
scoreTextPosX:
.byte 10, 02, 18, 1, 19
scoreTextPosY:
.byte 8 , 16, 16, 24, 24
scorePosX:
.byte 17, 09, 25, 08, 26

;-----------------------------------------------------------------------------
radarAL:
.byte <radar0A, <(radar0U + 1), <(radar0A + 1), <(radar0U + 2)
.byte <radar1A, <(radar1U + 1), <(radar1A + 1), <(radar1U + 2)
.byte <radar2A, <(radar2U + 1), <(radar2A + 1), <(radar2U + 2)
.byte <radar3A, <(radar3U + 1), <(radar3A + 1), <(radar3U + 2)
.byte <radar4A, <(radar4U + 1), <(radar4A + 1), <(radar4U + 2)
.byte <radar5A, <(radar5U + 1), <(radar5A + 1), <(radar5U + 2)
.byte <radar6A, <(radar6U + 1), <(radar6A + 1), <(radar6U + 2)
.byte <radar7A, <(radar7U + 1), <(radar7A + 1), <(radar7U + 2)
radarAH:
.byte >radar0A, >(radar0U + 1), >(radar0A + 1), >(radar0U + 2)
.byte >radar1A, >(radar1U + 1), >(radar1A + 1), >(radar1U + 2)
.byte >radar2A, >(radar2U + 1), >(radar2A + 1), >(radar2U + 2)
.byte >radar3A, >(radar3U + 1), >(radar3A + 1), >(radar3U + 2)
.byte >radar4A, >(radar4U + 1), >(radar4A + 1), >(radar4U + 2)
.byte >radar5A, >(radar5U + 1), >(radar5A + 1), >(radar5U + 2)
.byte >radar6A, >(radar6U + 1), >(radar6A + 1), >(radar6U + 2)
.byte >radar7A, >(radar7U + 1), >(radar7A + 1), >(radar7U + 2)
radarUL:
.byte <radar0U
.byte <radar1U
.byte <radar2U
.byte <radar3U
.byte <radar4U
.byte <radar5U
.byte <radar6U
.byte <radar7U
radarUH:
.byte >radar0U
.byte >radar1U
.byte >radar2U
.byte >radar3U
.byte >radar4U
.byte >radar5U
.byte >radar6U
.byte >radar7U
radarAS:
.byte 4, 3, 2, 1
radarAD:
.byte 2, 3, 2, 3
radarAR:
.byte 1, 1, 0, 0

;-----------------------------------------------------------------------------
missileAL:
.byte <missile0A, <missile1A, <(missile0U + 1), <(missile1U + 1)
missileAH:
.byte >missile0A, >missile1A, >(missile0U + 1), >(missile1U + 1)
missileUL:
.byte <missile0U, <missile1U
missileUH:
.byte >missile0U, >missile1U
missileAD:
.byte 1, 1, 2, 2 

;-----------------------------------------------------------------------------
bombAL:
.byte <bomb0A, <bomb1A
bombAH:
.byte >bomb0A, >bomb1A
bombUL:
.byte <bomb0U, <bomb1U
bombUH:
.byte >bomb0U, >bomb1U
bombH:
.byte 6, 5

;-----------------------------------------------------------------------------
monsterAL:
.byte <monsterA, <(monsterU + 1), <(monsterA+1)
monsterAH:
.byte >monsterA, >(monsterU + 1), >(monsterA+1)
monsterAS:
.byte 3, 2, 1
monsterAR:
.byte 1, 0, 0

;-----------------------------------------------------------------------------
nukeAL:
.byte <nukeA, <(nukeU + 1)
nukeAH:
.byte >nukeA, >(nukeU + 1)
nukeUL:
.byte <nukeU
nukeUH:
.byte >nukeU
nukeAD:
.byte 1, 2

;-----------------------------------------------------------------------------
explosionAL:
.byte <explosion0A
.byte <explosion1A
.byte <explosion2A
.byte <explosion3A
explosionAH:
.byte >explosion0A
.byte >explosion1A
.byte >explosion2A
.byte >explosion3A
explosionUL:
.byte <explosion0U
.byte <explosion1U
.byte <explosion2U
.byte <explosion3U
explosionUH:
.byte >explosion0U
.byte >explosion1U
.byte >explosion2U
.byte >explosion3U

;-----------------------------------------------------------------------------
layersL:
.byte <ram_layer0, <ram_layer1
layersH:
.byte >ram_layer0, >ram_layer1

;-----------------------------------------------------------------------------
; nuke, missile, monster, radar
scoreTable:
.word $0100, $0001, $0002, $0010

;-----------------------------------------------------------------------------
BitMasks:
.byte %00000001
.byte %00000010
.byte %00000100
.byte %00001000
.byte %00010000
.byte %00100000
.byte %01000000
.byte %10000000
.byte %00000011
.byte %00001100
.byte %01100000
.byte %10001110
.byte %11110000
BitMasksEnd:

;-----------------------------------------------------------------------------
; Audio delay values
explDelay:
    .byte $04, $08, $06, $04

;-----------------------------------------------------------------------------
; Sprite Information
; Images to the right in human form, not Apple II form (i.e. bytes don't
; neccesarily match visuals).  Rendering is bottom up so stored upside-down.

missile0A:
.byte $41                                       ; X.....X
.byte $41                                       ; X.....X
.byte $41                                       ; X.....X
.byte $63                                       ; XX...XX
.byte $63                                       ; XX...XX
.byte $7F                                       ; XXXXXXX
.byte $3E                                       ; .XXXXX.
.byte $22                                       ; .X...X.
.byte $3E                                       ; .XXXXX.
.byte $1C                                       ; ..XXX..
.byte $1C                                       ; ..XXX..
.byte $08                                       ; ...X...
.byte $08                                       ; ...X...
.byte $08                                       ; ...X...

missile0U:
.byte $10, $08                                  ; ....X.....X...
.byte $10, $08                                  ; ....X.....X...
.byte $10, $08                                  ; ....X.....X...
.byte $30, $0C                                  ; ....XX...XX...
.byte $30, $0C                                  ; ....XX...XX...
.byte $70, $0F                                  ; ....XXXXXXX...
.byte $60, $07                                  ; .....XXXXX....
.byte $20, $04                                  ; .....X...X....
.byte $60, $07                                  ; .....XXXXX....
.byte $40, $03                                  ; ......XXX.....
.byte $40, $03                                  ; ......XXX.....
.byte $00, $01                                  ; .......X......
.byte $00, $01                                  ; .......X......
.byte $00, $01                                  ; .......X......

missile1A:
.byte $55                                       ; X.X.X.X
.byte $5D                                       ; X.XXX.X
.byte $49                                       ; X..X..X
.byte $6B                                       ; XX.X.XX
.byte $63                                       ; XX...XX
.byte $7F                                       ; XXXXXXX
.byte $3E                                       ; .XXXXX.
.byte $22                                       ; .X...X.
.byte $3E                                       ; .XXXXX.
.byte $1C                                       ; ..XXX..
.byte $1C                                       ; ..XXX..
.byte $08                                       ; ...X...
.byte $08                                       ; ...X...
.byte $08                                       ; ...X...

missile1U:
.byte $50, $0A                                  ; ....X.X.X.X...
.byte $50, $0B                                  ; ....X.XXX.X...
.byte $10, $09                                  ; ....X..X..X...
.byte $30, $0D                                  ; ....XX.X.XX...
.byte $30, $0C                                  ; ....XX...XX...
.byte $70, $0F                                  ; ....XXXXXXX...
.byte $60, $07                                  ; .....XXXXX....
.byte $20, $04                                  ; .....X...X....
.byte $60, $07                                  ; .....XXXXX....
.byte $40, $03                                  ; ......XXX.....
.byte $40, $03                                  ; ......XXX.....
.byte $00, $01                                  ; .......X......
.byte $00, $01                                  ; .......X......
.byte $00, $01                                  ; .......X......


radar0A:
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $70, $07                                  ; ....XXXXXX....
.byte $70, $07                                  ; ....XXXXXX....
.byte $20, $02                                  ; .....X..X.....
.byte $70, $07                                  ; ....XXXXXX....
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $7E, $3F                                  ; .XXXXXXXXXXXX.
.byte $7F, $7F                                  ; XXXXXXXXXXXXXX
.byte $7F, $7F                                  ; XXXXXXXXXXXXXX
.byte $7F, $7F                                  ; XXXXXXXXXXXXXX
.byte $7E, $3F                                  ; .XXXXXXXXXXXX.
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $70, $07                                  ; ....XXXXXX....
.byte $40, $01                                  ; ......XX......
.byte $40, $01                                  ; ......XX......

radar0U:
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $24, $00                             ; .........X..X........
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $60, $7F, $07                             ; .....XXXXXXXXXXXX....
.byte $70, $7F, $0F                             ; ....XXXXXXXXXXXXXX...
.byte $70, $7F, $0F                             ; ....XXXXXXXXXXXXXX...
.byte $70, $7F, $0F                             ; ....XXXXXXXXXXXXXX...
.byte $60, $7F, $07                             ; .....XXXXXXXXXXXX....
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $18, $00                             ; ..........XX.........
.byte $00, $18, $00                             ; ..........XX.........

radar1A:
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $70, $07                                  ; ....XXXXXX....
.byte $70, $07                                  ; ....XXXXXX....
.byte $20, $02                                  ; .....X..X.....
.byte $78, $03                                  ; ...XXXXXX.....
.byte $7C, $01                                  ; ..XXXXXX......
.byte $7C, $03                                  ; ..XXXXXXX.....
.byte $7C, $07                                  ; ..XXXXXXXX....
.byte $78, $0F                                  ; ...XXXXXXXX...
.byte $70, $0F                                  ; ....XXXXXXX...
.byte $60, $0F                                  ; .....XXXXXX...
.byte $70, $0F                                  ; ....XXXXXXX...
.byte $58, $07                                  ; ...XX.XXXX....
.byte $08, $02                                  ; ...X....X.....
.byte $00, $00                                  ; ..............

radar1U:
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $24, $00                             ; .........X..X........
.byte $00, $3F, $00                             ; .......XXXXXX........
.byte $40, $1F, $00                             ; ......XXXXXX.........
.byte $40, $3F, $00                             ; ......XXXXXXX........
.byte $40, $7F, $00                             ; ......XXXXXXXX.......
.byte $00, $7F, $01                             ; .......XXXXXXXX......
.byte $00, $7E, $01                             ; ........XXXXXXX......
.byte $00, $7C, $01                             ; .........XXXXXX......
.byte $00, $7E, $01                             ; ........XXXXXXX......
.byte $00, $7B, $00                             ; .......XX.XXXX.......
.byte $00, $21, $00                             ; .......X....X........
.byte $00, $00, $00                             ; .....................

radar2A:
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $70, $07                                  ; ....XXXXXX....
.byte $70, $07                                  ; ....XXXXXX....
.byte $20, $02                                  ; .....X..X.....
.byte $70, $03                                  ; ....XXXXX.....
.byte $78, $01                                  ; ...XXXXX......
.byte $7C, $03                                  ; ..XXXXXXX.....
.byte $60, $07                                  ; .....XXXXX....
.byte $40, $07                                  ; ......XXXX....
.byte $40, $07                                  ; ......XXXX....
.byte $60, $07                                  ; .....XXXXX....
.byte $30, $07                                  ; ....XX.XXX....
.byte $18, $03                                  ; ...XX..XX.....
.byte $00, $01                                  ; .......X......
.byte $00, $00                                  ; ..............

radar2U:
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $24, $00                             ; .........X..X........
.byte $00, $3E, $00                             ; ........XXXXX........
.byte $00, $1F, $00                             ; .......XXXXX.........
.byte $40, $3F, $00                             ; ......XXXXXXX........
.byte $00, $7C, $00                             ; .........XXXXX.......
.byte $00, $78, $00                             ; ..........XXXX.......
.byte $00, $78, $00                             ; ..........XXXX.......
.byte $00, $7C, $00                             ; .........XXXXX.......
.byte $00, $76, $00                             ; ........XX.XXX.......
.byte $00, $33, $00                             ; .......XX..XX........
.byte $00, $10, $00                             ; ...........X.........
.byte $00, $00, $00                             ; .....................

radar3A:
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $70, $07                                  ; ....XXXXXX....
.byte $70, $07                                  ; ....XXXXXX....
.byte $20, $02                                  ; .....X..X.....
.byte $78, $03                                  ; ...XXXXXX.....
.byte $7C, $01                                  ; ..XXXXXX......
.byte $44, $03                                  ; ..X...XXX.....
.byte $04, $07                                  ; ..X....XXX....
.byte $64, $0E                                  ; ..X..XX.XXX...
.byte $68, $0C                                  ; ...X.XX..XX...
.byte $10, $08                                  ; ....X.....X...
.byte $30, $08                                  ; ....XX....X...
.byte $48, $04                                  ; ...X..X..X....
.byte $08, $03                                  ; ...X...XX.....
.byte $00, $00                                  ; ..............

radar3U:
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $24, $00                             ; .........X..X........
.byte $00, $3F, $00                             ; .......XXXXXX........
.byte $40, $1F, $00                             ; ......XXXXXX.........
.byte $40, $38, $00                             ; ......X...XXX........
.byte $40, $70, $00                             ; ......X....XXX.......
.byte $40, $6C, $01                             ; ......X..XX.XXX......
.byte $00, $4D, $01                             ; .......X.XX..XX......
.byte $00, $02, $01                             ; ........X.....X......
.byte $00, $06, $01                             ; ........XX....X......
.byte $00, $49, $00                             ; .......X..X..X.......
.byte $00, $31, $00                             ; .......X...XX........
.byte $00, $00, $00                             ; .....................

radar4A:
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $70, $07                                  ; ....XXXXXX....
.byte $70, $07                                  ; ....XXXXXX....
.byte $20, $02                                  ; .....X..X.....
.byte $70, $07                                  ; ....XXXXXX....
.byte $0C, $18                                  ; ..XX......XX..
.byte $02, $20                                  ; .X..........X.
.byte $01, $40                                  ; X............X
.byte $41, $41                                  ; X.....XX.....X
.byte $41, $41                                  ; X.....XX.....X
.byte $42, $21                                  ; .X....XX....X.
.byte $4C, $19                                  ; ..XX..XX..XX..
.byte $70, $07                                  ; ....XXXXXX....
.byte $40, $01                                  ; ......XX......
.byte $40, $01                                  ; ......XX......

radar4U:
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $24, $00                             ; .........X..X........
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $40, $01, $03                             ; ......XX......XX.....
.byte $20, $00, $04                             ; .....X..........X....
.byte $10, $00, $08                             ; ....X............X...
.byte $10, $18, $08                             ; ....X.....XX.....X...
.byte $10, $18, $08                             ; ....X.....XX.....X...
.byte $20, $18, $04                             ; .....X....XX....X....
.byte $40, $19, $03                             ; ......XX..XX..XX.....
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $18, $00                             ; ..........XX.........
.byte $00, $18, $00                             ; ..........XX.........

radar5A:
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $70, $07                                  ; ....XXXXXX....
.byte $70, $07                                  ; ....XXXXXX....
.byte $20, $02                                  ; .....X..X.....
.byte $60, $0F                                  ; .....XXXXXX...
.byte $40, $1F                                  ; ......XXXXXX..
.byte $60, $11                                  ; .....XXX...X..
.byte $70, $10                                  ; ....XXX....X..
.byte $38, $13                                  ; ...XXX.XX..X..
.byte $18, $0B                                  ; ...XX..XX.X...
.byte $08, $04                                  ; ...X.....X....
.byte $08, $06                                  ; ...X....XX....
.byte $10, $09                                  ; ....X..X..X...
.byte $60, $08                                  ; .....XX...X...
.byte $00, $00                                  ; ..............

radar5U:
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $24, $00                             ; .........X..X........
.byte $00, $7C, $01                             ; .........XXXXXX......
.byte $00, $78, $03                             ; ..........XXXXXX.....
.byte $00, $1C, $02                             ; .........XXX...X.....
.byte $00, $0E, $02                             ; ........XXX....X.....
.byte $00, $37, $02                             ; .......XXX.XX..X.....
.byte $00, $33, $01                             ; .......XX..XX.X......
.byte $00, $41, $00                             ; .......X.....X.......
.byte $00, $61, $00                             ; .......X....XX.......
.byte $00, $12, $01                             ; ........X..X..X......
.byte $00, $0C, $01                             ; .........XX...X......
.byte $00, $00, $00                             ; .....................

radar6A:
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $70, $07                                  ; ....XXXXXX....
.byte $70, $07                                  ; ....XXXXXX....
.byte $20, $02                                  ; .....X..X.....
.byte $60, $07                                  ; .....XXXXX....
.byte $40, $0F                                  ; ......XXXXX...
.byte $60, $1F                                  ; .....XXXXXXX..
.byte $70, $03                                  ; ....XXXXX.....
.byte $70, $01                                  ; ....XXXX......
.byte $70, $01                                  ; ....XXXX......
.byte $70, $03                                  ; ....XXXXX.....
.byte $70, $06                                  ; ....XXX.XX....
.byte $60, $0C                                  ; .....XX..XX...
.byte $40, $00                                  ; ......X.......
.byte $00, $00                                  ; ..............

radar6U:
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $24, $00                             ; .........X..X........
.byte $00, $7C, $00                             ; .........XXXXX.......
.byte $00, $78, $01                             ; ..........XXXXX......
.byte $00, $7C, $03                             ; .........XXXXXXX.....
.byte $00, $3E, $00                             ; ........XXXXX........
.byte $00, $1E, $00                             ; ........XXXX.........
.byte $00, $1E, $00                             ; ........XXXX.........
.byte $00, $3E, $00                             ; ........XXXXX........
.byte $00, $6E, $00                             ; ........XXX.XX.......
.byte $00, $4C, $01                             ; .........XX..XX......
.byte $00, $08, $00                             ; ..........X..........
.byte $00, $00, $00                             ; .....................

radar7A:
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $7C, $1F                                  ; ..XXXXXXXXXX..
.byte $70, $07                                  ; ....XXXXXX....
.byte $70, $07                                  ; ....XXXXXX....
.byte $20, $02                                  ; .....X..X.....
.byte $60, $0F                                  ; .....XXXXXX...
.byte $40, $1F                                  ; ......XXXXXX..
.byte $60, $1F                                  ; .....XXXXXXX..
.byte $70, $1F                                  ; ....XXXXXXXX..
.byte $78, $0F                                  ; ...XXXXXXXX...
.byte $78, $07                                  ; ...XXXXXXX....
.byte $78, $03                                  ; ...XXXXXX.....
.byte $78, $07                                  ; ...XXXXXXX....
.byte $70, $0D                                  ; ....XXXX.XX...
.byte $20, $08                                  ; .....X....X...
.byte $00, $00                                  ; ..............

radar7U:
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $40, $7F, $03                             ; ......XXXXXXXXXX.....
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $7E, $00                             ; ........XXXXXX.......
.byte $00, $24, $00                             ; .........X..X........
.byte $00, $7C, $01                             ; .........XXXXXX......
.byte $00, $78, $03                             ; ..........XXXXXX.....
.byte $00, $7C, $03                             ; .........XXXXXXX.....
.byte $00, $7E, $03                             ; ........XXXXXXXX.....
.byte $00, $7F, $01                             ; .......XXXXXXXX......
.byte $00, $7F, $00                             ; .......XXXXXXX.......
.byte $00, $3F, $00                             ; .......XXXXXX........
.byte $00, $7F, $00                             ; .......XXXXXXX.......
.byte $00, $5E, $01                             ; ........XXXX.XX......
.byte $00, $04, $01                             ; .........X....X......
.byte $00, $00, $00                             ; .....................

explosion0A:
 .byte $04, $00                                 ; ..X...........
 .byte $0C, $00                                 ; ..XX..........
 .byte $00, $41                                 ; .......X.....X
 .byte $00, $00                                 ; ..............
 .byte $00, $10                                 ; ...........X..
 .byte $49, $01                                 ; X..X..XX......
 .byte $60, $07                                 ; .....XXXXX....
 .byte $60, $0F                                 ; .....XXXXXX...
 .byte $60, $2F                                 ; .....XXXXXX.X.
 .byte $60, $03                                 ; .....XXXX.....
 .byte $08, $02                                 ; ...X....X.....
 .byte $00, $10                                 ; ...........X..
 .byte $30, $00                                 ; ....XX........
 .byte $31, $00                                 ; X...XX........
 .byte $01, $62                                 ; X.......X...XX
 .byte $00, $00                                 ; ..............

explosion0U:
 .byte $20, $00, $00                            ; .....X...............
 .byte $60, $00, $00                            ; .....XX..............
 .byte $00, $08, $04                            ; ..........X.....X....
 .byte $00, $00, $00                            ; .....................
 .byte $00, $00, $01                            ; ..............X......
 .byte $48, $0C, $00                            ; ...X..X..XX..........
 .byte $00, $3E, $00                            ; ........XXXXX........
 .byte $00, $7E, $00                            ; ........XXXXXX.......
 .byte $00, $7E, $02                            ; ........XXXXXX.X.....
 .byte $00, $1E, $00                            ; ........XXXX.........
 .byte $40, $10, $00                            ; ......X....X.........
 .byte $00, $00, $01                            ; ..............X......
 .byte $00, $03, $00                            ; .......XX............
 .byte $08, $03, $00                            ; ...X...XX............
 .byte $08, $10, $06                            ; ...X.......X...XX....
 .byte $00, $00, $00                            ; .....................

explosion1A:
 .byte $06, $00                                 ; .XX...........
 .byte $04, $42                                 ; ..X.....X....X
 .byte $00, $00                                 ; ..............
 .byte $00, $20                                 ; ............X.
 .byte $44, $01                                 ; ..X...XX......
 .byte $10, $0D                                 ; ....X..X.XX...
 .byte $50, $17                                 ; ....X.XXXX.X..
 .byte $60, $0A                                 ; .....XX.X.X...
 .byte $60, $0C                                 ; .....XX..XX...
 .byte $68, $41                                 ; ...X.XXX.....X
 .byte $18, $02                                 ; ...XX...X.....
 .byte $00, $08                                 ; ..........X...
 .byte $00, $20                                 ; ............X.
 .byte $30, $00                                 ; ....XX........
 .byte $14, $40                                 ; ..X.X........X
 .byte $00, $04                                 ; .........X....

explosion1U:
 .byte $30, $00, $00                            ; ....XX...............
 .byte $20, $10, $04                            ; .....X.....X....X....
 .byte $00, $00, $00                            ; .....................
 .byte $00, $00, $02                            ; ...............X.....
 .byte $20, $0C, $00                            ; .....X...XX..........
 .byte $00, $69, $00                            ; .......X..X.XX.......
 .byte $00, $3D, $01                            ; .......X.XXXX.X......
 .byte $00, $56, $00                            ; ........XX.X.X.......
 .byte $00, $66, $00                            ; ........XX..XX.......
 .byte $40, $0E, $04                            ; ......X.XXX.....X....
 .byte $40, $11, $00                            ; ......XX...X.........
 .byte $00, $40, $00                            ; .............X.......
 .byte $00, $00, $02                            ; ...............X.....
 .byte $00, $03, $00                            ; .......XX............
 .byte $20, $01, $04                            ; .....X.X........X....
 .byte $00, $20, $00                            ; ............X........

explosion2A:
.byte $02, $04                                  ; .X.......X....
.byte $00, $00                                  ; ..............
.byte $20, $40                                  ; .....X.......X
.byte $01, $21                                  ; X......X....X.
.byte $04, $09                                  ; ..X....X..X...
.byte $10, $00                                  ; ....X.........
.byte $10, $14                                  ; ....X....X.X..
.byte $24, $20                                  ; ..X..X......X.
.byte $20, $08                                  ; .....X....X...
.byte $12, $00                                  ; .X..X.........
.byte $08, $02                                  ; ...X....X.....
.byte $0A, $21                                  ; .X.X...X....X.
.byte $00, $00                                  ; ..............
.byte $10, $40                                  ; ....X........X
.byte $04, $00                                  ; ..X...........
.byte $09, $40                                  ; X..X.........X

explosion2U:
.byte $10, $20, $00                             ; ....X.......X........
.byte $00, $00, $00                             ; .....................
.byte $00, $02, $04                             ; ........X.......X....
.byte $08, $08, $02                             ; ...X......X....X.....
.byte $20, $48, $00                             ; .....X....X..X.......
.byte $00, $01, $00                             ; .......X.............
.byte $00, $21, $01                             ; .......X....X.X......
.byte $20, $02, $02                             ; .....X..X......X.....
.byte $00, $42, $00                             ; ........X....X.......
.byte $10, $01, $00                             ; ....X..X.............
.byte $40, $10, $00                             ; ......X....X.........
.byte $50, $08, $02                             ; ....X.X...X....X.....
.byte $00, $00, $00                             ; .....................
.byte $00, $01, $04                             ; .......X........X....
.byte $20, $00, $00                             ; .....X...............
.byte $48, $00, $04                             ; ...X..X.........X....

explosion3A:
.byte $00, $00                                  ; ..............
.byte $02, $10                                  ; .X.........X..
.byte $20, $04                                  ; .....X...X....
.byte $01, $01                                  ; X......X......
.byte $00, $40                                  ; .............X
.byte $04, $00                                  ; ..X...........
.byte $08, $10                                  ; ...X.......X..
.byte $41, $00                                  ; X.....X.......
.byte $00, $20                                  ; ............X.
.byte $01, $01                                  ; X......X......
.byte $10, $00                                  ; ....X.........
.byte $00, $08                                  ; ..........X...
.byte $02, $02                                  ; .X......X.....
.byte $04, $00                                  ; ..X...........
.byte $00, $10                                  ; ...........X..
.byte $01, $00                                  ; X.............

explosion3U:
.byte $00, $00, $00                             ; .....................
.byte $10, $00, $01                             ; ....X.........X......
.byte $00, $22, $00                             ; ........X...X........
.byte $08, $08, $00                             ; ...X......X..........
.byte $00, $00, $04                             ; ................X....
.byte $20, $00, $00                             ; .....X...............
.byte $40, $00, $01                             ; ......X.......X......
.byte $08, $04, $00                             ; ...X.....X...........
.byte $00, $00, $02                             ; ...............X.....
.byte $08, $08, $00                             ; ...X......X..........
.byte $00, $01, $00                             ; .......X.............
.byte $00, $40, $00                             ; .............X.......
.byte $10, $10, $00                             ; ....X......X.........
.byte $20, $00, $00                             ; .....X...............
.byte $00, $00, $01                             ; ..............X......
.byte $08, $00, $00                             ; ...X.................

monsterA:
.byte $78, $00                                  ; ...XXXX.......
.byte $4C, $01                                  ; ..XX..XX......
.byte $7C, $01                                  ; ..XXXXXX......
.byte $7E, $03                                  ; .XXXXXXXX.....
.byte $37, $07                                  ; XXX.XX.XXX....
.byte $33, $06                                  ; XX..XX..XX....
.byte $33, $06                                  ; XX..XX..XX....
.byte $7B, $06                                  ; XX.XXXX.XX....
.byte $7F, $07                                  ; XXXXXXXXXX....
.byte $7E, $03                                  ; .XXXXXXXX.....
.byte $7F, $07                                  ; XXXXXXXXXX....
.byte $7B, $06                                  ; XX.XXXX.XX....
.byte $01, $04                                  ; X........X....

monsterU:
.byte $00, $0F                                  ; .......XXXX...
.byte $40, $19                                  ; ......XX..XX..
.byte $40, $1F                                  ; ......XXXXXX..
.byte $60, $3F                                  ; .....XXXXXXXX.
.byte $70, $76                                  ; ....XXX.XX.XXX
.byte $30, $66                                  ; ....XX..XX..XX
.byte $30, $66                                  ; ....XX..XX..XX
.byte $30, $6F                                  ; ....XX.XXXX.XX
.byte $70, $7F                                  ; ....XXXXXXXXXX
.byte $60, $3F                                  ; .....XXXXXXXX.
.byte $70, $7F                                  ; ....XXXXXXXXXX
.byte $30, $6F                                  ; ....XX.XXXX.XX
.byte $10, $40                                  ; ....X........X

nukeA:
.byte $3F                                       ; XXXXXX.
.byte $12                                       ; .X..X..
.byte $0C                                       ; ..XX...
.byte $12                                       ; .X..X..
.byte $2D                                       ; X.XX.X.
.byte $2D                                       ; X.XX.X.
.byte $12                                       ; .X..X..
.byte $0C                                       ; ..XX...

nukeU:
.byte $70, $07                                  ; ....XXXXXX....
.byte $20, $02                                  ; .....X..X.....
.byte $40, $01                                  ; ......XX......
.byte $20, $02                                  ; .....X..X.....
.byte $50, $05                                  ; ....X.XX.X....
.byte $50, $05                                  ; ....X.XX.X....
.byte $20, $02                                  ; .....X..X.....
.byte $40, $01                                  ; ......XX......

bomb0A:
.byte $04                                       ; ..X....
.byte $04                                       ; ..X....
.byte $0E                                       ; .XXX...
.byte $1F                                       ; XXXXX..
.byte $15                                       ; X.X.X..
.byte $11                                       ; X...X..

bomb0U:
.byte $40, $00                                  ;......X.......
.byte $40, $00                                  ;......X.......
.byte $60, $01                                  ;.....XXX......
.byte $70, $03                                  ;....XXXXX.....
.byte $50, $02                                  ;....X.X.X.....
.byte $10, $02                                  ;....X...X.....

bomb1A:
.byte $07                                       ; XXX....
.byte $0C                                       ; ..XX...
.byte $3E                                       ; .XXXXX.
.byte $0C                                       ; ..XX...
.byte $07                                       ; XXX....

bomb1U:
.byte $70, $00                                  ; ....XXX.......
.byte $40, $01                                  ; ......XX......
.byte $60, $07                                  ; .....XXXXX....
.byte $40, $01                                  ; ......XX......
.byte $70, $00                                  ; ....XXX.......

shipA:
.byte $7C, $7F, $03                             ; ..XXXXXXXXXXXXXX.....
.byte $78, $03, $00                             ; ...XXXXXX............
.byte $70, $1F, $00                             ; ....XXXXXXXX.........
.byte $60, $7F, $0F                             ; .....XXXXXXXXXXXXX...
.byte $60, $7F, $7F                             ; .....XXXXXXXXXXXXXXXX
.byte $60, $63, $07                             ; .....XXXX...XXXXX....
.byte $60, $31, $00                             ; .....XXX...XX........
.byte $70, $1F, $00                             ; ....XXXXXXXX.........
.byte $78, $03, $00                             ; ...XXXXXX............
.byte $7C, $00, $00                             ; ..XXXXX..............
.byte $1E, $00, $00                             ; .XXXX................
.byte $7F, $07, $00                             ; XXXXXXXXXX...........

shipU:
.byte $40, $7F, $3F, $00                        ; ......XXXXXXXXXXXXXX.....
.byte $00, $3F, $00, $00                        ; .......XXXXXX............
.byte $00, $7E, $07, $00                        ; ........XXXXXXXXX........
.byte $00, $7C, $7F, $01                        ; .........XXXXXXXXXXXXX...
.byte $00, $7C, $7F, $0F                        ; .........XXXXXXXXXXXXXXXX
.byte $00, $3C, $78, $00                        ; .........XXXX....XXXX....
.byte $00, $1C, $0C, $00                        ; .........XXX....XX.......
.byte $00, $7E, $07, $00                        ; ........XXXXXXXXX........
.byte $00, $3F, $00, $00                        ; .......XXXXXX............
.byte $40, $0F, $00, $00                        ; ......XXXXX..............
.byte $60, $03, $00, $00                        ; .....XXXX................
.byte $70, $7F, $00, $00                        ; ....XXXXXXXXXX...........
