
		.setcpu "6502"
 
OP_EOR_imm	:=	$49
OP_CMP_imm	:=	$C9

	.proc A2
INIT:
		sta		MUSIC__SET_SOUND_DEVICE_0
		sta		MUSIC__SET_SOUND_DEVICE_1
		sta		MUSIC__SET_SOUND_DEVICE_2
		sta		MUSIC__SET_SOUND_DEVICE_3
		rts
PLAY:
		sta		@SET_MUSIC_PTR_LSB
		stx		@SET_MUSIC_PTR_MSB
		bit		HW_KEYBOARD_STROBE
@loop:
		lda		#$0
@SET_MUSIC_PTR_LSB	:= *-1
		sta		MUSIC_PTR
		lda		#$0
@SET_MUSIC_PTR_MSB	:= *-1
		sta		MUSIC_PTR+1
		
		lda		#$01
		sta		MUSIC__BYTE_0
		sta		MUSIC__BYTE_1
		pha
		pha
		pha
		bne		L0320
L030B:	iny
		lda		(MUSIC_PTR),y
		sta		MUSIC__BYTE_0
		iny
		lda		(MUSIC_PTR),y
		sta		MUSIC__BYTE_1
L0315:	lda		MUSIC_PTR
		clc
		adc		#$03
		sta		MUSIC_PTR
		bcc		L0320
		inc		MUSIC_PTR+1
L0320:	ldy		#$00
		lda		(MUSIC_PTR),y
		cmp		#$01
		beq		L030B
		bcs		@L0337
		pla
		pla
		pla
@L032D:	ldx		#OP_EOR_imm
		iny
		lda		(MUSIC_PTR),y
		bne		@L0336
		ldx 	#OP_CMP_imm
@L0336:	rts

@L0337:	sta		MUSIC__BYTE_5
		jsr		@L032D
		stx		L0383
		sta		MUSIC__BYTE_6
		ldx		MUSIC__BYTE_0
@L0343:	lsr		a
		dex
		bne		@L0343
		sta		L037C
		jsr		@L032D
		stx		L03BB
		sta		MUSIC__BYTE_4
		ldx		MUSIC__BYTE_1
@L0354:	lsr		a
		dex
		bne		@L0354
		sta		L03B4
		pla
		tay
		pla
		tax
		pla
		bne		L0365
L0362:	bit		HW_SPEAKER
		MUSIC__SET_SOUND_DEVICE_0		:= 	*-2
L0365:	cmp		#$00
		bmi		@L036C
		nop
		bpl		L036F
@L036C:	bit		HW_SPEAKER
		MUSIC__SET_SOUND_DEVICE_1		:= 	*-2
L036F:	sta		MUSIC__BYTE_2
		bit		HW_KEYBOARD_IN
		bmi		MUSIC__PLAY_exit
		dey
		bne		@L037B
		beq		L0381
@L037B: cpy		#0
L037C	:=		*-1
		beq		L0383
		bne		L0385
L0381:	ldy		MUSIC__BYTE_6
L0383:	eor		#$40
L0385:	bit		MUSIC__BYTE_2
		bvc		@L0390
		bvs		@L038B
@L038B:	bpl		@L0396
		nop
		bmi		L0399
@L0390:	nop
		bmi		@L0396
		nop
		bpl		L0399
@L0396:	cmp		HW_SPEAKER
		MUSIC__SET_SOUND_DEVICE_2		:= 	*-2
L0399:	dec		MUSIC__BYTE_3
		bne		L03AE
		dec		MUSIC__BYTE_5
		bne		L03AE
		bvc		L03A6
		bit		HW_SPEAKER
		MUSIC__SET_SOUND_DEVICE_3		:= 	*-2
L03A6:	pha
		txa
		pha
		tya
		pha
		jmp		L0315
L03AE:	dex
		bne		@L03B3
		beq		L03B9
@L03B3:	cpx		#0
L03B4	:=		*-1
		beq 	L03BB
		bne 	L03BD
L03B9:	ldx 	MUSIC__BYTE_4
L03BB:	eor 	#$80
L03BD:	bvs 	L0362
		nop
		bvc 	L0365
		SYS		CB2K_SYSTEM_PANIC
MUSIC__PLAY_exit:
		bit		HW_KEYBOARD_STROBE
		rts
	.endproc		
	
	.proc TK2k
INIT:
		sta		MUSIC__SET_SOUND_DEVICE_0
		sta		MUSIC__SET_SOUND_DEVICE_1
		sta		MUSIC__SET_SOUND_DEVICE_2
		sta		MUSIC__SET_SOUND_DEVICE_3
		rts
PLAY:
		sta		@SET_MUSIC_PTR_LSB
		stx		@SET_MUSIC_PTR_MSB
		lda		#$FF		; Sets the keyboard's matrix to sense eveything (but without identifying anything)
		sta		TK2K_HW_KEYBOARD_SELECT_EXTRA_ON
		sta		TK2K_HW_KEYBOARD_SELECT_ROW
@loop:
		lda		#$0
@SET_MUSIC_PTR_LSB	:= *-1
		sta		MUSIC_PTR
		lda		#$0
@SET_MUSIC_PTR_MSB	:= *-1
		sta		MUSIC_PTR+1
		
		lda		#$01
		sta		MUSIC__BYTE_0
		sta		MUSIC__BYTE_1
		pha
		pha
		pha
		bne		L0320
L030B:	iny
		lda		(MUSIC_PTR),y
		sta		MUSIC__BYTE_0
		iny
		lda		(MUSIC_PTR),y
		sta		MUSIC__BYTE_1
L0315:	lda		MUSIC_PTR
		clc
		adc		#$03
		sta		MUSIC_PTR
		bcc		L0320
		inc		MUSIC_PTR+1
L0320:	ldy		#$00
		lda		(MUSIC_PTR),y
		cmp		#$01
		beq		L030B
		bcs		@L0337
		pla
		pla
		pla
@L032D:	ldx		#OP_EOR_imm
		iny
		lda		(MUSIC_PTR),y
		bne		@L0336
		ldx 	#OP_CMP_imm
@L0336:	rts

@L0337:	sta		MUSIC__BYTE_5
		jsr		@L032D
		stx		L0383
		sta		MUSIC__BYTE_6
		ldx		MUSIC__BYTE_0
@L0343:	lsr		a
		dex
		bne		@L0343
		sta		L037C
		jsr		@L032D
		stx		L03BB
		sta		MUSIC__BYTE_4
		ldx		MUSIC__BYTE_1
@L0354:	lsr		a
		dex
		bne		@L0354
		sta		L03B4
		pla
		tay
		pla
		tax
		pla
		bne		L0365
L0362:	bit		HW_SPEAKER
		MUSIC__SET_SOUND_DEVICE_0		:= 	*-2
L0365:	cmp		#$00
		bmi		@L036C
		nop
		bpl		L036F
@L036C:	bit		HW_SPEAKER
		MUSIC__SET_SOUND_DEVICE_1		:= 	*-2
L036F:	sta		MUSIC__BYTE_2
		pha
		lda		TK2K_HW_KEYBOARD_READ
		and		#TK2K_HW_KEYBOARD_MASK
		bne		MUSIC__PLAY_exit
		pla
		dey
		bne		@L037B
		beq		L0381
@L037B: cpy		#0
L037C	:=		*-1
		beq		L0383
		bne		L0385
L0381:	ldy		MUSIC__BYTE_6
L0383:	eor		#$40
L0385:	bit		MUSIC__BYTE_2
		bvc		@L0390
		bvs		@L038B
@L038B:	bpl		@L0396
		nop
		bmi		L0399
@L0390:	nop
		bmi		@L0396
		nop
		bpl		L0399
@L0396:	cmp		HW_SPEAKER
		MUSIC__SET_SOUND_DEVICE_2		:= 	*-2
L0399:	dec		MUSIC__BYTE_3
		bne		L03AE
		dec		MUSIC__BYTE_5
		bne		L03AE
		bvc		L03A6
		bit		HW_SPEAKER
		MUSIC__SET_SOUND_DEVICE_3		:= 	*-2
L03A6:	pha
		txa
		pha
		tya
		pha
		jmp		L0315
L03AE:	dex
		bne		@L03B3
		beq		L03B9
@L03B3:	cpx		#0
L03B4	:=		*-1
		beq 	L03BB
		bne 	L03BD
L03B9:	ldx 	MUSIC__BYTE_4
L03BB:	eor 	#$80
L03BD:	bvs 	L0362
		nop
		bvc 	L0365
		SYS		CB2K_SYSTEM_PANIC
MUSIC__PLAY_exit:
		pla		; Clean up the stack. Please note that we have to save the Acc when pooling the TK2k's keyboard.
		rts
	.endproc
	
MUSIC_INIT:
		bmi		:+
		lda		#<HW_SPEAKER
		.byte	$2C	; BIT abs. Ignores the next 2 byte instrucion
:		lda		#<HW_TAPE_OUT
		jsr		A2::INIT
		jsr		TK2k::INIT
		rts
		
MUSIC_PLAY:
		BIT		IS_APPLE2
		bpl		:+
		jmp		A2::PLAY
:		jmp		TK2k::PLAY
