        .setcpu 	"6502"
		.localchar	'@'

		.include "../hw.def"
		.include "../sys.def"
		.include "../bios.def"
		
		.include "../CB2k.def"
		.include "system.def"
		.include "electric_duet_player.def"
		
		.org $4000
		
	jsr		SYSTEM_INIT
	
	bit		IS_APPLE2
	bmi		IS_A2
	
IS_TK2K:
	jsr		KEYPRESSED
	beq		:++
	lda		#$1
	sta		TK2K_HW_KEYBOARD_SELECT_EXTRA_ON
	lda		TK2K_HW_KEYBOARD_READ
	sta		TK2K_HW_KEYBOARD_SELECT_EXTRA_OFF
	and		#$01
	beq		:+
	lda		#$80
	.byte	$2C		; BIT abs (ignora a prxima instruo de 2 bytes)
:	lda		#0
:	jsr		MUSIC_INIT	
	jmp		:+
	
IS_A2:
	lda		HW_KEYBOARD_OPENAPPLE
	ora		HW_KEYBOARD_CLOSEDAPPLE
	jsr		MUSIC_INIT
:	
	PRINT	HEADER
	dec		HEADER_line_1
	dec		HEADER_line_0
	bmi		:+
	lda		#90
	jsr		MON_WAIT
	beq		:-			; Branch always!	
:
	PRINT	TEXT
	PRINT	ANYKEY
	
	SYS		CB2K_FILE_LOAD
	lda		CB2K_FILE_ADDRESS
	ldx		CB2K_FILE_ADDRESS+1	
	jsr		MUSIC_PLAY
	
	ldy		#CB2K_HANDLER_ERROR
	lda		#<NO_RUN
	ldx		#>NO_RUN
	SYS		CB2K_HANDLER_SET
	SYS		CB2K_FILE_RUN
	
NO_RUN:
	jmp		SYSTEM_APPLESOFT_START_COLD
	
HEADER:
HEADER_line_0:
	.byte	22,0
	textz	"============ CompatiBoot 2k ============"
HEADER_line_1:
	.byte	23,0
	textz	"                                        "
	.byte	1,0,0
	.byte	-1
		
TEXT:
	.byte	2,0
	textz	"Lisias:"
	.byte	2,36
	textz	"Code"
	.byte	3,32
	textz	"Graphics"
	.byte	4,14
	textz	"Pseudo =] Operating System"
	.byte	6,0
	textz	"Max a gaZ(FR):"
	.byte	6,35
	textz	"Music"
	.byte	8,0
	textz	"Mingo:"
	.byte	8,32
	textz	"Graphics"
	.byte	10,0
	textz	"Paul Lutus:"
	.byte	10,17
	textz	"El. Duet's Sound Engine"
	.byte	12,13
	textz	"SPECIAL THANKS"
	.byte	14,0
	textz	"F.Belavenuto L.Polimeno EmersonRC et all"
	.byte	15,1
	textz	"for the time and hardware used on tests"
	.byte	17,0
	textz	"appleII_br@yahoogrupos.com.br list:"
	.byte	18,4
	textz	"for emotional and moral support! X-D"
	.byte	20,0
	textz	"Hackerforce(FR):"
	.byte	21,3
	textz	"for the source. It showed me the way."
	.byte	23,9
	textz	"MMXII - Lisias  Toledo"
	.byte	-1
	textz	"Mingo, we finally did it. This is that demo of ours we ever wanted to make..."
	
ANYKEY:
	.byte	23,0
	textz	":"
	.byte	-1
	
	.include	"system.inc"		
	.include	"electric_duet_player.inc"