        .setcpu 	"6502"
		.localchar	'@'

		.include "../hw.def"
		.include "../sys.def"
		.include "../bios.def"
		.include "../CB2k.def"
		.include "system.def"
		
		.org $4000
		
	jsr		SYSTEM_INIT
	
	ldy		#CB2K_HANDLER_ERROR
	lda		#<END_OF_CATALOG
	ldx		#>END_OF_CATALOG
	SYS		CB2K_HANDLER_SET
	
		
		lda		#0
		sta		@counter
		sec		; Keeps the drive on (used by CB2K_ENTRY_SET)		
@again:	
		SYS		CB2K_FILE_SET
		bcc		@noerror
		beq		@acabou	; Z=0. End Of Catalog.
		; If Z=1, deleted file. Ignore.
		bne		@next		; Branch always
@noerror:
		SYS		CB2K_FILE_GET
		jsr		@PRINT_FILE_ENTRY
@next:
		inc		@counter
		lda		@counter
		sec		; Keeps the drive on (used by CB2K_ENTRY_SET)
		bcs		@again
		; Branch always
@acabou:
		lda		@counter
		jsr		MON_PRBYTE
		jsr		MON_CROUT
		;		This is important to assure that drive will be off (and, perhaps in the future, some house cleaning)
		SYS		CB2K_FINISH
		jmp		END_OF_CATALOG
		
@counter:
		.byte 	0
@PRINT_FILE_ENTRY:
		jsr		MON_PRBYTE
		jsr		@collon
		
		ldy		#CB2K_FILE_TSLIST_TRACK
		lda		(CB2K_FILE),y
		jsr		MON_PRBYTE
		jsr		@collon
		
		ldy		#CB2K_FILE_TSLIST_SECTOR
		lda		(CB2K_FILE),y
		jsr		MON_PRBYTE
		jsr		@collon
		
		ldy		#CB2K_FILE_TYPE
		lda		(CB2K_FILE),y
		jsr		MON_PRBYTE
		jsr		@collon
				
		ldy		#CB2K_FILE_SECTORCOUNT+1
		lda		(CB2K_FILE),y
		jsr		MON_PRBYTE
		ldy		#CB2K_FILE_SECTORCOUNT
		lda		(CB2K_FILE),y
		jsr		MON_PRBYTE
		
		jsr		MON_CROUT
		jsr		@collon
		
		ldx		#30
		ldy		#CB2K_FILE_NAME
:		lda		(CB2K_FILE),y
		jsr		MON_COUT
		iny
		dex
		bne		:-
		
		jsr		@collon
		jsr		MON_CROUT
		jmp		MON_CROUT
		
@collon:
		lda		#':' | $80
		jsr		MON_COUT
		rts	
		
END_OF_CATALOG:
	jmp		SYSTEM_APPLESOFT_START_COLD
	
	.include	"system.inc"		
