 
;		      **** DRAFT--Not Final ****
;		         ZCPR 3.3 System TCAP
;
; Version for the Visual 50 in the Hazeltine emulation mode using
;		Escape as a lead in character.
;
; Copyright 1985, 1986 by Richard Conn, Dennis Wright, and Echelon, Inc.
;                        All Rights Reserved
;
; Note on Padding:
;		All entries which have an asterisk (like, *) following
;		their one-line explanation have delays which may be
;		variable.
; Note on Definition:
;	        If a function is not available for a particular terminal,
;               its string should be 0 and its delay should be 0 (if it has
;               a delay).
;
;
; Section 1: Basic Terminal Characteristics
;
;	YU	Single Character Generated by Uparrow Key on Keyboard
;	YD	Single Character Generated by Downarrow Key on Keyboard
;	YL	Single Character Generated by Leftarrow Key on Keyboard
;	YR	Single Character Generated by Rightarrow Key on Keyboard
;		Note: If no arrow keys or arrow keys generate more than
;		one character (like VT100), then use WordStar convention
;		for these codes: YU=^E, YD=^X, YL=^S, YR=^D
;
;	CL	Clear Screen String (has a delay which may be variable);
;		cursor is placed in home position (upper left corner) when
;		this sequence is complete
;
;	CM	Cursor Motion String (see explanation of codes in the Manual)
;
;	CE	Clear to End of Line String; cursor is left at original
;		position when this sequence is complete
;
;	SO	Begin Highlighting (Reverse Video or Dim); no character
;		positions on the screen are used by this sequence (ie, cursor
;		does not move after this sequence is complete)
;	SE	End Highlighting (return to Normal display intensity); no
;		character positions on the screen are used by this sequence
;
;	TI	Initialize Terminal String; it is preferred that nothing be
;		output to the screen by this sequence, but no output is not
;		required
;	TE	Deinitialize Terminal String; it is preferred that nothing
;		be output to the screen by this sequence
;
envor2:
	db	'Visual 50/Hazel '	; Name of Terminal (16 chars)
	db	'E'-'@'			; YU (YU = Cursor UP)
	db	'X'-'@'			; YD (YD = Cursor DOWN)
	db	'D'-'@'			; YL (YL = Cursor LEFT)
	db	'S'-'@'			; YR (YR = Cursor RIGHT)
	db	15			; CL Delay (CL = Clear Screen)*
	db	0			; CM Delay (CM = Cursor Motion)
	db	2			; CE Delay (CE = Clear to EOL)
	db	1bh,'\'-'@',0		; CL String
	db	1bh,'Q'-'@','%r%.%.',0	; CM String
	db	1bh,'O'-'@',0		; CE String
	db	1bh,'Y'-'@',0		; SO String (SO = Stand Out Mode)
	db	1bh,'_'-'@',0		; SE String (SE = End Stand Out Mode)
	db	0			; TI String (TI = Terminal Init)
	db	0			; TE String (TE = Terminal Deinit)
;
;	Section 2: Business Graphics
;
;  The following strings are used to create graphics symbols.
; If your terminal does not support business graphics, make (GO) and (GE)
; a non-zero non-printable character that has no effect on your
; terminal and use ASCII characters like '*' to replace the graphics
; characters.  Recommended character values are indicated in [], like [*].
; An alternate recommendation using '.' and ':' will be made with release
; of ZCPRB3.
;
	db	0			; GO Delay (GO = Graphics On)
	db	0			; GE Delay (GE = Graphics End)
	db	1bh,'F',0		; GO  - Graphics on string
	db	1bh,'G',0		; GE  - Graphics end string
	db	's',0			; GULC - Upper left corner [*]
	db	'l',0			; GURC - Upper right corner [*]
	db	'e',0			; GLLC - Lower left corner [*]
	db	'm',0			; GLRC - Lower right corner [*]
	db	'`',0			; GHL  - Horizontal line [-]
	db	'a',0			; GVL  - Vertical line [|]
	db	'*',0			; GFB  - Full block [*]
 	db	'#',0			; GHB  - Hashed block [#]
	db	'd',0			; GUI  - Upper intersect [+]
	db	'c',0			; GLI  - Lower intersect [+]
	db	'b',0			; GIS  - Intersection [+]
	db	'o',0			; GRTI - Right intersect [+]
	db	'n',0			; GLTI - Left intersect [+]
;
;	Section 3: Windowing
;
;     The following environmental data must be present if window 
; routines are to be used.  GCM (Graphic Character Mask) contains
; any bits that are not used by on screen graphics characters. 
; GCD (Graphics Chararacter Difference) are the bits that are 
; stripped (by the terminal) from a sent graphics character to
; form the on screen graphics character. 
;
	db	00h  			; GCM - Graphic character mask byte
	db	00h  			; GCD - Graphic char difference bit(s)
;
; The next string can be either a terminal control code or an
; address of a user supplied subroutine.  If a user supplied routine
; is to be used set the U1 address accordingly.  Remember if an
; address is placed here and both bytes of the address are 00h,
; then the RAT string will be used.  If the RAT string is null the RSP
; string will be used.  At least one of these two functions must be
; available for window routines, RAT is prefered.
;
; If a RAT user supplied routine is to be used it must return the
; characters as follows:
;
; RAT - Read character at cursor position must return the character
;       at the current cursor position in the (A) register.
;
;
 	db	1bh,'!','P'-'@',0	; RAT - Read char at current cursor
					;       position
;	db	0			; Zero if using RSP
;
; Set the following address non-zero if user supplied RAT subroutine
; is to be used.
;
	dw	0			; U1  - Use user supplied RAT routine
;
	db	0			; RSP - Read screen page
;
; If RSP is to be used the following two bytes must be defined; if not,
; make them zero.
;
 	db	00h			; ELM - End of line mark
	db	00h			; EPM - End of screen mark
;
; These bytes are the screen codes sent by the terminal at the end of
; each line (ELM) and end of page (EPM).  Some terminals like the WYSE 50
; may have graphics character codes that are the same as the ELM or EPM
; codes.  In this case an alternative graphic character must be used.
;
;	Section 4: Extended Terminal Characteristics
;	           (More to be added in banked ZCPRB3 256-byte version)
;
;	CD	Clear to End of Display; the cursor is not moved by this
;		action
;	KL	Keyboard Lock; the keys on the keyboard are made inoperative
;	KU	Keyboard Unlock; the keys on the keyboard are made operative
;
;	CDO	Cursor Display Off; Cursor is no longer displayed, no
;		character positions on the screen are used by this sequence
;	CDE	Cursor Display Enable; Cursor is displayed, no character
;		positions on the screen are used by this sequence
;
	db	10			; CD Delay (CD = Clear to End Display)*
	db	1bh,'k',0		; CD String
	db	1bh,'U'-'@',0		; KL String (KL = Keyboard Lock)
	db	1bh,'F'-'@',0		; KU String (KU = Keyboard Unlock)
	db	1bh,'m',0		; CDO String (Cursor Display Off)
	db	1bh,'X',0		; CDE String (Cursor Display Enable)
;
	ds	80H-($-envor2)		; Make exactly 80H bytes long
;
; End of ZCPR 3.3 TCAP
;
	END
