 Program Read_Dbase2;
   (*  This program will switch a DBase2 file to Pascal
            To use the program it will be required to change
            the    1)  Record description,
                   2)  File Names,
                   3)  DbaseSize  constant,   and
                   4)  Copy statements at the end of the program.

        Written by:
           Jerry Kevorkian   IBM Connection  VA Beach
                             (804) 481-1824
                             CompuServe  75236,711       *)

 Const
   DbaseSize  = 99;                (* Size of the Dbase Records *)
   InName     = 'TESTFILE.DBF';    (* Name of the Dbase2 File here *)
   OutName    = 'CLIENT.FIL';      (* Name of the Pascal File here *)
 Type
       (* The Record Description for Pascal must be
                          1
         Character Shorter than the Dbase2 Definition of that record.

         The following record was defined in DBase2 as:

               FLD       NAME      TYPE WIDTH   DEC
               001     FNAME        C    020
               002     LNAME        C    015
               003     ADDRESS      C    035
               004     CITY         C    020
               005     STATE        C    002
               006     ZIP:CODE     C    005
               007     SITE         C    001
               ** TOTAL **             00099                *)


   Dbase2Rec = Record
                 FirstName : String[20];
                 LastName  : String[15];
                 Address   : String[35];
                 City      : String[20];
                 State     : String[2];
                 ZipCode   : String[5];
                 Site      : String[1];
               end;

 Var
  Drec         : Dbase2Rec;
  Infile       : Text;
  Outfile      : File of Dbase2Rec;
  Inbuf        : String[DbaseSize];
  I            : integer;
  Ch           : Char;

Begin
 Assign(Infile,InName);
 Reset(Infile);
 Assign(Outfile,OutName);
 Rewrite(Outfile);
 For I := 1 to 522 do             (* Despose of Dbase2 Header Record *)
 Begin
   Read(Infile,Ch);
 end;
 I := 0;                          (* Keep Track of Record Count *)
 TextMode(BW80);                  (* Force Black/White..Fair for all *)
 Gotoxy(30,12);
 Write('RECORD COUNT');
 While Not Eof(Infile) do         (* Read all the Remaining as DATA *)
 Begin
   Read(Infile,Inbuf);            (* Read Records in now and write them out *)
   With Drec do
   Begin
         (* Be sure to count the Depth into Inbuf Correct!
                    ****  Be Sure to Change These for your  *****
                    ****  Record Description                ***** *)
     FirstName := Copy(Inbuf,01,20);    (*Move Field*)
     LastName  := Copy(Inbuf,21,15);    (*Move Field*)
     Address   := Copy(Inbuf,36,35);    (*Move Field*)
     City      := Copy(Inbuf,71,20);    (*Move Field*)
     State     := Copy(Inbuf,91,02);    (*Move Field*)
     ZipCode   := Copy(Inbuf,93,05);    (*Move Field*)
     Site      := Copy(Inbuf,98,01);    (*Move Field*)
   End;  (* of Mass Move *)
   Write(Outfile,Drec);            (* Write Pascal Record out now *)
   I := I + 1;
   Gotoxy(40,13);
   Write(I:8);                     (* Let the caller Know how many Written *)
 end;
 Close(Infile);
 Close(Outfile);
end.                                                                                                     