100  REM     COPYRIGHT (C) 1984 BY THOMAS E. SPEER. ALL RIGHTS RESERVED
101  REM     RELEASED TO THE PUBLIC DOMAIN FOR NON-COMMERCIAL USE ONLY.
102 REM-----------PLOT PACKAGE-------------
103 REM VARIABLES:
104 REM CX      CHARACTER SIZE
105 REM LY      LINE SIZE IN Y DIRECTION
106 REM ML      LEFT MARGIN
107 REM MR      RIGHT MARGIN
108 REM MB      BOTTOM MARGIN
109 REM MT      TOP MARGIN
110 REM NY%     NUMBER OF CHARACTERS IN Y AXIS LABELS
111 REM NX%     NUMBER OF CHARACTERS IN X AXIS LABELS
112 REM LX%     NUMBER OF LINES OF X AXIS LABELS
113 REM DX,DY   REAL INCREMENTS BETWEEN GRID TIC MARKS
114 REM XL,XR   REAL VALUES FOR ENDS OF X AXIS
115 REM YB,YT   REAL VALUES FOR ENDS OF Y AXIS
116 REM GD      PLOTTER INCREMENT BETEEN DOTS IN GRID LINES
117 REM X1,Y1   STARTING PLOTTER COORDINATES FOR LINE SEGMENTS OR STRINGS
118 REM X2,Y2   ENDING PLOTTER COORDINATES FOR LINE SEGMENTS
119 REM G1-G7   GRAPHICS PACKAGE TEMPORARY VARIABLES
120 REM GF$     FILE NAME FOR VECTOR FILE
121 REM GB$     BUFFER STRING FOR VECTOR FILE
122 REM GC$     GRAPHIC COMMAND STRING
123 REM GC%	COLOR VALUE 0=WHITE, 1-63=PATTERNED, 64-127=GREY,NEG=XOR
124 REM GL$     LABEL STRING
125 REM --------------------------------
126 REM ------------------------------------------------------------------------
127 REM !                              ^                                       !
128 REM !                              MT                                      !
129 REM !                              !                                       !
130 REM !                              V                                       !
131 REM !          --------------------------------------------------          !
132 REM !          !                                                !          !
133 REM !<--ML---->!                                                !<---MR--->!
134 REM !          !   1000 I    .    .    .    .    .    .    .    !          !
135 REM !          !        I         .         .         .         !          !
136 REM !          !        I         .         .         .         !          !
137 REM !          !    950 I    .    .    .    .    .    .    .    !          !
138 REM !          !        I         !<-->!    .         .         !          !
139 REM !          !        I         . GD      .         .         !          !
140 REM !          !    900 I    .    .    .    .    .    .    .    !          !
141 REM !          !        I         .         .         .         !          !
142 REM !          !        I         .         .         .         !          !
143 REM !          !    850 I    .    .    .    .    .    .    .    !          !
144 REM !          !        I         .         .         .         !          !
145 REM !          !        I         .         .         .         !          !
146 REM !          !    800 I=======================================!          !
147 REM !          !      10.01     10.02     10.03     10.04       !          !
148 REM !          !                                                !          !
149 REM !          --------------------------------------------------          !
150 REM !                              ^                                       !
151 REM !                              !                                       !
152 REM !                              MB                                      !
153 REM !                              !                                       !
154 REM !                              V                                       !
155 REM ------------------------------------------------------------------------
156 REM XL=10.01, XR=10.05, DX=.01, YB=800, YT=1000, DY=50
157 REM NX%=5, LX%=1, NY%=4
158 REM WHEN LX%<=0, ADDITIONAL LINES WILL BE ADDED AUTOMATICALLY TO AVOID 
159 REM OVERLAP IN THE X AXIS LABELS.
160 REM
161 REM
162  REM  SCALING & CONVERSION FUNCTIONS
163 CX=1/80:LY=1/82: REM VALUES FOR MX-80
164 GK=32767: REM CONVERSION CONSTANT FOR COORDINATES
165  DEF  FN RX(X) =  ML + NY% * CX + (1 - ML - MR - NY% * CX) * (X - XL) / (XR - XL)
166  DEF  FN RY(Y) =  MB + LX% * LY +(1 - MT - MB - LX% * LY) * (Y - YB) / (YT - YB)
167  DEF  FN UX(X) = (X - ML - NY% * CX) * (XR - XL) / (1 - ML - MR - NY% * CX) + XL
168 DEF FN UY(Y) = (Y - MB - LX% * LY) * (YT - YB)/(1 - MT - MB - LX% * LY) + YB
169 REM OPEN .VEC FILE
170 GOSUB 204
171  GOTO 277: REM  TRANSFER TO USER PROGRAM
172 REM WRITE COMMAND STRING SUBROUTINE ****************************************
173 IF LEN(GB$)+LEN(GC$)<=126 THEN 176
174 GB$=GB$+STRING$(126-LEN(GB$),"N")
175 PRINT #1, GB$: GB$=MKS$(FRE(0)):GB$=""
176 GB$=GB$+GC$: RETURN
177 REM DRAW LINE SEGMENT               ****************************************
178 GC$="D"+MKI$(INT(X1*GK))+MKI$(INT(Y1*GK))+MKI$(INT(X2*GK))+MKI$(INT(Y2*GK))
179 GOSUB 173: RETURN
180 REM PLOT POINT                      ****************************************
181 GC$="P"+MKI$(INT(X1*GK))+MKI$(INT(Y1*GK)): GOSUB 173: RETURN
182 REM PLOT INCREMENTAL SEGMENT        ****************************************
183 GC$="I"+MKI$(INT(X1*GK))+MKI$(INT(Y1*GK)): GOSUB 173: RETURN
184 REM SET COLOR CODE                  ****************************************
185 GC$="C"+LEFT$(MKI$(GC%),1)
186 GOSUB 173: RETURN
187 REM ERASE PICTURE                   ****************************************
188 GC$="C"+LEFT$(MKI$(GC%),1)+"E"
189 GOSUB 173: RETURN
190 REM PLOT PRINTED STRING             ****************************************
191 GC$="S"+MKI$(INT(X1*GK))+MKI$(INT(Y1*GK))+GL$+CHR$(13): GOSUB 173: RETURN
192 REM SEND TEXT DIRECTLY TO PRINTER	****************************************
193 GC$="T"+GL$+CHR$(0): GOSUB 173: RETURN
194 REM PLOT FILLED SEGMENT             ****************************************
195 GC$="F"+MKI$(INT(X1*GK))+MKI$(INT(Y1*GK))+MKI$(INT(X2*GK))+MKI$(INT(Y2*GK))
196 GC$=GC$+MKI$(INT(YF*GK))
197 GOSUB 173:RETURN
198 REM SEND PRINT PICTURE COMMAND      ****************************************
199 GC$="O": GOSUB 173: RETURN
200 REM QUIT PLOTTING, PRINT GRAPH      ****************************************
201 GC$="OQ":GOSUB 173
202 GB$=GB$+GC$: GB$=GB$+STRING$(126-LEN(GB$),"N")
203 PRINT #1,GB$: CLOSE #1: RETURN
204 REM OPEN NEW OUTPUT FILE            ****************************************
205 INPUT "ENTER PLOT OUTPUT FILENAME: ",GF$
206 IF INSTR(GF$,".")=0 THEN GF$=GF$+".VEC"
207 OPEN "O",#1,GF$:GB$="":GC$="C"+CHR$(0)+"EC"+CHR$(127): GOSUB 173: RETURN
208  REM  SET DEFAULT VALUES            ****************************************
209 GC%=127
210 MT = 0:MB = 0:MR = 0:ML = 0
211 XL = 0:XR = 1:YB = 0:YT = 1:DX = 1:DY = 1
212 NX% = 0:NY% = 0:LX% = 0: GD = .01
213  RETURN 
214  REM  CALCULATE GRID                ****************************************
215 G1 =  FRE (0):G1 = 1 - ML - MR - CX * NX%: REM  PLOTTER LENGTH OF X AXIS
216  IF G1 > CX THEN 218
217  PRINT "GRAPH TOO NARROW": RETURN 
218 G3 =  ABS ( FN RX(XL) -  FN RX(XL + DX)): REM  PLOTTER DX
219  IF LX% > 0 THEN 221
220 LX% = INT(NX% * CX/ G3) + 1
221 G2 = 1 - MT - MB - LY * LX%: REM  PLOTTER LENGTH OF Y AXIS
222  IF G2 > CX THEN 224
223  PRINT "GRAPH TOO SHORT": RETURN 
224  RETURN 
225  REM  DRAW GRID                     ****************************************
226 REM
227  Y1=FN RY(YB):Y2=FN RY(YT)
228  GC$="C"+CHR$(8): GOSUB 173
229  FOR G4 = XL TO XR STEP DX
230 X1 =  FN RX(G4): X2=X1
231  GOSUB 178
232 NEXT G4
233 GC$="C"+CHR$(1): GOSUB 173
234  X1=FN RX(XL):X2=FN RX(XR)
235  FOR G4 = YB TO YT STEP DY
236  Y1=FN RY(G4):Y2=Y1
237  GOSUB 178
238 NEXT G4
239  GOSUB 184: RETURN 
240 IF NX%=0 THEN GOTO 245 ELSE G6 =  FN RY(YB)
241  FOR G4 = XL TO XR STEP DX
242 G5 =  FN RX(G4)
243 X1=G5:Y1=G6:X2=G5:Y2=G6-CX:GOSUB 178
244  NEXT G4:  X1=FN RX(XR):Y1=FN RY(YB):X2=FN RX(XL): Y2=Y1: GOSUB 178
245 IF NY%=0 THEN GOTO 250 ELSE G5 =  FN RX(XL)
246  FOR G4 = YB TO YT STEP DY
247 G6 =  FN RY(G4)
248  X1=G5:Y1=G6:X2=G5-CX:Y2=G6:GOSUB 178
249  NEXT G4: X1=FN RX(XL):Y1=FN RY(YT):X2=X1: Y2=FN RY(YB): GOSUB 178
250  RETURN 
251  REM  LABEL X AXIS                  ****************************************
252 IF NX%=0 THEN RETURN ELSE G7 =  FRE (0):G7 = 0
253 G6=FN RY(YB)-2*LY
254  FOR G4 = XL TO XR STEP DX
255 G5 =  FN RX(G4):G7 = G7 + 1
256 Y1=G6- (-INT (G7 / LX%) * LX% + G7)*LY
257 X1= INT((G5-NX%*CX/2)/CX)*CX
258 GL$ = LEFT$( STR$ (G4),NX%)
259 GOSUB 191
260 NEXT G4: X1=FN RX(XR):Y1=FN RY(YB): X2=FN RX(XL): Y2=Y1: GOSUB 178
261  RETURN 
262  REM  LABEL Y AXIS                  ****************************************
263 IF NY%=0 THEN RETURN ELSE G7 =  FRE (0):G7 = 0
264 X1=ML
265  FOR G4 = YB TO YT STEP DY
266 Y1=FN RY(G4)
267 GL$ =  LEFT$( STR$ (G4), NY% )
268 GOSUB 191
269  NEXT G4: X1=FN RX(XL):Y1=FN RY(YT):X2=X1: Y2=FN RY(YB): GOSUB 178
270  RETURN 
271  REM  DO WHOLE GRID                 ****************************************
272  GOSUB 214
273  GOSUB 226
274  GOSUB 251
275  GOSUB 262
276  RETURN 
277  GOSUB 208
278 REM -------- TOP OF USER PROGRAM -------------------------------------------
280 REM     COPYRIGHT (C) 1984 BY THOMAS E. SPEER. ALL RIGHTS RESERVED
290 INPUT "Enter Maximum number of data points:",MPTS%
300 INPUT "Enter Maximum number of Variables:",MV%
310 DIM X(MPTS%,MV%),NAMES%(20,MV%),XMIN(MV%),XMAX(MV%),SYMBOL%(10,5)
320 NV%=0:NPTS%=0:SYMB%=1:X%=1:Y%=2:ATOSCALE%=-1
330 DATA 78,79,78,69,32,32,32,32,32,32
340 DATA 43,32,32,32,32,32,32,32,32,32
350 DATA 88,32,32,32,32,32,32,32,32,32
360 DATA 83,81,85,65,82,69,32,32,32,32
370 DATA 68,73,65,77,79,78,68,32,32,32
380 FOR I=1 TO 5:FOR ICHAR%=1 TO 10:READ J:SYMBOL%(ICHAR%,I)=J:NEXT ICHAR%:NEXT
390 FOR I=1 TO MV%
400 FOR ICHAR%=1 TO 20:NAMES%(ICHAR%,I)=32:NEXT ICHAR%
410 NEXT I
420 FOR I=1 TO NV%:NAMES%(1,I)=I+48:NEXT I
430 GOSUB 2180   :REM ---------------------------------- DISPLAY MENU
440 INPUT OPT%
450 IF OPT% < 1 THEN 430 ELSE IF OPT% > 35 THEN 430: REM FILTER BAD INPUTS
460 REM ------------------------------------------------- DATA SETTINGS
470 IF OPT%>1 THEN 500
480 INMODE%=NOT INMODE%
490 GOTO 430
500 IF OPT%>2 THEN 550
510 INPUT "Enter Input file Name:",INFILE$
520 CLOSE #2
530 OPEN "I",#2, INFILE$
540 GOTO 430
550 IF OPT%>3 THEN 600
560 CLOSE #3
570 INPUT "Enter Ouput file Name:",OUTFILE$
580 OPEN "O",#3,OUTFILE$
590 GOTO 430
600 IF OPT%>4 THEN 660
610 PRINT "NO.         VARIABLE NAME"
620 FOR I=1 TO NV%:PRINT I;"          ";
630 FOR ICHAR%=1 TO 20:PRINT CHR$(NAMES%(ICHAR%,I));:NEXT ICHAR%
640 PRINT:NEXT I
650 INPUT "Enter Number of Variable for X axis:",X%:GOTO 430
660 IF OPT%>5 THEN 720
670 PRINT "NO.         VARIABLE NAME"
680 FOR I=1 TO NV%:PRINT I;"       ";
690 FOR ICHAR%=1 TO 20:PRINT CHR$(NAMES%(ICHAR%,I));:NEXT ICHAR%
700 PRINT:NEXT I
710 INPUT "Enter Number of Variable for Y axis:",Y%:GOTO 430
720 IF OPT%>6 THEN 790
730 PRINT "NO.       SYMBOL"
740 FOR I=1 TO 5:PRINT I;"       ";
750 FOR ICHAR%=1 TO 10:PRINT CHR$(SYMBOL%(ICHAR%,I));:NEXT ICHAR%
760 PRINT:NEXT I
770 INPUT "Enter Number of Symbol:",SYMB%:IF SYMB%>5 THEN SYMB%=1
780 GOTO 430
790 IF OPT%>7 THEN 820
800 CONNECTED%=NOT CONNECTED%
810 GOTO 430
820 IF OPT%>8 THEN 860
830 PRINT "Actual range is from ";XMIN(X%);" to ";XMAX(X%)
840 INPUT "Enter X Min:",XL
850 GOTO 430
860 IF OPT%>9 THEN 900
870 PRINT "Actual range is from ";XMIN(X%);" to ";XMAX(X%)
880 INPUT "Enter X Max:",XR
890 GOTO 430
900 IF OPT%>10 THEN 940
910 INPUT "Enter Delta-X:",DX
920 NDX%=(XR-XL)/DX
930 GOTO 430
940 IF OPT%>11 THEN 970
950 INPUT "Enter Number of Characters in X axis Labels (incl. sign & . ):",NX%
960 GOTO 430
970 IF OPT%>12 THEN 1030
980 INPUT "Enter the approximate no. of intervals for X axis:",NDX%
990 DX=(XR-XL)/NDX%
1000 GOSUB 1980: XL=INT(XL/DX)*DX:XR=(INT(XR/DX)+1)*DX
1010 NDX%=(XR-XL)/DX
1020 GOTO 430
1030 IF OPT%>13 THEN 1070
1040 PRINT "Actual range is from ";XMIN(Y%);" to ";XMAX(Y%)
1050 INPUT "Enter Y Min:",YB
1060 GOTO 430
1070 IF OPT%>14 THEN 1110
1080 PRINT "Actual range is from ";XMIN(Y%);" to ";XMAX(Y%)
1090 INPUT "Enter Y Max:",YT
1100 GOTO 430
1110 IF OPT%>15 THEN 1150
1120 INPUT "Enter Delta-Y:",DY
1130 NDY%=(YT-YB)/DY
1140 GOTO 430
1150 IF OPT%>16 THEN 1180
1160 INPUT "Enter No. of Characters for Y axis Labels (incl. sign & . ):",NY%
1170 GOTO 430
1180 IF OPT%>17 THEN 1240
1190 INPUT "Enter approx. No. of Intervals for Y axis:",NDY%
1200 DY=(YT-YB)/NDY%
1210 GOSUB 2080:YB=INT(YB/DY)*DY:YT=(INT(YT/DY)+1)*DY
1220 NDY%=(YT-YB)/DY
1230 GOTO 430
1240 IF OPT%>18 THEN 1290
1250 INPUT "Enter Left Margin (0 => 1):",ML
1260 IF ML < 0 THEN ML=0
1270 IF ML > 1 THEN ML=1
1280 GOTO 430
1290 IF OPT%>19 THEN 1340
1300 INPUT "Enter Right Margin (0 => 1):",MR
1310 IF MR < 0 THEN MR=0
1320 IF MR > 1 THEN MR=1
1330 GOTO 430
1340 IF OPT%>20 THEN 1390
1350 INPUT "Enter Bottom Margin (0 => 1):",MB
1360 IF MB<0 THEN MB=0
1370 IF MB>1 THEN MB=1
1380 GOTO 430
1390 IF OPT%>21 THEN 1440
1400 INPUT "Enter Top Margin (0 => 1):",MT
1410 IF MT<0 THEN MT=0
1420 IF MT>1 THEN MT=1
1430 GOTO 430
1440 IF OPT%>22 THEN 1490
1450 INPUT "Enter Color Value (-127 to 127; 0=white, 127=black):",GC%
1460 IF GC%<-127 THEN GC%=127
1470 IF GC%>127 THEN GC%=127
1480 GOSUB 185: GOTO 430
1490 IF OPT%>23 THEN 1520
1500 ATOSCALE%=NOT ATOSCALE%
1510 GOTO 430
1520 IF OPT%>24 THEN 1550
1530 FILLPLT%=NOT FILLPLT%
1540 GOTO 430
1550 IF OPT%>25 THEN 1590
1560 CLOSE #1
1570 GOSUB 204
1580 GOTO 430
1590 IF OPT%>26 THEN 1630
1600 IF INMODE% THEN GOSUB 3270
1610 IF NOT INMODE% THEN GOSUB 2780
1620 GOTO 430
1630 IF OPT%>27 THEN 1660
1640 GOSUB 2930
1650 GOTO 430
1660 IF OPT%>28 THEN 1690
1670 GOSUB 3660
1680 GOTO 430
1690 IF OPT%>29 THEN 1780
1700 IF NOT FILLPLT% THEN 1720 ELSE GC2%=GC%:GC%=0:GOSUB 184
1710 X1=ML:X2=1-MR:Y1=MB:Y2=MB:YF=1-MT:GOSUB 194:GC%=GC2%:GOSUB 184
1720 IF NOT ATOSCALE% THEN 1770 ELSE XL=XMIN(X%):XR=XMAX(X%):YB=XMIN(Y%):YT=XMAX(Y%)
1730 IF NDX%=0 THEN NDX%=10
1740 IF NDY%=0 THEN NDY%=10
1750 GOSUB 1980:GOSUB 2080:XL=INT(XL/DX)*DX:XR=(INT(XR/DX)+1)*DX
1760 YB=INT(YB/DX)*DX:YT=(INT(YT/DY)+1)*DY:NDX%=(XR-XL)/DX:NDY%=(YT-YB)/DY
1770 GOSUB 271:GOTO 430
1780 IF OPT%>30 THEN 1840
1790 X1=FN RX(X(1,X%)):Y1=FN RY(X(1,Y%)):GOSUB 181:IF SYMB%>1 THEN GOSUB 2600
1800 FOR I=2 TO NPTS%:X1=FN RX(X(I,X%)):Y1=FN RY(X(I,Y%))
1810 IF CONNECTED% THEN GOSUB 183
1820 IF SYMB%>1 THEN GOSUB 2600
1830 NEXT I: GOTO 430
1840 IF OPT%>31 THEN 1890
1850 PRINT "Enter Title:":INPUT GL$
1860 PRINT "The title occupies ";LEN(GL$)*CX;" of the width of the frame."
1870 INPUT "Enter X,Y of starting coordinate for title:",X1,Y1
1880 GOSUB 191:GOTO 430
1890 IF OPT%>32 THEN 1930
1900 GOSUB 199:GC2%=GC%:GC%=0:GOSUB 188
1910 GC%=GC2%:GOSUB 185
1920 GOTO 430
1930 IF OPT%>33 THEN 430
1940 GOSUB 201
1950 GOTO 1960
1960 END
1970 REM ***********************************  X AXIS SCALE FACTORS
1980 DX=LOG((XR-XL)/NDX%)/LOG(10):DXE=INT(DX)
1990 DX=DX-DXE
2000 IF DX < .1761 THEN DX=0
2010 IF DX>=.1761 THEN IF DX < .5441 THEN DX=.30103
2020 IF DX>=.5441 THEN IF DX < .8751 THEN DX=.69897
2030 IF DX>=.8751 THEN DX=1
2040 DX=DXE+DX
2050 DX=10^DX
2060 RETURN
2070 REM ***********************************  Y AXIS SCALE FACTORS
2080 DY=LOG((YT-YB)/NDY%)/LOG(10):DYE=INT(DY)
2090 DY=DY-DYE
2100 IF DY < .1761 THEN DY=0
2110 IF DY>=.1761 THEN IF DY < .5441 THEN DY=.30103
2120 IF DY>=.5441 THEN IF DY < .8751 THEN DY=.69897
2130 IF DY>=.8751 THEN DY=1
2140 DY=DYE+DY
2150 DY=10^DY
2160 RETURN
2170 REM ***********************************  DISPLAY MENU
2180 GOSUB 3750:PRINT "DATA SETTINGS" 
2190 PRINT "No. of Variables ";NV%;
2200 PRINT TAB(35);:PRINT "No. of Points ";NPTS%
2210 PRINT "1> Data Entry ";
2220 IF INMODE% THEN PRINT "DISK"; ELSE PRINT "KEYBOARD";
2230 PRINT TAB(35);: PRINT "2> Input File ";INFILE$;
2240 PRINT TAB(35);:PRINT "3> Output File ";OUTFILE$
2250 PRINT "4> X Variable ";
2260 FOR ICHAR%=1 TO 20:PRINT CHR$(NAMES%(ICHAR%,X%));:NEXT ICHAR%
2270 PRINT TAB(35);:PRINT "5> Y Variable ";
2280 FOR ICHAR%=1 TO 20:PRINT CHR$(NAMES%(ICHAR%,Y%));:NEXT ICHAR%
2290 PRINT:PRINT "6> Symbol ";
2300 FOR ICHAR%=1 TO 10:PRINT CHR$(SYMBOL%(ICHAR%,SYMB%));:NEXT ICHAR%
2310 PRINT TAB(35);:PRINT "7> Connect points ";
2320 IF CONNECTED% THEN PRINT "TRUE" ELSE PRINT "FALSE"
2330 PRINT:PRINT "GRAPHIC SETTINGS" 
2340 PRINT "X Axis    8> Min ";XL;
2350 PRINT TAB(35);:PRINT " 9> Max ";
2360 PRINT XR;:PRINT TAB(55);:PRINT "10> DeltaX ";DX
2370 PRINT TAB(10);:PRINT "11> Label Chars";NX%;:PRINT TAB(35);
2380 PRINT "12> Divisions ";NDX%
2390 PRINT "Y Axis   13> Min ";YB;
2400 PRINT TAB(35);:PRINT "14> Max ";
2410 PRINT YT;:PRINT TAB(55);:PRINT "15> DeltaY ";DY
2420 PRINT TAB(10);:PRINT "16> Label Chars ";NY%;:PRINT TAB(35);
2430 PRINT "17> Divisions ";NDY%
2440 PRINT "Margins  18> Left ";ML;:PRINT TAB(35);:PRINT "19> Right ";MR;
2450 PRINT TAB(10);:PRINT "20> Bottom ";MB;:PRINT TAB(35);:PRINT "21> Top ";:PRINT MT
2460 PRINT "22> Color Value ";GC%;:PRINT TAB(35);
2470 PRINT "23> Auto-Scale ";:PRINT TAB(51);
2480 IF ATOSCALE% THEN PRINT "TRUE" ELSE PRINT "FALSE"
2490 PRINT "24> Clear Plot Area First ";
2500 IF FILLPLT% THEN PRINT "TRUE" ELSE PRINT "FALSE"
2510 PRINT "25> Plot Output File Name ";GF$
2520 PRINT:PRINT "ACTIONS";SPACE$(72) 
2530 PRINT "26> Read New Data";:PRINT TAB(25);:PRINT "27> Edit data";
2540 PRINT TAB(50);:PRINT "28> Write Data"
2550 PRINT "29> Plot Graph Axes";:PRINT TAB(25);:PRINT "30> Plot Data";
2560 PRINT TAB(50);:PRINT "31> Title Plot"
2570 PRINT "32> Advance Page";:PRINT TAB(25);:PRINT "33> End Program"
2580 PRINT:PRINT "Enter Number of SETTING or ACTION";SPACE$(7); 
2590 RETURN
2600 REM ******************************  PLOT SYMBOL
2610 ON SYMB% GOTO 2630,2640,2680,2720,2750
2620 SYMB%=1
2630 RETURN
2640 XSYMB=X1:YSYMB=Y1
2650 X1=XSYMB-.01:Y1=YSYMB:X2=XSYMB+.01:Y2=YSYMB:GOSUB 178
2660 X1=XSYMB:Y1=YSYMB-.01:X2=XSYMB:Y2=YSYMB+.01:GOSUB 178
2670 X1=XSYMB:Y1=YSYMB:GOSUB 181:RETURN
2680 XSYMB=X1:YSYMB=Y1
2690 X1=XSYMB-.01:Y1=YSYMB-.01:X2=XSYMB+.01:Y2=YSYMB+.01:GOSUB 178
2700 Y1=YSYMB+.01:Y2=YSYMB-.01:GOSUB 178
2710 X1=XSYMB:Y1=YSYMB:GOSUB 181:RETURN
2720 XSYMB=X1:YSYMB=Y1:X1=XSYMB-.01:Y1=YSYMB-.01:X2=X1:Y2=YSYMB+.01:GOSUB 178
2730 X1=XSYMB+.01:Y1=Y2:GOSUB 182:Y1=YSYMB-.01:GOSUB 182:X1=XSYMB-.01:GOSUB 182
2740 X1=XSYMB:Y1=YSYMB:GOSUB 181:RETURN
2750 XSYMB=X1:YSYMB=Y1:X1=XSYMB-.01:X2=XSYMB:Y2=YSYMB+.01:GOSUB 178
2760 X1=XSYMB+.01:GOSUB 182:X1=XSYMB:Y1=YSYMB-.01:GOSUB 182
2770 X1=XSYMB-.01:Y1=YSYMB:GOSUB 182:X1=XSYMB:GOSUB 181:RETURN
2780 REM ******************************************* MANUAL DATA ENTRY
2790 INPUT "Enter Number of Variables:",NV%:IF NV%>MV% THEN NV%=MV%
2800 FOR J=1 TO NV%:PRINT "Enter the Name of the ";J;"th Variable";
2810 INPUT ":",GL$:L=LEN(GL$):IF L>20 THEN L=20
2820 FOR ICHAR%=1 TO L:NAMES%(ICHAR%,J)=ASC(MID$(GL$,ICHAR%,1)):NEXT ICHAR%
2830 NEXT J
2840 GOSUB 3750:PRINT"ENTER 999 FOR ALL FIELDS TO INDICATE END OF DATA"
2850 L=1
2860 FOR I=L TO MPTS%
2870 PRINT "Enter ";NV%;" Values for the ";I;"th Record (1 at a time):"
2880 FOR J=1 TO NV%:INPUT X(I,J):NEXT J
2890 CHECK%=(X(I,1)=999):FOR J=2 TO NV%:CHECK%=CHECK% AND (X(I,J)=999):NEXT J
2900 IF CHECK% THEN GOTO 2930
2910 NPTS%=I
2920 NEXT I
2930 REM ------------------------------------------ CORRECT MISTAKES
2940 FOR L=1 TO NPTS% STEP 15
2950 GOSUB 3750;
2960 PRINT "HIT RETURN TO CONTINUE"
2970 PRINT "PT";:FOR J=1 TO NV%:PRINT TAB(J*10-5);:PRINT "X";J;:NEXT J:PRINT
2980 FOR I=L TO L+14
2990 IF I>NPTS% THEN 3080
3000 PRINT I;:FOR J=1 TO NV%:PRINT TAB(J*10-5);:PRINT X(I,J);:NEXT J:PRINT
3010 IF I>1 THEN 3030
3020 FOR J=1 TO NV%:XMIN(J)=X(I,J):XMAX(J)=X(I,J):NEXT J
3030 FOR J=1 TO NV%
3040 IF X(I,J)<XMIN(J) THEN XMIN(J)=X(I,J)
3050 IF X(I,J)>XMAX(J) THEN XMAX(J)=X(I,J)
3060 NEXT J
3070 NEXT I
3080 PRINT "Please Note Incorrect Points":INPUT A$
3090 NEXT L
3100 PRINT:INPUT"IS DATA CORRECT";Y$
3110 IF LEFT$(Y$,1)="Y" THEN RETURN
3120 IF LEFT$(Y$,1)="y" THEN RETURN
3130 INPUT "Enter Option (A> Add  D> Delete  C> Correct  Entry):",Y$
3140 IF LEFT$(Y$,1)<>"A" THEN 3160
3150 L=NPTS%+1:GOTO 2860
3160 IF LEFT$(Y$,1)<>"D" THEN 3200
3170 INPUT "Enter Line Number to be Deleted:",L
3180 NPTS%=NPTS%-1:IF L>NPTS% THEN 3240
3190 FOR I=L TO NPTS%:FOR J=1 TO NV%:X(I,J)=X(I+1,J):NEXT J:NEXT I
3200 IF LEFT$(Y$,1)<>"C" THEN 3240
3210 INPUT "Input Number of Point:",L
3220 PRINT "Enter ";NV%;" Values for the Corrected Record:"
3230 FOR J=1 TO NV%:INPUT X(L,J):NEXT J
3240 INPUT"MORE CORRECTIONS";Y$
3250 IF LEFT$(Y$,1)="Y" THEN 3130
3260 GOTO 2940
3270 REM ******************************************** DISK DATA ENTRY
3280 IF EOF(2) THEN PRINT "Null File":RETURN
3290 INPUT #2,NV%
3300 IF EOF(2) THEN PRINT "No Names":RETURN
3310 I=1
3320 LINE INPUT#2,INBUF$
3330 FOR J=1 TO NV%
3340 FOR ICHAR%=1 TO 20:NAMES%(ICHAR%,J)=32:NEXT ICHAR%
3350 IF NOT (I>LEN(INBUF$)) THEN 3400
3360 IF NOT EOF(2) THEN 3390
3370 PRINT "End of File before all Names were read"
3380 FOR I=1 TO 500:NEXT I:RETURN
3390 LINE INPUT#2,INBUF$:I=1
3400 K=INSTR(I,INBUF$,","):IF K=0 THEN K=LEN(INBUF$)+1
3410 GL$=MID$(INBUF$,I,K-I):L=LEN(GL$):IF L>20 THEN L=20
3420 FOR ICHAR% = 1 TO L:NAMES%(ICHAR%,J)=ASC(MID$(GL$,ICHAR%,1)):NEXT ICHAR%
3430 I=K+1
3440 NEXT J
3450 IF EOF(2) THEN PRINT "No Data":RETURN
3460 I=1:LINE INPUT#2,INBUF$
3470 FOR NPTS%=1 TO MPTS%
3480 FOR J=1 TO NV%
3490 IF NOT (I>LEN(INBUF$)) THEN 3540
3500 IF NOT EOF(2) THEN 3530
3510 PRINT "End of File before all Data was read"
3520 FOR I=1 TO 500:NEXT I:RETURN
3530 LINE INPUT#2,INBUF$:I=1
3540 K=INSTR(I,INBUF$,","):IF K=0 THEN K=LEN(INBUF$)+1
3550 GL$=MID$(INBUF$,I,K-I)
3560 X(NPTS%,J)=VAL(GL$)
3570 IF NPTS%=1 THEN XMIN(J)=X(1,J):XMAX(J)=X(1,J)
3580 IF X(NPTS%,J)<XMIN(J) THEN XMIN(J)=X(NPTS%,J)
3590 IF X(NPTS%,J)>XMAX(J) THEN XMAX(J)=X(NPTS%,J)
3600 I=K+1:NEXT J
3610 IF EOF(2) THEN RETURN
3620 NEXT NPTS%
3630 NPTS%=50
3640 RETURN
3650 REM ****************************************  DISK OUTPUT
3660 PRINT #3,NV%
3670 FOR J=1 TO NV%
3680 FOR ICHAR%=1 TO 20:PRINT #3,CHR$(NAMES%(ICHAR%,J));:NEXT ICHAR%:PRINT #3,""
3690 NEXT J
3700 FOR I=1 TO NPTS%
3710 PRINT #3,X(I,1);:FOR J=2 TO NV%:PRINT #3,",";X(I,J);:NEXT J
3720 PRINT #3,""
3730 NEXT I
3740 REM
3750 REM ************************************************* CLEAR SCREEN
3760 HOME
3770 RETURN
