5 REM
10 REM     TimEPROMmer Clock Read-Set Routine w/ Julian Date
13 REM 
15 REM  For the TimEPROMmer Card from Optronics Technology, 
17 REM  2990 Atlantic Avenue, Penfield, NY 14526
20 REM
30 REM  D. Mc Lanahan, POBox 17, Marlow,NH 25 Mar 83
50 REM  Julian date-time assumes TP-100 set to Universal Time (GMT)
55 REM  Julian decimals set to agree with 1-second resolution of TP-100
57 REM
60 REM  FOR 24-HOUR (MILITARY) TIME, SET MIL=8
70 REM  FOR 12-HOUR (USUAL) TIME, SET MIL=0 (NOT IMPLEMENTED)
80 ON ERROR GOTO 710
90 MIL=8
100 DIM TIME(13),W$(7)
110 DATA Sunday, Monday,Tuesday,Wednesday,Thursday,Friday,Saturday
120 FOR X=1 TO 7 : READ W$(X) : NEXT X
130 P=40 : P1=41 : REM---TP-100 Addresses- MUST match on-card switches!
140 GOSUB 550 : REM Go read clock
150 YR=TIME(1)*10+TIME(2)+1900 : REM  format data
160 MO=(TIME(3) AND 1)*10+TIME(4)
170 DA=(TIME(5) AND 3)*10+TIME(6)
180 W=TIME(7)+1
190 HR=(TIME(8) AND 3)*10+TIME(9)
200 MIN=(TIME(10) AND 7)*10+TIME(11)
210 S=(TIME(12) AND 7)*10+TIME(13)
220 D$=W$(W)
230 PRINT USING "##";MO; : REM  print date-time
240 PRINT "-";
250 PRINT USING "##";DA;
260 PRINT "-";
270 PRINT YR;
280 PRINT ",  ";
290 PRINT D$". ";
300 PRINT HR;":";MIN;":";S;" "
310 SECS=HR*3600+MIN*60+S
320 JT=SECS/86400!
330 GOSUB 400 :  REM This routine determines the Julian Date
340 OF#=2159407.5#
350 PRINT "Julian date-time is ";
360 PRINT USING "########,.#####";(X+OF#+JT)
370 PRINT ""
380 GOTO 650
390 REM ***SUBROUTINES***
400 GOSUB 490:D1=DA:M1=MO:Y1=YR:GOSUB 430:REM***TEST DATE***
410 IF D1<>DA OR M1<>MO OR Y1<>YR THEN PRINT:PRINT "INVALID DATE":GOTO 400
420 RETURN
430 Y=INT((X+60)/365.25):REM ***NUMBER TO DATE***
440 I=X-INT(Y*365.25)+120+INT(Y/100)-INT(Y/400)
450 M=INT((I-.1)/30.6):IF M<4 THEN M=M+12:Y=Y-1:GOTO 440
460 I=I-INT(M*30.6):IF M>13 THEN M=M-12:Y=Y+1
470 YR=Y+1200:MO=M-1:DA=I
480 RETURN
490 D=DA:M=MO:Y=YR-1200:REM ***DATE TO NUMBER***
500 M=M+1:IF M<=3 THEN Y=Y-1:M=M+12
510 X=INT(365.25*Y)+INT(30.6*M)+D-120-INT(Y/100)+INT(Y/400)
520 RETURN
530 GOTO 650
540 REM ****** READ DATA ****** 
550 OUT P,16 : REM  output hold bit
560 OUT P,48 : REM  output hold + read bits
570 FOR X=1 TO 13 : REM  output address & input d-t data
580 OUT P,61-X
590 TIME(X)=INP(P1) : NEXT X
600 OUT P,0 : REM  remove clock hold
610 FOR X=1 TO 13
620 TIME(X)=(TIME(X)) AND 15 : NEXT X
630 TIME(8)=TIME(8) AND 3
640 RETURN
650 PRINT"Type (1) To Display time"
660 PRINT"     (2) To Return to Basic"
670 PRINT"     (3) To set clock"
680 PRINT"     (4) To return to CP/M"
690 INPUT L
700 ON L GOTO 140,1210,790,1200
710 IF ERR=9 AND ERL=220 THEN 720
720 PRINT CHR$(7)
730 PRINT CHR$(7)
740 PRINT "TimEPROMmer either not installed, or not configured for ";HEX$(P);" Hex."
750 PRINT "Check that DIP switch 17 matches 'P' in the header of this program."
760 PRINT CHR$(7)
770 GOTO 1210
780 REM
790 REM      TimEPROM ClockSet DEMO  Routine
800 REM     ******     SET   .BAS    ****** 11-11-82
810 PRINT " TIME SET ROUTINE IN BASIC"
820 REM GET DATA
830 PRINT "ENTER DATE IN THE FORM:YR,MO,DA "
840 INPUT YR,MO,DA
850 PRINT "ENTER DAY OF THE WEEK, 0=SUN, 2=TUES, 4=THURS"
860 INPUT W
870 PRINT "ENTER 24 HR TIME AS : HR,MIN"
880 INPUT HR,MIN
890 REM PREPARE THE DATA FOR ENTRY
900 LEAP=0
910 IF ((YR MOD 4=0) AND (MO=2)) THEN LEAP=4
920 TIME(1)=INT(YR/10)
930 TIME(2)=(YR AND 15)
940 TIME(3)=INT((MO/10)+LEAP)
950 TIME(4)=(MO-10*INT(MO/10))
960 TIME(5)=INT(DA/10)
970 TIME(6)=(DA-10*INT(DA/10))
980 TIME(7)=W
990 TIME(8)=INT((HR/10)+MIL)
1000 TIME (9)=(HR-10*INT(HR/10))
1010 TIME(10)=INT(MIN/10)
1020 TIME(11)=(MIN-10*INT(MIN/10))
1030 TIME(12)=1
1040 TIME(13)=0
1050 PRINT "PUSH CR ON THE ZERO SECOND"
1060 INPUT J
1070 OUT P,16
1080 FOR X= 1 TO 14
1090 OUT P,15+X
1100 OUT P1,TIME(14-X)
1110 FOR I=1 TO 4
1120 NEXT I
1130 OUT P,79+X
1140 OUT P,79+X
1150 OUT P,15+X
1160 NEXT X
1170 OUT P,0
1180  PRINT "THE CLOCK IS SET"
1190 GOTO 140
1200 SYSTEM
1210 END
