{
      TRIGLIB.PAS CONTAINS THE FOLLOWING FUNCTIONS 
      (AS OF 1:13:82 ) :

                        TAN
                        SIGN
                        ANTITAN
                        ARCSINE
                        ARCOSINE
                        RAD2DEGREES
                        DEG2RADIANS
       
THE CONSTANT PI AND THE BOOLEAN FAILURE ARE ASSUMED TO BE GLOBAL
                                                                    }
FUNCTION TAN(X:REAL):REAL;
BEGIN
 TAN:=SIN(X)/COS(X)
END;

FUNCTION SIGN(X:REAL):INTEGER;
BEGIN
 IF X<0 THEN SIGN:=-1 ELSE SIGN:=1
END;{OF FUNCTION SIGN}

FUNCTION ANTITAN(RADIANS : REAL):REAL;

{ WRITTEN BY G.M.ACLAND
  REQUIRES DECLARATION OF 
          CONST PI = ...
          FUNCTION SIGN(X:REAL):INTEGER   
  ACCEPTS ANY REAL NUMBER AS A TAN AND RETURNS THE ARCTAN
  IN RADIANS.ONLY GIVES ANGLES IN 1ST AND 2ND QUADRANTS
     (I.E. FROM 0 TO PI RADIANS = 0 TO 180 DEGREES).
  THUS THE RESULT MAY NOT ALWAYS BE THAT EXPECTED.WHERE
  NECESSARY YOU SHOULD CONSIDER WHETHER THE ANGLE IS
  REALLY (PI + ANTITAN) I.E IN 3RD OR 4TH QUADRANT.
  AVOIDS THE PROBLEMS PASCAL/Z HAS WITH VERY LARGE OR
  NEGATIVE INPUTS TO ITS ARCTAN FUNCTION.                    }

CONST
  MAXTAN = 8388609.0;

BEGIN
  IF ABS(RADIANS)>MAXTAN THEN RADIANS:=MAXTAN*SIGN(RADIANS);
  IF RADIANS<0 THEN ANTITAN := PI-ARCTAN(ABS(RADIANS))
               ELSE ANTITAN := ARCTAN(RADIANS)
END;{FUNCTION ANTITAN}

FUNCTION ARCSINE(SINE:REAL):REAL;

{WRITTEN BY G.M.ACLAND
 REQUIRES :
           CONST PI
           VARIABLE FAILURE (A GLOBAL BOOLEAN)
           FUNCTIONS ANTITAN AND SIGN
 ACCEPTS ANY REAL NUMBER AS INPUT 
 CHECKS FOR OUT OF BOUNDS ( FAILURE WILL BE TRUE IF INPUT > 1)
 RETURNS AN ANGLE BETWEEN -(PI/2) AND +(PI/2) RADIANS 
          (I.E. -90 TO +90 DEGREES)
 THUS THE RESULT MAY NOT ALWAYS BE THAT EXPECTED : IN THAT
 CASE CONSIDER WHETHER ANGLE IS REALLY ( PI-ARCSINE )          }

BEGIN
 IF SINE > 1.0 THEN FAILURE := TRUE
 ELSE
  IF SINE = 0.0 THEN ARCSINE := 0.0
  ELSE
    IF ABS(SINE)=1.0 THEN ARCSINE := (PI/2.0)*SIGN(SINE)
    ELSE ARCSINE := (ANTITAN(ABS(SINE)/SQRT(1.0-SINE*SINE)))*SIGN(SINE)
END;{OF FUNCTION ARCSINE}


FUNCTION ARCOSINE(COSINE : REAL):REAL;

{WRITTEN BY G.M.ACLAND
 ACCEPTS ANY REAL INPUT
 CHECKS FOR OUT OF BOUNDS
 RETURNS ANGLE BETWEEN 0 AND PI RADIANS (0 TO 180 DEGREES)
 THUS "TRUE" ANGLE MAY BE ( PI + ARCOSINE )

 REQUIRES 
        PI       ( CONST = 3.1415927 )
        ANTITAN  ( FUNCTION : GMA    )
        FAILURE  ( GLOBAL BOOLEAN    )                        }
        
BEGIN
 IF COSINE > 1.0 THEN FAILURE := TRUE
 ELSE
  IF COSINE = 0.0 THEN ARCOSINE := (PI/2.0)
  ELSE 
   IF COSINE = 1.0 THEN ARCOSINE := 0.0
   ELSE 
    IF COSINE = -1.0 THEN ARCOSINE := PI
      ELSE ARCOSINE := ANTITAN((SQRT(1.0-COSINE*COSINE))/COSINE)
 END;{OF FUNCTION ARCOSINE}

FUNCTION RAD2DEGREES(ANGLE:REAL):REAL;
 BEGIN
   RAD2DEGREES:=(ANGLE*360.0)/(2.0*PI)
 END;{OF FUNCTION RAD2DEGREES}

FUNCTION DEG2RADIANS(ANGLE:REAL):REAL;
 BEGIN
   DEG2RADIANS:=(ANGLE*2.0*PI)/360.0
 END;{OF FUNCTION DEG2RADIANS}
