FUNCTION SMOOTH9(VAR INPUT_VECTOR,
			SMOOTHED	: REAL_ARRAY;
			N		: INTEGER)	: BOOLEAN;

{ COMMENT :	PERFORMS A NINE-POINT DIGITAL SMOOTHING ON THE DATA IN
  THE INPUT ARRAY CORRESPONDING TO "INPUT_VECTOR".
		THE SMOOTHED DATA ARE RETURNED IN THE ARRAY CORRESPONDING 
  TO "SMOOTHED" . IT IS POSSIBLE , WHEN USING THIS PROCEDURE , TO HAVE THE 
  SMOOTHED DATA RETURNED IN THE SAME ARRAY THEY WERE TRANSMITTED IN . THIS
  WOULD SAVE MEMORY SPACE :- A GOOD IDEA ...IF THE RAW DATA ARE EXPENDABLE.
		IF THE FUNCTION IS CALLED WITH N < 10 IT RETURNS FALSE.
		THE BOOLEAN VARIABLE OR CONSTANT "SUCCESSFUL" IS ASSUMED TO 
  BE DECLARED AT A MORE GLOBAL LEVEL AND EQUATED TO TRUE.                    }

{ WRITTEN BY G.M.ACLAND : UNIVERSITY OF PENNSYLVANIA.
  (BASED ON A SPARSE 9X9 MATRIX POINTED OUT TO ME BY MARTIN PRING.)          }

VAR
	INDEX#,OFFSET	: INTEGER;
	SUM1,SUM2,TEMP	: REAL;

BEGIN
IF N<10 THEN SMOOTH9 := NOT SUCCESSFUL ELSE BEGIN
 SMOOTH9 := SUCCESSFUL;
 FOR INDEX# := 5 TO (N-4) DO BEGIN
  SUM1 := 0;
  SUM2 := 0;
  FOR OFFSET := -4 T0 4 DO BEGIN
   TEMP := INPUT_VECTOR[INDEX# + OFFSET];
   SUM1 := SUM1 + TEMP;
   SUM2 := SUM2 + TEMP * SQR(OFFSET);
   END; { OF : FOR OFFSET ... }
  SMOOTHED[INDEX#] := ((11.8 * SUM1) - SUM2 )/46.2;
  END;  { OF : FOR INDEX# ... }
 FOR OFFSET := 1 TO 4 DO BEGIN
  SMOOTHED[OFFSET] 	     := INPUT_VECTOR[OFFSET];
  SMOOTHED[(N - OFFSET + 1)] := INPUT_VECTOR[(N - OFFSET +1)];
  END;  { OF : FOR OFFSET ... }
 END;   { OF : IF N..THEN..ELSE..}
END;    { OF : FUNCTION SMOOTH9  }
