












      SYSLIB -- An Integrated Library of Assembly Language
  Utility Subroutines for use with the Microsoft M80 Assembler

                   User's Guide for SYSLIB 2.1

                               by
                          Richard Conn




                   Revision A of User's Guide


                        30 November 1982





     Thi User' Guide i  supplemen t th SYSLI 2. Use an 
Referenc Manual date 3 Novembe 1982.








    The SYSLIB Library is Copyrighted, 1982, by Richard Conn

.he                    User's Guide for SYSLIB 2.1
.pn 1
.fo Table of Contents                             TOC - #


      SYSLIB -- An Integrated Library of Assembly Language
  Utility Subroutines for use with the Microsoft M80 Assembler

                   User's Guide for SYSLIB 2.1


                        Table of Contents

     1.0 Introduction and Purpose of the User's Guide  1
         1.01 What is SYSLIB?                          1
         1.02 SYSLIB Documentation                     2

     2.0 SYSLIB Output, Math, and Some Misc Routines   3
         2.01 Printing Stuff with SYSLIB               3
         2.02 Math with SYSLIB                        10
         2.03 Some Miscellaneous Routines             11
         2.04 The CODEND Routine                      14

     3.0 SYSLIB Input Line Editors                    16
         3.01 What Is an Input Line Editor?           16
         3.02 The BDOS-Based Input Line Editors       16
         3.03 The INLINE Input Line Editor            18
  
     4.0 SYSLIB Disk Input/Output                     19
         4.01 Directory Manipulation Routines         20
         4.02 Block-Oriented File Input/Output        28
         4.03 Byte-Oriented File Input/Output         29
         4.04 File Control Block (FCB) Manipulation   31
         4.05 ZCPR2-Specific Functions                33
               Multiple Commands and SYSLIB           36
               External Paths and SYSLIB              37
               Named Directories and SYSLIB           43

     5.0 Numeric String Evaluation, CRC Check, and
               Sort Routines                          48
         5.01 Numeric String Evaluation               48
         5.02 Cyclic Redundancy Checking              50
         5.03 The SYSLIB Sort Routines                51
   
     6.0 What is SYSLIB?  SYSLIB Overview             54
         6.01 Functional Overview of SYSLIB           54
         6.02 SYSLIB Documentation and Files and
              SYSLIB Availability                     56
         6.03 Distribution Statement for SYSLIB       57

.pn 1
.fo Alphabetical Listing of SYSLIB Routines            AList - #


      SYSLIB -- An Integrated Library of Assembly Language
  Utility Subroutines for use with the Microsoft M80 Assembler

             Alphabetical Listing of SYSLIB Routines


A    ADDHD     10   |    ANDHD     10

B    BBLINE    16   |    BIOS      11
     BDOS      11   |    BLINE     16

C    CAPS      11   |    COMPB     12   |    CRC1K     50
     CAPSTR    11   |    COMPBC    12   |    CRC1UPD   50
     CATH      11   |    COMPHD    12   |    CRCCLR    50
     CCOUT      3   |    CONDIN     4   |    CRCDONE   50
     CIN        3   |    COUT       3   |    CRCK      50
     CLOUT      3   |    CPOUT      3   |    CRCUPD    50
     CMPH      10   |    CRC1CLR   50   |    CRLF       3
     CODEND    14   |    CRC1DONE  50   |    CST        4

D    DBUFFER   20   |    DIRFS     27   |    DIRSEL    23
     DFREE     28   |    DIRLOAD   22   |    DIRSLOAD  22
     DIRALPHA  25   |    DIRNPACK  24   |    DIVHD     10
     DIRF      27   |    DIRPACK   24   |    DPARAMS   21

E    EN        11   |    EVAL16    48
     EVAL      48   |    EVAL2     48
     EVAL10    48   |    EVAL8     48

F    F$CLOSE   28   |    F$OPEN    28
     F$DELETE  28   |    F$READ    28
     F$EXIST   28   |    F$RENAME  28
     F$MAKE    28   |    F$WRITE   28
     F$MOPEN   28

     Fn$GET    30   |    FILLBC    12
     Fn$PUT    30   |    FNAME     31
     FIn$CLOSE 30   |    FOn$CLOSE 30
     FIn$OPEN  30   |    FOn$OPEN  30
     FILLB     12   |    FSIZE     28

G    GETUD     41

H    HFILB     12   |    HMOVB     12
     HFILBC    12   |    HMOVBC    12

I    INITFCB   31   |    INSTR     13
     INLINE    18

                 Listing Continued on Next Page

         Alphabetical Listing of SYSLIB Routines, Con't

L    LA2HC      6   |    LHLDC      6
     LA3DC      6   |    LOGUD     41
     LADC       6   |    LOUT       3
     LCRLF      3   |    LPRINT     4
     LHL4HC     6   |    LPSTR      4
     LHL5DC     6

M    MA2HC      9   |    MHLDC      9
     MA3DC      9   |    MOVEB     12
     MADC       9   |    MOVEBC    12
     MHL4HC     9   |    MULHD     10
     MHL5DC     9

N    NEGH      10

O    ORHD      10

P    PA2HC      6   |    PHLDC      6
     PA3DC      6   |    POUT       3
     PADC       6   |    PRINT      4
     PAUSE     11   |    PSTR       4
     PHL4HC     6   |    PUTUD     41
     PHL5DC     6

R    RETUD     41   |    RND       13
     RIN        3   |    RNDINIT   13
     ROTLH     10   |    RNDSEED   13
     ROTRH     10

S    SCANNER   13   |    SORT      52
     SHFTLH    10   |    SSBINIT   52
     SHFTRH    10   |    SUBHD     10

V    VERSION   11

X    XORHD     10

Z    ZCPRQ     43   |    ZFSTAT    43
     ZCPRSET   42   |    ZGPINS    43
     ZDNAME    45   |    ZINIEXT   40
     ZDNFIND   46   |    ZINIMC    36
     ZFNAME    46   |    ZMCPTR    36
     ZFNINIT   44   |    ZPFIND    40


.fo 1 - Introduction                                   Page #
.pn 1
      SYSLIB -- An Integrated Library of Assembly Language
  Utility Subroutines for use with the Microsoft M80 Assembler

                   User's Guide for SYSLIB 2.1

1.0  Introduction

1.01 What is SYSLIB?

     SYSLI (SYSte LIBrary i  collectio o ove 13 subrou
tine whic ar designe t provid t th CP/ 8080/Z8 assembl 
languag programme  se o function upo whic h ca buil 
hi programs  Thi librar i intende t reliev th programme 
o th tas o frequentl "reinventin th wheel an t provid 
hi wit  too environmen whic encourage structure programm
in a th assembl languag level.

     Eac subroutin withi SYSLI ca b viewe a  reliabl 
"blac box.  Th subroutine i SYSLI ar completel documente 
withi th SYSLI Use an Referenc Manua fo SYSLI  Versio 
2.1 th companio documen t thi guide an th SYSLIBx.HL 
files  Th programme i consistentl provide wit th follow
in informatio o eac subroutin withi SYSLIB:

          1.  Name of Subroutine
          2.  Function it performs
          3.  What its inputs are
          4.  What its outputs are
          5.  What registers are affected by it
          6.  What other library routines it calls upon
          7.  What errors can occur and how it handles them

     Th routine withi SYSLI ar designe t wor togethe an 
complemen eac other  Paramete passin i consisten betwee 
th variou subroutines  Fo instance al routine whic nee 
t b passe  pointe t  Fil Contro Bloc ar passe tha 
pointe i th D registe pair  Also a  genera rule i  
registe i no returne a a outpu fro th SYSLI subroutine 
the it valu i no affecte (i ha th sam valu whe th 
routine is exited as it had when the routine was called).

     SYSLI  itsel i  librar o relocatabl objec module 
create i th Microsof M8 relocatabl objec format  Al 
subroutine withi SYSLI ar groupe withi functionally-relate 
modules  Onc  routin i reference (b th EX statemen i 
th M8 assembl languag program) it modul i loade an i 
i availabl t th programme b mean o  simpl subroutin 
call  Al othe subroutine withi tha particula modul ar 
als loaded bu the ar no availabl t th programme unles 
h ha als reference the b EX statements  Th modul i 
loade onl once regardles o ho man routine withi th 
modul ar referenced  Fo thi reason  hav designe eac 
modul t contai routine whic ar frequentl use togethe o 
ar calle b eac othe (on routin withi th modul call 
anothe routin withi th module).
1.02 SYSLIB Documentation

     Th followin document ar associate wit SYSLI --

           SYSLI Use an Referenc Manua fo SYSLI Version
               2.1 b Richar Conn 3 Novembe 1982, 112+ pages
               (I occasionally refer to this as SYSLIB User and
                Reference Manual)

            User' Guid fo SYSLI 2.1 b Richar Conn 3 
               November 1982, 57+ pages

          o  SYSLIBx.HLP files by Richard Conn
               (SYSLIB.HLP, SYSLIB1.HLP-SYSLIB9.HLP,
                SYSLIBA.HLP-SYSLIBC.HLP)

     Th SYSLI Use an Referenc Manua fo SYSLI Versio 2.1  
i divide int 2 chapters  Thi documen provide a intro
ductio t SYSLIB explainin wha i i an wha i buy th 
user an the proceed t describ al o th SYSLI  subrou
tines groupe b function i detail  Th las chapte contain 
seve sampl program whic us SYSLIB an i show th sourc 
listin o thes programs th assembl process an run o th 
programs.

     Th SYSLIBx.HLР file ar intende t b use a onlin 
referenc manual fo SYSLIB  Th HEL comman give th use 
acces t th content o th HL file i a indexe manner s 
th use ma quickl identif th routin h need an determin 
ho t us it  Th informatio i th SYSLI Use an Referenc 
Manua fo SYSLI Versio 2.1 o th SYSLI subroutine i dup
licate i thes HL files.

     Thi i th User' Guid fo SYSLI 2.1  I i designe t 
b use a a instructiona supplemen t th SYSLI  Use an 
Referenc Manua fo SYSLI Versio 2.1  Th Referenc Manua 
present th "har facts o th SYSLI subroutines an thi 
User' Guid present th philosoph behin th desig o th 
SYSLI subroutine an a explanatio o ho the ar intende t 
interac wit eac othe an wor togethe t provid  flexible 
powerfu too se fo th assembl languag programmer  Th 
Referenc Manua i jus tha --  boo t refe t i orde t 
answe specifi question abou th detail o th SYSLI  rou
tines  Th User' Guide o th othe hand i  tutorial.




.fo 2 - SYSLIB Output, Math, and Some Misc Routines    Page #

2.0 SYSLIB Output, Math, and Some Misc Routines

2.01 Printing Stuff Using SYSLIB

      pai o SYSLI Subroutine perfor  simpl functio fo 
th programme an hav n ne effec o an register whatso
ever  Hence the ca b use a wil withou an concer what
soeve o sid effects  Thi pai o routine includes:

          o CRLF   -- Output CR LF to the Console
          o LCRLF  -- Output CR LF to the LST: Device

     Th pai o SYSLI Subroutine jus discusse i probabl 
th simples o th entir library  Nex t the i complexit 
ar th singl characte input/outpu routines:

          o CIN     -- Input Character from Console in A
          o RIN     -- Input Character from Reader in A

          o COUT    -- Output Character in A to Console
          o LOUT    -- Output Character in A to LST: Device
          o POUT    -- Output Character in A to PUN: Device

          o CCOUT   -- Output Character in A to Console with
                         Control Character Processing
          o CLOUT   -- Output Character in A to LST: Device with
                         Control Character Processing
          o CPOUT   -- Output Character in A to PUN: Device with
                         Control Character Processing

     Not tha thes routines lik al SYSLI  subroutines 
perfor exactl th functio a documente an nothin else  
CIN fo example onl input  character an doe no ech thi 
character.  To input and then echo a character, a sequence like

          CALL CIN  ; input ch
          CALL COUT ; echo ch

woul b used  Onl th  registe i affecte b th inpu 
routines an n registe i affecte b th outpu routines.

     Th outpu routine ca outpu character wit o withou 
contro characte processing  Th routine whic proces contro 
character wil outpu character lik control- (binar 3 a ^ 
an th routine whic d no d suc processin woul outpu th 
exact binary code.


     Th Consol Statu routine CST return th statu o th 
consol i registe A sayin i  ke ha bee presse o not  
I dat i available A=0  I woul typicall b use a 
follows:

          CALL CST  ; get status
          ORA  A    ; see if A=0
          JNZ  NOIN ; routine to process if no input
          CALL CIN  ; get character and process

     Th堠 Conditiona Inpu routine CONDIN provide th 
function jus describe i  somewha simple an mor usefu 
form  CONDIΠ wil sampl th consol inpu an retur th 
characte i on i availabl wit  fla sayin tha  characte 
i returned  I  characte i no available CONDI wil simpl 
retur wit th appropriat flag  Th sam routin implemente 
using CONDIN looks like this:

          CALL CONDIN    ; get conditional input
          JZ   NOIN      ; routine to process if no input
          ...            ; process char in A from CONDIN

     A th reade ca see w alread hav take  nic ste 
forwar fro conventiona assembl languag programmin withou 
th us o  librar lik SYSLIB   thin tha simpl character-
oriente input/outpu i handle nicel now an th nex logica 
ste i t outpu  grou o character easily  Thi i don b 
the print routines:

          o PRINT   -- Print String Pointed to by Return Address
                         on Console
          o LPRINT  -- Print String Pointed to by Return Address
                         on LST: Device

          o PSTR    -- Print String Pointed to by HL on Console
           LPST   -- Prin Strin Pointe t b H o LST 
                         Device

     Thi i th firs introductio o th concep o  string  
I th SYSLI terminology  string i  sequenc o character 
terminate b  binar 0  Th programme coul defin  strin 
i th followin ways:

          DB   'This is a string',0
          DB   0dh,0ah,'This is another string',0dh,0ah,0

     PRINԠ an LPRIN prin string pointe t b thei retur 
addresses an the retur t th byt followin th strin the 
just printed.  They would typically be used as follows:

          CALL PRINT     ; Print the following string
          DB   'This is a test',0
          ...            ; Continue processing

     PSTҠ an LPSTҠ requir tha H point t  vali strin 
before they are called.  An example of the use of PSTR is:

          LXI  H,MYNAME  ; point to string
          CALL PSTR      ; print it
          ...            ; continue processing
MYNAME:   DB   'Rick',0  ; string to be printed

     Warning  PST an LPST affec th H registe pair  Upo 
exit H̠ point t th byt followin th indicate strings  
Thes routine wer designe i thi wa t easil allo 
successive calls to them to print one string after another:

          LXI  H,LIST    ; point to first string
          MVI  B,0       ; init counter
LOOP:     MOV  A,M       ; get first character
          OR            chec t se i lis en (nex ch=0)
          JZ   DONE      ; continue processing
          INR  B         ; increment count
          MOV  A,B       ; get count
          CALL PADC      ; print number
          MVI  A,' '     ; print space
          CALL COUT
          CALL PSTR      ; print string
          CALL CRLF      ; print new line
          JMP  LOOP      ; continue until end of list
DONE:                    ; continue processing
          ...
LIST:
          DB   'Rick',0       ; first name in list
          DB   'Olivia',0     ; second name in list
          DB   'Carolyn',0    ; third name in list
          DB   0         ; end of list

     The output from this code segment will be:

  1 Rick
  2 Olivia
  3 Carolyn

     Thi exampl i intende t driv severa ke point hom t 
the reader:
          1  SYSLI routine ar designe t perfor  functio 
an hav minima sid effects  Not tha th  registe i use 
a  counte i thi routine an  don' sav i anywhere  Non 
of these SYSLIB routines have any effect on B.
          2  SYSLI routine ar designe t b cohesive  The 
"bon together t for  functiona modul an ma b calle on 
after the other to collectively provide a function for the user.
          3  SYSLI  ha bee designe t eliminat  lo o 
overhea i assembl languag programming  Imagin ho muc mor 
o  programmin tas i woul b i yo ha t writ th PAD 
(Print A as Decimal Characters with Leading Spaces) routine.

     Which leads us into the next set of routines ...
      numbe o SYSLI routine ar designe t outpu number 
t th user  Bot 8-bi number an 16-bi number ma b 
output an i al cases th  registe contain th 8-bi 
numbe t outpu an th H registe pai contain th 16-bi 
number to output.  These routines are:

          o PADC, LADC        -- Print the number in the A
                                   register as up to 3 digits in
            PADC = Print           a 3-character field.  If 3
                   A as            significant digits are not
                   Decimal         required (there are leading
                   Characters      zeroes), print spaces in their
            LADC = List            places.  PADC prints to the
                   A as D.C.       Console, LADC prints to the
                                   LST: Device

          o PA3DC, LA3DC      -- Like PADC and LADC, but print
                                   3 digits, including the
            PA3DC = Print          leading zeroes
                    A as
                    3
                    Decimal
                    Characters

          o PA2HC, LA2HC      -- Like PA3DC and LA3DC, but print
                                   2 hexadecimal digits,
            PA2HC = Print          including the leading zeroes
                    A as
                    2
                    Hexadecimal
                    Characters

          o PHLDC, LHLDC      -- Print the number in the HL
                                   register pair as up to 5
            PHLDC = Print          digits in a 5-character
                    H and          field.  If 5 significant
                    L as           digits are not required
                    Decimal        (there are leading zeroes),
                    Characters     print spaces in their places.
                                   PHLDC prints to the Console,
                                   LHLDC prints to the LST:
                                   Device

          o PHL5DC, LHL5DC    -- Like PHLDC and LHLDC, but
                                   print 5 digits, including
            PHL5DC = Print         the leading zeroes
                     HL as
                     5 D.C.

          o PHL4HC, LHL5HC    -- Like PHL5DC and LHL5DC, but
                                   print 4 hexadecimal digits,
            PHL4HC = Print         including the leading zeroes
                     HL as
                     4 Hex Chars

     Non o thes prin routine hav an effect o an 
registers  Yo ma us the freel t prin ou values  Th 
followin table provid example o wha output woul loo lik 
from these routines:


                      8-Bit Numeric Outputs

A Register     PADC, LADC     PA3DC, LA3DC   PA2HC, LA2HC
----------     ----------     ------------   ------------
     0            __0             000             00
    16            _16             016             10
   100            100             100             64
   255            255             255             FF



                     16-Bit Numeric Outputs

HL Register    PHLDC, LHLDC   PHL5DC, LHL5DC   PHL4HC, LHL4HC
-----------    ------------   --------------   --------------
       0           ____0          00000             0000
      16           ___16          00016             0010
     100           __100          00100             0064
     256           __256          00256             0100
    4096           _4096          04096             1000
   16536           16536          16536             4000

Note: _ denotes a space.



     This sample code segment:

          LXI  H,100     ; set value

          CALL PRINT     ; print text
          DB   'HL = ',0

          CALL PHLDC     ; print HL as decimal chars

          CALL PRINT     ; print more text
          DB   ' Decimal or ',0

          CALL PHL4HC    ; print HL as hexadecimal chars

          CALL PRINT     ; print ending text
          DB   ' Hexadecimal',0

          ...

prints this text:

HL_=___100_Decimal_or_0064_Hexadecimal

     (Note: _ denotes a space)

     Th reade ca se tha SYSLI come throug again makin 
th jo nic an easy  Not tha H i NOԠ AFFECTEĠ b th 
numeri prin routine (PHLDC PHL4HC o b th strin prin 
routin (PRINT)  Fo tha matter N registe i affecte b th 
calls to these routines.

     Thi example lik th previou example i intende t 
driv severa ke point hom t th reader:

          1  SYSLI routine ar designe t perfor  functio 
an hav minima sid effects

          2  SYSLI routine ar designe t b cohesive  The 
"bon together t for  functiona modul an ma b calle on 
after the other to collectively provide a function for the user.

          3  SYSLI  ha bee designe t eliminat  lo o 
overhea i assembl languag programming

          4  SYSLI  routine ar frequentl name t serv a 
mnemoni aid i orde t hel th programme remembe wha th 
routin does.


     Flexibilit i  ke wor fo SYSLIB an on goo questio 
t as i wha capabilit doe SYSLI giv m t outpu m num
ber i an wa  desir (lik H a u t  decima character 
instea o 5)  Th nex se o routine solve thi problem:

          o MADC    -- Place up to 3 ASCII digit characters
                         into memory which represent the number
          MADC = Memory  in the A register and use leading
                 (store) spaces.  The first byte of a three-
                 A as    byte memory buffer is pointed to by
                 Dec     the DE register pair.
                 Chars

          o MA3DC   -- Like MADC, but including leading zeroes

          o MA2HC   -- Like MA3DC, but hexadecimal digits

          o MHLDC   -- 5 ASCII digits characters stored in
                         memory to represent the value in HL

          o MHL5DC  -- Like MHLDC, but including leading zeroes

          o MHL4HC  -- Like MHL5DC, but hexadecimal digits


     Note  DŠ i affecte b thes routines  O entry D 
point t th firs byt o th buffe use t stor th desire 
characters and o exit D point t th firs byt afte th 
las characte stored  Thes routine ar se u thi wa s 
tha whol string o tex ca b sequentiall store i memor 
with some ease.

     Sample Code:

          LXI  D,NUM3    ; 3-byte buffer
          MVI  A,10      ; Number 10
          CALL MADC      ; Store in Buffer
          LXI  H,400     ; Number 400
          CALL MHLDC     ; Store in 5-byte buffer
          ...
NUM3:     DS   3         ; reserve 3 bytes
NUM5:     DS   5         ; reserve 5 bytes

     Results:

               Address   ASCII Char     Address   ASCII Char
               -------   ----------     -------   ----------
               NUM3        (space)      NUM5        (space)
               NUM3+1         1         NUM5+1      (space)
               NUM3+2         0         NUM5+2         4
                                        NUM5+3         0
                                        NUM5+4         0

2.02 Math with SYSLIB

     Mat function ar particularl eas wit SYSLIB  SYSLI 
contain  whol modul o 16-bi mat function whic wor wit 
jus th H registe pai i onl on argumen i require o th 
H an D registe pair i tw argument ar necessary  I al 
cases, the HL register pair contains the final result.

     Followin th genera philosoph o th SYSLI  routines 
thes mat function affec ONL th H registe pai an hav n 
effec o an othe registers includin th  registe an th 
condition code flags, unless so noted.

     The math functions provided in SYSLIB are:

          o ADDHD   HL = HL + DE
          o SUBHD   HL = HL - DE
          o MULHD   HL = HL * DE
          o DIVHD   HL = HL / DE

          o NEGH    HL = 2's Complement of HL
          o CMPH    HL = 1's Complement of HL

          o ANDHD   HL = HL (Logical AND) DE
          o ORHD    HL = HL (Logical OR) DE
          o XORHD   HL = HL (Logical XOR) DE

          o ROTLH   HL is Rotated Left one Bit
                         The old MSB is rotated into the LSB
          o ROTRH   HL is Rotated Right one Bit
                         The old LSB is rotated into the MSB
          o SHFTLH  HL is Shifted Left one Bit
                         The LSB becomes 0
          o SHFTRH  HL is Shifted Right one Bit
                         The MSB becomes 0

     Note  MS  an LS refe t Mos Significan Bi an Leas 
Significant Bit, resp.

     Note  Erro Condition ar handle i  logica manner  
Th complet description o thes routine foun i th Use an 
Referenc Manua an th SYSLIBx.HL file exactl stat wha th 
error conditions and return codes are.


2.03 Some Miscellaneous Routines

     Some miscellaneous routines contained within SYSLIB include:

           BDO an BIO -- routine t allo th SYSLI 
               programme t directl acces th CP/ BDO o 
               BIOS with minimum effect on the registers

          o CAPS -- capitalize the character in the A register;
               if a <= A reg <= z, then the capital is returned,
               else no change; the Most Significant Bit of A is
               masked out in this process and ignored

          o CAPSTR -- capitalize the string pointed to by HL
               in place:

                    LXI  H,CSTR    ; point to string
                    CALL CAPSTR    ; capitalize it
                    ...
               CSTR: DB  'test',0  ; initial string

               results in:

               CSTR: DB  'TEST',0  ; resulting string


          o CATH -- Convert ASCII to Hexadecimal; if the
               register A contains any one of the following
               ASCII characters

                    '0'-'9', 'A'-'F', 'a'-'f'

               the representative hexadecimal value (binary
               0-F) is returned in A; if an error occurs,
               the number 20 Hex is returned

          o EN -- Exchange Nybbles in the A register; the
               low-order 4 bits of A are switched with the
               high-order 4 bits of A

          o VERSION -- Return the Version Number of SYSLIB
               in the HL register pair

          o PAUSE -- Delay so many tenths of a second; inputs
               to this routine are the number of 1/10 secs
               to delay in HL and the speed of your processor
               in B


          o FILL Routines -- These routines serve to fill
               an area of memory pointed to by HL with a
               constant byte value contained in the A
               register; no registers are affected by
               FILLB and FILLBC, and only HL is affected
               by HFILB and HFILBC; the FILL Routines are:

                    FILLB -- number of bytes to fill
                         is in the B register
                    FILLBC -- number of bytes to fill
                         is in the BC register pair
                    HFILB -- like FILLB, but HL is
                         affected, and HL points to
                         the byte following the last
                         byte filled when done
                    HFILBC -- like FILLBC, but HL is
                         affected as in HFILB

          o MOVE Routines -- These routines copy a block of
               memory starting at the address contained in
               HL to another place in memory starting at the
               address contained in DE; these routines auto-
               matically determine if the move is forwards
               or backwards and compensate for any overlap;
               no registers are affected by MOVEB and MOVEBC,
               and HL and DE are affected by HMOVB and HMOVBC;
               the MOVE Routines are:

                    MOVEB -- number of bytes to move in
                         the B register
                    MOVEBC -- number of bytes to move in
                         the BC register pair
                    HMOVB -- like MOVEB, but HL and DE are
                         affected, pointing to after the
                         last byte copied in each block
                    HMOVBC -- like MOVEBC, but HL and DE
                         are affected as in HMOVB

          o Compare Routines -- These routines are used for
               various types of comparisons, including simple
               HL-to-DE comparison, fixed-length byte compare,
               and subgroup comparisons.  The compare routines
               are:
                    COMPHD -- Compare HL to DE; on return,
                         Zero Flag Set means HL=DE, Carry
                         Flag Set means HL<DE
                    COMPB and COMPBC -- Compare the group
                         of bytes pointed to by HL to the
                         group of bytes pointed to by DE;
                         the groups are of equal length,
                         being B bytes long for COMPB and
                         BC bytes long for COMPBC; on return,
                         Zero Flag Set means (HL)=(DE),
                         Carry Flag Set means (HL)<(DE)
                    SCANNER -- Scan the group of bytes
                         pointed to by HL to see if it
                         contains the group of bytes
                         pointed to by DE; the HL group
                         is B bytes long, and the DE
                         group is C bytes long; if found,
                         HL points to first byte of sub-
                         group and Zero Flag is Set (Z); if not
                         found, Zero Flag is Clear (NZ) and HL
                         is not affected
                    INSTR -- Scan the string pointed to by
                         HL for the string pointed to by DE;
                         if found, Zero Flag is Set (Z) and
                         HL points to first byte of substring

          o Random Number Generator Routines -- Two routines
               ar provide t initializ th SYSLI rando num-
               be generato an on routin return a 8-bi 
               rando numbe fro th generator.  These routines
               are:
                    RNDINIT -- Enters a counting loop and waits
                         for a keypress from the user.  The count
                         value at the keypress sets the random
                         seed.
                    RNDSEED -- Allows the programmer to provide
                         a seed value.  This is input in the A
                         register.
                    RND -- Returns a random number in the A
                         register, and uses this number as the
                         seed value for the next call to RND.



2.04 The CODEND Routine

     Ther ar man time whe i i necessar t kno wher you 
progra an dat area en an th beginnin o th scratc are 
whic extend fro th en o you program/dat area t th en 
o th Transien Progra Are (TPA i located  Th followin i 
 memor ma o th situatio described:

          Top of Memory       --------------------------
                              |  CP/M BIOS and Buffers |
                              --------------------------
                              |  CP/M BDOS             |
                            / --------------------------
                           /  |  CP/M CCP              |
                          /   --------------------------
                          T   |  Unused Memory Space   |
                          P   |  above your program    |
                          A   |  and its data areas    |
                          \   |    ----------------    |
                           \  |  Your Program          |
          100H              \ --------------------------
                              |  CP/M Buffers and JMPs |
          Bottom of Memory    --------------------------


     Th routin CODENĠ i SYSLI provide yo wit th en 
addres o you program/dat area an th beginnin o th 
Unuse Memor Spac diagramme above  CODEN i  routin locat
e i th SCODE modul o SYSLIB an thi modul i ALWAY th 
las modul i th library  Durin th linkin process SYSLI 
i t b th las librar specifie t L8 fo th link and 
sinc SCODE i th las modul i SYSLIB i th CODEN routin 
i reference b th program the i wil b loaded an i wil 
ALWAYӠ b th las subroutin i you program  CODENĠ simpl 
return th addres o th nex pag followin th las byt o 
code.

     Diagrammatically, the situation described looks like this:

          End of BDOS         --------------------------
                              | BDOS                   |
          Start of BDOS/      --------------------------
            End of Scratch    | Scratch Space for your |
                              | work area, as desired  |
     -->  Next Page After Pgm --------------------------
     |                        | Dead Space (Not Used)  |
     |    End of Your Program --------------------------
     |                        | CODEND Routine         |
     |                        --------------------------
     CODEND Returns This      | Other SYSLIB Routines  |
     Address                  --------------------------
                              | Your Program Code      |
          100H                --------------------------


     A i th norma CP/ environment th bas o th BDO ca 
b determine b loadin th addres o th BDO cal a locatio 
5 into HL:

          LHLD 6    ; load address of BDOS call

Note  A locatio  i  CAL instructio (CAL Address) s th 
desire Addres i a location  an 7 low-orde byt a 
location 6.

     CODENĠ ca b use t determin th star o th scratc 
area s th followin cod segmen illustrate  techniqu t 
determine the size of the scratch area.

     ;
     ;  SYSLIB EXTERNAL REFERENCES -- NOTE THAT ORDER OF THESE
     ;  EXT PSEUDO-OPS IS NOT IMPORTANT
     ;
               EXT  CODEND    ; CODEND ROUTINE
               EXT  SUBHD     ; HL=HL-DE
               EXT  PRINT     ; PRINT STRING
               EXT  PHLDC     ; PRINT HL AS UP TO 5 DEC CHARS
               ...
     ENTRY     EQU  5         ; BDOS ENTRY CALL
               ...
               CALL CODEND    ; GET ADDRESS IN HL
               XCHG           ; ... ADDRESS IN DE
               LHLD ENTRY+1   ; GET ADDRESS OF BDOS BASE
               MVI  L,0       ; SET ON PAGE BOUNDARY
               CALL SUBHD     ; HL=HL-DE (SIZE OF SCRATCH AREA)
               CALL PRINT
               DB   'The size of the scratch area is ',0
               CALL PHLDC     ; PRINT IN DECIMAL
               CALL PRINT
               DB   ' bytes',0
               ...

.fo 3 - SYSLIB Input Line Editors                      Page #

3.0 SYSLIB Input Line Editors

3.01 What is an Input Line Editor?

     A Inpu Lin Edito i  routin whic i ver fundamenta 
t mos user-interactiv program an timesharin o dedicate 
operatin systems  Thi routin ca b calle b a application 
progra an allo th use t ente  lin o tex (whic i wh 
ɠ cal i  line edito a oppose t  fil editor an correc 
hi typin mistake a h goes.

     CP/͠ provide th use wit a inpu lin edito whic ma 
b calle b BDO Functio 10  Thi inpu lin edito i use b 
th CP/ Consol Comman Processo (CCP itself an i come 
int pla whe th A (o whateve disk promp appears  Whe 
th use type hi CP/ command h i withi th BDO inpu lin 
editor and a th reade i probabl wel aware h ha th 
abilit t delet th previou character eras th whol lin 
an star ove again retyp th lin a entere s far an s 
on.

     Thi i  ver importan kin o function and SYSLI con
tain thre subroutine whic serv a inpu lin editors  Tw 
o them BLIN an BBLINE tur aroun an cal th BDO inpu 
lin edito an mainl serv a  shel aroun th BDOӠ inpu 
lin edito whic preserve register an set u buffers  Th 
thir inpu lin editor INLINE i  complet inpu lin edito 
i it ow right an i i intende t b use whe securit i 
important.


3.02 The BDOS-Based Input Line Editors

     Th tw BDOS-Base inpu lin editor i SYSLI ar BLIN 
an BBLINE  The diffe mainl i th wa the handl buffers 
and i bot cases the retur wit H pointin t th firs 
characte o th strin inpu b th use an th  registe 
containin  coun o th numbe o character type (no 
countin th endin zero)  Not tha H i returne a  strin 
pointer an th inpu lin i store a  NULL-terminate strin 
of characters in the standard SYSLIB sense.

     BBLINŠ contain  200-byt buffe internall i whic th 
lin t b inpu i stored  Thi i probabl th mos frequentl 
use o th SYSLI inpu lin editor sinc i i s simpl t 
use  It onl inpu i  fla i th  registe -- i  i 0 
th inpu lin i no capitalized an i  i no 0 th inpu 
lin i capitalized.  Example:


               EXT  BBLINE    ; Reference BBLINE
               EXT  PRINT     ; PRINT STRING ROUTINE
               EX  PST       PRIN STRIN PTE T B HL
               ...
               CALL PRINT
               DB   'What Is Your Name? ',0
               XRA  A         ; A=0 SO DON'T CAPITALIZE LINE
               CALL BBLINE    ; GET LINE FROM USER
                              ; ON RETURN, HL PTS TO FIRST CHAR
                              ;   AND A IS NUMBER OF CHARS TYPED
               CALL PRINT
               DB   0DH,0AH   ; NEW LINE
               DB   'Your Name is: ',0
               CALL PSTR      ; PRINT STRING PTED TO BY HL
                              ; ... HL WAS SET BY BBLINE
               ...


     Th BLIN routin i simila t BBLINE wit th on differ
enc tha th use provide a externa buffer  Th onl advant
ag o BLIN ove BBLIN i tha i i smalle (doe no contai 
tha 200-byt buffer) bu wit BLIN th programme ha t worr 
abou allocatin buffe space  Th sam progra usin BLINE:

               EXT  BLINE     ; Reference BLINE
               EXT  PRINT     ; PRINT STRING ROUTINE
               EX  PST       PRIN STRIN PTE T B HL
               ...
               CALL PRINT
               DB   'What Is Your Name? ',0
               XRA  A         ; A=0 SO DON'T CAPITALIZE LINE
               LXI  H,INLINE  ; PT TO BUFFER
               CALL BLINE     ; GET LINE FROM USER
                              ; ON RETURN, HL PTS TO BUFF AND
                              ;   A IS NUMBER OF CHARS TYPED
               CALL PRINT
               DB   0DH,0AH   ; NEW LINE
               DB   'Your Name is: ',0
               CALL PSTR      ; PRINT STRING PTED TO BY HL
                              ; ... HL WAS SET BY BBLINE
               ...
     INLINE:   DB   40        ; SIZE OF BUFFER
               DB   0         ; RETURNED SIZE OF LINE
     BUFF:     DS   41        ; BUFFER SPACE + 1 FOR ENDING 0



3.03 The INLINE Input Line Editor

     INLINE a mentione earlier i intende t b use fo 
secur applications  I ha tw ke feature whic com int 
play for such applications:

          1  INLIN canno b aborte b ^C th ^ i simpl 
stored in the input line buffer if the user types it

          2  INLINŠ ca b mad t ech it inpu o no ech 
it input i somethin lik  passwor i bein entered the i 
may be desirable not to echo the password back to the user


     INLINŠ doe no perfor optiona capitalizatio lik th 
othe two and i capitalizatio i required th CAPST routin 
ca b use immediatel afte th cal t INLIN t correc thi 
problem.

     A  tradeoff INLIN take u mor spac tha eithe BLIN 
o BBLINE an th use stil ha t provid a externa buffer  
INLIN wil no permi mor tha 25 character t b stored s 
the buffer size should generally be 256+1 for the ending 0.

     Fo inputs INLIN require H t poin t th firs byt o 
th buffe an  t contai   i n ech i desire o no  i 
ech i desired  Not tha INLIN require H t poin t th 
firs byt o th buffe itself an NO  buffe siz value  
Th exampl abov implemente wit INLIN look lik this:

               EXT  INLINE    ; Reference INLINE
               EXT  PRINT     ; PRINT STRING ROUTINE
               EX  PST       PRIN STRIN PTE T B HL
               ...
               CALL PRINT
               DB   'What Is Your Password? ',0
               XRA  A         ; A=0 SO DON'T ECHO USER INPUT
               LXI  H,BUFF    ; PT TO BUFFER
               CALL INLINE    ; GET LINE FROM USER
                              ; ON RETURN, HL PTS TO BUFF
               CALL CAPSTR    ; CAPITALIZE INPUT STRING
               CALL PRINT
               DB   0DH,0AH   ; NEW LINE
               DB   'Your Password is: ',0
               CALL PSTR      ; PRINT STRING PTED TO BY HL
                              ; ... HL WAS SET BY BBLINE
               ...
     BUFF:     DS   257       ; BUFFER SPACE + 1 FOR ENDING 0

.fo 4 - SYSLIB Disk Input/Output                       Page #

4.0 SYSLIB Disk Input/Output

     SYSLI  provide  numbe o convenience t th programme 
whe i come t manipulatin th dis unde CP/M  Th librar 
provide fiv group o utilitie fo dis input/output:

          1.  Directory Manipulation Routines
               -- Allocate Buffer Space
               -- Extract Disk Parameter Information
               -- Determine Amount of Free Space on Disk
               -- Determine the Size of a Disk File
               -- Load a Disk Directory into Memory
               -- Alphabetize a Loaded Disk Directory
               -- Select Files from a Loaded Disk Directory
               -- Pack (Compress) a Loaded Disk Directory
               -- Combination Utility (Load, Select, Alphabetize,
                    and Pack a Disk Directory)

          2.  Block-Oriented File Input/Output
               -- Open, Create, and Close a File
               -- Delete a File
               -- Rename a File
               -- See if a File Exists
               -- Read and Write Blocks from and to a File

          3.  Byte-Oriented File Input/Output
               -- Open and Close a File
               -- Read and Write a Byte from and to a File

          4.  File Control Block (FCB) Manipulation
               -- Set Up an FCB from a String
               -- Initialize an FCB

          5.  ZCPR2-Specific Functions
               -- Initialize ZCPR2 SYSLIB Buffers
               -- Return Pointer to Next Character in Multiple
                    Command Line
               -- Return Status of a ZCPR2 File
               -- Search for a File Along the ZCPR2 Command
                    Path
               -- Determine User and Disk Referred to by a
                    ZCPR2 Named Directory
               -- Find a ZCPR2 Named Directory Index File
               -- Set Up an FCB from a String with ZCPR2
                    Named Directories Permitted


     Not tha th las se o routine appl t ZCPR2  ZCPR i 
 replacemen fo th CP/ CCР tha ɠ a designin whic 
significantl enhance th powe o th CC an give i man 
capabilities similar to some found in the UNIX Operating System.


4.01 Directory Manipulation Routines

     Th director manipulatio routine o SYSLI ar designe 
wit  maximu o generalit an flexibilit i mind  Actin t 
reliev th programme o th tas o writin routine whic 
acces th director informatio o disk thes routine acces 
th dis director fo hi an loa it content int  memor 
buffer in a form which is relatively easy to use.

     Th imag o  dis director a place i memor b SYSLI 
is a series of 16-byte entries organized as follows:

     ----------------------------------------------------------
     | 1 Byte | 8 Bytes | 3 Bytes | 1 Byte | 2 Bytes | 1 Byte |
     ----------------------------------------------------------
         ^         ^         ^         ^        ^         ^
         |         |         |         |        |         |
     ----------------------------------------------------------
     |User Num|File Name|File Type| Extent |  Unused | Rec Cnt|
     ----------------------------------------------------------

     Not tha thi i identica t th firs 1 byte o th 
CP/ director entr a i exist o dis an i specifie i th 
Fil Contro Bloc (FCB)  Not als tha th firs byt i use 
t indicat th Use Numbe associate wit th file an NO th 
dis numbe (a thi byt i use fo i th FCB).

     Befor th dis director i accessed however i i usual
l  goo ide t us th SYSLI DBUFFEҠ routin t allocat 
memor spac fo th loade director entries especiall i th 
alphabetizatio routin i t b use later  Th DBUFFE routin 
i passe  pointe t  scratc memor are whic extend t th 
to o th TPA an i accesse th dis paramete information 
allocate pointe spac fo th alphabetizatio routine check 
fo Transien Progra Are (TPA overflow an return  pointe 
t th nex availabl byt afte th pointe spac int whic th 
director i t b late loaded.

     Th memor addres require b DBUFFE ca b frequentl 
provide b th CODEN routin (unles th scratc are i al
read bein use b th program i whic cas th programme ha 
t provid thi valu fro withi hi code)  DBUFFE an CODEN 
fi nicel togethe fo thi purpose  Th typica callin se
quenc look lik this:

               ...
               CALL CODEND
;  HL now points to the bottom of the scratch area
               CALL DBUFFER
;  HL now points to the bottom of the directory load area
;    and A = 0 and Zero Flag is Set (Z) if TPA Overflow
               JZ   TPAOVFL   ; Handle Error and Abort
               ...
     The memory map for directory access looks like this:

                         -------------------------------
                         | CP/M BDOS                   |
     Top of TPA/Bottom   -------------------------------
       of BDOS           | Unused Space                |
                         -------------------------------
     DIRLOAD or DIRSLOAD | Directory Entries (16 Bytes)|
       Load This ----->  |   are loaded here           |
                         -------------------------------
     DBUFFER Computes    | Pointer Space for Alphabet- |
       This ---------->  |   ization                   |
     Beginning of        -------------------------------
       Scratch Area      | Dead Space                  |
     End of Program      -------------------------------
                         | CODEND Routine              |
                         -------------------------------
                         | Other SYSLIB Routines       |
                         -------------------------------
                         | Programmer's Code           |
     100H                -------------------------------

     Note  I i assume tha th programme ha alread logge 
i th require dis befor DBUFFE i called  I not th dis 
paramete informatio ma b i error and consequently in
sufficien pointe spac ma b allocated.

     DBUFFE call th routin DPARAM t determin th specific 
o th CP/ dis structur an th informatio i require t 
allocat th pointe space  I particular DPARAM return th 
maximu numbe o dis director entries an DBUFFEҠ allocate 
enoug pointe spac t loa al director entrie i necessary.

     DPARAMӠ extract muc necessar informatio fo us b SYS
LI i dealin wit dis directories  Th programme nee no b 
concerne wit exactl wha thi informatio is sinc SYSLI 
use i internall an provide th programme wit wha h need 
t kno throug it subroutines  Fo th interes o th reader 
however th followin informatio i extracte b DPARAMӠ fo 
interna SYSLI use:

          o Block Shift Factor
          o Block Mask
          o Extent Mask
          o Maximum Number of Blocks on Disk
          o Maximum Number of Directory Entries

     Thos reader familia wit CP/ internal ma b intereste 
t kno tha thi i al o th informatio require t perfor 
thes dis functions  DPARAM als determine wha versio o 
CP/ i bein use (1. o 2. o MP/M) an extract thi infor
matio fro th BDO internal i CP/ 1. i bein use o fro 
th BDO Functio Call i CP/ 2. o MP/ i bein used  Thos 
reall intereste i pursuin mor detai ar invite t rea th 
SYSLI sourc code.
     No tha th preliminarie ar overwit an th buffer hav 
bee properl initialized th nex logica ste i t loa th 
dis directory  Tw SYSLI routine ar provide t d this  
DIRLOAD and DIRSLOAD.

     Bot DIRLOA an DIRSLOA loa th director buffe pointe 
t b H wit th entrie o al unerase file o th dis i 
al use area o th disk  Also bot DIRLOAĠ an DIRSLOA 
retur  fla i th  registe i TP Overflo occur (no 
enoug roo t stor al th director entries) and i  TP 
overflo ha no occurred the th B registe pai contain th 
numbe o director entrie loade int memory.

     Th tradeof betwee DIRLOA an DIRSLOAĠ lie i wha 
informatio i require b th programmer  DIRLOAĠ execute 
faste tha DIRSLOAD an i load onl th firs entr fo eac 
file  DIRSLOAD however load th LAS entr fo eac file an 
i th programme wishe t late comput th siz o hi 
selected files, DIRSLOAD must be used instead of DIRLOAD.

     T recap DIRLOA an DIRSLOA provid th "proces box 
whic load  director fro dis int memory  Ou developin 
program now looks like this:

               ...
               CALL CODEND
;  HL now points to the bottom of the scratch area
               CALL DBUFFER
;  HL now points to the bottom of the directory load area
;    and A = 0 and Zero Flag is Set (Z) if TPA Overflow
               JZ   TPAOVFL   ; Handle Error and Abort
               CALL DIRLOAD   ; Load Disk Directory
;  DIRLOAD/DIRSLOAD only affect BC, so, at this point:
;    HL = address of first directory entry loaded
;    BC = number of directory entries loaded if no error
;    A = error flag (A=0 and Zero Flag Set if TPA Overflow)
               JZ   TPAOVFL   ; Handle Error and Abort
               ...

     No tha th dis director ha bee loade int memory 
wha type o thing woul on wan t d wit it  Unde SYSLIB 
routine ar provide t d th following:

          o Select Entries (Match Target FCB)
          o Pack Directory Image (Get Rid of Unselected Entries)
          o Alphabetize the Directory Image
          o Compute Sizes of Files


     DIRSE̠ i th routin use t selec entrie fro  loade 
disk directory.  DIRSEL requires the following information:

          HL = address of first entry
          DE = address of FCB containing of desired files
               - only the file name and file type fields are
                 used, so a full FCB need not be allocated
               - only the first 12 bytes of an FCB are required
                 by DIRSEL, and the first byte is ignored
          BC = number of files in the directory
          A  = selection flag, organized as follows:
               - Bit 7 = Select Non-System Files if Set
               - Bit 6 = Select System Files if Set
               - Bit 5 = Select Files in All User Areas if Set
               - Bits 4-0 = If Bit 5 is 0, user number (5 bits)
                    of user area to select files from

     Ou evolvin progra no contain  DIRSE cal a th nex 
logica step:

               ...
               CALL CODEND
;  HL now points to the bottom of the scratch area
               CALL DBUFFER
;  HL now points to the bottom of the directory load area
;    and A = 0 and Zero Flag is Set (Z) if TPA Overflow
               JZ   TPAOVFL   ; Handle Error and Abort
               CALL DIRLOAD   ; Load Disk Directory
;  DIRLOAD/DIRSLOAD only affect BC, so, at this point:
;    HL = address of first directory entry loaded
;    BC = number of directory entries loaded if no error
;    A = error flag (A=0 and Zero Flag Set if TPA Overflow)
               JZ   TPAOVFL   ; Handle Error and Abort
;  Prepare for DIRSEL Call
;  HL and BC already contained values required by DIRSEL
               LXI  D,FCB     ; Point to FCB
               MVI  A,11100000B    ; Select Non-System and System
                                   ;   Files in All User Areas
               CALL DIRSEL
;  No Error Code is Returned, and
;  All Registers are Unchanged; Hence, the following important
;  values are retained:
;    HL = address of first directory entry loaded
;    BC = number of directory entres loaded
               ...
;
;  Data Buffer Area
;
FCB:
     DB   0    ; Just Filler
     DB   'ANYFIL? TXT'  ; File Spec, may include wild card of ?


     DIRSE select it file b settin th Mos Significan Bi 
o th Use Numbe fiel o th selecte director entrie t  
1  Hence sinc thi i al tha i changed DIRSE ma b use 
repeatedl t selec severa group o files an thes group 
ma includ th sam file (MYF? an MYF ma matc som o th 
sam files)  Sinc DIRSE change n registers on cal afte 
another may be made:

          ...
          LXI  D,FCB1    ; Match first set
          MVI  A,11100000B    ; Non-Sys, Sys, and All Users
          CALL DIRSEL
          LXI  D,FCB2    ; Match 2nd set
          CALL DIRSEL
          ...

     Onc al th desire file hav bee selected DIRPAC an 
DIRNPAC ar use t pac th director buffer leavin i onl 
thos entrie desired  I DIRPAC i used entrie NO marke b 
DIRSE̠ ar discarded an th buffe i reorganize t contai 
onl thos entrie marke b DIRSEL  I DIRNPAC i used en
trie marke b DIRSE ar discarde (negativ selection) an 
th buffe i reorganize t contai onl thos entrie NO 
marke b DIRSEL.

     DIRPACK and DIRNPACK require the following inputs:
          HL = address of first entry in directory buffer
          BC = number of entries in directory buffer

     DIRPACK and DIRNPACK return the following values:
          HL = address of first entry in directory buffer
          BC = number of desired entries left in directory buffer

     Not tha onl th B registe pai ma b changed an al 
othe register ar no affected  Again ou progra no evolve 
as indicated:


               ...
               CALL CODEND
;  HL now points to the bottom of the scratch area
               CALL DBUFFER
;  HL now points to the bottom of the directory load area
;    and A = 0 and Zero Flag is Set (Z) if TPA Overflow
               JZ   TPAOVFL   ; Handle Error and Abort
               CALL DIRLOAD   ; Load Disk Directory
;  DIRLOAD/DIRSLOAD only affect BC, so, at this point:
;    HL = address of first directory entry loaded
;    BC = number of directory entries loaded if no error
;    A = error flag (A=0 and Zero Flag Set if TPA Overflow)
               JZ   TPAOVFL   ; Handle Error and Abort
;  Prepare for DIRSEL Call
;  HL and BC already contained values required by DIRSEL
               LXI  D,FCB     ; Point to FCB
               MVI  A,11100000B    ; Select Non-System and System
                                   ;   Files in All User Areas
               CALL DIRSEL
;  No Error Code is Returned, and
;  All Registers are Unchanged; Hence, the following important
;  values are retained:
;    HL = address of first directory entry loaded
;    BC = number of directory entries loaded
               CALL DIRPACK   ; Pack Directory
;  Only BC is changed, and now:
;    BC = number of remaining (desired) directory entries
;  This is typically followed by a test to see if BC=0 (no
;  entries selected
               MOV  A,B       ; See if BC=0
               ORA  C
               JZ   EMPTY     ; Process No Selected File Routine
               ...
;
;  Data Buffer Area
;
FCB:
     DB   0    ; Just Filler
     DB   'ANYFIL? TXT'  ; File Spec, may include wild card of ?


     Finally no tha w hav loade th director fro disk 
selecte th files an finall packe th loade directory w 
ma wis t alphabetiz thi loade director fo eas o acces 
an user-friendlines i ou progra (lis th file t th use 
alphabetically)  DIRALPH i th SYSLI routin whic doe this.

     DIRALPH require th followin input an ha n effec o 
any registers:

          HL = address of first directory entry
          BC = number of directory entries to sort
          A  = sort flag; if A=0, sort first by file name and
               then by file type (HISFILE.TXT comes before
               MYFILE.MAC), else sort first by file type and
               then by file name (MYFILE.MAC comes before
               HISFILE.TXT)

     Our program has finally evolved into the following:

               ...
               CALL CODEND
;  HL now points to the bottom of the scratch area
               CALL DBUFFER
;  HL now points to the bottom of the directory load area
;    and A = 0 and Zero Flag is Set (Z) if TPA Overflow
               JZ   TPAOVFL   ; Handle Error and Abort
               CALL DIRLOAD   ; Load Disk Directory
;  DIRLOAD/DIRSLOAD only affect BC, so, at this point:
;    HL = address of first directory entry loaded
;    BC = number of directory entries loaded if no error
;    A = error flag (A=0 and Zero Flag Set if TPA Overflow)
               JZ   TPAOVFL   ; Handle Error and Abort
;  Prepare for DIRSEL Call
;  HL and BC already contained values required by DIRSEL
               LXI  D,FCB     ; Point to FCB
               MVI  A,11100000B    ; Select Non-System and System
                                   ;   Files in All User Areas
               CALL DIRSEL
;  No Error Code is Returned, and
;  All Registers are Unchanged; Hence, the following important
;  values are retained:
;    HL = address of first directory entry loaded
;    BC = number of directory entries loaded
               CALL DIRPACK   ; Pack Directory
;  Only BC is changed, and now:
;    BC = number of remaining (desired) directory entries
;  This is typically followed by a test to see if BC=0 (no
;  entries selected
               MOV  A,B       ; See if BC=0
               ORA  C
               JZ   EMPTY     ; Process No Selected File Routine
               CALL DIRALPHA  ; Alphabetize Directory
;  No error codes are returned, and the following registers are
;  significant:
;    HL = address of first directory entry loaded
;    BC = number of directory entries loaded
;  The programmer may now continue with his specific application
               ...
;
;  Data Buffer Area
;
FCB:
     DB   0,'ANYFIL? TXT'  ; File Spec, may include wild card of ?

     A th reade ca see th SYSLI routine ar certainl 
cohesivel designe an wor togethe wit  minimu o overhead  
Sinc th abov sequenc o instruction ar s frequentl neede 
i exactl th sam order  hav toppe of th SYSLI director 
manipulation routine module with the DIRF and DIRFS routines.

     DIR an DIRF perfor th followin operation i th orde 
indicated:

          1.  Initialize Buffer Area (DBUFFER call)
          2.  Load the Disk Directory into the Buffer
               (DIRF calls DIRLOAD, DIRFS calls DIRSLOAD)
          3.  Select a Set of Files (DIRSEL call)
          4.  Pack the Files in the Memory Buffer (DIRPACK call)
          5.  Alphabetize the Files in the Memory Buffer
               (DIRALPHA call) by file name and then file type

     DIRF and DIRFS require the following input parameters:

          H  bas o dynami buffe are (a returne b
               CODEND)
          DE = address of FCB containing file spec to match
               (only 1st 12 bytes required)
          A  = selection flag, as for DIRSEL

     DIRF and DIRFS return the following output parameters:

          HL = address of first file entry
          BC = number of file entries
          A  = error flag; A=0 and Zero Flag Set (Z) if TPA
               Overflow occurred

     The DIRF/DIRFS calling sequence is typically:

          ...
          EXT  CODEND    ; Use CODEND
          EXT  DIRF      ; Use DIRF
          ...
          CALL CODEND    ; Get Scratch Area Address
          LXI  D,FCB     ; Pt to FCB
          MVI  A,11100000B    ; Non-Sys, Sys, in all User Areas
          CALL DIRF      ; Do It!
          ...
     FCB: DB   0,'????????TXT'     ; Select all TXT files
          ...


     Finally th las tw subroutine availabl i SYSLI  fo 
directory manipulation are DFREE and FSIZE.

     DFREŠ compute th amoun o fre spac lef o disk an 
return thi valu (i  bytes i DE  N othe register ar 
affected  Th desire dis shoul b logge in DPARAM shoul 
b calle t extrac th desire informatio fo tha disk' dis 
parameter block, and then DFREE should be called.

     FSIZŠ compute th siz o th fil whos loade director 
entr (mus hav bee loade b DIRSLOA throug eithe  cal t 
DIRSLOAĠ o  cal t DIRFS i pointe t b HL  Th siz o 
this file in K bytes is returned as a binary number in DE.

     Thi complete th discussio o th director manipulatio 
routine o SYSLIB  On fina note  al o thes routine ar 
containe i th SDI module an th entir modul i loade i 
an on o thes routine i called  Sinc th programme 
frequentl want t us severa o thes routine i hi code  
did not consider this to be an unnecessary overhead burdon.


4.02 Block-Oriented File Input/Output

     Th block-oriente fil input/outpu routine o SYSLI wil 
b discusse briefl i thi documen sinc the ar quit simi
la t thei BDO counterparts  Th majo thin tha SYSLI 
offer wit thes routine i no havin t worr abou th 
effect o thes routine o registers  I al cases onl th 
PS i affecte b thes routines an i i use t retur erro 
codes  Th Block-Oriente Fil Input/Outpu routine i SYSLI 
are:

          F$OPEN    Open the file whose FCB is pointed to by DE
                    Returns normal CP/M Error Code in A
          F$MOPEN   FCB is pointed to by DE, and, if the file is
                    not already existing, it is created; other-
                    wise, it is just opened;
                    Returns Error Code in A
          F$CLOSE   Close the file whose FCB is pointed to by DE
          F$MAKE    Create the file whose FCB is pointed to by
                    DE
          F$DELETE  Delete the file whose FCB is pointed to by DE
          F$RENAME  Rename the file whose FCB is pointed to by DE
                    to that whose FCB is pointed to by HL; only
                    the first 12 bytes of each FCB is required;
                    F$RENAME returns with the Zero Flag Set if
                    the original file was not found
          F$EXIST   Determine if the file whose FCB is pointed to
                    b D exist i th curren dis an use
                    area; F$EXIST returns with the Zero Flag Set
                    if the file does not exist
          F$READ    Read Block; usual error code
          F$WRITE   Write Block; usual error code

     Not tha thes routine ar mainl reflection o th 
conventiona BDO functions  Significan extension ar F$MOPEN 
F$RENAME, and F$EXIST.  Example follows:

          ...
          LXI  D,FCB2    ; test for existance of file
          CALL F$EXIST
          JZ   NOFILE
;
;  DE Still Points to FCB of Old File
;
          LXI  H,FCB1    ; new FCB
          CALL F$RENAME  ; rename file
          ...
FCB1:     DB   0,'NEWFILE TXT'     ; new file name
FCB2:     DB   0,'OLDFILE TXT'     ; old file name
          ...



4.03 Byte-Oriented File Input/Output

     SYSLI take  significan ste beyon th conventiona CP/ 
block-oriente fil input/outpu capabilitie wit it byte-
oriente fil input/outpu capabilities  Thes routines unlik 
th other whic requir th use t rea t an writ fro  
fil o  bloc basi (12 byte a  time) allo th programme 
t rea fro an writ t  CP/ fil o  byte-for-byt basis  
Thes routines o read rea i  bloc a require an continu 
t retur onl th nex byt requeste b th programmer and o 
write collec u t 12 byte sen ou b th programmer writ 
tha block an the continu collectin bytes.

     Th utilit o thes routine i enhance b th fac tha 
the ca b use withou car b th programmer  Fo example 
F0$PUԠ i use t outpu on byt t fil 0 an th followin 
sampl cod print  strin o byte t th console printer an 
disk file, using SYSLIB routines:


          ...
          LXI  D,FCB     ; POINT TO FCB OF OUTPUT FILE
          CALL INITFCB   ; CLEAR PROPER FCB FIELDS
          CALL FO0$OPEN  ; OPEN FILE 0 FOR OUTPUT
          JZ   FERR      ; FILE ERROR HANDLER
          LXI  H,STRING  ; POINT TO STRING TO OUTPUT
LOOP:
          MOV  A,M       ; GET NEXT CHARACTER
          ORA  A         ; END OF STRING IF 0
          JZ   DONE      ; DONE IF END OF STRING
          CALL F0$PUT    ; WRITE BYTE TO DISK
          JZ   FERR
          CALL COUT      ; WRITE BYTE TO CONSOLE
          CALL LOUT      ; WRITE BYTE TO PRINTER
          INX  H         ; POINT TO NEXT BYTE
          JMP  LOOP      ; CONTINUE UNTIL DONE
DONE:
          CALL FO0$CLOSE ; CLOSE OUTPUT FILE
          ...
FERR:                    ; ERROR HANDLER
          ...
FCB:      DB   0,'OUTFILE TXT'     ; OUTPUT FILE FCB
          DS   4
          DS   16
          DS   4         ; FOUR MORE BYTES FOR SYSLIB
          ...


     Thi exampl i probabl adequat t sho th reade ho t 
us SYSLI  i general  Th followin ar th SYSLI  routine 
used to support Byte-Oriented File Input and Output:

 File Open for       File Close for           Byte-Oriented
Input     Output    Input     Output         Read      Write
-----     ------    -----     ------         ----      -----
FI0$OPEN  FO0$OPEN  FI0$CLOSE FO0$CLOSE      F0$GET    F0$PUT
FI1$OPEN  FO1$OPEN  FI1$CLOSE FO1$CLOSE      F1$GET    F1$PUT
FI2$OPEN  FO2$OPEN  FI2$CLOSE FO2$CLOSE      F2$GET    F2$PUT
FI3$OPEN  FO3$OPEN  FI3$CLOSE FO3$CLOSE      F3$GET    F3$PUT

     U t eigh file ca b ope a on tim -- fou fo inpu 
an fou fo output  Th sequenc o call t us thes routine 
is always the same:

          < Open Files for Input or Output >
          < Read or Write Bytes using GET and PUT >
          < Close Files for Input or Output >


     Th abov exampl showe ho thi wa don fo writin t  
file  Th $OPE routine requir  36-byt FC whic i pointe 
t b D a a inpu argument an the retur wit th Zer Fla 
Se i a erro occurred  Th $CLOS routine requir n inpu 
argumen (the kno wha file the ar dealin with) an the 
retur wit Zer Fla Se i a erro occurred  Th $GEԠ an 
$PUԠ routine onl requir  t contai th characte t outpu 
(fo th $PU routines o inpu (fo th $GEԠ routines) an 
the retur a erro fla (Zer Fla Se i Error an erro cod 
(i A i a erro occurs  I a erro occurs  return th 
erro code i n erro occurs  i unchanged.

     Chapte  o th SYSLI Use an Referenc Manual give  
little more detail, including the error code information.


4.04 File Control Block (FCB) Manipulation

     SYSLIB provides two simple routines for FCB manipulation.

     Th ke field w ar intereste i a FC ar th fil nam 
an fil typ fields  Th FC use b SYSLI i alway 3 byte 
long an i typicall declare wit th followin code:

          FCB: DB   0              ; Zero Disk Number
               DB   'FILENAMETYP'  ; File Name and Type
               DS   4              ; Rest of first 16 bytes
               DS   16             ; Second 16 bytes
               DS   4              ; Last required by SYSLIB

     Th firs i INITFCB  Thi routin simpl clear al o th 
field (excep th fil nam an fil typ fields o th 36-byt 
FC pointe t b D t zero  I i  nice quic wa t init
ializ a FC fully.

     Not tha i clear th dis numbe fiel (th firs field 
a well thereb selectin th curren disk  I i intende tha 
th use manuall selec th dis himsel rathe tha allowin 
th BDO t auto-selec  disk.

     Th secon SYSLI routin discusse her i FNAME  Thi i 
 fil nam strin parser an i build a FC an extract use 
an dis informatio fro  grou o character terminate b  
delimiter  O input H point t th firs byt o th grou o 
character an D point t th FCB  O output th followin 
regster values are returned:

          B  = Number of Disk Specified (A=1 to P=16 or 0FFH if
               no disk specified)
          C  = User Number Specified (0 to 31, '?' if all users,
               or 0FFH if no user specified)
          HL = address of delimiter which ended the scan
          A  = error flag; A=0 and Zero Flag Set if invalid disk
               or user number specified
     Scannin vi FNAM i stoppe whe  delimite i encoun
tered  Th followin ar classifie b SYSLI a delimiters:

          <NULL or Binary 0>       <Space Character>
          =    _    ;    ,    <    >

     Th grou o character i intende t b  fil specifica
tion simila t th CP/ standard  I i o th genera form:

          du:filename.typ

wher d=dis letter u=use number an th res i standard  
Vali dis letter ar A-P an vali use number ar 0-3 an 
the '?' character.

     Th FC i initialize b thi routine an onl th fil 
nam an fil typ field ar se (t th filename.ty part o 
th string)  Al lowe cas character ar converte t uppe 
case.

     Examples of valid character sequences are:

          Sequence       Returned Values
          --------       ---------------

          test.txt       File Name = TEST    File Type = TXT
                         B Reg = 0FFH        C Reg = 0FFH

          a:t            File Name = T       File Type = <spaces>
                         B Reg = 1           C Reg = 0FFH

          5:.t           File Name = <space> File Type = T
                         B Reg = 0FFH        C Reg = 5

          c10:x*.t?t     File Name = X???????  File Type = T?T
                         B Reg = 3           C Reg = 10


     FNAMŠ i frequentl use i processin use input   cod 
exampl is:


          ...
          CALL PRINT
          DB   'Name of File? ',0
          CALL BBLINE    ; GET NAME OF FILE FROM USER
          LXI  D,FCB     ; PT TO FCB WITH DE, HL ALREADY PTS TO
                         ;   FIRST CHAR OF FILE NAME
          CALL FNAME     ; EXTRACT INFORMATION
          JZ   FNERR     ; ERROR HANDLER
          MOV  A,B       ; SAVE DISK NUMBER
          STA  DISK
          MOV  A,C       ; SAVE USER NUMBER
          STA  USER
          ...
FCB:      DS   36        ; NO INITIALIZATION NECESSARY FOR FCB
DISK:     DS   1         ; USER-SPECIFIED DISK NUMBER
USER:     DS   1         ; USER-SPECIFIED USER NUMBER
          ...


4.05 ZCPR2-Specific Functions

      a currentl i th throw o designin  ne CP/ compat
abl CCP-replacemen calle ZCPR2 an th desig o SYSLI 
reflect thi t som extent  SYSLI contain tw module whic 
suppor ZCPR2-specifi capabilities an thes module contai 
fiv SYSLIB-interna buffe initializatio routine an si ZCPR 
utilit routines  Som o th reader ma b familia wit ZCPR 
(whic i availabl fo fre i Volum 5 o th SIG/͠ User' 
Group)  Afte writin ZCPR1  foun severa o it feature t 
b lackin (especiall afte  gaine som experienc usin 
UNIX)  ZCPR i  significan extensio t ZCPR1 an i con
tain varient o severa feature foun i non-CP/͠ operatin 
systems suc a UNIX.

     Give th CP/ memor map fro befor (th reade i in
vite t refe bac t the i desired) th followin i th 
memor ma fo  typica ZCPR2-base syste whic support al o 
th extende features:


          Comments       Size Memory Map

     High Memory              ----------------------------
                           1K | ZCPR2 Buffers, incl      |
                      (May be |   Multiple Command Line  |
                       less)  ----------------------------
                           2K | ZCPR2 BIOS, incl special |
                              |   Cold Boot Init routines|
                              ----------------------------
                         3.5K | CP/M BDOS or other BDOS  |
                        ->    ----------------------------
                       /   2K | ZCPR2                    |
     Normal ZCPR2     /       ----------------------------
       TPA (when     /   0.5K | ZEX Monitor and Buffer   |
       ZEX is not    \(Approx)|   Optionally Loaded      |
       loaded)        \       ----------------------------
                       \      | COM File Space           |
                        \     |    TPA when ZEX is       |
                         \    |        loaded in with    |
                          \   |        ZCPR2             |
     Address 100H          -> ----------------------------
                        0.25K | System Buffers and Entry |
                              |   Points                 |
     Address 0H               ----------------------------



      wil no g int  detaile explanatio o ZCPR2 particu
larl ZEX a thi time  Extensiv detail o ZCPR wil b 
release later.

     Befor expoundin o wha th ZCPR2-oriente SYSLI routine 
do i woul b  goo ide t explai som o th extende 
feature o ZCPR whic ar supporte b thes routines  Thre 
ZCPR feature ar supporte i SYSLIB:

          1. Multiple Command Lines
               -- ZCPR ca b se u t allo th use t ente 
                  command lines like the following:
                    xdir;b3:;a7:display myfile
                         <-- run XDIR from current user/disk,
                             log into Disk B/User 3, run DISPLAY
                             from Disk A/User 7 on MYFILE in B3

          2. Command Search Paths (File Search Paths)
               -- whe ZCPR receive  command i i determine 
                  tha  comman fil (CO file i necessar t 
                  execut th command ZCPR searche alon  
                  pat fo th command movin fro on dis an 
                  use are t anothe unti th en o th pat 
                  i reached; example is --


                    $$ $0 a$ a0    <-- ZCPR2 will look for file
                                       from current disk/user to
                                       cur disk/user 0 to disk A
                                       cur user to disk A/U 0


          3 Name Directorie (ma b implemente o 
             conventional CP/M systems as well)
               -- ZCPR ha th adde abilit t suppor  
                  disk/user for whereve jus  disk for wa 
                  permitte before example ar --
                    a5:            <-- change to disk A/User 5
                    b6:cmnd        <-- execute command from B6
                    type a7:myfile <-- type file in A7
                    dir c11:       <-- directory of C11
                    a:             <-- change to disk A/Cur User
                    5:             <-- change to cur disk/User 5
                    er 1:myfil   <-- eras fil o cu disk/ 1

                  Thi i furthe extende b a implementatio 
                  o name directorie i CO fil thr SYSLIB  
                  directory in the ZCPR2 vernacular is a disk and
                  use are combination suc a dis  an use 
                  5 suc directorie ca b give mnemoni 
                  names suc a JEFF o MYWORK: example o 
                  existing ZCPR2 utilities are --
                    xdi jeff     <-- XDI o dir named JEFF
                    cd mytext:     <-- change dir (log into)
                                       dir named MYTEXT
                    mcopy backup:=work:*.txt
                                   <-- copy *.TXT files from
                                       WORK: to BACKUP:


     Bein i lov wit th SYSLI concept  decide t reliev 
som o th tediou ZCPR2-specifi codin require t implemen 
o acces thes feature fro th programme an plac i int 
SYSLIB  Onc th whee i invented wh d i again right?




                  Multiple Commands and SYSLIB

     Acces t th ZCPR multipl comman lin i th firs 
featur  place int SYSLI i thi regard  Unde ZCPR2 th 
multipl comman lin featur ma b engage o disengage a th 
syste programmer' discretion  Th tradeof fo thi featur i 
that i disengaged th buffe use t stor th user' comman 
lin i store interna t ZCPR2 an thi prohibit th us o 
multipl command o  singl lin an take u valuabl spac 
withi ZCPR whic ma b use fo othe options  I engaged 
th buffe use t stor th user' comman lin i store ex
ternall t ZCPR2 an som cod mus b place int th BIO s 
tha th BIOS o Col Boot wil allocat spac fo thi buffe 
an initializ it  On thin nic abou thi featur i that i 
initializin thi buffer  startu comman line possibl con
sistin o severa commands ca b se t b execute wheneve  
col boo (syste startup i performed.

     Tw thing mus b know b th SYSLI multipl comman lin 
routine  (1 i th multipl comman lin featur engage an 
(2 wher i th multipl comman lin buffe located  Th 
ZINIMà routin initialize (o changes th interna SYSLI buf
fe whic contain th addres o th multipl comman lin 
buffer  I ZINIM i called i assume tha H contain th 
addres o thi buffe an tell SYSLI tha multipl command 
ar availabl an wher the ar located  I ZINIMà i no 
called SYSLI assume tha multipl command ar no available.

     Onc ZINIM ha bee called th SYSLI routin ZMCPTҠ i 
availabl t th programmer  Thi routin return th addres o 
th nex characte i th multipl comman line  Th programme 
ca the rea th res o th curren multipl comman line 
realizin tha eac comman i separate b  semicolo (; an 
tha th entir lin i terminate b  binar 0  ZMCPTҠ als 
return a erro cod i A i whic cas A= an th Zer Fla 
i Se (Z i multipl command ar no available.


     To illustrate, if the multiple command line is:

          myprog p1;myprog p2;myprog p3

and MYPROG.COM contains the following code:

          ...
          LXI  H,MCBASE  ; base adr of MC line
          CALL ZINIMC    ; init SYSLIB
          CAL ZMCPT     ge ad o firs byt o res o MC
                         ;   adr returned in HL
          CALL PRINT
          DB   'The rest of the command line is -- ',0
          CALL PSTR      ; print rest of command line, as pted
                         ;   to by HL and ending in a binary 0
          ...

then the command 'myprog p1' will print:

          The rest of the command line is -- myprog p2;myprog p3

and the command 'myprog p2' will print:

          The rest of the command line is -- myprog p3



                    External Paths and SYSLIB

     Th externa path i th secon ZCPR featur supporte 
extensivel b SYSLIB  Again lik mos ZCPR features externa 
path ma b enable o disable a th discretio o th syste 
programmer  I orde t understan th concep o th externa 
path th concep o th SYSLI directory mus b understood  I 
th SYSLI vernacular  directory i  logica entit o  dis 
i whic file ar stored  I i designate wit a X- coordin
ate th  coordinat bein th nam o th dis (A B C etc. 
an th  coordinat bein th numbe o th use are ( t 31)  
Unde CP/͠ 2. an ZCPR2 ther ar 3 directorie o eac o 
you disks an th overal director syste (NOԠ th name 
director system t b discusse later identifie thes direct
orie b th form

          du:

wher 'd i  lette (A-P an 'u i  use numbe (0-31)  
Examples of directories are:

          A5:  B7:  A30: C12:


     Unde CP/ 2. an ZCPR2 distinc file ma b place i 
eac o th directorie an b handle a uniqu files regard
les o thei names  Specifically  fil name TEST.TXԠ ma 
resid i directorie A5: A10: A20: an B3: an ther wil b 
fou distinc file her b th sam nam (TEST.TXT)  Editin 
TEST.TX i A5 doe no chang th content o TEST.TX i th 
othe directories  On exceptio t thi rul exists namel 
tha whic occur whe th DUPUS progra i employed an thi 
wil b discusse later.

     Unde CP/ 2.2 th utilit o thes directorie wa some
wha limite since onc th use wa logge int  director 
lik A5 (h issue th comman 'A: i h wa no alread o 
dis  an th comman 'USE 5') an comman h issue whic 
require  CO fil t execut i ha t us  CO fil whic wa 
eithe i hi curren director o o anothe dis i th sam 
use are (i whic cas h coul issu  comman lik "A:PIP")  
Hence i h wante t separat hi file int use area 5 6 
an  o dis A an h wante t alway hav PI available h 
ha t hav  cop o th PIP.CO fil i al thre use areas.

     Problem wer immediatel recognize wit thi environmen 
unde CP/ 2.2 an  progra calle DUPUS wa release whic 
create duplicat director entrie o  fil i differen use 
areas  I thi way additiona director entrie wer take up 
pointin t th sam file bu th fil itsel di no hav t b 
duplicate i eac use area  Thi wa nice bu i adde dan
gers especiall whe  fil wa change o delete fro on use 
are an no i al th others  ZCPR cam ou late t reliev 
thi proble an eliminat th nee fo DUPUS t som extent.

     Unde ZCPR1 th syste programmer a installatio time 
coul configur ZCPR t d  limite director searc wheneve  
CO͠ fil wa t b executed  Th ZCPR defaul wa t loo fo 
th CO fil i th curren dis an curren use area i thi 
faile t dro dow t use are  o th curren disk i thi 
faile t dro dow t dis  an use are 0 an i thi 
failed t issu th standar erro messag tha th CO fil wa 
no found  DUPUS an it associate danger coul b elimin
ated an th use coul plac himsel int an use are h 
desired keepin al o hi syste utilitie o dis  i use 
are 0 and wheneve h woul issu  command ZCPR woul 
searc fo it  Thank t suc  concept ZCPR allowe th use 
t creat  workin environmen i which say dis B containe 
al o hi workin file an dis A:/use  containe al o hi 
CO files  H coul issu an comman fro an use are o B: 
sa fro B5: an ZCPR woul searc fo th CO͠ file movin 
fro B5 t B0 t A0:.


     Thi was i m opinio (bu I' prejudice)  significan 
enhancemen t th CP/ concept  No th wor dis coul b 
totall dedicate t wor file (bein devoi o commands whil 
 syste dis coul contai al o th user' commands  Th 
ZCPR capabilit t mov fro on disk/use are t anothe wa 
nice bu stil somewha limited  Th ZCPR use coul no 
chang thi comman searc pat ( path being i th ZCPR 
definitions  vecto o directorie alon whic  fil searc i 
performed t sto a A10 instea o A0 withou modifyin ZCPR 
an reinstallin it fo instance  No coul h specif  longe 
path suc a  4-director search withou som effort.

     ZCPR significantl extend th comman searc pat ide 
fro ZCPR1  ZCPR support  pat definition whic i containe 
i  memor buffer  Th ZCPR pat i  serie o byt pairs 
th firs byt indicatin th dis numbe an th secon byt 
indicatin th use number whic ma b o an lengt an i 
terminate b  binar 0  Internally th pat ma b store a 
 par o ZCPR itself takin u spac withi ZCPR2 o externa 
t ZCPR2 i  buffe i lo memor (belo 100H suc a 40H 
whic  use o i hig memor (abov th BIOS whic i wher  
currentl plac m multipl comman lin buffer).

     I th pat i store interna t ZCPR2 i canno typicall 
b change b th programme i hi utilities  I th pat i 
externa t ZCPR i  precisely-define locatio (know b th 
syste programmer) the  programme ma writ utilitie t 
chang thi pat a will addin TON o flexibilit t th 
system!  ZCPR2 whe i i released wil includ  comman 
calle PAT i it distribution an thi comman allow th use 
t chang hi ZCPR pat a wil t anythin h desires.

     Eac director specifie i th pat i represente b  
byt pair  Th firs byt i th dis number an i ma tak o 
value fro  t 1 (binary t represen disk A t P: o i 
ma tak o th valu o th characte '$ (24H) whic stand 
fo th curren dis (th dis th use i logge into)  Th 
secon byt i th use number an i ma tak o value fro  
t 3 (binary t presen user  t 31  Th pat i terminate 
b  binar  (whic woul b i th plac o  dis number an 
 i a invali dis number).

     A path, stored in memory, could look like this:

          01H 24H    24H 00H    01H 00H   00H
             \          \          \       \__ End of Path
              \          \          \
               \          \          \__ Disk A/User 0
                \          \
                 \          \__ Current Disk/User 0
                  \
                   \__ Disk A/Current User


     I designin th PATȠ comman o ZCPR2 ɠ hav als 
establishe  standar wa t represen  ZCPR pat i text  
Th following fo example i  PAT comman whic ma b issue 
by the user to set the path in the example above:

          PATH A$ $0 A0

     Th PAT comman wil b discusse agai whe  cove name 
directories.

     Gettin bac t path an SYSLIB tw SYSLI utilitie ar 
provide whic ar designe t specificall dea wit ZCPR 
paths  Thes utilitie are:

           ZINIEX -- tel SYSLI th bas addres (addres o 
               the first byte) of the ZCPR2 path to be used;
               note that this may be the address of any path,
               and not necessarily that of the ZCPR2 system,
               so many paths may be used by different programs
               under ZCPR2 (such as having a path for HELP
               commands and another path to access special
               programs)

               ZINIEXT expects the base address of a path to
               be passed to it in HL; if ZINIEXT is not called,
               the SYSLIB routines assume that there is no path
               and just check the current disk/current user when
               called

          o ZPFIND -- search for a file along the current path
               whose base was identified by a call to ZINIEXT
               for the file whose FCB is pointed to by DE;
               B is a flag, and if B=0, search just the path,
               while if B<>0, search the current disk/user
               first and then follow the path

               ZPFIND returns with the Zero Flag Clear (NZ)
               and A=0FFH if the file is found, and the
               disk number of the file in B (B=0 for disk A)
               and the user number of the file in C (0-31) if
               the file is found

               ZPFIND leaves the user logged into the directory
               he was in originally before the path search began



     T mak lif eve easie fo th SYSLI  programmer SYSLI 
provide fou routine whic manipulat use an dis area s 
tha th programme ca mov betwee the wit ease  Thes 
routines are:

          o PUTUD -- save the current disk/current user away in
                     an internal SYSLIB buffer; PUTUD affects
                     no registers

          o GETUD -- read the contents of the internal SYSLIB
                     buffer used by PUTUD and log the user into
                     his original disk/user; GETUD affects no
                     registers

          o LOGUD -- log the user into the disk/user specified
                     by BC; B is the disk number (B=0 for disk
                     A) and C is the user number (0-31); no
                     registers are affected by LOGUD

          o RETUD -- return the current user/disk numbers;
                     RETUD requires no inputs, and returns B with
                     the current disk (B=0 for disk A) and
                     C with the current user (0-31)


     Not tha thes routine mes i nicel wit ZPFIND whic 
return dis numbe i  (B= fo dis A an use numbe i C  
Th followin cod illustrate ho th SYSLI programme ma us 
these routines to his advantage:


          ...
          LXI  H,MYPATH  ; Set ZCPR2 Path Base Address
          CALL ZINIEXT
          ...
          LXI  D,MYFCB   ; Find the desired file
          CALL INITFCB   ; Init FCB
          MVI  B,0FFH    ; Search current disk/user first
          CALL ZPFIND    ; Search along path
          JZ   FNF       ; Routine to execute if file not found
;
;  At this point, B=disk number and C=user number in which
;  file was found
;
          CALL PUTUD     ; Save current directory
          CALL LOGUD     ; Go to file's directory
          < Work With File -- Detail Left Out >
          CALL GETUD     ; Return to original directory
          ...
FNF:      ...            ; Routine to process if file not found
          ...
;
;  Path used by ZPFIND
;
MYPATH:   DB   '$',0     ; Current disk/user 0
          DB   1,'$'     ; Disk A/current user
          DB   1,0       ; Disk A/user 0
          DB   0         ; End of path
;
;  FCB for desired file
;
MYFCB:
          DB   0
          DB   'MYFILE TXT'
          DS   4
          DS   16
          DS   4         ; 36 bytes long


     Befor w leav thi subject let' hi jus  coupl mor 
o th ZCPR2-specifi routine i SYSLI whic ma b usefu t 
the programmer:

          o ZCPRSET -- this sets the character used to indicate
                       the current disk or current user; char
                       is passed into ZCPRSET in the A register;
                       if ZCPRSET is not called, this char is
                       assumed to be the ZCPR2 standard, a '$';
                       also, ZCPRSET receives the DMA address
                       for disk file I/O in HL for use by ZPFIND;
                       again i ZCPRSE i no called thi
                       address is assumed to by 80H


          o ZCPRQ -- this returns the following information to
                     the program about SYSLIB settings:
                         HL = External Path Base Address
                         DE = Multiple Command Buffer Address
                         A  = MC Buffer Available (A=0 means No)


          o ZFSTAT -- this returns the attributes of the file
                      whose FCB is pointed to by DE; ZFSTAT
                      returns the following information:
                         B = System Flag (B=0 means Not Sys)
                         C = R/O Flag (C=0 means Not R/O)
                         A = File Found Flag (A=0 and Z mean
                              file NOT found, so BC invalid)


          o ZGPINS -- General Purpose Installation; with all of
                      these initializations to perform, I rapidly
                      became tired of coding up an installation
                      for SYSLIB as I wrote each ZCPR2 utility
                      program.  Hence, I added one more init
                      utility to SYSLIB -- ZGPINS.  This utility
                      assumes the program it resides in has a
                      set of standard ZCPR2 buffers starting at
                      location 103H, and it completely inits
                      SYSLIB based upon the contents of these
                      buffers.  The exact structure of these
                      buffers will not be discussed here, but the
                      fil SINSFORM.MA i th SYSLI distribu-
                      tion gives this information.




                  Named Directories and SYSLIB

     Th thir an fina ZCPR2-specifi featur supporte b 
SYSLI  i tha o name directories  Reiteratin  previou 
definition  directory i  logica entit o  dis i whic 
file ar stored  I i designate wit a X- coordinate th  
coordinat bein th nam o th dis (A B C etc. an th  
coordinat bein th numbe o th use are ( t 31)  Hence  
director woul b somethin lik dis A/use  o dis B/use 
12 an i i designate b th for "du: i th ZCPR vernacu
lar:

          A5:  B12: C31: D0:


      name directory unde ZCPR (i coul als b implemente 
unde CP/͠ 2. fo tha matter bu i make mor sens unde 
ZCPR2 i  director whic ha bee identifie i  name dir
ector fil (suc fil calle NAMES.DI i th ZCPR vernacular 
an ha  mnemoni nam associate wit it lik WOR o JEFF  
Al o th ZCPR utilitie ar designe t suppor thi feature 
an the permi th use t issu command like:

          XDIR WORK:*.TXT
          MCOPY BACKUP:=*.MAC,BACKUP:=WORK:*.TXT
          ERASE TEXT:DEMO.TXT,TEMP:DEMO.TMP
          PROTECT *.COM,ROOT:*.COM RS
          CD TEXT:

     Th name o th director ar store i  file standardl 
calle NAMES.DIR whic shoul typicall b locate a th botto 
o th comman searc pat o ZCPR (th las director ZCPR 
stop at)  Whe  ZCPR utilit receive  comman containin  
director name i searche alon th ZCPR pat fo NAMES.DIR 
load it an trie t matc th nam give t th name store 
i thi file  I n match i issue a error otherwise i 
proceeds.

     Th ZCPR utilit calle CHDI ca b use t creat an 
edi  NAMES.DI file a wel a mov fro on director t 
another  CHDI (CHang DIRectory wil no b discusse i an 
further detail in this paper.

     SYSLI  contain fou routine whic dea wit蠠 name 
directories.  They are:

          o ZFNINIT -- Init Named Directory Buffers
          o ZDNFIND -- Scan for Disk Directory Name
          o ZDNAME  -- Load All Disk Directory Name Data
          o ZFNAME  -- Named Directory File Name Scanner
                         (like FNAME)

     ZFNINIT is passed three arguments:

          DE = address of FCB (36 bytes) containing name of
               disk directory file (NAMES.DIR)
          C  = maximum number of names in NAMES.DIR
          A  = flag which indicates the following:
               if Bit 7 = 1, pay attention to DE and set buffer
               if Bit 6 = 1, pay attention to C and set buffer

     I ZFNINI i no called th nam o th director fil i 
assume t b NAMES.DIR an i i assume t contai  maximu 
of 64 names.


     ZDNAMŠ load th content o th NAMES.DI fil int th 
memor buffe pointe t b H s tha th programme ma acces 
thi informatio a h desires  Eac entr i thi fil i 
structured as follows:

          Byte 0: Disk Number (Disk A = 0)
          Byte 1: User Number
          Bytes 2-9: Directory Name (all caps), 8 chars max,
                     space fill at end

     So representin  NAMES.DI fil i assembl language on 
may look like this:

          DB   0,0            ; disk A/user 0
          DB   'ROOT    '     ; directory named ROOT:
          DB   0,1            ; disk A/user 1
          DB   'MINEWORK'     ; directory named MINEWORK:
          DB   0,0            ; disk A/user 0
          DB   0              ; no entry, so ignored
          DS   7              ; don't care
          DB   1,0            ; disk B/user 0
          DB   'DEVELOPE'     ; directory named DEVELOPE:
          ...

     ZDNAM compresse thi informatio somewhat removin thos 
entrie whic ar empty  O input ZDNAM expect H t poin t 
 dynami memor buffe (CODEN i goo fo providin thi 
address).  On output, ZDNAME provides the following:

          HL = address of first entry in the buffer
          C  = number of valid entries
          B  = 0
          A  = error flag (A=0 and Z if NAMES.DIR not found or
                              memory overflow)

     ZDNAMŠ wil d al th wor fo th programmer  Whe in
voked i searche alon th pat fo NAMES.DI (startin a th 
curren disk/user) log int th director containin th firs 
NAMES.DI i finds load th buffer processe th buffer an 
returns leavin th progra logge int it origina directory.

     Glancin a th SYSLI referenc manual not tha ZDNAM 
use th FI3$OPE an F3$GE routines  Hence thes shoul no 
b use b th programmer  Als not tha i use ZPFIND s th 
programme shoul initializ th pat usin ZINIEXԠ befor 
calling ZDNAME.  A sample code segment using ZDNAME follows:

          ...
          LXI  H,MYPATH  ; set ZCPR2 path for SYSLIB
          CALL ZINIEXT
          CALL CODEND    ; get beginning of scratch area in HL
          CALL ZDNAME    ; load memory buffer
          JZ   NERR      ; process error routine
          ...

     Th nex SYSLI routine ZDNFIND i use t quickl deter
min th director referre t b  strin o character o th 
for "du: o "dir: (conventiona ZCPR director nomenclatur 
o ZCPR name director for allowed).

     ZDNFIND accepts two inputs:

          HL = address of first byte of DIR: or DU: prefix
               this prefix may be terminated by a colon (:),
               space, or binary 0
          A  = flag; if A=0, ZDNFIND does not permit the DU:
               form to be used and assumes that only a DIR:
               form is given and issues an error if it is not

     ZDNFIND returns these values:

          HL = address of character which terminated the prefix
               (usually the address of the colon)
          B  = disk number (disk A = 1, or 0FFH if current disk)
          C  = user number (0-31, or 0FFH if current user)
          Zero Flag Set if error

     Again ZDNFIN use Byt Inpu Fil 3 s thi fil shoul 
no b activ whe ZDNFIN i called.


     Th fina name director routin i SYSLI i ZFNAME  I 
i  fil nam scanner lik FNAME bu i permit name 
directorie t b used  O input D point t  36-byt FC an 
H̠ point t th firs byt o  strin t scan  String lik 
this may be evaluated by ZFNAME:

          HELP:*.HLP          A5:TEST.TXT
          C?:ABC.*            PASCAL:*.COM

     Not tha th use numbe fiel o th DU for ma contai 
 questio mark thi indicate al use areas  Th sam value 
ar returne a wit ZDNFIND bu  ca als tak o  '? 
character an th sca i terminate b an SYSLI  delimiter 
including:

          <Binary 0 or NULL>       <Space>
          = _ ; , < >

     An example on the use of ZFNAME:


          ...
          LXI  H,MYPATH  ; SET PATH FOR ZPFIND (USED BY ZFNAME)
          CALL ZINIEXT
          ...
          CALL PRINT
          DB   'Input Your File Name: ',0
          CALL BBLINE    ; GET LINE FROM USER
          RZ             ; ABORT IF EMPTY LINE
                            H NO POINT T FIRS CHA O LINE
          LXI  D,FCB     ; PT TO FCB
          CALL ZFNAME    ; PARSE NAME AND GET DATA
          JZ   FERR      ; ERROR IF ZERO FLAG SET
;
;  B IS NOW DISK NUMBER, C IS NOW USER NUMBER, AND HL PTS TO
;  TERMINATING CHAR ... PROCESSING MAY NOW CONTINUE AS DESIRED
;
          ...
FERR:     ...            ; ERROR ROUTINE
          ...
MYPATH    EQU  40H       ; ZCPR2 PATH BASE
FCB:      DS   36        ; SYSLIB FCB
          ...

.fo 5 - Numbers, CRC Check, and Sort Routines          Page #

5.0 Numeric String Evaluation, CRC Check, and Sort Routines

     Th las thre set o SYSLI routine whic remai t b 
discusse dea wit evaluatio o ASCI characte string whic 
ar intende t represen number (like "110 fo decima 11 o 
"ABCH fo hexadecima ABC) performin erro checkin usin 
Cycli Redundanc Chec algorithms an th SYSLI general-pur
pos sor routines.


5.01 Numeric String Evaluation

     Recognizin tha i wil b occasionall necessar fo th 
programme t b abl t accep  numbe a type i b th use 
an conver i t  binar for tha ca b use b th cod o 
th program  hav provide SYSLI wit  serie o  routine 
which perform such conversions.  These routines are:

          o EVAL2  -- convert binary digit strings to binary
          o EVAL8  -- convert octal digit strings to binary
          o EVAL10 -- convert decimal digit strings to binary
          o EVAL16 -- convert hexadecimal digit strings to binary
          o EVAL   -- determine base employed by user based on
                        an optional suffix character and convert

     I al cases th addres o th firs characte o th 
strin i passe t th routin i th H registe pair an th 
routin return  16-bi valu i D an a 8-bi valu i  
(A=E)  Evaluatio o th strin progresse fro th firs char
acte unti a invali digi (fo th appropriat base i en
countered an th routin return H pointin t th characte 
whic terminate th scan.

     EVAL evaluate binar characte string (onl '0 an '1 
ar th vali digits)  String lik "1010 ar evaluate an 
converte t binary  Give  strin lik "1010B" th routin 
wil sto whe i encounter th "B an retur wit H pointin 
to this character.

     EVAL evaluate octa characte string (onl '0 t '7 ar 
th vali digits)  EVAL1 evaluate decima characte string 
(onl '0 t '9 ar th digits) an EVAL1 evaluate hexa
decima characte string (onl '0 t '9 an 'A t 'F ar th 
digits an cas i no significan wit th letters).

     EVA̠ i th grandadd o th group an i accept string 
of the following forms:

          bbbbbbbbbbbbbbbbB -- b='0' or '1'; Binary string
          oooooooO or oooooooQ -- '0' <= o <= '7'; Octal string
          ttttt or tttttD -- '0' <= t <= '9'; Decimal string
          hhhhH or hhhhX -- '0' <= h <= 'F'; Hexadecimal string


     EVA determine th typ o strin use an call th appro
priat routin t perfor th conversion  EVA return on othe 
fla tha th others Carr Fla Se mean tha a invali strin 
forma wa given an H point t th offendin characte o 
exit.

     Th followin i a exampl o  cod segmen whic accept 
two numbers input by the user and adds them together:

          ...
          EXT  PRINT     ; USE SYSLIB PRINT STRING ROUTINE
          EXT  BBLINE    ; USE SYSLIB INPUT LINE EDITOR
          EXT  PHLDC     ; USE SYSLIB PRINT HL AS DEC ROUTINE
          EXT  CRLF      ; USE SYSLIB NEW LINE ROUTINE
          EXT  EVAL      ; USE SYSLIB EVAL ROUTINE
          ...
          CALL PRINT     ; PROMT USER
          DB   'Input Your Numbers, Separated by a Comma: ',0
          CALL BBLINE    ; GET LINE FROM USER
                         ;  HL POINTS TO FIRST ARGUMENT
          CALL EVAL      ; EXTRACT FIRST ARGUMENT
          JC   NUMERR    ; ERROR IF CARRY SET
          PUSH D         ; SAVE FIRST NUMBER ON STACK
          MOV  A,M       ; GET OFFENDING CHARACTER
          CPI  ','       ; ERROR IF IT IS NOT A COMMA
          JNZ  CERR
          INX  H         ; SKIP OVER THE COMMA
          CALL EVAL      ; GET THE 2ND NUMBER IN DE
          JC   NUMERR    ; PROCESS ERROR
          POP  H         ; GET FIRST NUMBER FROM STACK
          CALL CRLF      ; NEW LINE
          DAD  D         ; HL=HL+DE
          CALL PRINT
          DB   'The sum of these numbers is ',0
          CALL PHLDC     ; PRINT AS DECIMAL
          ...


     A th reade ca see th EVA famil o routine make 
numeri inpu conversio reall easy.



5.02 Cyclic Redundancy Checking

     Th SYSLI CR routine ma b use t chec th validit o 
a incomin seria byt strea o arbitrar length  The ar 
particularl goo i makin sur tha  give fil contain vali 
dat o tha dat transmitte vi th phon line (a pe  mode 
program wa correctl received  Thes routine comput an 
chec  tru 16-bi Cycli Redundanc Cod (CRC) an thei us 
will guarantee the detection of:

          o all single- and double-bit errors
          o all errors with an odd number of error bits
          o all burst errors of length 16 or less

Also, the CRC routines will detect the following:

          o 99.9969% of all 17-bit error bursts
          o 99.9984% of all possible longer error bursts

     Two sets of CRC routines are provided.  They are:

          CRC       CRC1      Function
          CRCCLR    CRC1CLR   Clear CRC Accumulator
          CRCUPD    CRC1UPD   Update CRC Accumulator
          CRCDONE   CRC1DONE  Done and Return CRC Value
          CRCK      CRC1K     Check CRC Values

     Th CRCxxx routine us th X^16+X^12+X^5+ polynomial an 
th CRC1xxx routine us th X^16+X^15+X^2+ polynomial  Th 
SYSLI programmer however nee no b concerne wit ho thi 
polynomia i applie internall .. jus tha i doe it job  
Th intereste reade i invite t examin th sourc code.

     Th CRCCL routin require n argument an return none  
It has no effect on any register.

     Th CRCUPĠ routin update th CR Accumulato wit th 
valu o th nex byte whic i passe t i i th  register  
No registers are affected by this routine.

     Th CRCDON routin terminate CR accumulatio an return 
the calculated 16-bit CRC value in the HL register pair.

     Finally th CRC routin check th accumulate CR valu 
fo Zero an return wit th Zer Fla Se (Z i suc i th 
cas (al inpu dat i validated)  Se exampl belo a t ho 
this is used.



     Th followin cod segmen illustrate  typica wa t us 
these routines:

          ...
          EXT  CRCCLR    ; CLEAR CRC
          EXT  CRCUPD    ; UPDATE CRC
          EXT  CRCDONE   ; RETURN CRC
          EXT  CRCK      ; CHECK CRC
          ...
;
;  ROUTINE TO COMPUTE TRANSMITTED CRC
;
CRC$MAKE:
          CALL CRCCLR    ; CLEAR ACCUMULATOR
          < Loop CALLing CRCUPD with Byte Values in A >
          CALL CRCDONE   ; GET VALUE
          SHLD CRCVAL    ; SAVE IT
          ...
;
;  ROUTINE TO EVALUATE INCOMING DATA FOR VALID CRC
;
CRC$CHECK:
          CALL CRCCLR    ; CLEAR ACCUMULATOR
          < Loop CALLing CRCUPD with Byte Values in A >
          LHLD CRCVAL    ; COMPARE AGAINST FINAL VALUE
          MOV  A,H       ; GET HIGH-ORDER FIRST
          CALL CRCUPD    ; UPDATE CRC
          MOV  A,L       ; GET LOW-ORDER NEXT
          CALL CRCUPD    ; UPDATE CRC
          CALL CRCK      ; CHECK CRC
          JZ   OK        ; PROCESS IF OK
;
;  THE ERROR ROUTINE GOES HERE
;
          ...



5.03 The SYSLIB Sort Routines

     Ther堠 ar tw SYSLI  routine whic giv th SYSLI 
programme acces t  ver flexibl sortin system  Th mai 
routin i calle SORT an i provide  utilit whic doe a 
in-memor sor o  se o fixed-lengt records  Th sortin 
techniqu use i  Shel Sort adapte fro th boo Softwar 
Tools b Kerniga an Plaugher publishe b Addison-Wesly 1976 
page 106.  This sort is much faster than the simple bubble sort.


     Th SOR routin ca b instructe t perfor th in-memor 
sor i on o tw way -- wit o withou usin pointers  
Sortin withou usin pointer i typicall slowe tha sortin 
wit pointers mainl becaus whe usin pointers  swa i don 
b simpl exchangin pointer ( byt values) whil  sor 
withou pointer require  swa t completel exchang th n-
byt record bein sorted  Th onl advantag t no usin 
pointer i th saving o th spac take u b th pointe 
table  Thi tabl require 2*(numbe o entrie t b sorted i 
bytes.

     Th SORԠ i controlle b passin  pointe t th Sor 
Specificatio Bloc (SSB i D t th SOR routine  Thi Sor 
Specificatio Bloc i  serie o si 2-byt word whic contai 
the following information:

          Bytes 0&1 -- Starting Address of 1st Record
          Bytes 2&3 -- Number of Records to Sort
          Bytes 4&5 -- Size of Each Record (in Bytes)
          Bytes 6&7 -- Address of Compare Routine Provided
                         by the Programmer
          Bytes 8&9 -- Address of a Pointer Table (if needed)
          Byte 10   -- Flag; 0 means to use pointers, 0FFH not
          Byte 11   -- Unused

     Tw routine ar provide i th SSOR modul o SYSLIB  
The ar SSBINIT whic i use t initializ buffer an i 
describe full i th SYSLI referenc manual an SORT whic 
perform th actua sort   wil no cove SSBINI her .. th 
interested reader is invited to read the reference manual.

     SOR accept a inpu  pointe t a SS i D an perform 
th sort  N error ar generated an n register ar affecte 
by SORT.  An example of a code sequence using SORT follows:

          ...
          EXT  SORT      ; SORT ROUTINE IN SYSLIB
          ...
          CALL CODEND    ; GET ADDRESS OF SCRATCH AREA FOR PTRS
          SHLD SSBPTR    ; SET ADDRESS IN SSB
          LXI  D,SSB     ; POINT TO SSB
          CALL SORT      ; DO THE SORT
          ...
;
;  THIS IS THE COMPARE ROUTINE
;
COMPARE:
          PUSH H         ; ONLY PSW MAY BE AFFECTED
          PUSH D
          PUSH B
          MVI  B,RECSIZ  ; SIZE OF RECORDS
CLOOP:
          LDAX D         ; COMPARE (DE) TO (HL)
          CMP  M
          JNZ  CDONE     ; RETURN WITH CARRY SET IF (DE)<(HL)
          INX  H         ; PT TO NEXT BYTE
          INX  D
          DCR  B         ; COUNT DOWN REQUIRED NUMBER OF BYTES
          JNZ  CLOOP
CDONE:
          POP  B         ; RESTORE REGISTERS
          POP  D
          POP  H
          RET            ; RETURN WITH CARRY SET IF (DE)<(HL)
                         ;   OR ZERO SET IF (DE)=(HL)
          ...
;
;  THE SORT SPECIFICATION BLOCK DEFINES THE SORT PARAMETERS
;
SSB:
          DW   REC1      ; ADDRESS OF FIRST RECORD
          DW   NREC      ; NUMBER OF RECORDS TO SORT
          DW   RECSIZ    ; SIZE OF EACH RECORD
          DW   COMPARE   ; ADDRESS OF COMPARE ROUTINE
SSBPTR:
          DS   2         ; ADDRESS OF POINTER TABLE, FILLED IN
                         ;   ABOVE
          DB   0,0       ; USE POINTERS
          ...
;
;  THE DATA TO SORT
;
REC1:
          DB   'THIS'    ; 4-BYTE RECORDS
          DB   'IS  '
          DB   'A   '
          DB   'TEST'
RECSIZ    EQU  4                   ; SIZE OF EACH RECORD
NREC      EQU  ($-REC1)/RECSIZ     ; NUMBER OF RECORDS
          ...
.fo 6 - What is SYSLIB?  SYSLIB Overview               Page #

6.0 What is SYSLIB?  SYSLIB Overview

     Fro th beginnin o thi document SYSLI (SYSte LIBrary 
wa describe a  collectio o ove 13 subroutine whic ar 
designe t provid t th CP/ 8080/Z8 assembl languag pro
gramme  se o function upo whic h ca buil hi programs  
Thi librar i intende t reliev th programme o th tas o 
frequentl "reinventin th wheel an t provid hi wit a 
environmen o reliabl tool whic encourage structure pro
grammin a th assembl languag level.

     I thi document  hav take yo throug al 130 routine 
i SYSLIB describin the i  functiona sens an givin 
example a t ho  intende the t b use an designe the 
t wor together.



6.01 Functional Overview of SYSLIB

     Th SYSLI routine ar groupe int  numbe o functiona 
categories.  In a nutshell, these categories are:

     Directory Manipulation Routines
          DIRF      DIRFS     DBUFFER   DPARAMS
          DFREE     FSIZE     DIRLOAD   DIRSLOAD
          DIRALPHA  DIRSEL    DIRPACK   DIRNPACK

     Numeric String Evaluation Routines
          EVAL      EVAL16    EVAL10    EVAL8
          EVAL2

     Byte-Oriented File Input/Output Routines (0<=n<=3)
          FIn$OPEN  FOn$OPEN  FIn$CLOSE FOn$CLOSE
          Fn$GET    Fn$PUT

     CP/M File Input/Output Routines
          F$OPEN    F$MOPEN   F$CLOSE   F$MAKE
          F$DELETE  F$RENAME  F$EXIST   F$READ
          F$WRITE

     File Name String Parser and FCB Initialization
          FNAME     INITFCB

     Input Line Editors
          BBLINE    BLINE     INLINE

     String Output Routines
          PRINT     LPRINT    PSTR      LPSTR


     NumeriOutpu Routine
          PHL4HC    LHL4HC    MHL4HC    PHL5DC
          LHL5DC    MHL5DC    PHLDC     LHLDC
          MHLDC     PA2HC     LA2HC     MA2HC
          PA3DC     LA3DC     MA3DC     PADC
          LADC      MADC

     String and Value Comparison Routines
          COMPHD    COMPB     COMPBC    SCANNER
          INSTR

     Character-Oriented Input/Output Routines
          CRLF      LCRLF     CONDIN    CST
          CIN       RIN       COUT      LOUT
          POUT      CCOUT     CLOUT     CPOUT

     Math Routines
          ADDHD     SUBHD     MULHD     DIVHD
          NEGH      CMPH      ROTLH     ROTRH
          SHFTLH    SHFTRH    ANDHD     ORHD
          XORHD

     CRC Routines
          CRCCLR    CRC1CLR   CRCUPD    CRC1UPD
          CRCDONE   CRC1DONE  CRCK      CRC1K

     Random Number Generator Routines
          RNDINIT   RNDSEED   RND

     User/Disk Manipulation Routines
          PUTUD     GETUD     LOGUD     RETUD

     Sort Routines
          SSBINIT   SORT

     ZCPR2 Feature-Specific Routines
          ZINIMC    ZINIEXT   ZCPRSET   ZGPINS
          ZCPRQ     ZMCPTR    ZPFIND    ZFSTAT

     ZCPR2-Specific Named Directory Routines
          ZFNINIT   ZDNAME    ZDNFIND   ZFNAME

     Misellaneous Routines
          BDOS      BIOS      CAPS      CAPSTR
          CATH      CODEND    EN        FILLB
          FILLBC    HFILB     HFILBC    MOVEB
          MOVEBC    HMOVB     HMOVBC    PAUSE
          VERSION



6.02 SYSLIB Documentation and Files and SYSLIB Availability

     SYSLI  documentatio i somewha extensive consistin o 
(1  112 pag SYSLI Use an Referenc Manual whic contain 
detail o al o th SYSLI routine an  se o seve sampl 
programs complet wit  sampl assembl an ru o eac pro
gra an (2  se o 1 HEL file whic ca b accesse onlin 
via the HELP program (new release coming out shortly to SIG/M).

     Th origina SYSLIB Versio 1 i currentl availabl i 
Volum 1 o th SIG/ disks  Us o thi versio i no recom
mende becaus th versio describe i thi documen greatl 
enhance th feature o th origina SYSLI an th origina 
SYSLI ha som problem dealin wit CP/ 2.2  Th ne SYSLIB 
describe i thi document wil b availabl i th SIG/͠ lib
rar soon  I wil probabl resid o thre disks an i con
tain th followin files:

                 Source Files to SYSLIB Modules

Filename.Typ Size K    Filename.Typ Size K    Filename.Typ Size K
------------ ------    ------------ ------    ------------ ------
S0FILEIO.MAC      2    SCOMP   .MAC      2    SEVAL4  .MAC      2
S1FILEIO.MAC      2    SCOMPHD .MAC      1    SFCLOS  .MAC      1
S2FILEIO.MAC      2    SCONDIN .MAC      1    SFDEL   .MAC      1
S3FILEIO.MAC      2    SCOUT   .MAC      1    SFEXIST .MAC      1
SBBLINE .MAC      3    SCPOUT  .MAC      2    SFILEIO .MAC      9
SBDOS   .MAC      1    SCRC    .MAC      4    SFILL   .MAC      2
SBIOS   .MAC      3    SCRC1   .MAC      4    SFMAKE  .MAC      1
SBLINE  .MAC      3    SCRLF   .MAC      1    SFNAME  .MAC      5
SCAPS   .MAC      1    SCST    .MAC      1    SFOPEN  .MAC      2
SCAPSTR .MAC      1    SDIR    .MAC     34    SFREAD  .MAC      1
SCATH   .MAC      1    SEN     .MAC      1    SFRENAME.MAC      2
SCCOUT  .MAC      2    SEVAL   .MAC      4    SFWRIT  .MAC      1
SCIN    .MAC      1    SEVAL1  .MAC      2    SHDR    .MAC      1
SCLOUT  .MAC      2    SEVAL2  .MAC      2    SINITFCB.MAC      1
SCODEND .MAC      1    SEVAL3  .MAC      2    SINLINE .MAC      6

SINSFORM.MAC      3    SLHL5DC .MAC      2    SMADC   .MAC      2
SINSTR  .MAC      2    SLOUT   .MAC      1    SMATH   .MAC      5
SLA2HC  .MAC      1    SLPRINT .MAC      1    SMHL4HC .MAC      1
SLADC   .MAC      2    SLPSTR  .MAC      2    SMHL5DC .MAC      3
SLCRLF  .MAC      1    SMA2HC  .MAC      1    SMOVE   .MAC      3
SLHL4HC .MAC      1

SPA2HC  .MAC      1    SRAND   .MAC      2    SYSTEST2.MAC      3
SPADC   .MAC      2    SRIN    .MAC      1    SYSTEST3.MAC      4
SPAUSE  .MAC      3    SSCANNER.MAC      2    SYSTEST4.MAC      6
SPHL4HC .MAC      1    SSORT   .MAC     14    SYSTEST5.MAC      2
SPHL5DC .MAC      2    SUD     .MAC      2    SYSTEST6.MAC      5
SPOUT   .MAC      1    SVERSION.MAC      1    SZCPR   .MAC      7
SPRINT  .MAC      1    SYSTEST .MAC      4    SZFNAME .MAC     16
SPSTR   .MAC      2    SYSTEST1.MAC      3    SZGPINS .MAC      3
   85 Files Occupying   244K

                     SYSLIB.REL Library File

Filename.Typ Size K
-------- --- ------
SYSLIB  .REL     13
    1 File Occupying    13K



           SYSLIB Help Files for Online Documentation

Filename.Typ Size K    Filename.Typ Size K    Filename.Typ Size K
-------- --- ------    -------- --- ------    -------- --- ------
SYSLIB  .HLP     15    SYSLIB5 .HLP      6    SYSLIB9 .HLP      7
SYSLIB1 .HLP     14    SYSLIB6 .HLP      4    SYSLIBA .HLP      7
SYSLIB2 .HLP      4    SYSLIB7 .HLP      6    SYSLIBB .HLP      5
SYSLIB3 .HLP      8    SYSLIB8 .HLP      6    SYSLIBC .HLP      9
SYSLIB4 .HLP      6
   13 Files Occupying    97K



   SYSLIB Document Files, Including User and Reference Manual

Filename.Typ Size K    Filename.Typ Size K    Filename.Typ Size K
-------- --- ------    -------- --- ------    -------- --- ------
SYSLIB  .WS     104    SYSLIBI .WS      10    SYSLIBR .WS       3
SYSLIBHD.WS      16    SYSLIBID.WS       3    SYSLIBS .WS      42
    6 Files Occupying   178K



6.03 Distribution Statement for SYSLIB

     SYSLI i release t th publi domain  Anyon wh wishe 
t US i ma d s wit n string attached  Th autho assume 
n responsibilit o liabilit fo th us o SYSLIB  I i 
copyrighte b th author Richar Conn wh ha sol right t 
it  SYSLI  an it associate documentatio ma b sol b 
itsel o a a independen par o  packag o program onl 
wit th express writte consen o th author  Th author 
however support th us o SYSLI b commercia softwar devel
opers an place n restrictio o th sal o program whic 
ar base o SYSLI an us routine containe withi SYSLI  t 
perfor thei majo functions.


