;********************************************************
;*							*
;*		KEYBOARD INPUT DEFINITION		*
;*							*
;*		  SIMULATED FUNCTION			*
;*    KEYS WITH CPM IN GENERAL; THE SORCERER COMPUTER	*
;*    IN PARTICULAR, USING KIP.HEX AND KID.COM &  DDT	*
;*							*
;*    AS PUBLISHED IN DR DOBBS JOURNAL, ISSUE 55  MAY	*
;*    1981, BY JOHN B PALMER.				*
;*	   P.O. BOX 23					*
;*	   BOONSVILLE, CA, 95415			*
;*	   USA						*
;*							*
;*	See the Dr. Dobbs article for commented code	*
;*							*
;********************************************************
;
;	Keyed in By	John Cepak
;		 	Australia
;
MAXI	EQU	4
BOOT	EQU	0
BDOS	EQU	5
FCBL	EQU	05CH
FTYP	EQU	FCBL+9
FCBCR	EQU	FCBL+32
PRINTF	EQU	9
OPENF	EQU	15
CLOSEF	EQU	16
READF	EQU	20
SETDMA	EQU	26
LF	EQU	0AH
CR	EQU	0DH
;
FRERAM	EQU	5C00H
;
	ORG	100H
;
	JMP	BEGIN
;
FREPTR:	DW	FRERAM
CSVPTR:	DS	2
CIVPTR:	DS	2
DMATMP:	DW	0
COUNT:	DB	0
;
BEGIN:
	LXI	D,FTYP
	LXI	B,03
	LXI	H,KIDFIL
	CALL	MOVIT
	JMP	OPEN
;
MOVIT:
	MOV	A,B
	ORA	C
	RZ
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCX	B
	JMP	MOVIT
;
OPEN:
	LHLD	FREPTR
	LXI	D,256
	DAD	D
	SHLD	DMATMP
	XCHG
	MVI	C,SETDMA
	CALL	BDOS
	LXI	D,FCBL
	MVI	C,OPENF
	CALL	BDOS
	INR	A
	LXI	D,MESNOF
	JZ	FINISH
READ:
	LXI	D,FCBL
	MVI	C,READF
	CALL	BDOS
	ORA	A
	JNZ	CLOSE
	LXI	H,COUNT
	INR	M
	MOV	A,MAXI
	DB	0BEH
	LXI	D,MESBIG
	JC	FINISH
	LHLD	DMATMP
	LXI	D,128
	DAD	D
	SHLD	DMATMP
	XCHG
	MVI	C,SETDMA
	CALL	BDOS
	JMP	READ
;
CLOSE:
	LXI	D,FCBL
	MVI	C,CLOSEF
	CALL	BDOS
	JMP	MODIFY
;
MESNOF:	DB	'NO'
KIDFIL:	DB	'KID FILE $'
MESBIG:	DB	'KID FILE IS TOO BIG $'
NOKIP:	DB	'KIP ABSENT $'
ALLOK:	DB	'KID READ OK $'
;
PATCH:
	LHLD	CSVPTR
	CALL	LOADDE
	LHLD	FREPTR
	INX	H
	CALL	STORDE
	LHLD	CIVPTR
	CALL	LOADDE
	LHLD	FREPTR
	LXI	B,4
	DAD	B
	CALL	STORDE
	LHLD	FREPTR
	LXI	B,6
	DAD	B
	XCHG
	LHLD	CSVPTR
	CALL	STORDE
	LHLD	FREPTR
	LXI	B,9
	DAD	B
	XCHG
	LHLD	CIVPTR
	CALL	STORDE
	RET
;
LOADDE:
	MOV	E,M
	INX	H
	MOV	D,M
	RET
;
STORDE:
	MOV	M,E
	INX	H
	MOV	M,D
	RET
;
TSTJMP:
	LHLD	FREPTR
	MVI	A,0C3H
	CMP	M
	STC
	RNZ
	INX	H
	MOV	A,M
	ORA	A
	RNZ
	INX	H
	MOV	A,M
	ORA	A
	RET
;
MODIFY:
	LHLD	01
	LXI	D,3
	DAD	D
	INX	H
	SHLD	CSVPTR
	INX	H
	INX	H
	INX	H
	SHLD	CIVPTR
	CALL	TSTJMP
	LXI	D,NOKIP
	JC	FINISH
	CZ	PATCH
	LXI	D,ALLOK
FINISH:
	MVI	C,PRINTF
	CALL	BDOS
	JMP	BOOT
;
	END
