;********************************************************
;*							*
;*	FOR GODBOUT INTERFACER 1/2 SERIAL I/O BOARD	*
;*							*
;********************************************************
;
;	April 22, 1981
;
;	By	Bill Bolton
;		Software Tools
;		P.O. Box 80
;		Newport Beach
;		NSW, 2106
;		Australia
;
;
BEGIN	ORG	103H
INITIL	JMP	INITIU			;UART/USART INITIALISATION ENTRY POINT
INSPORT	JMP	INSPRU			;STATUS PORT READ ENTRY POINT
ERRSET	JMP	ERRSTU			;UART/USART ERROR RESET ENTRY POINT
INPORT	JMP	INPRTU			;READ DATA PORT ENTRY POINT
OUTPORT	JMP	OUTPRU			;WRITE DATA PORT ENTRY POINT
;
;
TP	EQU	38H			;DATA PORT
TPS	EQU	TP+1			;STATUS PORT
;
;
INITIU:
	CALL	SIGNON			;TELL USER WHAT'S IMPLEMENTED
	RET				;RETURN TO BSTAM
;
;
;			THIS IS THE STATUS READ PORT ROUTINE.
;			WHEN EXITING THIS ROUTINE BSTAM EXPECTS IN REGISTER A
;			THE FOLLOWING BITS TO BE SET IF NEEDED:
;			1. 20 BIT SET IF FRAMING ERROR
;			2. 10 BIT SET IF OVERRUN ERROR
;			3. 08 BIT SET IF PARITY  ERROR
;			4. 04 BIT SET IF TRANSMITTER EMPTY
;				IF YOUR UART/USART DOES NOT HAVE TRANSMITTER
;				EMPTY FEATURE, THEN ALWAYS SET THIS BIT ON.
;			5. 02 BIT SET IF RECEIVER READY
;			6. 01 BIT SET IF TRANSMITTER READY
;			7. DO NOT SET THE 80 BIT OR 40 BIT
;
INSPRU:
	IN	TPS		;GET INFO BITS FROM INTERFACER STATUS PORT
	ANI	2BH		;MASK OUT RELEVANT BITS
	XRI	04H		;FORCE TX EMPTY ON
	RET			;RETURN TO BSTAM
;
;
;			THIS IS THE ERROR RESET FOR UART/USART ROUTINE.
;			YOUR UART/USART MAY NOT NEED TO BE RESET IF FRAMING,
;			OVERRUN, OR PARITY ERROR IS FOUND. IF THIS IS YOUR
;			CASE, JUST DO A RETURN.
;
ERRSTU:
	RET			;RETURN TO BSTAM
;
;
;			THIS IS THE READ DATA PORT ROUTINE.
;			BEFORE THIS ROUTINE IS ENTERED THE 02 BIT OF
;			STATUS READ ROUTINE MUST HAVE BEEN SET.
;			DO NOT CLEAR THE 80 BIT FROM THE DATA INPUT PORT.
;			RETURN WITH REGISTER A LOADED WITH INPUT DATA.
;
INPRTU:
	IN	TP		;GET DATA FROM PORT
	RET			;RETURN TO BSTAM
;
;
;			THIS IS THE WRITE DATA PORT ROUTINE.
;			BEFORE THIS ROUTINE IS ENTERED THE 04 BIT AND 01 BIT
;			OF STATUS READ MUST BE SET.
;			DO NOT CLEAR THE 80 BIT FROM THE DATA OUTPUT PORT.
;			REGISTER A CONTAINS THE OUTPUT DATA.
;
OUTPRU:
	OUT	TP		;SEND DATA TO REMOTE CPU
	RET			;RETURN TO BSTAM
;
MESSGE:	DB	0DH,0AH,0DH,0AH
	DB	'Version 4.5 - April 22,1981',0DH,0AH
	DB	'For Godbout "Interfacer" S-100 I/O Card,',0DH,0AH
	DB	'using an 1602 UART at ports 38H/39H, no parity.',0DH,0AH,'$'
;
SIGNON:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,MESSGE
	MVI	C,9
	CALL	5		;ANOUNCE VERSION TO USER
	POP	H
	POP	D
	POP	B
	RET
;
	END	BEGIN
