;	BIOS PATCH FOR COLD BOOT COMMAND EXECUTION
;
;************************************************************
;THE FOLLOWING CODE SHOULD BE ADDED IN THE COLD BOOT SECTION
;OF BIOS BEFORE THE JUMP TO THE CCP IS MADE.  IT MAY BE LOCATED
;IN THE DEVICE DRIVER INITIALIZATION SECTION OF YOUR BIOS OR IN
;ANY SECTION OF BIOS THAT IS OVERWRITTEN BY BUFFERS AND CALLED
;FROM THE COLD BOOT SECTION BUT UNDER NO CIRCUMSTANCES SHOULD
;IT BE LOCATED SO THAT ANY PORTION OF IT OCCUPIES SPACE ABOVE
; BIOS + 380H AS THIS SPACE MAY EXIST IN MEMORY BUT IT DOES
;NOT EXIST ON A SINGLE DENSITY SYSTEM.(TRACK1,SECTOR 26 HOLDS
;MEMORY FROM BIOS+300H TO BIOS+37FH).
;USE THE CODEND AND DSKEND EQUATES TO INSURE THAT IT WILL FIT.
;CHECK THE REST OF THE CODE TO INSURE THAT IT DOESN'T PASS
;DSKEND TOO.
; ALSO CHECK TO SEE IF ANY REGISTERS NEED TO BE SAVED AS
;THIS ROUTINE AFFECTS PSW, D/E, AND H/L.  THEY SHOULD BE
;PUSHED PRIOR AND POPPED AFTER IF IN DOUBT.
; ALSO CHECK THE END OF YOUR BIOS COLD BOOT ROUTINE TO SEE IF
;IT JUMPS TO CCP OR TO CCP+3.  IF IT GOES TO CCP+3 IT WILL
;CLEAR THE COMMAND FROM THE BUFFER BEFORE EXECUTING IT, AND
;MUST BE CHANGED TO JUST 'CCP'.
;
;**********  CODE STARTS HERE  **************
;
; OFFSET USED FOR COLD BOOT MESAGE
CCPBUF	EQU	CCP+7	;LOC TO PUT COLD BOOT COMMAND
BUFLEN	EQU	32	;OR WHATEVER YOUR SYSTEM REQUIRES
			;SHOULD MATCH THE OTHER SECTIONS
;
; THE ACTUAL COLD BOOT BUFFER IS LOCATED IN THE UNUSED
; SECTION OF BDOS JUST BEFORE BIOS'S ORG LOCATION.
; EVEN IF BDOS NEEDS THIS AREA, IT IS ONLY USED BY BIOS
; BEFORE THE JUMP TO BDOS, AND AT THAT TIME IT MAY BE
; OVERWRITTEN SINCE IT WILL BE RELOADED FROM DISK IF NEEDED.
;
MESSAG	EQU	BIOS-BUFLEN-3	;PUT MESSAGE IN UNUSED
				;SECTION OF BDOS
;
; COPY STRING ROUTINE FROM BIOS BUFFER TO CCP BUFFER
; ONLY DURING COLD BOOT.
;
	LXI	H,CCPBUF	;POINT TO CCP BUFFER
	LXI	D,MESSAG	;POINT TO MESSAGE
MSGLOP:	LDAX	D		;GET BYTE
	MOV	M,A		;PUT IT
	INX	D		;NEXT SOURCE
	INX	H		;NEXT DESTINATION
	ORA	A		;DID WE DO ZERO
	JNZ	MSGLOP		;LOOP TILL WE DID
;
CODEND	EQU	$		;END OF CODE
	;NOTE:  CODEND MAY BE PUT AT THE END OF YOUR
	;BIOS CODE TO GIVE YOU AN INDICATION THAT IT
	; WILL OR WILL NOT FIT ON THE SYSTEM TRACKS.
;
DSKEND	EQU	BIOS+380H	;END OF SYSTEM ON DISK
	; IF THE VALUE OF 'CODEND' IS GREATER THAN
	; THE VALUE OF 'DSKEND', THEN THE CODE
	; WILL NOT FIT ON A SINGLE DENSITY SYSTEM DISK.
;
;**********************************************************
; END OF MODIFICATIONS
