C RAPPL1- SPECIAL PURPOSE ROOM ROUTINES, PART 1
C
C COPYRIGHT 1980, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. 02142
C ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED
C WRITTEN BY R. M. SUPNIK
C
C DECLARATIONS
C
	LOGICAL FUNCTION RAPPL1(RI)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QOPEN,QON,QHERE,PROB,F
	LOGICAL MOVETO,LIT
C
C PARSER OUTPUT
C
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
C
C GAME STATE
C
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
	1	LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
C
C SCREEN OF LIGHT
C
	COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
	COMMON /SCREEN/ SCOLDR(8),SCOLWL(12)
C
C MISCELLANEOUS VARIABLES
C
	COMMON /BATS/ BATDRP(9)
C
C ROOMS
C
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(200),REXIT(200),
	1	RACTIO(200),RVAL(200),RFLAG(200)
	INTEGER RRAND(200)
	EQUIVALENCE (RVAL,RRAND)
C
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
	1	RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
C
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
	COMMON /RINDEX/ CPANT,CPOUT,CPUZZ
C
C OBJECTS
C
	COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
	1	OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
	2	OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
	3	OADV(220),OCAN(220),OREAD(220)
C
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
	1	NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
	2	TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
	1	WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
	2	TCHBT,VEHBT,SCHBT
C
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ WARNI,CSLIT,GCARD,STLDR
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
C
C CLOCK INTERRUPTS
C
	LOGICAL*1 CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
C
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
	1	CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
	2	CEVGNO,CEVBUC,CEVSPH,CEVEGH,
	3	CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
	5	CEVMRS,CEVPIN,CEVINQ,CEVFOL

C
	LOGICAL THFFLG,THFACT,SWDACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT
C
C ADVENTURERS
C
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
	1	AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
C
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
C
C VERBS
C
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
C
C FLAGS
C
	LOGICAL*1 TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL*1 DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL*1 MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL*1 EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL*1 GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL*1 GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL*1 MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL*1 FOLLWF,SPELLF,CPOUTF,CPUSHF
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
	1	DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
	2	MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
	3	EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
	4	GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
	5	GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
	6	MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
	7	FOLLWF,SPELLF,CPOUTF,CPUSHF
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL,CPHERE
C
C FUNCTIONS AND DATA
C
	QOPEN(R)=(OFLAG2(R).AND.OPENBT).NE.0
	QON(R)=(OFLAG1(R).AND.ONBT).NE.0
C RAPPL1, PAGE 2
C
	RAPPL1=.TRUE.				!USUALLY IGNORED.
	IF(RI.EQ.0) RETURN			!RETURN IF NAUGHT.
C						!SET TO FALSE FOR
C						!NEW DESC NEEDED.
	GO TO (1000,2000,3000,4000,5000,6000,7000,8000,9000,10000,
	1 11000,12000,13000,14000,15000,16000,17000,18000,19000,20000,
	2 21000,22000,23000,24000,25000,26000,27000,28000,29000,30000,
	3 31000,32000,33000,34000,35000,36000,37000),RI
	CALL BUG(1,RI)
C
C R1--	EAST OF HOUSE.  DESCRIPTION DEPENDS ON STATE OF WINDOW
C
1000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	I=13					!ASSUME CLOSED.
	IF(QOPEN(WINDO)) I=12			!IF OPEN, AJAR.
	CALL RSPSUB(11,I)			!DESCRIBE.
	RETURN
C
C R2--	KITCHEN.  SAME VIEW FROM INSIDE.
C
2000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	I=13					!ASSUME CLOSED.
	IF(QOPEN(WINDO)) I=12			!IF OPEN, AJAR.
	CALL RSPSUB(14,I)			!DESCRIBE.
	RETURN
C
C R3--	LIVING ROOM.  DESCRIPTION DEPENDS ON MAGICF (STATE OF
C	DOOR TO CYCLOPS ROOM), RUG (MOVED OR NOT), DOOR (OPEN OR CLOSED)
C
3000	IF(PRSA.NE.LOOKW) GO TO 3500		!LOOK?
	I=15					!ASSUME NO HOLE.
	IF(MAGICF) I=16				!IF MAGICF, CYCLOPS HOLE.
	CALL RSPEAK(I)				!DESCRIBE.
	I=17+ORRUG				!ASSUME INITIAL STATE.
	IF(QOPEN(DOOR)) I=I+2			!DOOR OPEN?
	CALL RSPEAK(I)				!DESCRIBE.
	RETURN
C
C	NOT A LOOK WORD.  REEVALUATE TROPHY CASE.
C
3500	IF((PRSA.NE.TAKEW).AND.((PRSA.NE.PUTW).OR.(PRSI.NE.TCASE)))
	1	RETURN				!IF NOT TAKE OR PUT.
	ASCORE(WINNER)=RWSCOR			!SCORE TROPHY CASE.
	DO 3600 I=1,OLNT			!RETAIN RAW SCORE AS WELL.
	  J=I					!FIND OUT IF IN CASE.
3550	  J=OCAN(J)				!TRACE OWNERSHIP.
	  IF(J.EQ.0) GO TO 3600
	  IF(J.NE.TCASE) GO TO 3550		!DO ALL LEVELS.
	  ASCORE(WINNER)=ASCORE(WINNER)+OTVAL(I)
3600	CONTINUE
	CALL SCRUPD(0)				!SEE IF ENDGAME TRIG.
	RETURN
C RAPPL1, PAGE 3
C
C R4--	CELLAR.  SHUT DOOR AND BAR IT IF HE JUST WALKED IN.
C
4000	IF(PRSA.NE.LOOKW) GO TO 4500		!LOOK?
	CALL RSPEAK(21)				!DESCRIBE CELLAR.
	RETURN
C
4500	IF(PRSA.NE.WALKIW) RETURN		!WALKIN?
	IF((OFLAG2(DOOR).AND.(OPENBT+TCHBT)).NE.OPENBT) RETURN
	OFLAG2(DOOR)=(OFLAG2(DOOR).OR.TCHBT).AND. .NOT.OPENBT
	CALL RSPEAK(22)				!SLAM AND BOLT DOOR.
	RETURN
C
C R5--	MAZE11.  DESCRIBE STATE OF GRATING.
C
5000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	CALL RSPEAK(23)				!DESCRIBE.
	I=24					!ASSUME LOCKED.
	IF(GRUNLF) I=26				!UNLOCKED?
	IF(QOPEN(GRATE)) I=25			!OPEN?
	CALL RSPEAK(I)				!DESCRIBE GRATE.
	RETURN
C
C R6--	CLEARING.  DESCRIBE CLEARING, MOVE LEAVES.
C
6000	IF(PRSA.NE.LOOKW) GO TO 6500		!LOOK?
	CALL RSPEAK(27)				!DESCRIBE.
	IF(RVCLR.EQ.0) RETURN			!LEAVES MOVED?
	I=28					!YES, ASSUME GRATE CLOSED.
	IF(QOPEN(GRATE)) I=29			!OPEN?
	CALL RSPEAK(I)				!DESCRIBE GRATE.
	RETURN
C
6500	IF((RVCLR.NE.0).OR.(QHERE(LEAVE,CLEAR).AND.
	1	((PRSA.NE.MOVEW).OR.(PRSO.NE.LEAVE)))) RETURN
	CALL RSPEAK(30)				!MOVE LEAVES, REVEAL GRATE.
	RVCLR=1					!INDICATE LEAVES MOVED.
	RETURN
C RAPPL1, PAGE 4
C
C R7--	RESERVOIR SOUTH.  DESCRIPTION DEPENDS ON LOW TIDE FLAG.
C
7000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	I=31					!ASSUME FULL.
	IF(LWTIDF) I=32				!IF LOW TIDE, EMPTY.
	CALL RSPEAK(I)				!DESCRIBE.
	CALL RSPEAK(33)				!DESCRIBE EXITS.
	RETURN
C
C R8--	RESERVOIR.  STATE DEPENDS ON LOW TIDE FLAG.
C
8000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	I=34					!ASSUME FULL.
	IF(LWTIDF) I=35				!IF LOW TIDE, EMTPY.
	CALL RSPEAK(I)				!DESCRIBE.
	RETURN
C
C R9--	RESERVOIR NORTH.  ALSO DEPENDS ON LOW TIDE FLAG.
C
9000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	I=36					!YOU GET THE IDEA.
	IF(LWTIDF) I=37
	CALL RSPEAK(I)
	CALL RSPEAK(38)
	RETURN
C
C R10--	GLACIER ROOM.  STATE DEPENDS ON MELTED, VANISHED FLAGS.
C
10000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	CALL RSPEAK(39)				!BASIC DESCRIPTION.
	I=0					!ASSUME NO CHANGES.
	IF(GLACMF) I=40				!PARTIAL MELT?
	IF(GLACRF) I=41				!COMPLETE MELT?
	CALL RSPEAK(I)				!DESCRIBE.
	RETURN
C
C R11--	FOREST ROOM
C
11000	IF(PRSA.EQ.WALKIW) CFLAG(CEVFOR)=.TRUE.	!IF WALK IN, BIRDIE.
	RETURN
C
C R12--	MIRROR ROOM.  STATE DEPENDS ON MIRROR INTACT.
C
12000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	CALL RSPEAK(42)				!DESCRIBE.
	IF(MIRRMF) CALL RSPEAK(43)		!IF BROKEN, NASTY REMARK.
	RETURN
C RAPPL1, PAGE 5
C
C R13--	CAVE2 ROOM.  BLOW OUT CANDLES WITH 50% PROBABILITY.
C
13000	IF(PRSA.NE.WALKIW) RETURN		!WALKIN?
	IF(PROB(50,50).OR.(OADV(CANDL).NE.WINNER).OR.
	1	.NOT.QON(CANDL)) RETURN		!BLOW EM OUT?
	OFLAG1(CANDL)=OFLAG1(CANDL).AND. .NOT. ONBT	!YES.
	CALL RSPEAK(47)				!TELL OF WINDS.
	CFLAG(CEVCND)=.FALSE.			!HALT CANDLE COUNTDOWN.
	RETURN
C
C R14--	BOOM ROOM.  BLOW HIM UP IF CARRYING FLAMING OBJECT.
C
14000	J=ODESC2(CANDL)				!ASSUME CANDLE.
	IF((OADV(CANDL).EQ.WINNER).AND.QON(CANDL)) GO TO 14100
	J=ODESC2(TORCH)				!ASSUME TORCH.
	IF((OADV(TORCH).EQ.WINNER).AND.QON(TORCH)) GO TO 14100
	J=ODESC2(MATCH)
	IF((OADV(MATCH).EQ.WINNER).AND.QON(MATCH)) GO TO 14100
	RETURN					!SAFE
C
14100	IF(PRSA.NE.TRNONW) GO TO 14200		!TURN ON?
	CALL RSPSUB(294,J)			!BOOM!
	CALL JIGSUP(44)
	RETURN
C
14200	IF(PRSA.NE.WALKIW) RETURN		!WALKIN?
	CALL RSPSUB(295,J)			!BOOM!
	CALL JIGSUP(44)
	RETURN
C
C R15--	NO-OBJS.  SEE IF EMPTY HANDED, SCORE LIGHT SHAFT.
C
15000	EMPTHF=.TRUE.				!ASSUME TRUE.
	DO 15100 I=1,OLNT			!SEE IF CARRYING.
	  IF(OADV(I).EQ.WINNER) EMPTHF=.FALSE.
15100	CONTINUE
C
	IF((HERE.NE.BSHAF).OR.(.NOT.LIT(HERE))) RETURN
	CALL SCRUPD(LTSHFT)			!SCORE LIGHT SHAFT.
	LTSHFT=0				!NEVER AGAIN.
	RETURN
C RAPPL1, PAGE 6
C
C R16--	MACHINE ROOM.  DESCRIBE MACHINE.
C
16000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	I=46					!ASSUME LID CLOSED.
	IF(QOPEN(MACHI)) I=12			!IF OPEN, OPEN.
	CALL RSPSUB(45,I)			!DESCRIBE.
	RETURN
C
C R17--	BAT ROOM.  UNLESS CARRYING GARLIC, FLY AWAY WITH ME...
C
17000	IF(PRSA.NE.LOOKW) GO TO 17500		!LOOK?
	CALL RSPEAK(48)				!DESCRIBE ROOM.
	IF(OADV(GARLI).EQ.WINNER) CALL RSPEAK(49) !BAT HOLDS NOSE.
	RETURN
C
17500	IF((PRSA.NE.WALKIW).OR.(OADV(GARLI).EQ.WINNER)) RETURN
	CALL RSPEAK(50)				!TIME TO FLY, JACK.
	F=MOVETO(BATDRP(RND(9)+1),WINNER)	!SELECT RANDOM DEST.
	RAPPL1=.FALSE.				!INDICATE NEW DESC NEEDED.
	RETURN
C
C R18--	DOME ROOM.  STATE DEPENDS ON WHETHER ROPE TIED TO RAILING.
C
18000	IF(PRSA.NE.LOOKW) GO TO 18500		!LOOK?
	CALL RSPEAK(51)				!DESCRIBE.
	IF(DOMEF) CALL RSPEAK(52)		!IF ROPE, DESCRIBE.
	RETURN
C
18500	IF(PRSA.EQ.LEAPW) CALL JIGSUP(53)	!DID HE JUMP???
	RETURN
C
C R19--	TORCH ROOM.  ALSO DEPENDS ON WHETHER ROPE TIED TO RAILING.
C
19000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	CALL RSPEAK(54)				!DESCRIBE.
	IF(DOMEF) CALL RSPEAK(55)		!IF ROPE, DESCRIBE.
	RETURN
C
C R20--	CAROUSEL ROOM.  SPIN HIM OR KILL HIM.
C
20000	IF(PRSA.NE.LOOKW) GO TO 20500		!LOOK?
	CALL RSPEAK(56)				!DESCRIBE.
	IF(.NOT.CAROFF) CALL RSPEAK(57)		!IF NOT FLIPPED, SPIN.
	RETURN
C
20500	IF((PRSA.EQ.WALKIW).AND.CAROZF) CALL JIGSUP(58)	!WALKED IN.
	RETURN
C RAPPL1, PAGE 7
C
C R21--	LLD ROOM.  HANDLE EXORCISE, DESCRIPTIONS.
C
21000	IF(PRSA.NE.LOOKW) GO TO 21500		!LOOK?
	CALL RSPEAK(59)				!DESCRIBE.
	IF(.NOT.LLDF) CALL RSPEAK(60)		!IF NOT VANISHED, GHOSTS.
	RETURN
C
21500	IF(PRSA.NE.EXORCW) RETURN		!EXORCISE?
	IF((OADV(BELL).EQ.WINNER).AND.(OADV(BOOK).EQ.WINNER).AND.
	1	(OADV(CANDL).EQ.WINNER).AND.QON(CANDL)) GO TO 21600
	CALL RSPEAK(62)				!NOT EQUIPPED.
	RETURN
C
21600	IF(QHERE(GHOST,HERE)) GO TO 21700	!GHOST HERE?
	CALL JIGSUP(61)				!NOPE, EXORCISE YOU.
	RETURN
C
21700	CALL NEWSTA(GHOST,63,0,0,0)		!VANISH GHOST.
	LLDF=.TRUE.				!OPEN GATE.
	RETURN
C
C R22--	LLD2-ROOM.  IS HIS HEAD ON A POLE?
C
22000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	CALL RSPEAK(64)				!DESCRIBE.
	IF(ONPOLF) CALL RSPEAK(65)		!ON POLE?
	RETURN
C
C R23--	DAM ROOM.  DESCRIBE RESERVOIR, PANEL.
C
23000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	CALL RSPEAK(66)				!DESCRIBE.
	I=67
	IF(LWTIDF) I=68
	CALL RSPEAK(I)				!DESCRIBE RESERVOIR.
	CALL RSPEAK(69)				!DESCRIBE PANEL.
	IF(GATEF) CALL RSPEAK(70)		!BUBBLE IS GLOWING.
	RETURN
C
C R24--	TREE ROOM
C
24000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	CALL RSPEAK(660)			!DESCRIBE.
	I=661					!SET FLAG FOR BELOW.
	DO 24200 J=1,OLNT			!DESCRIBE OBJ IN FORE3.
	  IF(.NOT.QHERE(J,FORE3).OR.(J.EQ.FTREE)) GO TO 24200
	  CALL RSPEAK(I)			!SET STAGE,
	  I=0
	  CALL RSPSUB(502,ODESC2(J))		!DESCRIBE.
24200	CONTINUE
	RETURN
C RAPPL1, PAGE 8
C
C R25--	CYCLOPS-ROOM.  DEPENDS ON CYCLOPS STATE, ASLEEP FLAG, MAGIC FLAG.
C
25000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	CALL RSPEAK(606)			!DESCRIBE.
	I=607					!ASSUME BASIC STATE.
	IF(RVCYC.GT.0) I=608			!>0?  HUNGRY.
	IF(RVCYC.LT.0) I=609			!<0?  THIRSTY.
	IF(CYCLOF) I=610			!ASLEEP?
	IF(MAGICF) I=611			!GONE?
	CALL RSPEAK(I)				!DESCRIBE.
	IF(.NOT.CYCLOF .AND.(RVCYC.NE.0))
	1	CALL RSPEAK(193+IABS(RVCYC))	!CYCLOPS IS ANNOYED.
	RETURN
C
C R26--	BANK BOX ROOM.
C
26000	IF(PRSA.NE.WALKIW) RETURN		!SURPRISE HIM.
	DO 26100 I=1,8,2			!SCOLRM DEPENDS ON
	  IF(FROMDR.EQ.SCOLDR(I)) SCOLRM=SCOLDR(I+1)
26100	CONTINUE				!ENTRY DIRECTION.
	RETURN
C
C R27--	TREASURE ROOM.
C
27000	IF((PRSA.NE.WALKIW).OR. .NOT.THFACT)
	1	RETURN				!WALKIN, THIEF ACTIVE?
	IF(OROOM(THIEF).NE.HERE)
	1	CALL NEWSTA(THIEF,82,HERE,0,0)	!NO, MATERIALIZE HIM.
	THFPOS=HERE				!RESET SEARCH PATTERN.
	OFLAG2(THIEF)=OFLAG2(THIEF).OR.FITEBT	!HE'S ANGRY.
	IF(OROOM(CHALI).EQ.HERE)
	1	OFLAG1(CHALI)=OFLAG1(CHALI).AND..NOT.TAKEBT
C
C	VANISH EVERYTHING IN ROOM
C
	J=0					!ASSUME NOTHING TO VANISH.
	DO 27200 I=1,OLNT
	  IF((I.EQ.CHALI).OR.(I.EQ.THIEF).OR..NOT.QHERE(I,HERE))
	1	GO TO 27200			!HERE?
	  J=83					!FLAG BYEBYE.
	  OFLAG1(I)=OFLAG1(I).AND..NOT.VISIBT	!AWAY IT GOES.
27200	CONTINUE
	CALL RSPEAK(J)				!DESCRIBE.
	RETURN
C
C R28--	CLIFF FUNCTION.  SEE IF CARRYING INFLATED BOAT.
C
28000	DEFLAF=OADV(RBOAT).NE.WINNER		!TRUE IF NOT CARRYING.
	RETURN
C RAPPL1, PAGE 9
C
C R29--	RIVR4 ROOM.  PLAY WITH BUOY.
C
29000	IF(.NOT.BUOYF.OR.(OADV(BUOY).NE.WINNER)) RETURN
	CALL RSPEAK(84)				!GIVE HINT,
	BUOYF=.FALSE.				!THEN DISABLE.
	RETURN
C
C R30--	OVERFALLS.  DOOM.
C
30000	IF(PRSA.NE.LOOKW) CALL JIGSUP(85)	!OVER YOU GO.
	RETURN
C
C R31--	BEACH ROOM.  DIG A HOLE.
C
31000	IF((PRSA.NE.DIGW).OR.(PRSO.NE.SHOVE)) RETURN
	RVSND=RVSND+1				!INCREMENT DIG STATE.
	GO TO (31100,31100,31100,31400,31500),RVSND !PROCESS STATE.
	CALL BUG(2,RVSND)
C
31100	CALL RSPEAK(85+RVSND)			!1-3... DISCOURAGE HIM.
	RETURN
C
31400	I=89					!ASSUME DISCOVERY.
	IF((OFLAG1(STATU).AND.VISIBT).NE.0) I=88 !ALREADY DONE.
	CALL RSPEAK(I)
	OFLAG1(STATU)=OFLAG1(STATU).OR.VISIBT	!MATERIALIZE STATUE.
	RETURN
C
31500	RVSND=0					!5... SAND COLLAPSES
	CALL JIGSUP(90)				!AND SO DOES HE.
	RETURN
C
C R32--	TCAVE ROOM.  DIG A HOLE IN GUANO.
C
32000	IF((PRSA.NE.DIGW).OR.(PRSO.NE.SHOVE)) RETURN
	I=91					!ASSUME NO GUANO.
	IF(.NOT. QHERE(GUANO,HERE)) GO TO 32100	!IS IT HERE?
	RVGUA=MIN0(4,RVGUA+1)		!YES, SET NEW STATE.
	I=91+RVGUA				!GET NASTY REMARK.
32100	CALL RSPEAK(I)				!DESCRIBE.
	RETURN
C
C R33--	FALLS ROOM
C
33000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	CALL RSPEAK(96)				!DESCRIBE.
	I=97					!ASSUME NO RAINBOW.
	IF(RAINBF) I=98				!GOT ONE?
	CALL RSPEAK(I)				!DESCRIBE.
	RETURN
C RAPPL1, PAGE 10
C
C R34--	LEDGE FUNCTION.  LEDGE CAN COLLAPSE.
C
34000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	CALL RSPEAK(100)			!DESCRIBE.
	I=102					!ASSUME SAFE ROOM OK.
	IF((RFLAG(MSAFE).AND.RMUNG).NE.0) I=101	!IF MUNGED, ROOM GONE.
	CALL RSPEAK(I)				!DESCRIBE.
	RETURN
C
C R35--	SAFE ROOM.  STATE DEPENDS ON WHETHER SAFE BLOWN.
C
35000	IF(PRSA.NE.LOOKW) RETURN		!LOOK?
	CALL RSPEAK(104)			!DESCRIBE.
	I=105					!ASSUME OK.
	IF(SAFEF) I=106				!BLOWN?
	CALL RSPEAK(I)				!DESCRIBE.
	RETURN
C
C R36--	MAGNET ROOM.  DESCRIBE, CHECK FOR SPINDIZZY DOOM.
C
36000	IF(PRSA.NE.LOOKW) GO TO 36500		!LOOK?
	CALL RSPEAK(107)			!DESCRIBE.
	RETURN
C
36500	IF((PRSA.NE.WALKIW).OR. .NOT.CAROFF) RETURN	!WALKIN ON FLIPPED?
	IF(CAROZF) GO TO 36600			!ZOOM?
	CALL RSPEAK(108)			!NO, SPIN HIS COMPASS.
	RETURN
C
36600	I=58					!SPIN HIS INSIDES.
	IF(WINNER.NE.PLAYER) I=99		!SPIN ROBOT.
	CALL JIGSUP(I)				!DEAD.
	RETURN
C
C R37--	CAGE ROOM.  IF SOLVED CAGE, MOVE TO OTHER CAGE ROOM.
C
37000	IF(CAGESF) F=MOVETO(CAGER,WINNER)	!IF SOLVED, MOVE.
	RETURN
C
	END
