;***********************************************************************
;	QUME PRINT DRIVER INSTALLATION UTILITY FOR ALTAIR 8800B
;***********************************************************************
;
;
;	THIS UTILITY INITIALIZES THE QUME LINE PRINTER I/O
;	BOARD AND THEN BLOCK MOVES THE CODE FOR THE ACTUAL
;	QUME DRIVER INTO THE MEMORY AREA ABOVE THE BIOS
;	AT 0FA00H. THE LINE PRINTER PARAMETER STORAGE AREAS
;	ARE INITIALIZED BY VIRTUE OF BEING INCLUDED WITHIN
;	THE CODE AREA THAT IS TRANSFERED.
;
;	THIS UTILITY WILL FUNCTION WITH CP/M SYSTEM SIZES
;	UP TO 62K.
;
;	THE CODE BLOCK THAT IS MOVED BY THIS PROGRAM MUST
;	BE SEPERATELY ASSEMBLED AS "QUMEDRV.ASM" AND THEN
;	ATTACHED TO THE "COM" VERSION OF THIS UTILITY BY
;	UTILIZING DDT TO LOAD THE TWO TOGETHER. THEN "SAVE"
;	THE JOINED FILES AS "QUMEINST.COM".
;
;
;	COPYRIGHT 1980
;	MICHAEL J. KARAS
;	MICRO RESOURCES
;	2468 HANSEN COURT
;	SIMI VALLEY, CA 93065
;	(805) 527-7922
;
;
;***********************************************************************
;
;
;DEFINE QUME LINE PRINTER I/O PARAMETERS
;
LENHGT	EQU	132		;PRINTER LINE LENGTH
QUME1	EQU	31H		;FIRST DATA PORT
QUME2	EQU	QUME1+2		;SECOND DATA PORT
;
;
;DEFINE CP/M PARAMETERS
;
BDOS	EQU	0005H		;SYSTEM I/O ENTRY POINT
WBOOT	EQU	0000H		;WARM BOOT ENTRY POINT
LSTOFST	EQU	(04*3)+1	;WARM BOOT PLUS THREE VECTORS
PRTSRT	EQU	0009H		;PRINT STRING BDOS FUNCTION
;
;
;DEFINE POSITION AND LENGTH OF ATTACHED AND MOVED MODULE
;
LISTST	EQU	0FA00H		;BASE ADDRESS OF QUME DRIVER
LISTLN	EQU	00100H		;LENGTH OF MOVED AREA...
;				;...INCLUDES PARAMETER STORAGE LOCATIONS
;
;
;DEFINE ASCII CHARACTERS USED IN SYMBOLIC FASHION
;
CR	EQU	0DH		;CARRAGE RETURN
LF	EQU	0AH		;LINE FEED
;
;
;SET UP START OF THIS ROUTINE
;
	ORG	00100H		;START OF CP/M TPA
;
	DI
	LXI	SP,STACK	;GET A STACK SETUP
;
;
;TELL THEM WHAT THIS IS ALL ABOUT
;
	LXI	D,MSG		;POINT TO SIGNON MESSAGE
	MVI	C,PRTSRT	;PRINT MESSAGE
	CALL	BDOS
;
;
;INITIALIZE THE QUME PRINTER I/O BOARD
;
	XRA	A		;INIT PRINTER PORTS
	OUT	30H		;OUTPUT ZEROS TO CONTROL REGISTERS
	OUT	32H
	OUT	34H
	OUT	36H
	OUT	35H		;SET DIRECTION REG'S
	CMA
	OUT	31H
	OUT	33H
	OUT	37H
	MVI	A,4		;ACCESS DATA REGISTERS
	OUT	30H
	OUT	32H
	OUT	34H
	OUT	36H
	MVI	A,0FCH		;SELECT AND RESET PRINTER
	OUT	37H
	MVI	A,0FAH		;LATCH DATA PORT
	OUT	37H
;
;
;PLACE A NEW PRINT VECTOR ADDRESS INTO THE BIOS VECTOR TABLE
;FOR THE SOON TO BE INSTALLED UTILITY
;
	LHLD	WBOOT+1		;GET ADDRESS OF WARM BOOT VECTOR
	LXI	D,LSTOFST	;SETUP VECTOR TABLE INDEX
	DAD	D		;HL NOW POINTS TO THE LIST VECTOR
	LXI	D,LISTST	;GET ROUTINE START ADDRESS
	MOV	M,E		;PUT ADDRESS INTO THE BIOS VECTOR
	INX	H
	MOV	M,D
;
;
;NOW MOVE THE DRIVER CODE FROM BELOW TO AREA ABOVE BIOS
;START OF CODE TO BE MOVED SHOULD BE ATTACHED WITH DDT
;TO START AT 01000H.
;
	LXI	D,01000H	;START ADDRESS OF MOVE BLOCK
	LXI	H,LISTST	;DESTINATION ADDRESS
	LXI	B,LISTLN	;LENGTH OF CODE TO MOVE
MOVE:
	LDAX	D		;GET CODE BYTE
	MOV	M,A		;PUT AT DESTINATION
	INX	H		;TAKE CARE OF POINTERS
	INX	D
	DCX	B		;DEC BYTE COUNT
	MOV	A,B		;SEE IF WE ARE DONE
	ORA	C
	JNZ	MOVE
;
;
;GET OUT OF HERE WITH WARM BOOT OF CP/M
;
	JMP	WBOOT
;
;
;SETUP A SIGN ON MESSAGE
;
MSG:
	DB	CR,LF,LF
	DB	'MICRO RESOURCES QUME PRINT DRIVER INSTALLATION '
	DB	'UTILITY',CR,LF,LF
	DB	'++FOR USE WITH ALTAIR 8800 COMPUTER++',CR,LF,LF
	DB	'++REQUIRES READ/WRITE RAM AT ADDRESS 0FA00H++',CR,LF,LF
	DB	'$'
;
;
;MAKE SOME ROOM FOR OUR STACK
;
	DS	0100H		;50 ENTRIES SHOULD BE ENOUGH
STACK	DW	0
;
;
;  ----------------
;
;
        END
;
;+++
