






PROGRAM NAD; {$P}

TYPE

	MAILING = RECORD
		NAME:ARRAY[1..30] OF CHAR;
		STREET_NUMBER:ARRAY[1..6] OF CHAR;
		STREET: ARRAY[1..20] OF CHAR;
		CITY: ARRAY[1..10] OF CHAR;
		STATE:ARRAY[1..10] OF CHAR;
		ZIP:ARRAY[1..10] OF CHAR;
		ATTENTION:ARRAY[1..30] OF CHAR;
		ACCT_NUMBER:ARRAY[1..4] OF CHAR;
		BLANKS: ARRAY[1..8]  OF CHAR;
		END;

F = FILE OF MAILING;
$STRING80 = STRING 80;
$STRING0  = STRING 0;
$STRING255 = STRING 255;
$STRING14 = STRING 14;

TR = ARRAY [1..4] OF CHAR;

VAR
FIN: F;
COUNTER,I,N:INTEGER;
INFORMATION: MAILING;
NUMBER_OF_RECORDS: INTEGER;

NA,ST_NO,ST,CIT,STA,ZI,ATT: $STRING80;

CONTINUE,NEWFILE: BOOLEAN;
ANSWER:CHAR;
FILENAM:$STRING14;


PROCEDURE SETLENGTH(VAR X: $STRING0; Y:INTEGER);EXTERNAL;
FUNCTION LENGTH(X:$STRING255):INTEGER;EXTERNAL;


PROCEDURE CLEAR_SCREEN;
BEGIN
WRITE (CHR(27),'*',CHR(0),CHR(0),CHR(0),CHR(0));
END;

PROCEDURE ERASE_LINES(STARTING_LINE,NUMBER_OF_LINES:INTEGER);

VAR
I:INTEGER;
BLANKS:STRING 80;

BEGIN
BLANKS:='                                        ';{40SPACES}
FOR I:= 1 TO NUMBER_OF_LINES DO
	BEGIN
	WRITE(CHR(27),'=',CHR(STARTING_LINE+31),CHR(32),BLANKS,BLANKS);
	STARTING_LINE:=STARTING_LINE + 1;
	END
END;


PROCEDURE MOVE_CURSOR (X,Y:INTEGER);
BEGIN
	WRITE(CHR(27),'=',CHR(Y+31),CHR(X+31));
END;

PROCEDURE PROMPT (X,Y,LENGTH:INTEGER; P:$STRING80;
		  PROTECTED_FIELD_DESIRED:BOOLEAN);

VAR
UNDERLINE:STRING 80;
I:INTEGER;
BEGIN
UNDERLINE:='_';
	FOR I:= 1 TO LENGTH DO APPEND(UNDERLINE,'_');
	IF PROTECTED_FIELD_DESIRED = FALSE THEN
WRITE(CHR(27),'=',CHR(Y+31),CHR(X+31),P,UNDERLINE)
	ELSE
WRITE(CHR(27),'=',CHR(Y+31),CHR(X+31),')',P,
	UNDERLINE,CHR(27),'(');
END;


FUNCTION INPUT_DATA (X,Y,LEN:INTEGER; ALPHANUMERIC:BOOLEAN;
		     MAXIMUM_VALUE,MINIMUM_VALUE:REAL):$STRING80;

VAR
DATA,BLANKS:$STRING80;
I:INTEGER;

PROCEDURE CORRECT(X,Y:INTEGER);
VAR
I,A,B:INTEGER;
BEGIN

	ERASE_LINES(20,2);
	WRITE (CHR(7));
	MOVE_CURSOR (1,20);
	
	IF (ALPHANUMERIC = TRUE) AND (LENGTH(DATA)>LEN) THEN
		WRITE('TERM TOO LONG');
	
	MOVE_CURSOR(X,Y);
	WRITE(' ');
	A:=X;
	B:=Y;

	FOR I:= 1 TO LENGTH(DATA) DO
	BEGIN
		MOVE_CURSOR(A,B);
		WRITE(' ');	
		A:=A+1;
	END;

	MOVE_CURSOR(X,Y);
	WRITE('_');
	A:=X;
	B:=Y;
	FOR I:= 1 TO (LEN-1) DO	
	BEGIN
		MOVE_CURSOR(A,B);
		WRITE('_');
		A:=A+1;
	END;

	MOVE_CURSOR(X,Y);
	READ(DATA);
	ERASE_LINES(20,1);


END;



BEGIN

	BLANKS:='                                        ';{40SPACES}

MOVE_CURSOR(X,Y);
READ(DATA);

WHILE(ALPHANUMERIC = TRUE) AND (LENGTH(DATA) > LEN) DO CORRECT(X,Y);

IF LENGTH(DATA) = 0 THEN
BEGIN
	DATA:=' ';
	FOR I:=1 TO (LEN-1) DO APPEND(DATA,' ');
END;

IF LENGTH(DATA) < LEN THEN
	FOR I:=  LENGTH(DATA) TO LEN DO APPEND(DATA,' ');

INPUT_DATA:=DATA;

END;


{************  PROCEDURE TO DETERMINE NUMBER RECORDS IN FILE ******}

PROCEDURE NUMBER_RECORDS(FILENAM:$STRING14);
BEGIN

RESET(FILENAM,FIN);
WITH INFORMATION DO
BEGIN

READ(FIN:1,INFORMATION);
NUMBER_OF_RECORDS:=(((ORD(ACCT_NUMBER[1])-48)*1000)+
		((ORD(ACCT_NUMBER[2])-48)*100)+
		((ORD(ACCT_NUMBER[3])-48)*10)+
		((ORD(ACCT_NUMBER[4])-48)*1));
END; {OF WITH}

END; {OF PROCEDURE}

{********** DETERMINE THE CURRENT NUMBER OF RECORDS  *******}

PROCEDURE CALC_ACCT_NO(CURRENT_NUMBER_OF_RECORDS:INTEGER);
VAR
ONES,TENS,HUNDREDS,THOUSANDS:CHAR;
O,T,H,TH:INTEGER;

BEGIN
O:=1;
T:=1;
H:=1;
TH:=1;
WITH INFORMATION DO
BEGIN

IF CURRENT_NUMBER_OF_RECORDS < 10 THEN
BEGIN
ONES:=CHR(CURRENT_NUMBER_OF_RECORDS + 48);
ACCT_NUMBER[1]:='0';
ACCT_NUMBER[2]:='0';
ACCT_NUMBER[3]:='0';
ACCT_NUMBER[4]:=ONES;
END; {IF}

IF CURRENT_NUMBER_OF_RECORDS  = 10 THEN ACCT_NUMBER:='0010';
IF CURRENT_NUMBER_OF_RECORDS  = 100 THEN ACCT_NUMBER:='0100';

IF (CURRENT_NUMBER_OF_RECORDS < 100) AND
   (CURRENT_NUMBER_OF_RECORDS > 10) THEN
BEGIN
WHILE (CURRENT_NUMBER_OF_RECORDS < 100) AND
      (CURRENT_NUMBER_OF_RECORDS > 10) DO          {FOR VALUE 1-99}
BEGIN
CURRENT_NUMBER_OF_RECORDS:=CURRENT_NUMBER_OF_RECORDS-10;
T:=T+1;
IF CURRENT_NUMBER_OF_RECORDS < 10 THEN
BEGIN
ONES:= CHR(CURRENT_NUMBER_OF_RECORDS + 48);
TENS:=CHR(T+48);
ACCT_NUMBER[1]:='0';
ACCT_NUMBER[2]:='0';
ACCT_NUMBER[3]:=TENS;
ACCT_NUMBER[4]:=ONES;
END; {IF}

END; {WHILE}
END; {OF IF}

IF (CURRENT_NUMBER_OF_RECORDS < 10000) AND
   (CURRENT_NUMBER_OF_RECORDS > 10) THEN
BEGIN
WHILE (CURRENT_NUMBER_OF_RECORDS < 10000) AND
      (CURRENT_NUMBER_OF_RECORDS > 10) DO           {FOR VALUE 1 - 9999}
BEGIN
WHILE (CURRENT_NUMBER_OF_RECORDS < 10000) AND
      (CURRENT_NUMBER_OF_RECORDS > 1000) DO
BEGIN
CURRENT_NUMBER_OF_RECORDS:=CURRENT_NUMBER_OF_RECORDS - 1000;
TH:=TH+1;
IF CURRENT_NUMBER_OF_RECORDS < 1000 THEN THOUSANDS:=CHR(TH+48);
END;

WHILE (CURRENT_NUMBER_OF_RECORDS < 1000) AND
      (CURRENT_NUMBER_OF_RECORDS > 100) DO
BEGIN
CURRENT_NUMBER_OF_RECORDS:=CURRENT_NUMBER_OF_RECORDS-100;
H:=H+1;
IF CURRENT_NUMBER_OF_RECORDS < 100 THEN HUNDREDS:=CHR(H+48);
END;

WHILE (CURRENT_NUMBER_OF_RECORDS < 100) AND
      (CURRENT_NUMBER_OF_RECORDS > 10) DO
BEGIN
CURRENT_NUMBER_OF_RECORDS:=CURRENT_NUMBER_OF_RECORDS-10;
T:=T+1;
IF CURRENT_NUMBER_OF_RECORDS < 10 THEN
BEGIN
TENS:=CHR(T+48);
ONES:=CHR(CURRENT_NUMBER_OF_RECORDS+48);
END;
END;

ACCT_NUMBER[1]:=THOUSANDS;
ACCT_NUMBER[2]:=HUNDREDS;
ACCT_NUMBER[3]:=TENS;
ACCT_NUMBER[4]:=ONES;

END; {OF WHILE}
END; {OF IF}
END; {OF WITH INFORMATION DO}
END; {OF PROCEDURE}


{********************  PRINT THE FILE  ********************}

PROCEDURE PRINT_FILE(FILENAM:$STRING14);

TYPE
C = FILE OF CHAR;

VAR
ANSWER:CHAR;
AC,HARDCOPY: BOOLEAN;
FOUT: C;

BEGIN
CLEAR_SCREEN;
REPEAT
WRITELN;
WRITE ('DO YOU WANT A HARDCOPY OF THE FILE? Y/N');
READ(ANSWER);
UNTIL (ANSWER = 'Y') OR (ANSWER = 'N');

IF ANSWER = 'Y' THEN 
	BEGIN
	HARDCOPY:=TRUE;
	REWRITE('LST',FOUT);
	END;

IF ANSWER = 'N' THEN HARDCOPY:= FALSE;

REPEAT
WRITELN;
WRITE ('DO YOU WANT THE ACCOUNT NUMBER INCLUDED IN THE PRINT OUT? Y/N');
READ(ANSWER);
UNTIL (ANSWER = 'Y') OR (ANSWER = 'N');
IF ANSWER = 'Y' THEN AC:=TRUE ELSE AC:=FALSE;

RESET(FILENAM,FIN);
CLEAR_SCREEN;
NUMBER_RECORDS(FILENAM);

WITH INFORMATION DO
BEGIN

FOR I:= 2 TO NUMBER_OF_RECORDS DO
BEGIN
READ(FIN:I,INFORMATION);

IF HARDCOPY = FALSE THEN
BEGIN
WRITELN;
WRITELN (NAME);
WRITELN(STREET_NUMBER,'  ',STREET);
WRITELN(CITY,'    ',STATE,'    ',ZIP);
WRITELN;
IF ATTENTION <> '                              ' THEN
	WRITELN('ATT:  ',ATTENTION);
IF AC = TRUE THEN
	BEGIN
	WRITELN;
	WRITELN('ACCOUNT NUMBER:  ',ACCT_NUMBER);
	END;

END; {FOR HARDCOPY = FALSE}

IF HARDCOPY = TRUE THEN
BEGIN
WRITELN(FOUT,' ');
WRITELN(FOUT,NAME);
WRITELN(FOUT,STREET_NUMBER,'   ',STREET);
WRITELN(FOUT,CITY,'     ',STATE,'    ',ZIP);
WRITELN(FOUT,' ');
IF ATTENTION <> '                              ' THEN
	WRITELN(FOUT,'ATT:   ',ATTENTION);
IF AC = TRUE THEN
	BEGIN
	WRITELN(FOUT,' ');
	WRITELN(FOUT,'ACCOUNT NUMBER:  ',ACCT_NUMBER);
	END;

END; {FOR HARDCOPY  =  TRUE}
END;  {FOR LOOP}
END; {THIS IS FOR WITH STATEMENTS}

END; {OF PROCEDURE}


{*****************  CREATING THE FIRST RECORD OF FILE *******}

PROCEDURE CREATE_FIRST_RECORD (ACTNO: TR);
BEGIN
IF (NEWFILE = TRUE) AND (CONTINUE = TRUE) THEN REWRITE(FILENAM,FIN);

WITH INFORMATION  DO
BEGIN
NAME:='FIRST RECORD OF FILE          ';
STREET_NUMBER:='      ';
STREET:='                    ';
CITY:='          ';
STATE:='          ';
ZIP:='          ';
ATTENTION:='                              ';
IF (NEWFILE = TRUE) AND (CONTINUE = TRUE) THEN ACCT_NUMBER:='0001';
IF (NEWFILE = TRUE) AND (CONTINUE = FALSE) THEN ACCT_NUMBER:=ACTNO;
IF NEWFILE =  FALSE THEN ACCT_NUMBER:= ACTNO;
BLANKS:='        ';
WRITE(FIN:1,INFORMATION);
END; {WITH LOOP}
END; {OF PROCEDURE}


{**************   ENTER THE  NAME OF THE  FILE *****************}

PROCEDURE ENTER_FILE_NAME;
BEGIN
CLEAR_SCREEN;
WRITELN(' ENTER THE FILE  NAME AS: DRIVE: NAME. EXTENSION');
WRITELN;
WRITELN(' WHERE  DRIVE IS  A SINGLE LETTER--EITHER A  OR  B');
WRITELN('        NAME  IS UP TO  8 LETTERS OR SPACES');
WRITELN('        EXTENSION MUST HAVE 3 LETTERS  OR  SPACES');
WRITELN;

READLN(FILENAM);

REPEAT
MOVE_CURSOR(1,10);
WRITE('IS THIS A  NEW  FILE? Y/N');
READ  (ANSWER);
UNTIL (ANSWER = 'Y') OR (ANSWER = 'N');

IF ANSWER = 'Y' THEN NEWFILE:=TRUE ELSE NEWFILE:=FALSE;
IF NEWFILE = TRUE THEN CREATE_FIRST_RECORD('0001');

END; {OF PROCEDURE}

{*********** PROCEDURE TO CORRECT INCORRECT ENTRY ************}

PROCEDURE MISTAKE;
VAR
WRONG:CHAR;

BEGIN
WITH INFORMATION DO
BEGIN
ERASE_LINES(10,12);
PROMPT(1,12,0,'ENTER NUMBER OF INCORRECT INFORMATION',FALSE);
PROMPT(1,14,0,'1-NAME ',FALSE);
PROMPT(1,15,0,'2-# ',FALSE);
PROMPT(1,16,0,'3-STREET ',FALSE);
PROMPT(1,17,0,'4-CITY ',FALSE);
PROMPT(1,18,0,'5-STATE ',FALSE);
PROMPT(1,19,0,'6-ZIP ',FALSE);
PROMPT(1,20,0,'7-ATTENTION ',FALSE);
PROMPT(1,21,0,'8-ALL INFORMATION IS CORRECT AS DISPLAYED ',FALSE);

REPEAT
MOVE_CURSOR(50,16);
READ(WRONG);

CASE WRONG OF 
	'1':BEGIN
		PROMPT(1,2,30,'NAME',FALSE);
		NA:=INPUT_DATA(6,2,30,TRUE,0,0);
		FOR I:= 1 TO 30 DO NAME[I]:=NA[I];
	    END;

	'2': BEGIN
		PROMPT(1,4,6,'#: ',FALSE);
		ST_NO:=INPUT_DATA(4,4,6,TRUE,0,0);
		FOR I:= 1 TO 6 DO STREET_NUMBER[I]:=ST_NO[I];
		END;

	'3': BEGIN
		PROMPT(10,4,20,'STREET:',FALSE);
		ST:=INPUT_DATA(19,4,20,TRUE,0,0);
		FOR I:= 1 TO 20 DO STREET[I]:=ST[I];
		END;

	'4': BEGIN
		PROMPT(1,6,10,'CITY: ',FALSE);
		CIT:=INPUT_DATA(7,6,10,TRUE,0,0);
		FOR I:= 1 TO 10 DO CITY[I]:=CIT[I];
		END;

	'5': BEGIN
		PROMPT(20,6,10,'STATE: ',FALSE);
		STA:=INPUT_DATA(27,6,10,TRUE,0,0);
		FOR I:= 1 TO 10 DO STATE[I]:=STA[I];
		END;

	'6': BEGIN
		PROMPT(40,6,10,'ZIP: ',FALSE);
		ZI:= INPUT_DATA(46,6,10,TRUE,0,0);
		FOR I:= 1 TO 10 DO ZIP[I]:=ZI[I];
		END;

	'7': BEGIN
		PROMPT(1,8,30,'ATTENTION: ',FALSE);
		ATT:=INPUT_DATA(12,8,29,TRUE,0,0);
		FOR I:= 1 TO 30 DO ATTENTION[I]:=ATT[I];
		END;

	END; {OF CASE}

UNTIL WRONG = '8';
END; {OF WITH INFORMATION}
ERASE_LINES(10,12);
END; {OF PROCEDURE}

{****************  MAIN PROGRAM BEGINS HERE   ******************}

BEGIN
CONTINUE:=TRUE;
ENTER_FILE_NAME;
IF NEWFILE = TRUE THEN COUNTER:= 2;

IF NEWFILE = FALSE THEN
BEGIN
NUMBER_RECORDS(FILENAM);
COUNTER:=NUMBER_OF_RECORDS + 1;
END;

WITH INFORMATION DO
BEGIN
REPEAT

CLEAR_SCREEN;
	PROMPT(1,2,30,'NAME',FALSE);
	PROMPT(1,4,6,'#: ',FALSE);
	PROMPT(10,4,20,'STREET: ',FALSE);
	PROMPT(1,6,10,'CITY: ',FALSE);
	PROMPT(20,6,10,'STATE: ',FALSE);
	PROMPT(40,6,10,'ZIP: ',FALSE);
	PROMPT(1,8,30,'ATTENTION: ',FALSE);
	
	NA:=INPUT_DATA(6,2,30,TRUE,0,0);
	ST_NO:=INPUT_DATA(4,4,6,TRUE,0,0);	
	ST:=INPUT_DATA(19,4,20,TRUE,0,0);
	CIT:=INPUT_DATA(7,6,10,TRUE,0,0);
	STA:=INPUT_DATA(27,6,10,TRUE,0,0);
	ZI:=INPUT_DATA(46,6,10,TRUE,0,0);
	ATT:=INPUT_DATA(12,8,29,TRUE,0,0);

FOR I:= 1 TO 30 DO NAME[I]:=NA[I];
FOR I:= 1 TO 6  DO STREET_NUMBER[I]:=ST_NO[I];
FOR I:= 1 TO 20 DO STREET[I]:=ST[I];
FOR I:= 1 TO 10 DO CITY[I]:=CIT[I];
FOR I:= 1 TO 10 DO STATE[I]:=STA[I];
FOR I:= 1 TO 10 DO ZIP[I]:=ZI[I];
FOR I:= 1 TO 30 DO ATTENTION[I]:=ATT[I];
CALC_ACCT_NO(COUNTER);
FOR I:= 1 TO 8 DO BLANKS[I]:=' ';

IF NAME <> 'EXIT                          ' THEN
REPEAT
PROMPT(1,20,1,'IS INFORMATION CORRECT AS ENTERED? Y/N',FALSE);
MOVE_CURSOR(50,20);
READ(ANSWER);
UNTIL (ANSWER = 'Y') OR (ANSWER = 'N');

IF ANSWER = 'N' THEN MISTAKE;

IF NAME <> 'EXIT                          ' THEN
BEGIN
WRITE(FIN:COUNTER,INFORMATION);
COUNTER:=COUNTER+1;
END; {OF IF}

UNTIL NAME = 'EXIT                          ';
CONTINUE:=FALSE;
CALC_ACCT_NO(COUNTER - 1);
CREATE_FIRST_RECORD(ACCT_NUMBER);

END;

REPEAT
ERASE_LINES(20,1);
PROMPT(1,20,1,'DO YOU WANT A LISTING OF THE FILE? Y/N',FALSE);
MOVE_CURSOR(50,20);
READ(ANSWER);
UNTIL (ANSWER = 'Y') OR (ANSWER = 'N');

IF ANSWER = 'Y' THEN PRINT_FILE(FILENAM);


END.

