; CP/M BASIC INPUT/OUTPUT OPERATING SYSTEM (BIOS)
; This version boots in SINGLE OR DOUBLE DENSITY 
; IT LINKS TO MYDDPROM.Z80 IN PROM 
;
PROM	EQU  0F800H		;LOCATION OF ROM CONTAINING MAIN BIOS
MSIZE	EQU  60			;MEMORY SIZE IN KBYTES.


CBASE	EQU  (MSIZE-21)*1024  	;BIAS FOR CPM LARGER THAN 17K.(NOTE I ALLOW A 
				;2K BIOS TO MAKE ROOM FOR A VDM BOARD AT EC00H)
CCP	EQU  CBASE+3400H	;START OF CPM
BIOS	EQU  CCP+1600H

	ORG  BIOS		;START OF BIOS.
				
BOOT:	JMP  PROM		;FROM COLD START LOADER.
WBOOTE:	JMP  PROM+03H		;FROM WARM BOOT.
	JMP  PROM+06H		;CHECK CONSOLE KB STATUS.
	JMP  PROM+09H		;READ CONSOLE CHARACTER.
CONOT:	JMP  PROM+0CH		;WRITE CONSOLE CHARACTER.
	JMP  PROM+0FH		;WRITE LISTING CHAR.
	JMP  PROM+12H		;WRITE PUNCH CHAR.
	JMP  PROM+15H		;READ READER CHAR.
	JMP  PROM+18H		;MOVE DISK TO TRACK ZERO.
	JMP  TEMPSELDSK		;SELECT DISK DRIVE.
	JMP  PROM+1EH		;SEEK TO TRACK IN REG A.
	JMP  PROM+21H		;SET SECTOR NUMBER.
	JMP  PROM+24H		;SET DISK STARTING ADR.
	JMP  PROM+27H		;READ SELECTED SECTOR.
	JMP  PROM+2AH		;WRITE SELECTED SECTOR.
	JMP  PROM+2DH		;LIST STATUS CHECK
	JMP  PROM+30H		;SECTOR TRANSLATE ROUTINE

	MACLIB DISKDEF
;*****************************************************************************
	DISKS 4
	DISKDEF 0,1,26,6,1024,243,64,64,2
	DISKDEF 1,0
	DISKDEF 2,1,50,1,2048,234,64,64,2
	DISKDEF 3,2

;******************************************************************************
;
;
TEMPSELDSK
	CALL PROM+1BH
	LXI D,DPBASE
	DAD H
	DAD H
	DAD H
	DAD H
	DAD D
	RET
;
;
	ENDEF
;
;END
