

; OVERLAY FOR CP/M VERSION OF MICRONET EXECUTIVE


TRUE	EQU	0FFFFH		; DEFINE TRUE
FALSE	EQU	NOT TRUE	; DEFINE FALSE

BBASE:	EQU	0000H		; "PAGE 0" ADDRESS
TBASE:	EQU	BBASE+100H	; TRANSIENT PROGRAM AREA
OVLOC:	EQU	BBASE+0A00H	; WHERE THE OVERLAY GOES

; ************************************************************
; ************************************************************

;	THIS BEGINS THE SECTION THAT MUST BE MODIFIED
;	TO YOUR PARTICULAR SYSTEM.  THE FIRST THING YOU
;	SHOULD DO IS PUT YOUR SYSTEM IDENTIFICATION INTO
;	THE PROGRAM.  TO DO THIS, CHANGE THE 'IMSAI 8080'
;	IN THE STATEMENT LABELED "SYSID:" TO WHATEVER
;	TYPE OF SYSTEM YOU HAVE.  NOTE THAT "SYSID:" CAN
;	BE NO LONGER THAN 23 CHARACTERS AND THE LAST
;	CHARACTER MUST BE A 00 BYTE.

; ------------------------------------------------------------

;	THESE ARE THE PORT ADDRESSES USED FOR THE MODEM.

CTL	EQU	001H	; MODEM STATUS (CONTROL) PORT
SIO	EQU	000H	; MODEM DATA PORT

; ------------------------------------------------------------

;	THESE ARE THE MODEM PORT STATUS FLAG MASKS

SIOIR	EQU	02H	; MODEM PORT INPUT DATA READY FLAG
SIOTR	EQU	01H	; MODEM PORT TRANSMITTER READY FLAG

; ------------------------------------------------------------

;	THIS IS SET TO FALSE IF YOUR MODEM PORT READY FLAGS
;	ARE ACTIVE LOW. (ZERO IMPLIES READY)

RDYHI	EQU	TRUE	; TRUE IF UART READY FLAGS ARE
			; ACTIVE HIGH (1=READY). FALSE
			; IF FLAGS ARE ACTIVE LOW (0=READY).

;	THIS ENDS THE SECTION THAT MUST BE
;	MODIFIED TO YOUR PARTICULAR SYSTEM
;	UNLESS YOU NEED UART INITIALIZATION.
;	IF YOU DO NEED TO INITAILIZE YOUR
;	MODEM UART, CHANGE "SIOINI:" (AT THE
;	END OF THIS PROGRAM) TO SET UP YOUR
;	UART TO USE 8 DATA BITS, NO PARITY
;	AND 1 STOP BIT.

; ************************************************************
; ************************************************************

RDYLO	EQU	NOT RDYHI

	ORG	TBASE+3		; OVERLAY TRANSFER VECTOR AND ID STRING

INISIO:	JMP	SIOINI		; INITIALIZE MODEM UART
GETSIO:	JMP	SIOGET		; GET CHAR FROM MODEM UART
PUTSIO:	JMP	SIOPUT		; PUT A CHAR TO MODEM UART
SYSID:	DB	'Z-80 Homebrew',0	; IDENTIFIES YOUR SYSTEM
				; MAXIMUM LENGTH IS 23 CHARACTERS.
				; LAST CHARACTER MUST BE A 00
	ORG	OVLOC		; MOVE BEYOND EXEC FOR MODEM PORT I/O ROUTINES

; THIS ROUTINE INPUTS A CHARACTER FROM THE MODEM'S UART (OR USART)

SIOGET:	IN	CTL	; GET MIO STATUS FLAGS
	ANI	SIOIR	; ISOLATE INPUT READY FLAG

	IF RDYLO	; INVERT IF ACTIVE LOW
	XRI	SIOIR	; INVERT IT
	ENDIF

	RZ		; RETURN IF Z = 1
	IN	SIO	; ELSE GET MODEM CHARACTER
	RET		; AND RETURN (Z FLAG = 0)

; THIS ROUTINE OUTPUT CONTENTS OF A TO THE MODEM'S UART

SIOPUT:	PUSH	PSW	; WRITE (A) TO SIO
PUTSI1:	IN	CTL	; WAIT FOR FLAG TO = 0
	ANI	SIOTR

	IF RDYLO	; SENSE OF JUMP
	JNZ	PUTSI1
	ENDIF

	IF RDYHI	; SENSE OF JUMP
	JZ	PUTSI1
	ENDIF

	POP	PSW
	OUT	SIO
	RET

; THIS ROUTINE INITIALIZES THE MODEM UART FOR OPERATION

SIOINI:	RET			; INITILIZE MODEM UART HERE
				; IF UART NEEDS IT
				; 8 DATA BITS
				; NO PARITY
				; 1 STOP BIT

	END
