;	4 8 K    S T A N D A R D I Z E D    B O O T
;
;	NOTE:  MSIZE AND BIOSSZ DETERMINES WHERE THIS BOOT LOADS THE SYSTEM
;
MSIZE	EQU	48
BIOSSZ	EQU	512
;
BOOT	EQU	0
START	EQU	MSIZE*1024-BIOSSZ-1024
ENDPT	EQU	MSIZE*1024
NSECTS	EQU	(ENDPT-START)/128
STACK	EQU	100H
;
LOWTRK	EQU	0
LOWSCT	EQU	2
LOWSZE	EQU	NSECTS
;
IOBYTE	EQU	0
ACTDSK	EQU	0
;
;
;
	ORG	BOOT
;
;
	LXI	SP,STACK
INIT:
MAIN:
	MVI	C,LOWTRK	;NOW WE READ ONE TRACK
	CALL	SETTRK
	LXI	B,START		;SET STARTING RAM LOCATION
	LXI	D,LOWSZE SHL 8 + LOWSCT
	CALL	DO$READ
	LXI	H,ACTDSK SHL 8 + IOBYTE
	SHLD	3
	JMP	START
;
;
DO$READ:
	PUSH	B
	PUSH	D
	CALL	SETDMA
	POP	D
	MOV	C,E
	PUSH	D
	CALL	SETSEC
	CALL	READ
	POP	D
	POP	B
	LXI	H,128
	DAD	B
	MOV	B,H
	MOV	C,L
	INR	E
	DCR	D
	JNZ	DO$READ
	RET
;
;
	END	BOOT
